/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.navigator.broker;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Mirror {
    private final Class class1;
    private final Object object;

    public Object getObject() {
        return this.object;
    }

    private Class[] parseMethodSignature(String params) {
        String[] paramArray = params.split(", *");
        Class[] cs = new Class[paramArray.length];
        try {
            int i = 0;
            while (i < paramArray.length) {
                cs[i] = "int".equals(paramArray[i]) ? Integer.TYPE : ("short".equals(paramArray[i]) ? Short.TYPE : ("long".equals(paramArray[i]) ? Long.TYPE : ("char".equals(paramArray[i]) ? Character.TYPE : ("boolean".equals(paramArray[i]) ? Boolean.TYPE : ("byte".equals(paramArray[i]) ? Byte.TYPE : ("float".equals(paramArray[i]) ? Float.TYPE : ("double".equals(paramArray[i]) ? Double.TYPE : Class.forName(paramArray[i], true, this.class1.getClassLoader()))))))));
                ++i;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        return cs;
    }

    public Method getMethod(String signature) {
        String name;
        Class[] params = null;
        int posParam = signature.indexOf(40);
        if (posParam == -1) {
            name = signature;
        } else {
            name = signature.substring(0, posParam);
            int posParamEnd = signature.lastIndexOf(41);
            if (posParamEnd == -1) {
                return null;
            }
            params = this.parseMethodSignature(signature.substring(posParam + 1, posParamEnd));
            if (params == null) {
                return null;
            }
        }
        Method m = null;
        Class c = this.class1;
        while (c != null) {
            block13: {
                try {
                    if (params == null) {
                        Method[] ms = c.getDeclaredMethods();
                        int i = 0;
                        while (i < ms.length) {
                            if (name.equals(ms[i].getName())) {
                                m = ms[i];
                            }
                            ++i;
                        }
                    } else {
                        m = c.getDeclaredMethod(name, params);
                    }
                }
                catch (SecurityException securityException) {
                    break block13;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    break block13;
                }
                if (m != null) {
                    m.setAccessible(true);
                    return m;
                }
            }
            c = c.getSuperclass();
        }
        return null;
    }

    public Object invoke(String signature, Object[] params) throws Exception {
        Method m = this.getMethod(signature);
        return m.invoke(this.object, params);
    }

    public Field getField(String name) {
        Class c = this.class1;
        while (c != null) {
            block5: {
                Field f;
                try {
                    f = c.getDeclaredField(name);
                }
                catch (SecurityException securityException) {
                    break block5;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    break block5;
                }
                if (f != null) {
                    f.setAccessible(true);
                    return f;
                }
            }
            c = c.getSuperclass();
        }
        return null;
    }

    public Object getFieldObject(String name) throws IllegalAccessException {
        return this.getField(name).get(this.object);
    }

    private static boolean isParamAccept(Class cp, Class c) {
        if (cp.isAssignableFrom(c)) {
            return true;
        }
        if (Integer.TYPE == cp && Integer.class.equals((Object)c)) {
            return true;
        }
        if (Short.TYPE == cp && Short.class.equals((Object)c)) {
            return true;
        }
        if (Long.TYPE == cp && Long.class.equals((Object)c)) {
            return true;
        }
        if (Character.TYPE == cp && Character.class.equals((Object)c)) {
            return true;
        }
        if (Boolean.TYPE == cp && Boolean.class.equals((Object)c)) {
            return true;
        }
        if (Byte.TYPE == cp && Byte.class.equals((Object)c)) {
            return true;
        }
        return Float.TYPE == cp && Float.class.equals((Object)c) && Double.TYPE == cp && Double.class.equals((Object)c);
    }

    public Constructor findConstructor(Object[] params) {
        Constructor<?>[] cs = this.class1.getDeclaredConstructors();
        int i = 0;
        while (i < cs.length) {
            block7: {
                Class<?>[] cParams = cs[i].getParameterTypes();
                if (params == null) {
                    if (cParams.length == 0) {
                        return cs[i];
                    }
                } else if (cParams.length == params.length) {
                    int j = 0;
                    while (j < params.length) {
                        if (Mirror.isParamAccept(cParams[j], params[j].getClass())) {
                            ++j;
                            continue;
                        }
                        break block7;
                    }
                    return cs[i];
                }
            }
            ++i;
        }
        return null;
    }

    public Object newInstance(Object[] params) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        return this.findConstructor(params).newInstance(params);
    }

    public Mirror(String className) throws ClassNotFoundException {
        this.class1 = Class.forName(className);
        this.object = null;
    }

    public Mirror(Class cls) {
        this.class1 = cls;
        this.object = null;
    }

    public Mirror(Object object) {
        this.class1 = object.getClass();
        this.object = object;
    }

    public Mirror(String className, Object[] params) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException {
        this.class1 = Class.forName(className);
        this.object = this.newInstance(params);
    }

    public static void main(String[] args) throws Exception {
        Mirror miS = new Mirror("java.lang.String");
        System.out.println("java.lang.String.charAt:" + miS.getMethod("charAt"));
        System.out.println("java.lang.String.indexOf(int,int):" + miS.getMethod("indexOf(int, int)"));
        Mirror miS2 = new Mirror("java.lang.String", new Object[]{"test string"});
        System.out.println("String instanciation test:" + miS2.getObject());
        Mirror miI = new Mirror("java.lang.Integer", new Object[]{new Integer(100)});
        System.out.println("Integer instanciation test:" + miI.getObject());
    }
}

