/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.tts.sapi.preferences;

import org.eclipse.actf.ai.tts.TTSRegistry;
import org.eclipse.actf.ai.tts.sapi.Messages;
import org.eclipse.actf.ai.tts.sapi.SAPIPlugin;
import org.eclipse.actf.ai.tts.sapi.preferences.SapiAudioOutputFieldEditor;
import org.eclipse.actf.ai.tts.sapi.preferences.SapiTestManager;
import org.eclipse.actf.ai.tts.sapi.preferences.SapiVoiceFieldEditor;
import org.eclipse.actf.ai.voice.preferences.util.GroupFieldEditorVoicePreferencePage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SapiPreferencePage
extends GroupFieldEditorVoicePreferencePage
implements IWorkbenchPreferencePage {
    private String orgVoice;
    private String orgAudio;

    public SapiPreferencePage() {
        this.setDescription(Messages.tts_sapi_description);
        this.setPreferenceStore(SAPIPlugin.getDefault().getPreferenceStore());
    }

    public void createFieldEditors() {
        if (!TTSRegistry.isAvailable((String)"org.eclipse.actf.ai.tts.sapi.engine.SapiVoice")) {
            this.setMessage(Messages.tts_sapi_notAvailable);
            return;
        }
        this.orgVoice = this.getPreferenceStore().getString("org.eclipse.actf.ai.tts.sapi.engine.SapiVoice");
        this.orgAudio = this.getPreferenceStore().getString("org.eclipse.actf.ai.tts.SapiVoice.audioOutput");
        SapiVoiceFieldEditor voiceEditor = new SapiVoiceFieldEditor(Messages.tts_sapi_voicename, this.getFieldEditorParent());
        this.addField((FieldEditor)voiceEditor);
        this.addField((FieldEditor)new SapiAudioOutputFieldEditor(Messages.tts_sapi_audiooutput, this.getFieldEditorParent()));
        Composite comp = new Composite(this.getFieldEditorParent(), 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(128);
        gd.horizontalSpan = voiceEditor.getNumberOfControls();
        comp.setLayoutData((Object)gd);
        Button testButton = new Button(comp, 0);
        testButton.setText(Messages.tts_sapi_test);
        testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SapiTestManager.getInstance().speakTest();
            }
        });
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performCancel() {
        this.getPreferenceStore().setValue("org.eclipse.actf.ai.tts.sapi.engine.SapiVoice", this.orgVoice);
        this.getPreferenceStore().setValue("org.eclipse.actf.ai.tts.SapiVoice.audioOutput", this.orgAudio);
        return super.performCancel();
    }

    protected void performApply() {
        super.performApply();
        this.orgVoice = this.getPreferenceStore().getString("org.eclipse.actf.ai.tts.sapi.engine.SapiVoice");
        this.orgAudio = this.getPreferenceStore().getString("org.eclipse.actf.ai.tts.SapiVoice.audioOutput");
    }
}

