/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.fennec.impl;

import org.eclipse.actf.ai.fennec.FennecException;
import org.eclipse.actf.ai.fennec.FennecInterruptedException;
import org.eclipse.actf.ai.fennec.IFennecEntry;
import org.eclipse.actf.ai.fennec.IFennecService;
import org.eclipse.actf.ai.fennec.impl.FennecDOMReader;
import org.eclipse.actf.ai.fennec.impl.FennecGroupMetadata;
import org.eclipse.actf.ai.fennec.impl.FennecMetadata;
import org.eclipse.actf.ai.fennec.impl.FennecMode;
import org.eclipse.actf.ai.fennec.impl.FennecRecombinantMetadata;
import org.eclipse.actf.ai.fennec.impl.TreeItemAccessKeyList;
import org.eclipse.actf.ai.fennec.impl.TreeItemFennec;
import org.eclipse.actf.ai.fennec.impl.TreeItemSoundControl;
import org.eclipse.actf.ai.fennec.impl.TreeItemVideoControl;
import org.eclipse.actf.ai.fennec.treemanager.IAccessKeyList;
import org.eclipse.actf.ai.fennec.treemanager.ISoundControl;
import org.eclipse.actf.ai.fennec.treemanager.ITreeItem;
import org.eclipse.actf.ai.fennec.treemanager.IVideoControl;
import org.eclipse.actf.ai.fennec.treemanager.TreeManagerException;
import org.eclipse.actf.ai.query.IQuery;
import org.eclipse.actf.ai.query.QueryService;
import org.eclipse.actf.model.dom.dombycom.AnalyzedResult;
import org.eclipse.actf.model.dom.dombycom.IDocumentEx;
import org.eclipse.actf.model.dom.dombycom.IFlashNode;
import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.eclipse.actf.util.vocab.IEvalTarget;
import org.eclipse.actf.util.vocab.IProposition;
import org.eclipse.actf.util.vocab.Vocabulary;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FennecServiceImpl
implements IFennecService {
    private FennecMetadata rootMetadata;
    private int status;
    private TreeItemFennec lastItem;
    private IDocumentEx document;
    private Element root;
    private AnalyzedResult analyzedResult;
    private ISoundControl cachedSoundControl;
    private IVideoControl cachedVideoControl;
    private IAccessKeyList cachedAccessKeyList;
    private IFlashNode[] cachedFlashTopNodes;

    Element getDocumentElement() {
        return this.root;
    }

    private void initDefaultMetadata() {
        FennecMode rootMode = new FennecMode(0);
        FennecMode nextMode = new FennecMode(1, 23, true, false, false);
        IQuery q = QueryService.createFromXPath((String)"/HTML");
        FennecMetadata[] mds = new FennecMetadata[]{FennecRecombinantMetadata.newAttach(this, q, rootMode, nextMode, null)};
        this.rootMetadata = new FennecGroupMetadata(this, null, rootMode, mds);
    }

    public FennecServiceImpl(IFennecEntry entry, IDocumentEx document) throws FennecException {
        this.document = document;
        this.root = document.getDocumentElement();
        try {
            FennecDOMReader reader = new FennecDOMReader(this);
            this.rootMetadata = reader.parse(entry);
            this.status = 0;
        }
        catch (Exception e) {
            throw new FennecException("Failed to load Fennec data.", e);
        }
    }

    public FennecServiceImpl(IDocumentEx document) {
        this.document = document;
        this.root = document.getDocumentElement();
        this.initDefaultMetadata();
    }

    public int getStatus() {
        return this.status;
    }

    public int analyze() throws FennecException {
        this.analyzedResult = new AnalyzedResult();
        if (this.root instanceof INodeEx) {
            this.cachedVideoControl = null;
            this.cachedSoundControl = null;
            this.analyzedResult = ((INodeEx)this.root).analyze(this.analyzedResult);
        }
        return 0;
    }

    public int initialize() throws FennecException {
        if (this.analyzedResult == null) {
            this.analyze();
        }
        this.lastItem = this.rootMetadata.buildRootItem();
        if (this.lastItem == null) {
            throw new FennecException("Failed to initialize", null);
        }
        this.status = 1;
        return 1;
    }

    public ITreeItem getLastTreeItem() {
        return this.lastItem;
    }

    private int update(ITreeItem target, int trigger) throws FennecException {
        TreeItemFennec targetItem = (TreeItemFennec)target;
        if (targetItem.getParent() == null) {
            return this.initialize();
        }
        if ((targetItem = targetItem.expand(trigger)) == null) {
            return 0;
        }
        if (targetItem == null) {
            this.status = 0;
            throw new FennecInterruptedException("Lost my way");
        }
        this.lastItem = targetItem;
        return 1;
    }

    public int moveUpdate(ITreeItem target) throws FennecException {
        return this.update(target, 1);
    }

    public int moveUpdate(ITreeItem target, boolean update) throws FennecException {
        if (update) {
            return this.update(target, 1);
        }
        return this.update(target, 9);
    }

    public int clickUpdate(ITreeItem target) throws FennecException {
        return this.update(target, 2) | 8;
    }

    private int searchForwardChildren(int idx, TreeItemFennec item, IProposition proposition) throws FennecException {
        item = item.expandChildItems(4);
        ITreeItem[] childItems = item.getChildItems();
        int i = idx;
        while (i < childItems.length) {
            TreeItemFennec cItem = (TreeItemFennec)childItems[i];
            if (proposition.eval((IEvalTarget)cItem)) {
                return this.moveUpdate(cItem) | 0x40;
            }
            int st = this.searchForwardChildren(0, cItem, proposition);
            if ((st & 0x40) != 0) {
                return st;
            }
            ++i;
        }
        return 0;
    }

    private int searchForwardInternal(int idx, TreeItemFennec item, IProposition proposition) throws FennecException {
        int st = this.searchForwardChildren(idx, item, proposition);
        if ((st & 0x40) != 0) {
            return st;
        }
        TreeItemFennec pItem = (TreeItemFennec)item.getParent();
        if (pItem == null) {
            return 0;
        }
        st = this.searchForwardInternal(item.getNth() + 1, pItem, proposition);
        if ((st & 0x40) != 0) {
            return st;
        }
        return 0;
    }

    public ITreeItem[] getSiblings() throws TreeManagerException {
        ITreeItem parent = this.lastItem.getParent();
        if (parent == null) {
            ITreeItem[] itas = new ITreeItem[]{this.lastItem};
            return itas;
        }
        return parent.getChildItems();
    }

    public int searchForward(IProposition proposition) throws FennecException {
        return this.searchForwardInternal(0, this.lastItem, proposition);
    }

    private int searchBackwardInternal(boolean first, TreeItemFennec item, IProposition proposition) throws FennecException {
        ITreeItem[] childItems;
        ITreeItem[] siblings;
        TreeItemFennec pItem = (TreeItemFennec)item.getParent();
        if (pItem == null) {
            return 0;
        }
        int nth = item.getNth() - 1;
        if (nth < 0) {
            if (proposition.eval((IEvalTarget)pItem)) {
                return this.moveUpdate(pItem) | 0x40;
            }
            return this.searchBackwardInternal(false, pItem, proposition);
        }
        if (first) {
            pItem = pItem.expandChildItems(4);
        }
        if (nth >= (siblings = pItem.getChildItems()).length) {
            nth = siblings.length - 1;
        }
        item = (TreeItemFennec)siblings[nth];
        while ((childItems = (item = item.expandChildItems(4)).getChildItems()).length != 0) {
            item = (TreeItemFennec)childItems[childItems.length - 1];
        }
        if (proposition.eval((IEvalTarget)item)) {
            return this.moveUpdate(item) | 0x40;
        }
        return this.searchBackwardInternal(false, item, proposition);
    }

    public int searchBackward(IProposition predicate) throws FennecException {
        return this.searchBackwardInternal(true, this.lastItem, predicate);
    }

    public ISoundControl getSoundControl() {
        if (this.cachedSoundControl == null) {
            this.cachedSoundControl = TreeItemSoundControl.newTreeItemSoundControl(this.analyzedResult);
        }
        return this.cachedSoundControl;
    }

    public IVideoControl getVideoControl() {
        if (this.cachedVideoControl == null) {
            this.cachedVideoControl = TreeItemVideoControl.newTreeItemVideoControl(this.analyzedResult, this);
        }
        return this.cachedVideoControl;
    }

    public IAccessKeyList getAccessKeyList() {
        if (this.cachedAccessKeyList == null) {
            this.cachedAccessKeyList = TreeItemAccessKeyList.newAccessKeyList(this.analyzedResult);
        }
        return this.cachedAccessKeyList;
    }

    public IFlashNode[] getFlashTopNodes() {
        if (this.cachedFlashTopNodes == null) {
            this.cachedFlashTopNodes = this.analyzedResult.getFlashTopNodes();
        }
        return this.cachedFlashTopNodes;
    }

    private void expandWholeTreeInternal(TreeItemFennec item) throws FennecException {
        item = item.expandChildItems(4);
        ITreeItem[] childItems = item.getChildItems();
        int i = 0;
        while (i < childItems.length) {
            this.expandWholeTreeInternal((TreeItemFennec)childItems[i]);
            ++i;
        }
    }

    private int skipToNode(Element e) throws FennecException {
        this.initialize();
        return this.searchForward(Vocabulary.nodeLocation((Node)e, (boolean)false));
    }

    public int skipToAnchor(String target) throws FennecException {
        Element el = this.document.getTargetElement(target);
        if (el != null) {
            return this.skipToNode(el);
        }
        return 0;
    }

    public ITreeItem expandWholeTree() throws FennecException {
        this.initialize();
        if (this.lastItem instanceof TreeItemFennec) {
            this.expandWholeTreeInternal(this.lastItem);
        }
        return this.lastItem;
    }
}

