/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.util.httpproxy.core.IBufferRange;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.BufferRange;
import org.eclipse.actf.util.internal.httpproxy.core.ChunkDecoder;
import org.eclipse.actf.util.internal.httpproxy.core.ChunkEncoder;
import org.eclipse.actf.util.internal.httpproxy.core.ChunkListener;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessageBuffer;
import org.eclipse.actf.util.internal.httpproxy.core.HeaderInBuffer;
import org.eclipse.actf.util.internal.httpproxy.core.SocketTimeoutRetryInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HTTPReader {
    static final Logger LOGGER = Logger.getLogger(HTTPReader.class);
    public static final int INIT_NUM_HEADERS = 50;
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final char SP = ' ';
    public static final char HT = '\t';
    public static final int EOF = -1;
    private PushbackInputStream fIn;
    private long fLastReadTime = 0L;
    protected int fLastByte = -1;
    public static final int INIT_NUM_TRAILERS = 2;

    protected HTTPReader(InputStream in) {
        this.fIn = in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in, 1);
    }

    protected InputStream getInputStream() {
        return this.fIn;
    }

    protected final long getLastReadTime() {
        return this.fLastReadTime;
    }

    protected final int getLastByte() {
        return this.fLastByte;
    }

    /*
     * Unable to fully structure code
     */
    private int getAvailableInput(long timeout) throws IOException, TimeoutException {
        while (true) {
            try {
                data = this.fIn.read();
            }
            catch (SocketTimeoutException v0) {
                if (timeout <= 0L) continue;
                if (this.fLastReadTime == 0L) {
                    this.fLastReadTime = System.currentTimeMillis();
                }
                if (System.currentTimeMillis() - this.fLastReadTime > timeout) ** break;
                continue;
                this.fLastReadTime = System.currentTimeMillis();
                throw new TimeoutException("HTTPReader.getAvailableInput");
            }
            break;
        }
        this.fLastReadTime = System.currentTimeMillis();
        return data;
    }

    protected final boolean nextByte(long timeout, OutputStream replica) throws IOException, TimeoutException {
        this.fLastByte = this.getAvailableInput(timeout);
        if (this.fLastByte != -1) {
            replica.write(this.fLastByte);
            return true;
        }
        return false;
    }

    private final boolean hasContinuedLine(long timeout) throws IOException, TimeoutException {
        if (this.fLastByte != 10) {
            return false;
        }
        int nextChar = this.getAvailableInput(timeout);
        this.fIn.unread(nextChar);
        return nextChar == 32 || nextChar == 9;
    }

    protected final int readBytes(long timeout, OutputStream out, int len) throws IOException, TimeoutException {
        int i = 0;
        while (i < len) {
            if (!this.nextByte(timeout, out)) break;
            ++i;
        }
        return i;
    }

    protected List<IHTTPHeader> readChunkedMessageTrailers(long timeout, HTTPMessageBuffer buf) throws IOException, TimeoutException {
        HeaderInBuffer header;
        ArrayList<HeaderInBuffer> trailers = null;
        while ((header = this.readHeader(timeout, buf)) != null) {
            if (trailers == null) {
                trailers = new ArrayList<HeaderInBuffer>(2);
            }
            trailers.add(header);
        }
        return trailers;
    }

    protected HeaderInBuffer readHeader(long timeout, HTTPMessageBuffer buf) throws IOException, TimeoutException {
        BufferRange fieldName = new BufferRange();
        this.readNextToken(timeout, buf, fieldName, ':');
        if (this.fLastByte == -1 || this.fLastByte == 10) {
            return null;
        }
        if (this.fLastByte != 58) {
            throw new IOException("Unexpected char (" + this.fLastByte + ".) Expected was (':')");
        }
        this.skipSpaces(timeout, buf);
        BufferRange fieldValue = new BufferRange();
        this.readNextToken(timeout, buf, fieldValue);
        while (this.hasContinuedLine(timeout)) {
            this.readContinuedLine(timeout, buf, fieldValue);
        }
        HeaderInBuffer header = new HeaderInBuffer();
        header.init(buf, fieldName, fieldValue);
        return header;
    }

    private final int readContinuedLine(long timeout, HTTPMessageBuffer buf, IBufferRange range) throws IOException, TimeoutException {
        int start = buf.getLength();
        boolean cr = false;
        boolean crlf = false;
        while (this.fLastByte != -1) {
            this.nextByte(timeout, buf);
            if (this.fLastByte == 13) {
                cr = true;
                continue;
            }
            if (this.fLastByte == 10 && cr) {
                crlf = true;
                break;
            }
            cr = false;
        }
        int length = buf.getLength() - start;
        if (crlf) {
            length -= 2;
        }
        range.setLength(range.getLength() + length);
        return this.fLastByte;
    }

    protected final void skipSpaceCRAndLFs(long timeout) throws IOException, TimeoutException {
        this.fLastByte = this.getAvailableInput(timeout);
        while (this.fLastByte == 32 || this.fLastByte == 13 || this.fLastByte == 10) {
            this.fLastByte = SocketTimeoutRetryInputStream.read(this.fIn);
        }
        this.fIn.unread(this.fLastByte);
    }

    protected final void skipSpaces(long timeout, OutputStream replica) throws IOException, TimeoutException {
        this.fLastByte = this.getAvailableInput(timeout);
        while (this.fLastByte == 32) {
            replica.write(this.fLastByte);
            this.fLastByte = SocketTimeoutRetryInputStream.read(this.fIn);
        }
        this.fIn.unread(this.fLastByte);
    }

    protected final int readNextToken(long timeout, HTTPMessageBuffer buf, IBufferRange marker) throws IOException, TimeoutException {
        return this.readNextToken(timeout, buf, marker, '\u0000');
    }

    protected final int readNextToken(long timeout, HTTPMessageBuffer buf, IBufferRange marker, char delim) throws IOException, TimeoutException {
        int start = buf.getLength();
        this.nextByte(timeout, buf);
        int length = 0;
        boolean cr = false;
        while (this.fLastByte != -1) {
            if (delim != '\u0000' && this.fLastByte == delim) break;
            if (this.fLastByte == 13) {
                cr = true;
            } else {
                if (this.fLastByte == 10 && cr) {
                    --length;
                    break;
                }
                cr = false;
            }
            this.nextByte(timeout, buf);
            ++length;
        }
        if (length > 0) {
            marker.setStart(start);
            marker.setLength(length);
        }
        return this.fLastByte;
    }

    protected void readCRLF(long timeout, OutputStream out) throws IOException, TimeoutException {
        this.nextByte(timeout, out);
        if (this.fLastByte != 13) {
            throw new IOException("Unexpected char (" + this.fLastByte + ".) Expected was (" + Integer.toString(13) + ")");
        }
        this.nextByte(timeout, out);
        if (this.fLastByte != 10) {
            throw new IOException("Unexpected char (" + this.fLastByte + ".) Expected was (" + Integer.toString(10) + ")");
        }
    }

    protected final String readNextToken(long timeout, OutputStream out) throws IOException, TimeoutException {
        return this.readNextToken(timeout, out, '\u0000');
    }

    protected final String readNextToken(long timeout, OutputStream out, char delim) throws IOException, TimeoutException {
        this.nextByte(timeout, out);
        if (this.fLastByte == -1) {
            return null;
        }
        boolean cr = false;
        StringBuffer token = new StringBuffer();
        while (this.fLastByte != -1) {
            if (delim != '\u0000' && this.fLastByte == delim) break;
            if (this.fLastByte == 13) {
                cr = true;
            } else {
                if (this.fLastByte == 10 && cr) break;
                cr = false;
                token.append((char)this.fLastByte);
            }
            this.nextByte(timeout, out);
        }
        return token.toString();
    }

    public int readChunkedMessageBody(long timeout, OutputStream out) throws IOException, TimeoutException {
        ChunkDecoder decoder = new ChunkDecoder(this.fIn);
        final ChunkEncoder encoder = new ChunkEncoder(out);
        decoder.setChunkListener(new ChunkListener(){

            public void newChankRead(int n, int size) {
                try {
                    encoder.setMaxChunkSize(size);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        try {
            int b;
            int n = 0;
            while ((b = decoder.read(timeout)) != -1) {
                encoder.write(b);
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            encoder.close();
        }
    }
}

