/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32;

import org.eclipse.actf.util.win32.WindowUtil;
import org.eclipse.actf.util.win32.comclutch.ComService;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.eclipse.actf.util.win32.comclutch.IUnknown;
import org.eclipse.actf.util.win32.msaa.IAccessible;
import org.eclipse.actf.util.win32.msaa.MSAA;

public class FlashMSAAObject {
    FlashMSAAObject parent;
    IAccessible iacc;
    int childId = 0;
    private FlashMSAAObject[] cachedChildren = new FlashMSAAObject[0];
    private String strClassName;
    private long accWindow = -1L;

    FlashMSAAObject(IAccessible iacc) {
        this.iacc = iacc;
    }

    FlashMSAAObject(FlashMSAAObject parent, int childId) {
        this.parent = parent;
        this.childId = childId;
    }

    private int getChildId() {
        return this.childId;
    }

    public IAccessible getIAccessible() {
        if (this.iacc != null) {
            return this.iacc;
        }
        if (this.parent != null) {
            return this.parent.getIAccessible();
        }
        return null;
    }

    public String getAccKeyboardShortcut() {
        return this.getIAccessible().getAccKeyboardShortcut(this.getChildId());
    }

    public int getAccRole() {
        return this.getIAccessible().getAccRole(this.getChildId());
    }

    public String getAccDescription() {
        return this.getIAccessible().getAccDescription(this.getChildId());
    }

    public int getAccState() {
        return this.getIAccessible().getAccState(this.getChildId());
    }

    public boolean doDefaultAction() {
        try {
            return this.getIAccessible().accDoDefaultAction(this.getChildId());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int getChildCount() {
        if (this.iacc != null) {
            return this.iacc.getAccChildCount();
        }
        return 0;
    }

    public String getAccName() {
        return this.getIAccessible().getAccName(this.getChildId());
    }

    public boolean select(int selflagTakefocus) {
        this.getIAccessible().accSelect(selflagTakefocus, this.getChildId());
        return true;
    }

    public FlashMSAAObject[] getChildren() {
        int childCount = Math.max(0, this.getChildCount());
        if (childCount == this.cachedChildren.length) {
            return this.cachedChildren;
        }
        if (childCount > 32768) {
            System.err.println("Too many children(" + childCount + "), we don't fectch.");
            return new FlashMSAAObject[0];
        }
        this.cachedChildren = new FlashMSAAObject[childCount];
        if (childCount > 0) {
            Object[] children = MSAA.getAccessibleChildren((IDispatch)this.getIAccessible(), (int)0, (int)childCount);
            int i = 0;
            while (i < childCount) {
                if (children[i] != null) {
                    if (children[i] instanceof Integer) {
                        this.cachedChildren[i] = new FlashMSAAObject(this, (Integer)children[i]);
                    } else if (children[i] instanceof IDispatch) {
                        IAccessible iacc = ComService.newIAccessible((IUnknown)((IDispatch)children[i]));
                        this.cachedChildren[i] = new FlashMSAAObject(iacc);
                    }
                }
                ++i;
            }
        }
        return this.cachedChildren;
    }

    public String getClassName() {
        if (this.strClassName == null) {
            long hwnd = this.getWindow();
            this.strClassName = null;
            if (0L != hwnd) {
                this.strClassName = WindowUtil.GetWindowClassName((int)hwnd);
            }
        }
        return this.strClassName;
    }

    public int getWindow() {
        if (-1L == this.accWindow) {
            try {
                this.accWindow = MSAA.WindowFromAccessibleObject((long)this.getIAccessible().getPtr());
            }
            catch (Exception exception) {
                this.accWindow = 0L;
            }
        }
        return (int)this.accWindow;
    }

    public int getPtr() {
        return (int)this.getIAccessible().getPtr();
    }
}

