/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.util;

import java.io.PrintStream;
import org.eclipse.actf.ai.xmlstore.nvdl.util.MessageFormatter;

public class Log {
    public static final int FATAL = 0;
    public static final int ERROR = 1;
    public static final int WARN = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    private static final Object[] defArg = new Object[0];
    private static int logLevel = 3;

    private static void print(int lv, String mes, Object[] args) {
        if (lv <= logLevel) {
            String outstr = MessageFormatter.mes(mes, args);
            PrintStream w = lv <= 1 ? System.err : System.out;
            w.println(outstr);
        }
    }

    private static void print(int lv, String mes) {
        Log.print(lv, mes, defArg);
    }

    public static void setLevel(int lv) {
        logLevel = lv;
    }

    public static void debug(String mes) {
        Log.print(4, mes);
    }

    public static void debug(String mes, Object[] args) {
        Log.print(4, mes, args);
    }

    public static void info(String mes) {
        Log.print(3, mes);
    }

    public static void info(String mes, Object[] args) {
        Log.print(3, mes, args);
    }

    public static void warn(String mes) {
        Log.print(2, mes);
    }

    public static void warn(String mes, Object[] args) {
        Log.print(2, mes, args);
    }

    public static void error(String mes) {
        Log.print(1, mes);
    }

    public static void error(String mes, Object[] args) {
        Log.print(1, mes, args);
    }

    public static void fatal(String mes) {
        Log.print(0, mes);
    }

    public static void fatal(String mes, Object[] args) {
        Log.print(0, mes, args);
    }
}

