/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.model;

import org.eclipse.actf.ai.xmlstore.nvdl.util.IRIUtil;

public class Location {
    public final int line;
    public final int pos;
    public final String iri;

    public String toString() {
        StringBuffer r = new StringBuffer(IRIUtil.IRIToFilename(this.iri));
        r.append("(");
        if (this.line > 0) {
            r.append(this.line);
        } else {
            r.append("NoLine");
        }
        if (this.pos > 0) {
            r.append(":" + this.pos);
        }
        r.append(")");
        return r.toString();
    }

    public Location() {
        this.line = -1;
        this.pos = -1;
        this.iri = "";
    }

    public Location(int line) {
        this.line = line;
        this.pos = -1;
        this.iri = "";
    }

    public Location(int line, int pos) {
        this.line = line;
        this.pos = pos;
        this.iri = "";
    }

    public Location(int line, int pos, String iri) {
        this.line = line;
        this.pos = pos;
        this.iri = iri == null ? "" : iri;
    }
}

