/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.driver;

import java.io.File;
import java.io.FilenameFilter;
import javax.xml.parsers.SAXParser;
import javax.xml.validation.ValidatorHandler;
import org.eclipse.actf.ai.xmlstore.nvdl.NVDLException;
import org.eclipse.actf.ai.xmlstore.nvdl.dispatcher.NVDLSAXDispatcher;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRules;
import org.eclipse.actf.ai.xmlstore.nvdl.reader.NVDLSAXReader;
import org.eclipse.actf.ai.xmlstore.nvdl.util.DefaultErrorHandler;
import org.eclipse.actf.ai.xmlstore.nvdl.util.IRIUtil;
import org.eclipse.actf.ai.xmlstore.nvdl.util.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TestDriver {
    SAXParser parser = NVDLSAXReader.newSAXParser();
    NVDLSAXReader r;

    TestDriver() throws SAXException {
        this.parser.getXMLReader().setErrorHandler(DefaultErrorHandler.getErrorHandler());
        this.r = new NVDLSAXReader(this.parser);
    }

    NVDLRules readTest(String path, boolean result) throws Exception {
        InputSource is = IRIUtil.newInputSourceFromFilename(path);
        if (!result) {
            System.out.println("Interpret " + path + ", assuming it is invalid.");
            try {
                this.r.parse(is);
            }
            catch (Exception exception) {
                return null;
            }
            throw new NVDLException("The test failed... ");
        }
        System.out.println("Interpret " + path + ", assuming it is valid.");
        return this.r.parse(is);
    }

    void dispatchTest(XMLReader vr, File d, TestSet.Case c) throws Exception {
        String path = String.valueOf(d.getPath()) + File.separator + c.xmlFilename;
        InputSource is = IRIUtil.newInputSourceFromFilename(path);
        if (!c.result) {
            System.out.println("Validate " + path + ", assuming it is invalid.");
            try {
                vr.parse(is);
            }
            catch (Exception exception) {
                return;
            }
            throw new NVDLException("The test failed... ");
        }
        System.out.println("Validate " + path + ", assuming it is valid.");
        vr.parse(is);
    }

    void doTest(File d, TestSet ts) throws Exception {
        NVDLRules rules = this.readTest(String.valueOf(d.getPath()) + File.separator + ts.nvdlFilename, ts.result);
        if (!ts.result) {
            return;
        }
        NVDLSAXDispatcher dispatcher = new NVDLSAXDispatcher(rules, false);
        ValidatorHandler h = dispatcher.getValidatorHandler();
        XMLReader vr = XMLReaderFactory.createXMLReader();
        vr.setFeature("http://xml.org/sax/features/namespaces", true);
        vr.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        h.setErrorHandler(DefaultErrorHandler.getErrorHandler());
        vr.setContentHandler(h);
        vr.setErrorHandler(DefaultErrorHandler.getErrorHandler());
        int i = 0;
        while (i < ts.cases.length) {
            this.dispatchTest(vr, d, ts.cases[i]);
            dispatcher.reset();
            ++i;
        }
    }

    void invalidFilename(String filename) {
        throw new IllegalArgumentException("Filename must be of the form of '<name>-<true/false>-<number>.<suffix>':" + filename);
    }

    void testCaseSet(File base, TestSet ts) {
        String[] fileList = base.list(new BaseNameFilter(ts.baseName));
        ts.cases = new TestSet.Case[fileList.length];
        int i = 0;
        while (i < fileList.length) {
            String[] parts = fileList[i].split("-");
            TestSet.Case cs = ts.newCase();
            cs.xmlFilename = fileList[i];
            if ("true".equals(parts[1])) {
                cs.result = true;
            } else if ("false".equals(parts[1])) {
                cs.result = false;
            } else {
                this.invalidFilename(cs.xmlFilename);
            }
            ts.cases[i] = cs;
            ++i;
        }
    }

    TestSet parseFilename(File base, String filename) {
        String[] parts = filename.split("-");
        if (parts.length != 3) {
            this.invalidFilename(filename);
        }
        TestSet ts = new TestSet();
        ts.nvdlFilename = filename;
        ts.baseName = parts[0];
        if ("true".equals(parts[1])) {
            ts.result = true;
            this.testCaseSet(base, ts);
        } else if ("false".equals(parts[1])) {
            ts.result = false;
        } else {
            this.invalidFilename(filename);
        }
        return ts;
    }

    void testDir(String dir) throws Exception {
        File f = new File(dir);
        if (!f.exists()) {
            Log.error("Directory:" + dir + " does not exist.  Skip it.");
            return;
        }
        if (!f.isDirectory()) {
            Log.error(String.valueOf(dir) + " is not a directory.  Skip it.");
            return;
        }
        String[] fileList = f.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (!name.endsWith(".nvdl")) {
                    return false;
                }
                String[] parts = name.split("-");
                return parts.length == 3;
            }
        });
        int i = 0;
        while (i < fileList.length) {
            this.doTest(f, this.parseFilename(f, fileList[i]));
            ++i;
        }
    }

    public static void main(String[] args) {
        try {
            TestDriver td = new TestDriver();
            int i = 0;
            while (i < args.length) {
                td.testDir(args[i]);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace(System.out);
            System.out.flush();
            System.exit(255);
        }
        System.out.println("All tests are done.");
        System.out.flush();
        System.exit(0);
    }

    static class BaseNameFilter
    implements FilenameFilter {
        final String baseName;

        public boolean accept(File dir, String name) {
            if (!name.endsWith(".xml")) {
                return false;
            }
            String[] parts = name.split("-");
            if (parts.length != 3) {
                return false;
            }
            return parts[0].equals(this.baseName);
        }

        BaseNameFilter(String baseName) {
            this.baseName = baseName;
        }
    }

    public static class TestSet {
        boolean result;
        String baseName;
        String nvdlFilename;
        Case[] cases;

        Case newCase() {
            return new Case();
        }

        public class Case {
            boolean result;
            String xmlFilename;
        }
    }
}

