/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable.masterdetail;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.internal.databinding.observable.masterdetail.DetailObservableHelper;
import org.eclipse.core.runtime.Assert;

public class DetailObservableValue
extends AbstractObservableValue
implements IObserving {
    private boolean updating = false;
    private IValueChangeListener innerChangeListener = new IValueChangeListener(){

        public void handleValueChange(ValueChangeEvent event) {
            if (!DetailObservableValue.this.updating) {
                DetailObservableValue.this.fireValueChange(event.diff);
            }
        }
    };
    private Object currentOuterValue;
    private IObservableValue innerObservableValue;
    private Object detailType;
    private IObservableValue outerObservableValue;
    private IObservableFactory factory;
    IValueChangeListener outerChangeListener = new IValueChangeListener(){

        public void handleValueChange(ValueChangeEvent event) {
            ObservableTracker.runAndIgnore(new Runnable(this){
                final /* synthetic */ 2 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    Object oldValue = 2.access$0(this.this$1).doGetValue();
                    DetailObservableValue.access$2(2.access$0(this.this$1));
                    DetailObservableValue.access$1(2.access$0(this.this$1), Diffs.createValueDiff(oldValue, 2.access$0(this.this$1).doGetValue()));
                }
            });
        }

        static /* synthetic */ DetailObservableValue access$0(2 var0) {
            return var0.DetailObservableValue.this;
        }
    };

    public DetailObservableValue(IObservableValue outerObservableValue, IObservableFactory factory, Object detailType) {
        super(outerObservableValue.getRealm());
        Assert.isTrue((!outerObservableValue.isDisposed() ? 1 : 0) != 0, (String)"Master observable is disposed");
        this.factory = factory;
        this.detailType = detailType;
        this.outerObservableValue = outerObservableValue;
        outerObservableValue.addDisposeListener(new IDisposeListener(){

            public void handleDispose(DisposeEvent staleEvent) {
                DetailObservableValue.this.dispose();
            }
        });
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                DetailObservableValue.this.updateInnerObservableValue();
            }
        });
        outerObservableValue.addValueChangeListener(this.outerChangeListener);
    }

    private void updateInnerObservableValue() {
        this.currentOuterValue = this.outerObservableValue.getValue();
        if (this.innerObservableValue != null) {
            this.innerObservableValue.removeValueChangeListener(this.innerChangeListener);
            this.innerObservableValue.dispose();
        }
        if (this.currentOuterValue == null) {
            this.innerObservableValue = null;
        } else {
            ObservableTracker.runAndIgnore(new Runnable(){

                public void run() {
                    DetailObservableValue.this.innerObservableValue = (IObservableValue)DetailObservableValue.this.factory.createObservable(DetailObservableValue.this.currentOuterValue);
                }
            });
            DetailObservableHelper.warnIfDifferentRealms(this.getRealm(), this.innerObservableValue.getRealm());
            if (this.detailType != null) {
                Object innerValueType = this.innerObservableValue.getValueType();
                Assert.isTrue((boolean)this.detailType.equals(innerValueType), (String)("Cannot change value type in a nested observable value, from " + innerValueType + " to " + this.detailType));
            }
            this.innerObservableValue.addValueChangeListener(this.innerChangeListener);
        }
    }

    public void doSetValue(final Object value) {
        if (this.innerObservableValue != null) {
            ObservableTracker.runAndIgnore(new Runnable(){

                public void run() {
                    DetailObservableValue.this.innerObservableValue.setValue(value);
                }
            });
        }
    }

    public Object doGetValue() {
        if (this.innerObservableValue == null) {
            return null;
        }
        final Object[] result = new Object[1];
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                result[0] = DetailObservableValue.this.innerObservableValue.getValue();
            }
        });
        return result[0];
    }

    public Object getValueType() {
        return this.detailType;
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.outerObservableValue != null) {
            this.outerObservableValue.removeValueChangeListener(this.outerChangeListener);
        }
        if (this.innerObservableValue != null) {
            this.innerObservableValue.removeValueChangeListener(this.innerChangeListener);
            this.innerObservableValue.dispose();
        }
        this.outerObservableValue = null;
        this.outerChangeListener = null;
        this.currentOuterValue = null;
        this.factory = null;
        this.innerObservableValue = null;
        this.innerChangeListener = null;
    }

    public Object getObserved() {
        if (this.innerObservableValue instanceof IObserving) {
            return ((IObserving)((Object)this.innerObservableValue)).getObserved();
        }
        return null;
    }
}

