/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.ui.util;

import org.eclipse.actf.model.internal.ui.WebBrowserUtilForACTF;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.IModelServiceHolder;
import org.eclipse.actf.model.ui.editor.DummyEditorInput;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.ui.util.PlatformUIUtil;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ModelServiceUtils {
    public static IEditorPart launch(String targetUrl) {
        IWorkbenchPage activePage = PlatformUIUtil.getActivePage();
        if (activePage == null) {
            return null;
        }
        if (targetUrl != null && targetUrl.length() != 0) {
            targetUrl = targetUrl.trim();
            IEditorReference[] editorRefs = activePage.getEditorReferences();
            int i = 0;
            while (i < editorRefs.length) {
                IModelService modelService;
                IEditorPart part = editorRefs[i].getEditor(false);
                if (part instanceof IModelServiceHolder && targetUrl.equals((modelService = ((IModelServiceHolder)part).getModelService()).getURL())) {
                    activePage.activate((IWorkbenchPart)part);
                    modelService.open(targetUrl);
                    return part;
                }
                ++i;
            }
            try {
                return ModelServiceUtils.launch(targetUrl, ModelServiceUtils.getEditorId(targetUrl));
            }
            catch (EditorNotFoundException editorNotFoundException) {
                System.err.println("Editor not found: " + targetUrl);
            }
        }
        return null;
    }

    private static boolean isModelService(IEditorDescriptor desc) {
        if (desc == null) {
            return false;
        }
        return desc.getId().indexOf("actf.model.ui") >= 0;
    }

    private static String getEditorId(String targetUrl) throws EditorNotFoundException {
        IEditorDescriptor desc;
        int n;
        int n2;
        IEditorDescriptor[] iEditorDescriptorArray;
        IEditorDescriptor[] candidates;
        IEditorDescriptor editor;
        IEditorRegistry editors = PlatformUI.getWorkbench().getEditorRegistry();
        if (!targetUrl.startsWith("http://") && !targetUrl.startsWith("https://")) {
            editor = editors.getDefaultEditor(targetUrl);
            if (ModelServiceUtils.isModelService(editor)) {
                return editor.getId();
            }
            iEditorDescriptorArray = candidates = editors.getEditors(targetUrl);
            n2 = candidates.length;
            n = 0;
            while (n < n2) {
                desc = iEditorDescriptorArray[n];
                if (ModelServiceUtils.isModelService(desc)) {
                    return desc.getId();
                }
                ++n;
            }
        }
        if (ModelServiceUtils.isModelService(editor = editors.getDefaultEditor("default.html"))) {
            return editor.getId();
        }
        iEditorDescriptorArray = candidates = editors.getEditors("default.html");
        n2 = candidates.length;
        n = 0;
        while (n < n2) {
            desc = iEditorDescriptorArray[n];
            if (ModelServiceUtils.isModelService(desc)) {
                return desc.getId();
            }
            ++n;
        }
        throw new EditorNotFoundException();
    }

    public static IEditorPart launch(String targetUrl, String id) {
        IWorkbenchPage activePage = PlatformUIUtil.getActivePage();
        if (activePage == null) {
            return null;
        }
        targetUrl = targetUrl != null ? targetUrl.trim() : "";
        IEditorPart blankEditorPart = ModelServiceUtils.getBlankBrowserEditorPart(id);
        if (blankEditorPart != null) {
            activePage.activate((IWorkbenchPart)blankEditorPart);
            if (targetUrl != null) {
                ((IModelServiceHolder)blankEditorPart).getModelService().open(targetUrl);
                return blankEditorPart;
            }
        } else {
            IEditorReference[] editorRefs = activePage.getEditorReferences();
            int i = 0;
            while (i < editorRefs.length) {
                IModelService modelService;
                IWorkbenchPart part;
                if (editorRefs[i].getId().equals(id) && (part = editorRefs[i].getPart(false)) instanceof IModelServiceHolder && targetUrl.equals((modelService = ((IModelServiceHolder)part).getModelService()).getURL())) {
                    activePage.activate(part);
                    return (IEditorPart)part;
                }
                ++i;
            }
            try {
                String editorName = "";
                IEditorRegistry editors = PlatformUI.getWorkbench().getEditorRegistry();
                IEditorDescriptor editorDesc = editors.findEditor(id);
                if (editorDesc != null) {
                    editorName = editorDesc.getLabel();
                    return activePage.openEditor((IEditorInput)new DummyEditorInput(targetUrl, editorName), id);
                }
                System.err.println("Editor not found: " + id);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static IEditorPart getBlankBrowserEditorPart(String id) {
        IEditorReference[] editors = PlatformUIUtil.getActivePage().getEditorReferences();
        int i = 0;
        while (i < editors.length) {
            IWorkbenchPart part;
            if (editors[i].getId().equals(id) && (part = editors[i].getPart(false)) instanceof IModelServiceHolder) {
                IModelService modelService = ((IModelServiceHolder)part).getModelService();
                if (modelService.getURL() == null) {
                    return (IEditorPart)part;
                }
                if (modelService instanceof IWebBrowserACTF && ("about:blank".equals(modelService.getURL()) || "".equals(modelService.getURL()))) {
                    return (IEditorPart)part;
                }
            }
            ++i;
        }
        return null;
    }

    public static void openInExistingEditor(String targetUrl) {
        String editorId;
        if (targetUrl == null) {
            return;
        }
        targetUrl = targetUrl.trim();
        IWorkbenchPage activePage = PlatformUIUtil.getActivePage();
        if (activePage == null) {
            return;
        }
        try {
            editorId = ModelServiceUtils.getEditorId(targetUrl);
        }
        catch (EditorNotFoundException editorNotFoundException) {
            System.err.println("Editor not found: " + targetUrl);
            return;
        }
        if (ModelServiceUtils.activateEditorPart(editorId)) {
            IEditorPart editor = activePage.getActiveEditor();
            if (editor instanceof IModelServiceHolder) {
                ((IModelServiceHolder)editor).getModelService().open(targetUrl);
            } else {
                ModelServiceUtils.launch(targetUrl);
            }
        } else {
            ModelServiceUtils.launch(targetUrl);
        }
    }

    public static boolean activateEditorPart(String id) {
        if (id != null) {
            IWorkbenchPage activePage = PlatformUIUtil.getActivePage();
            if (activePage == null) {
                return false;
            }
            IEditorPart editor = activePage.getActiveEditor();
            if (editor != null && editor.getSite().getId().equals(id)) {
                return true;
            }
            IEditorReference[] editors = activePage.getEditorReferences();
            int i = 0;
            while (i < editors.length) {
                DebugPrintUtil.devOrDebugPrintln((Object)editors[i].getId());
                if (editors[i].getId().equals(id) && (editor = editors[i].getEditor(false)) != null) {
                    activePage.activate((IWorkbenchPart)editor);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static IModelServiceHolder getActiveModelServiceHolder() {
        IEditorPart editor = PlatformUIUtil.getActiveEditor();
        if (editor != null && editor instanceof IModelServiceHolder) {
            return (IModelServiceHolder)editor;
        }
        DebugPrintUtil.devOrDebugPrintln((Object)("ModelServiceUtils: " + editor + " isn't IModelServiceHolder"));
        return null;
    }

    public static IModelService getActiveModelService() {
        IModelServiceHolder holder = ModelServiceUtils.getActiveModelServiceHolder();
        if (holder != null) {
            return holder.getModelService();
        }
        return null;
    }

    public static IEditorPart reopenInACTFBrowser() {
        String url = WebBrowserUtilForACTF.getUrl(PlatformUIUtil.getActiveEditor());
        if (url != null) {
            return ModelServiceUtils.launch(url);
        }
        return null;
    }

    private static class EditorNotFoundException
    extends Exception {
        private static final long serialVersionUID = -5760127077107164112L;

        private EditorNotFoundException() {
        }
    }
}

