/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.screenreader.jaws;

import org.eclipse.actf.ai.navigator.IScreenReaderControl;
import org.eclipse.actf.ai.screenreader.jaws.JawsAPI;
import org.eclipse.actf.ai.screenreader.jaws.JawsWindowUtil;
import org.eclipse.actf.ai.tts.ITTSEngine;
import org.eclipse.actf.ai.voice.IVoiceEventListener;

public class Jaws
implements ITTSEngine,
IScreenReaderControl {
    public static final String JAWS_ON_SCRIPT = "JawsOn";
    public static final String JAWS_OFF_SCRIPT = "JawsOff";
    public static final String JAWS_OBSERVE_SPEECH = "ObserveSpeech";
    public static final String SAYALLOFF = "AiBrowserSayAllOff";
    JawsAPI jaws = JawsAPI.getInstance();
    JawsWindowUtil util = JawsWindowUtil.getInstance();

    public void dispose() {
    }

    public boolean isDisposed() {
        return false;
    }

    public int getSpeed() {
        return 0;
    }

    public void setEventListener(IVoiceEventListener eventListener) {
        if (this.util != null) {
            this.util.setEventListener(eventListener);
        }
    }

    public void setLanguage(String language) {
    }

    public void setSpeed(int speed) {
    }

    public void speak(String text, int flags, int index) {
        if (this.jaws == null || this.util == null) {
            return;
        }
        if (index < 0) {
            this.jaws.JawsSayString(text, flags == 1);
        } else {
            this.util.JawsShowTextToWindow(text, flags == 1, index);
            this.jaws.JawsRunScript(JAWS_OBSERVE_SPEECH);
        }
    }

    public void stop() {
        if (this.jaws != null && this.util != null) {
            this.jaws.JawsStopSpeech();
            this.util.resetJawsWindowText();
            this.jaws.JawsRunScript(SAYALLOFF);
        }
    }

    public void screenReaderOff() {
        if (this.jaws != null) {
            this.jaws.JawsRunScript(JAWS_OFF_SCRIPT);
        }
    }

    public void screenReaderOn() {
        if (this.jaws != null) {
            this.jaws.JawsRunScript(JAWS_ON_SCRIPT);
        }
    }

    public void takeBackControl() {
        if (this.util != null) {
            this.util.TakeBackControl();
        }
    }

    public void setGender(String gender) {
    }

    public boolean isAvailable() {
        if (this.jaws == null) {
            return false;
        }
        return this.jaws.isAvailable();
    }
}

