/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.audio.description.impl;

import java.util.HashMap;
import org.eclipse.actf.ai.audio.description.IMetadataProvider;
import org.eclipse.actf.ai.audio.description.impl.MediaSyncEventListener;
import org.eclipse.actf.ai.audio.description.impl.MetadataManager;
import org.eclipse.actf.ai.fennec.treemanager.IMediaSyncEventListener;
import org.eclipse.actf.ai.internal.audio.description.DescriptionPlugin;
import org.eclipse.actf.ai.internal.audio.description.Messages;
import org.eclipse.actf.ai.navigator.IMediaControl;

public class MediaControlImpl
implements IMediaControl {
    private HashMap<IMediaControl.IHandle, MetadataManager> map = new HashMap();
    MetadataManager manager;
    MetadataManager oldManager;
    IMediaControl.IHandle old = null;
    IMediaControl.IHandle handle;

    public void dispose(IMediaControl.IHandle handle) {
    }

    public void start(IMediaControl.IHandle handle) {
        this.initialize(handle);
    }

    private void initialize(IMediaControl.IHandle handle) {
        this.handle = handle;
        MetadataManager temp = this.map.get(handle);
        IMetadataProvider provider = null;
        if (temp == null) {
            String url = handle.getWebBrowser().getURL();
            provider = DescriptionPlugin.getDefault().getMetadata(url);
            temp = new MetadataManager(handle, provider);
            if (handle.getVideoControl() != null) {
                handle.getVideoControl().addEventListener((IMediaSyncEventListener)new MediaSyncEventListener(handle, temp));
            }
        }
        if (this.manager != null) {
            this.manager.stop();
        }
        this.manager = temp;
        this.manager.start();
        DescriptionPlugin.getDefault().setActiveMetadataProvider(provider);
        if (this.manager.hasMetadata()) {
            if (this.oldManager != null) {
                System.out.println(this.oldManager.getMetadataProvider());
                System.out.println(this.manager.getMetadataProvider());
            }
            if (this.oldManager == null || this.oldManager.getMetadataProvider() != this.manager.getMetadataProvider()) {
                handle.getVoice();
                this.oldManager = this.manager;
            }
        }
    }

    public void speakInfo(boolean flush) {
        DescriptionPlugin plugin = DescriptionPlugin.getDefault();
        if (!plugin.isAvailable()) {
            return;
        }
        if (this.handle.getVoice() == null) {
            return;
        }
        if (plugin.getEnable()) {
            this.handle.getVoice().speak(Messages.AudioDescription_on, flush);
        } else {
            this.handle.getVoice().speak(Messages.AudioDescription_off, flush);
        }
    }

    public int toggleEnabled() {
        DescriptionPlugin plugin = DescriptionPlugin.getDefault();
        return plugin.toggleEnable();
    }

    public boolean isAvailable() {
        DescriptionPlugin plugin = DescriptionPlugin.getDefault();
        return plugin.isAvailable();
    }

    public boolean toggleViewShowing() {
        DescriptionPlugin plugin = DescriptionPlugin.getDefault();
        return plugin.getDescriptionView().toggleViewShowing();
    }

    public boolean isEnabled() {
        DescriptionPlugin plugin = DescriptionPlugin.getDefault();
        return plugin.getEnable();
    }
}

