/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.preferences;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.help.internal.base.remote.RemoteIC;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.preferences.IRemoteHelpListViewer;
import org.eclipse.help.ui.internal.preferences.RemoteICLabelProvider;
import org.eclipse.help.ui.internal.preferences.RemoteICList;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class RemoteICViewer {
    private Table table;
    private TableViewer tableViewer;
    private RemoteICList remoteICList = new RemoteICList();
    private final String NAME_COLUMN = Messages.RemoteICViewer_Name;
    private final String LOCATION_COLUMN = Messages.RemoteICViewer_URL;
    private final String STATUS_COLUMN = Messages.RemoteICViewer_Enabled;
    private String[] columnNames = new String[]{this.NAME_COLUMN, this.LOCATION_COLUMN, this.STATUS_COLUMN};

    public RemoteICViewer(Composite parent) {
        this.createTable(parent);
        this.createTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)new RemoteICContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new RemoteICLabelProvider());
        this.remoteICList = new RemoteICList();
        this.tableViewer.setInput((Object)this.remoteICList);
    }

    public void dispose() {
        this.tableViewer.getLabelProvider().dispose();
    }

    private void createTable(Composite parent) {
        int style = 68356;
        this.table = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 200;
        gridData.heightHint = this.table.getItemHeight();
        gridData.horizontalSpan = 1;
        this.table.setLayoutData((Object)gridData);
        TableLayout tableLayout = new TableLayout();
        this.table.setLayout((Layout)tableLayout);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setFont(parent.getFont());
        ColumnLayoutData[] fTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(85), new ColumnWeightData(165), new ColumnWeightData(60)};
        tableLayout.addColumnData(fTableColumnLayouts[0]);
        TableColumn column = new TableColumn(this.table, 0, 0);
        column.setResizable(fTableColumnLayouts[0].resizable);
        column.setText(this.NAME_COLUMN);
        tableLayout.addColumnData(fTableColumnLayouts[1]);
        column = new TableColumn(this.table, 0, 1);
        column.setResizable(fTableColumnLayouts[1].resizable);
        column.setText(this.LOCATION_COLUMN);
        tableLayout.addColumnData(fTableColumnLayouts[2]);
        column = new TableColumn(this.table, 0, 2);
        column.setResizable(fTableColumnLayouts[2].resizable);
        column.setText(this.STATUS_COLUMN);
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(this.columnNames);
    }

    public void updateRemoteICList(Vector rics) {
        this.getRemoteICList().setRemoteICs(rics);
        this.updateView();
    }

    public void updateView() {
        this.getTableViewer().refresh((Object)this.getRemoteICList());
    }

    public List getColumnNames() {
        return Arrays.asList(this.columnNames);
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public RemoteICList getRemoteICList() {
        return this.remoteICList;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Control getControl() {
        return this.table.getParent();
    }

    public Table getTable() {
        return this.table;
    }

    class RemoteICContentProvider
    implements IStructuredContentProvider,
    IRemoteHelpListViewer {
        RemoteICContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((RemoteICList)newInput).addChangeListener(this);
            }
            if (oldInput != null) {
                ((RemoteICList)oldInput).removeChangeListener(this);
            }
        }

        public void dispose() {
            RemoteICViewer.this.remoteICList.removeChangeListener(this);
        }

        public Object[] getElements(Object parent) {
            return RemoteICViewer.this.remoteICList.getRemoteICs().toArray();
        }

        public void addRemoteIC(RemoteIC remoteic) {
            RemoteICViewer.this.tableViewer.add((Object)remoteic);
        }

        public void removeRemoteIC(RemoteIC remoteic) {
            RemoteICViewer.this.tableViewer.remove((Object)remoteic);
        }

        public void updateRemoteIC(RemoteIC remoteic) {
            RemoteICViewer.this.tableViewer.update((Object)remoteic, null);
        }

        public void refreshRemoteIC(RemoteIC remoteic, int selectedIndex) {
            RemoteICViewer.this.tableViewer.replace((Object)remoteic, selectedIndex);
        }

        public void removeAllRemoteICs(Object[] remoteICs) {
            RemoteICViewer.this.tableViewer.remove(remoteICs);
        }
    }
}

