/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.tests;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.internal.debug.model.TCFMemoryRegion;
import org.eclipse.tcf.internal.debug.tests.ITCFTest;
import org.eclipse.tcf.internal.debug.tests.RunControl;
import org.eclipse.tcf.internal.debug.tests.TCFTestSuite;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IErrorReport;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IBreakpoints;
import org.eclipse.tcf.services.IContextQuery;
import org.eclipse.tcf.services.IDiagnostics;
import org.eclipse.tcf.services.IDisassembly;
import org.eclipse.tcf.services.ILineNumbers;
import org.eclipse.tcf.services.IMemory;
import org.eclipse.tcf.services.IMemoryMap;
import org.eclipse.tcf.services.IPathMap;
import org.eclipse.tcf.services.IRegisters;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.services.ISymbols;

class TestRCBP1
implements ITCFTest,
RunControl.DiagnosticTestDone,
IRunControl.RunControlListener {
    private final TCFTestSuite test_suite;
    private final RunControl test_rc;
    private final int channel_id;
    private final List<IPathMap.PathMapRule> path_map;
    private final Map<String, ArrayList<IMemoryMap.MemoryRegion>> mem_map;
    private final IDiagnostics srv_diag;
    private final ISymbols srv_syms;
    private final IMemory srv_memory;
    private final IRunControl srv_run_ctrl;
    private final IRegisters srv_registers;
    private final IBreakpoints srv_breakpoints;
    private final ILineNumbers srv_line_numbers;
    private final IDisassembly srv_disassembly;
    private final IPathMap srv_path_map;
    private final IMemoryMap srv_memory_map;
    private final IContextQuery srv_context_query;
    private final Map<String, IRunControl.RunControlContext> threads = new HashMap<String, IRunControl.RunControlContext>();
    private final Map<String, SuspendedContext> suspended = new HashMap<String, SuspendedContext>();
    private final Map<String, SuspendedContext> suspended_prev = new HashMap<String, SuspendedContext>();
    private final Map<String, IDisassembly.IDisassemblyLine[]> disassembly_lines = new HashMap<String, IDisassembly.IDisassemblyLine[]>();
    private final Map<String, Map<String, Object>[]> disassembly_capabilities = new HashMap<String, Map<String, Object>[]>();
    private final Set<String> running = new HashSet<String>();
    private final Set<IToken> get_state_cmds = new HashSet<IToken>();
    private final Set<IToken> bp_change_cmds = new HashSet<IToken>();
    private final Map<String, Map<String, IRegisters.RegistersContext>> regs = new HashMap<String, Map<String, IRegisters.RegistersContext>>();
    private final Map<String, Map<String, Object>> bp_list = new HashMap<String, Map<String, Object>>();
    private final Map<String, IDiagnostics.ISymbol> sym_list = new HashMap<String, IDiagnostics.ISymbol>();
    private final Random rnd = new Random();
    private String[] test_list;
    private String test_id;
    private boolean path_map_done;
    private boolean mem_map_done;
    private String test_ctx_id;
    private IRunControl.RunControlContext test_context;
    private String main_thread_id;
    private Map<String, Object> bp_capabilities;
    private Runnable pending_cancel;
    private int bp_cnt;
    private boolean done_get_state;
    private boolean done_disassembly;
    private int resume_cnt = 0;
    private IToken cancel_test_cmd;
    private boolean bp_set_done;
    private boolean bp_change_done;
    private boolean bp_reset_done;
    private boolean bp_sync_done;
    private boolean data_bp_area_done;
    private ILineNumbers.CodeArea data_bp_area;
    private String data_bp_id;
    private String temp_bp_id;
    private String inv_bp_id;
    private boolean temp_bp_removed;
    private int temp_bp_cnt;
    private int data_bp_cnt;
    private boolean mem_map_test_running;
    private boolean mem_map_test_done;
    private boolean all_setup_done;
    private boolean test_done;
    private static int mem_map_region_id = 0;
    private static int test_cnt;
    private final IBreakpoints.BreakpointsListener bp_listener = new IBreakpoints.BreakpointsListener(){

        public void breakpointStatusChanged(String id, Map<String, Object> status) {
            if (TestRCBP1.this.bp_list.get(id) != null && TestRCBP1.this.test_context != null && TestRCBP1.this.bp_cnt < 40) {
                String err;
                String prs;
                String ctx;
                Map map;
                Iterator iterator;
                Object list;
                Map m;
                Collection prop_ids;
                if (TestRCBP1.this.bp_change_cmds.size() == 0 && (prop_ids = (Collection)(m = (Map)TestRCBP1.this.bp_list.get(id)).get("ContextIds")) != null && (list = (Collection)status.get("Instances")) != null) {
                    iterator = list.iterator();
                    while (iterator.hasNext()) {
                        map = (Map)iterator.next();
                        ctx = (String)map.get("LocationContext");
                        if (prop_ids.contains(ctx)) continue;
                        boolean ok = false;
                        for (String s : prop_ids) {
                            IRunControl.RunControlContext x = TestRCBP1.this.test_rc.getContext(s);
                            if (x == null || !ctx.equals(x.getBPGroup())) continue;
                            ok = true;
                        }
                        if (ok) continue;
                        TestRCBP1.this.exit(new Error("Breakpoint " + id + ": invalid planting context " + ctx));
                        return;
                    }
                }
                if ((prs = TestRCBP1.this.test_context.getProcessID()) != null) {
                    list = TestRCBP1.this.test_suite.getActiveTests().iterator();
                    while (list.hasNext()) {
                        TestRCBP1 rcbp;
                        ITCFTest test = list.next();
                        if (!(test instanceof TestRCBP1) || !(rcbp = (TestRCBP1)test).mem_map_test_running || !prs.equals(rcbp.test_context.getProcessID())) continue;
                        return;
                    }
                }
                if ((err = (String)status.get("Error")) == null && (list = (Collection)status.get("Instances")) != null) {
                    iterator = list.iterator();
                    while (iterator.hasNext()) {
                        map = (Map)iterator.next();
                        ctx = (String)map.get("LocationContext");
                        if (!TestRCBP1.this.test_context.getProcessID().equals(ctx) || map.get("Error") == null) continue;
                        err = (String)map.get("Error");
                    }
                }
                if (err != null) {
                    if (TestRCBP1.this.bp_cnt == 0 && id.equals(TestRCBP1.this.data_bp_id)) {
                        return;
                    }
                    if (id.equals(TestRCBP1.this.inv_bp_id)) {
                        return;
                    }
                    if (TestRCBP1.this.test_done) {
                        return;
                    }
                    TestRCBP1.this.exit(new Exception("Invalid BP status: " + err));
                }
            }
        }

        public void contextAdded(Map<String, Object>[] bps) {
            Map<String, Object>[] mapArray = bps;
            int n = bps.length;
            int n2 = 0;
            while (n2 < n) {
                Map<String, Object> m0 = mapArray[n2];
                String id = (String)m0.get("ID");
                Map m1 = (Map)TestRCBP1.this.bp_list.get(id);
                if (!this.checkBPData(m0, m1)) {
                    return;
                }
                ++n2;
            }
        }

        public void contextChanged(Map<String, Object>[] bps) {
            if (TestRCBP1.this.bp_change_cmds.size() > 1) {
                return;
            }
            Map<String, Object>[] mapArray = bps;
            int n = bps.length;
            int n2 = 0;
            while (n2 < n) {
                Map<String, Object> m0 = mapArray[n2];
                String id = (String)m0.get("ID");
                Map m1 = (Map)TestRCBP1.this.bp_list.get(id);
                if (!this.checkBPData(m0, m1)) {
                    return;
                }
                ++n2;
            }
        }

        public void contextRemoved(String[] ids) {
            if (!TestRCBP1.this.bp_change_done) {
                return;
            }
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (TestRCBP1.this.bp_list.get(id) != null) {
                    if (id.equals(TestRCBP1.this.temp_bp_id)) {
                        if (TestRCBP1.this.bp_cnt != 3 || TestRCBP1.this.temp_bp_removed) {
                            TestRCBP1.this.exit(new Exception("Invalid Breakpoints.contextRemoved event for temporary breakpoint"));
                            return;
                        }
                        TestRCBP1.this.temp_bp_removed = true;
                    } else {
                        TestRCBP1.this.exit(new Exception("Invalid Breakpoints.contextRemoved event"));
                        return;
                    }
                }
                ++n2;
            }
        }

        private boolean checkBPData(Map<String, Object> m0, Map<String, Object> m1) {
            if (m1 == null) {
                return true;
            }
            if ((m0 = new HashMap<String, Object>(m0)).get("Enabled") == null) {
                m0.put("Enabled", false);
            }
            if (m1.get("Enabled") == null) {
                m1.put("Enabled", false);
            }
            if (!m1.equals(m0)) {
                TestRCBP1.this.exit(new Exception("Invalid data in Breakpoints event: " + m0 + " != " + m1));
                return false;
            }
            return true;
        }
    };
    private final Set<String> reg_changed = new HashSet<String>();
    private final IRegisters.RegistersListener reg_listener = new IRegisters.RegistersListener(){

        public void contextChanged() {
        }

        public void registerChanged(String id) {
            TestRCBP1.this.reg_changed.add(id);
        }
    };

    TestRCBP1(TCFTestSuite test_suite, RunControl test_rc, IChannel channel, int channel_id, List<IPathMap.PathMapRule> path_map, Map<String, ArrayList<IMemoryMap.MemoryRegion>> mem_map) {
        this.test_suite = test_suite;
        this.test_rc = test_rc;
        this.channel_id = channel_id;
        this.path_map = path_map;
        this.mem_map = mem_map;
        this.srv_diag = (IDiagnostics)channel.getRemoteService(IDiagnostics.class);
        this.srv_syms = (ISymbols)channel.getRemoteService(ISymbols.class);
        this.srv_memory = (IMemory)channel.getRemoteService(IMemory.class);
        this.srv_run_ctrl = (IRunControl)channel.getRemoteService(IRunControl.class);
        this.srv_registers = (IRegisters)channel.getRemoteService(IRegisters.class);
        this.srv_breakpoints = (IBreakpoints)channel.getRemoteService(IBreakpoints.class);
        this.srv_line_numbers = (ILineNumbers)channel.getRemoteService(ILineNumbers.class);
        this.srv_disassembly = (IDisassembly)channel.getRemoteService(IDisassembly.class);
        this.srv_path_map = (IPathMap)channel.getRemoteService(IPathMap.class);
        this.srv_memory_map = (IMemoryMap)channel.getRemoteService(IMemoryMap.class);
        this.srv_context_query = (IContextQuery)channel.getRemoteService(IContextQuery.class);
    }

    @Override
    public void start() {
        if (this.srv_run_ctrl == null) {
            this.test_suite.done(this, null);
        } else {
            if (this.srv_breakpoints != null) {
                this.srv_breakpoints.addListener(this.bp_listener);
            }
            if (this.srv_registers != null) {
                this.srv_registers.addListener(this.reg_listener);
            }
            this.runTest();
        }
    }

    private void runTest() {
        if (!this.test_suite.isActive(this)) {
            return;
        }
        if (!this.path_map_done) {
            this.setPathMap();
            return;
        }
        if (!this.mem_map_done) {
            this.setMemMap();
            return;
        }
        if (this.test_list == null) {
            this.getTestList();
            return;
        }
        if (this.test_id != null) {
            if (this.test_ctx_id == null) {
                this.startTestContext();
                return;
            }
            if (this.test_context == null) {
                this.getTestContext();
                return;
            }
            if (this.sym_list.isEmpty()) {
                this.getSymbols();
                return;
            }
            if (!this.data_bp_area_done) {
                this.getDataBPFile();
                return;
            }
            if (this.bp_capabilities == null) {
                this.getBreakpointCapabilities();
                return;
            }
            if (!this.bp_set_done) {
                this.iniBreakpoints();
                return;
            }
        }
        if (!this.done_get_state) {
            assert (this.get_state_cmds.isEmpty());
            assert (this.threads.isEmpty());
            assert (this.running.isEmpty());
            assert (this.suspended.isEmpty());
            this.getContextState(this.test_ctx_id);
            return;
        }
        if (this.srv_disassembly != null && !this.done_disassembly) {
            assert (this.get_state_cmds.isEmpty());
            assert (this.disassembly_lines.isEmpty());
            this.getDisassemlyLines();
            return;
        }
        if (this.test_id != null) {
            if (!this.bp_change_done) {
                this.changeBreakpoint5();
                return;
            }
            if (!this.mem_map_test_done) {
                this.runMemoryMapTest();
                return;
            }
            if (!this.all_setup_done) {
                assert (this.resume_cnt == 0);
                this.all_setup_done = true;
                for (SuspendedContext s : this.suspended.values()) {
                    this.resume(s.id);
                }
                return;
            }
        }
        if (this.suspended.size() > 0) {
            final int test_cnt = this.suspended.size();
            Runnable done = new Runnable(){
                int done_cnt;

                @Override
                public void run() {
                    ++this.done_cnt;
                    if (this.done_cnt == test_cnt) {
                        TestRCBP1.this.runTest();
                    }
                }
            };
            for (SuspendedContext sc : this.suspended.values()) {
                this.runRegistersTest(sc, done);
            }
            return;
        }
        if (this.test_ctx_id == null) {
            this.test_done = true;
        } else if (!this.test_done) {
            return;
        }
        if (!this.bp_reset_done) {
            this.resetBreakpoints();
            return;
        }
        this.exit(null);
    }

    private void getTestList() {
        if (this.srv_diag == null) {
            this.test_list = new String[0];
            this.runTest();
            return;
        }
        this.srv_diag.getTestList(new IDiagnostics.DoneGetTestList(){

            public void doneGetTestList(IToken token, Throwable error, String[] list) {
                if (error != null) {
                    TestRCBP1.this.exit(error);
                } else {
                    if (list == null) {
                        list = new String[]{};
                    }
                    if (list.length > 0) {
                        TestRCBP1.this.test_id = list[TestRCBP1.this.rnd.nextInt(list.length)];
                    }
                    TestRCBP1.this.test_list = list;
                    TestRCBP1.this.runTest();
                }
            }
        });
    }

    private void setPathMap() {
        if (this.srv_path_map == null || this.path_map == null) {
            this.path_map_done = true;
            this.runTest();
            return;
        }
        this.srv_path_map.set(this.path_map.toArray(new IPathMap.PathMapRule[this.path_map.size()]), new IPathMap.DoneSet(){

            public void doneSet(IToken token, Exception error) {
                if (error != null) {
                    TestRCBP1.this.exit(error);
                } else {
                    TestRCBP1.this.path_map_done = true;
                    TestRCBP1.this.runTest();
                }
            }
        });
    }

    private void setMemMap() {
        if (this.mem_map == null || this.mem_map.size() == 0) {
            this.mem_map_done = true;
            this.runTest();
            return;
        }
        final HashSet<IToken> cmds = new HashSet<IToken>();
        for (String id : this.mem_map.keySet()) {
            ArrayList<IMemoryMap.MemoryRegion> l = this.mem_map.get(id);
            cmds.add(this.srv_memory_map.set(id, l.toArray(new IMemoryMap.MemoryRegion[l.size()]), new IMemoryMap.DoneSet(){

                public void doneSet(IToken token, Exception error) {
                    IErrorReport e;
                    cmds.remove(token);
                    if (error instanceof IErrorReport && (e = (IErrorReport)error).getErrorCode() == 16) {
                        error = null;
                    }
                    if (error != null) {
                        TestRCBP1.this.exit(error);
                    } else if (cmds.size() == 0) {
                        TestRCBP1.this.mem_map_done = true;
                        TestRCBP1.this.runTest();
                    }
                }
            }));
        }
        assert (cmds.size() > 0);
    }

    private void resetBreakpoints() {
        if (this.srv_breakpoints == null) {
            this.bp_reset_done = true;
            this.runTest();
            return;
        }
        this.bp_list.clear();
        this.srv_breakpoints.set(null, new IBreakpoints.DoneCommand(){

            public void doneCommand(IToken token, Exception error) {
                if (error != null) {
                    TestRCBP1.this.exit(error);
                    return;
                }
                TestRCBP1.this.bp_reset_done = true;
                TestRCBP1.this.runTest();
            }
        });
    }

    private void getBreakpointCapabilities() {
        if (this.srv_breakpoints == null) {
            this.bp_capabilities = new HashMap<String, Object>();
            this.runTest();
            return;
        }
        this.srv_breakpoints.getCapabilities(this.test_ctx_id, new IBreakpoints.DoneGetCapabilities(){

            public void doneGetCapabilities(IToken token, Exception error, Map<String, Object> capabilities) {
                if (!TestRCBP1.this.test_suite.isActive(TestRCBP1.this)) {
                    return;
                }
                if (error != null) {
                    TestRCBP1.this.exit(error);
                    return;
                }
                Boolean l = (Boolean)capabilities.get("Location");
                Boolean c = (Boolean)capabilities.get("Condition");
                if (l == null || !l.booleanValue()) {
                    TestRCBP1.this.exit(new Exception("Breakpoints service does not support \"Location\" attribute"));
                    return;
                }
                if (c == null || !c.booleanValue()) {
                    TestRCBP1.this.exit(new Exception("Breakpoints service does not support \"Condition\" attribute"));
                    return;
                }
                TestRCBP1.this.bp_capabilities = capabilities;
                TestRCBP1.this.runTest();
            }
        });
    }

    private void startTestContext() {
        this.srv_diag.runTest(this.test_id, new IDiagnostics.DoneRunTest(){

            public void doneRunTest(IToken token, Throwable error, final String context_id) {
                if (error != null) {
                    TestRCBP1.this.exit(error);
                } else {
                    Protocol.sync((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (!TestRCBP1.this.test_suite.isActive(TestRCBP1.this)) {
                                return;
                            }
                            if (!$assertionsDisabled && TestRCBP1.this.test_ctx_id != null) {
                                throw new AssertionError();
                            }
                            TestRCBP1.this.test_ctx_id = context_id;
                            if (TestRCBP1.this.pending_cancel != null) {
                                TestRCBP1.this.exit(null);
                            } else {
                                TestRCBP1.this.runTest();
                            }
                        }
                    });
                }
            }
        });
    }

    private void getTestContext() {
        this.srv_run_ctrl.getContext(this.test_ctx_id, new IRunControl.DoneGetContext(){

            public void doneGetContext(IToken token, Exception error, IRunControl.RunControlContext context) {
                if (((TestRCBP1)TestRCBP1.this).test_suite.cancel) {
                    return;
                }
                if (error != null) {
                    TestRCBP1.this.exit(error);
                    return;
                }
                TestRCBP1.this.test_context = context;
                if (!$assertionsDisabled && !TestRCBP1.this.test_ctx_id.equals(context.getID())) {
                    throw new AssertionError();
                }
                TestRCBP1.this.srv_run_ctrl.addListener((IRunControl.RunControlListener)TestRCBP1.this);
                TestRCBP1.this.runTest();
            }
        });
    }

    private void getSymbols() {
        final HashMap<IToken, String> cmds = new HashMap<IToken, String>();
        IDiagnostics.DoneGetSymbol done = new IDiagnostics.DoneGetSymbol(){

            public void doneGetSymbol(IToken token, Throwable error, IDiagnostics.ISymbol symbol) {
                String name = (String)cmds.remove(token);
                if (error != null) {
                    TestRCBP1.this.exit(error);
                    return;
                }
                if (!TestRCBP1.this.test_suite.isActive(TestRCBP1.this)) {
                    return;
                }
                if (!$assertionsDisabled && TestRCBP1.this.test_ctx_id == null) {
                    throw new AssertionError();
                }
                if (symbol == null) {
                    TestRCBP1.this.exit(new Exception("Symbol must not be NULL: " + name));
                } else if (!symbol.isAbs()) {
                    TestRCBP1.this.exit(new Exception("Symbol must be absolute: " + name));
                } else if (symbol.getValue() == null || symbol.getValue().longValue() == 0L) {
                    TestRCBP1.this.exit(new Exception("Symbol value must not be NULL: " + name));
                } else {
                    TestRCBP1.this.sym_list.put(name, symbol);
                    if (cmds.isEmpty()) {
                        TestRCBP1.this.runTest();
                    }
                }
            }
        };
        String[] syms = new String[]{"tcf_test_func0", "tcf_test_func1", "tcf_test_func2", "tcf_test_func3", "tcf_test_array"};
        String prs = this.test_context.getProcessID();
        String[] stringArray = syms;
        int n = syms.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            cmds.put(this.srv_diag.getSymbol(prs, name, done), name);
            ++n2;
        }
    }

    private void getDataBPFile() {
        IDiagnostics.ISymbol sym = this.sym_list.get("tcf_test_func3");
        if (sym == null || this.srv_line_numbers == null) {
            this.data_bp_area_done = true;
            this.runTest();
            return;
        }
        this.srv_line_numbers.mapToSource(this.test_ctx_id, sym.getValue(), (Number)(sym.getValue().longValue() + 1L), new ILineNumbers.DoneMapToSource(){

            public void doneMapToSource(IToken token, Exception error, ILineNumbers.CodeArea[] areas) {
                if (error != null) {
                    TestRCBP1.this.exit(error);
                } else {
                    if (areas != null && areas.length > 0) {
                        TestRCBP1.this.data_bp_area = areas[0];
                    }
                    TestRCBP1.this.data_bp_area_done = true;
                    TestRCBP1.this.runTest();
                }
            }
        });
    }

    private void iniBreakpoints() {
        assert (!this.bp_set_done);
        assert (this.bp_list.isEmpty());
        Boolean bp_type_ok = (Boolean)this.bp_capabilities.get("BreakpointType");
        Boolean bp_ctx_ids = (Boolean)this.bp_capabilities.get("ContextIds");
        Map[] m = new Map[10];
        int i = 0;
        while (i < m.length) {
            m[i] = new HashMap();
            m[i].put("ID", "TcfTestBP" + i + this.channel_id);
            m[i].put("Enabled", true);
            switch (i) {
                case 0: {
                    ArrayList<String> l;
                    m[i].put("Location", this.sym_list.get("tcf_test_func0").getValue().toString());
                    if (bp_ctx_ids != null && bp_ctx_ids.booleanValue()) {
                        l = new ArrayList<String>();
                        l.add(this.test_context.getProcessID());
                        m[i].put("ContextIds", l);
                    }
                    m[i].put("Condition", "$thread!=\"\"");
                    break;
                }
                case 1: {
                    ArrayList<String> l;
                    m[i].put("Location", this.sym_list.get("tcf_test_func0").getValue().toString());
                    if (bp_ctx_ids != null && bp_ctx_ids.booleanValue()) {
                        l = new ArrayList();
                        l.add(this.test_context.getProcessID());
                        m[i].put("ContextIds", l);
                    }
                    m[i].put("Condition", "$thread==\"\"");
                    break;
                }
                case 2: {
                    m[i].put("Location", "tcf_test_func0");
                    break;
                }
                case 3: {
                    m[i].put("Location", "(31+1)/16+tcf_test_func1-2");
                    m[i].put("Condition", "tcf_test_func0!=tcf_test_func1");
                    if (bp_type_ok == null || !bp_type_ok.booleanValue()) break;
                    switch (this.rnd.nextInt(4)) {
                        case 0: {
                            m[i].put("BreakpointType", "Software");
                            break;
                        }
                        case 1: {
                            m[i].put("BreakpointType", "Auto");
                        }
                    }
                    break;
                }
                case 4: {
                    m[i].put("Location", "tcf_test_func2");
                    m[i].put("Enabled", false);
                    break;
                }
                case 5: {
                    m[i].put("Location", "tcf_test_func2");
                    m[i].put("Enabled", false);
                    break;
                }
                case 6: {
                    m[i].put("Location", "tcf_test_func3");
                    if (bp_type_ok == null || !bp_type_ok.booleanValue()) break;
                    switch (this.rnd.nextInt(4)) {
                        case 0: {
                            m[i].put("BreakpointType", "Software");
                            break;
                        }
                        case 1: {
                            m[i].put("BreakpointType", "Auto");
                        }
                    }
                    break;
                }
                case 7: {
                    m[i].put("Location", "&tcf_test_char");
                    m[i].put("AccessMode", 2);
                    Number ca = (Number)this.bp_capabilities.get("AccessMode");
                    if (this.data_bp_area != null && ca != null && (ca.intValue() & 2) != 0) {
                        m[i].put("File", this.data_bp_area.file);
                        m[i].put("Line", this.data_bp_area.start_line);
                        this.data_bp_id = (String)m[i].get("ID");
                        break;
                    }
                    m[i].put("Enabled", false);
                    break;
                }
                case 8: {
                    m[i].put("Location", "tcf_test_func3");
                    m[i].put("Enabled", false);
                    Boolean ct = (Boolean)this.bp_capabilities.get("Temporary");
                    if (ct == null || !ct.booleanValue()) break;
                    m[i].put("Temporary", true);
                    this.temp_bp_id = (String)m[i].get("ID");
                    break;
                }
                case 9: {
                    m[i].put("Unknown property", "Unknown value");
                    this.inv_bp_id = (String)m[i].get("ID");
                }
            }
            this.bp_list.put((String)m[i].get("ID"), m[i]);
            ++i;
        }
        this.srv_breakpoints.set(m, new IBreakpoints.DoneCommand(){

            public void doneCommand(IToken token, Exception error) {
                if (!$assertionsDisabled && TestRCBP1.this.bp_set_done) {
                    throw new AssertionError();
                }
                TestRCBP1.this.bp_set_done = true;
                if (error != null) {
                    TestRCBP1.this.exit(error);
                    return;
                }
                TestRCBP1.this.runTest();
            }
        });
    }

    private void getContextState(final String id) {
        this.get_state_cmds.add(this.srv_run_ctrl.getChildren(id, new IRunControl.DoneGetChildren(){

            public void doneGetChildren(IToken token, Exception error, String[] contexts) {
                TestRCBP1.this.get_state_cmds.remove(token);
                if (((TestRCBP1)TestRCBP1.this).test_suite.cancel) {
                    return;
                }
                if (error != null) {
                    TestRCBP1.this.exit(error);
                    return;
                }
                String[] stringArray = contexts;
                int n = contexts.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    TestRCBP1.this.getContextState(s);
                    ++n2;
                }
                if (TestRCBP1.this.get_state_cmds.isEmpty()) {
                    TestRCBP1.this.doneContextState();
                }
            }
        }));
        if (id == null) {
            return;
        }
        this.get_state_cmds.add(this.srv_run_ctrl.getContext(id, new IRunControl.DoneGetContext(){

            public void doneGetContext(IToken token, Exception error, IRunControl.RunControlContext ctx) {
                TestRCBP1.this.get_state_cmds.remove(token);
                if (((TestRCBP1)TestRCBP1.this).test_suite.cancel) {
                    return;
                }
                if (error != null) {
                    TestRCBP1.this.exit(error);
                    return;
                }
                if (TestRCBP1.this.test_id != null) {
                    if (!$assertionsDisabled && TestRCBP1.this.test_ctx_id == null) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !TestRCBP1.this.isMyContext(ctx)) {
                        throw new AssertionError();
                    }
                    for (ITCFTest t : TestRCBP1.this.test_suite.getActiveTests()) {
                        if (t == TestRCBP1.this || !(t instanceof TestRCBP1) || ((TestRCBP1)t).threads.get(id) == null) continue;
                        TestRCBP1.this.exit(new Exception("Invalid or missing 'CreatorID' context attribute.\nContext: " + ctx));
                        return;
                    }
                }
                if (ctx.hasState()) {
                    TestRCBP1.this.threads.put(id, ctx);
                    TestRCBP1.this.get_state_cmds.add(ctx.getState(new IRunControl.DoneGetState(){

                        public void doneGetState(IToken token, Exception error, boolean susp, String pc, String reason, Map<String, Object> params) {
                            TestRCBP1.this.get_state_cmds.remove(token);
                            if (((TestRCBP1)(this).TestRCBP1.this).test_suite.cancel) {
                                return;
                            }
                            if (error != null) {
                                TestRCBP1.this.exit(new Exception("Cannot get context state", error));
                                return;
                            }
                            if (!susp) {
                                if (TestRCBP1.this.suspended.get(id) != null) {
                                    TestRCBP1.this.exit(new Exception("Invalid result of getState command"));
                                    return;
                                }
                                TestRCBP1.this.running.add(id);
                            } else {
                                if (!$assertionsDisabled && TestRCBP1.this.threads.get(id) == null) {
                                    throw new AssertionError();
                                }
                                if (TestRCBP1.this.running.contains(id)) {
                                    TestRCBP1.this.exit(new Exception("Invalid result of getState command"));
                                    return;
                                }
                                SuspendedContext sc = (SuspendedContext)TestRCBP1.this.suspended.get(id);
                                if (sc != null && sc.pc != null && !sc.pc.equals(pc)) {
                                    TestRCBP1.this.exit(new Exception("Invalid result of getState command: invalid PC. Context: " + id));
                                    return;
                                }
                                if (sc != null && sc.reason != null && !sc.reason.equals(reason)) {
                                    TestRCBP1.this.exit(new Exception("Invalid result of getState command: invalid suspend reason. Context: " + id));
                                    return;
                                }
                                if (TestRCBP1.this.test_id != null && "Breakpoint".equals(reason)) {
                                    TestRCBP1.this.exit(new Exception("Invalid suspend reason of main thread " + id + " after test start: " + reason + " " + pc));
                                    return;
                                }
                                if (!$assertionsDisabled && TestRCBP1.this.done_get_state) {
                                    throw new AssertionError();
                                }
                                TestRCBP1.this.suspended.put(id, new SuspendedContext(id, pc, reason, params));
                            }
                            if (TestRCBP1.this.get_state_cmds.isEmpty()) {
                                TestRCBP1.this.doneContextState();
                            }
                        }
                    }));
                }
                if (TestRCBP1.this.get_state_cmds.isEmpty()) {
                    TestRCBP1.this.doneContextState();
                }
            }
        }));
    }

    private void doneContextState() {
        assert (!this.done_get_state);
        assert (this.get_state_cmds.isEmpty());
        assert (this.resume_cnt == 0);
        assert (this.threads.size() == this.suspended.size() + this.running.size());
        this.done_get_state = true;
        this.runTest();
    }

    private void getDisassemlyLines() {
        for (final String id : this.suspended.keySet()) {
            SuspendedContext sc = this.suspended.get(id);
            this.get_state_cmds.add(this.srv_disassembly.getCapabilities(id, new IDisassembly.DoneGetCapabilities(){

                public void doneGetCapabilities(IToken token, Throwable error, Map<String, Object>[] arr) {
                    TestRCBP1.this.get_state_cmds.remove(token);
                    if (error != null) {
                        TestRCBP1.this.exit(error);
                    } else {
                        TestRCBP1.this.disassembly_capabilities.put(id, arr);
                        if (TestRCBP1.this.get_state_cmds.isEmpty()) {
                            TestRCBP1.this.doneDisassembly();
                        }
                    }
                }
            }));
            if (sc.pc == null) {
                this.disassembly_lines.put(id, new IDisassembly.IDisassemblyLine[0]);
                continue;
            }
            BigInteger pc = new BigInteger(sc.pc);
            this.get_state_cmds.add(this.srv_disassembly.disassemble(id, (Number)pc, 1, null, new IDisassembly.DoneDisassemble(){

                public void doneDisassemble(IToken token, Throwable error, IDisassembly.IDisassemblyLine[] arr) {
                    TestRCBP1.this.get_state_cmds.remove(token);
                    if (error != null) {
                        TestRCBP1.this.exit(error);
                    } else {
                        TestRCBP1.this.disassembly_lines.put(id, arr);
                        if (TestRCBP1.this.get_state_cmds.isEmpty()) {
                            TestRCBP1.this.doneDisassembly();
                        }
                    }
                }
            }));
        }
        if (this.get_state_cmds.isEmpty()) {
            this.doneDisassembly();
        }
    }

    private void doneDisassembly() {
        assert (!this.done_disassembly);
        assert (this.get_state_cmds.isEmpty());
        if (!this.test_suite.isActive(this)) {
            return;
        }
        assert (this.suspended.size() == this.disassembly_lines.size());
        this.done_disassembly = true;
        this.runTest();
    }

    private void changeBreakpoint5() {
        Boolean sg;
        assert (!this.bp_change_done);
        final String bp_id = "TcfTestBP5" + this.channel_id;
        final Map<String, Object> m = this.bp_list.get(bp_id);
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.test_context.getProcessID());
        Boolean ci = (Boolean)this.bp_capabilities.get("ContextIds");
        if (ci != null && ci.booleanValue()) {
            m.put("ContextIds", l);
        }
        if ((sg = (Boolean)this.bp_capabilities.get("StopGroup")) != null && sg.booleanValue()) {
            m.put("StopGroup", l);
        }
        StringBuffer bf = new StringBuffer();
        for (final String id : this.threads.keySet()) {
            if (bf.length() > 0) {
                bf.append(" || ");
            }
            bf.append("$thread==\"");
            bf.append(id);
            bf.append('\"');
        }
        m.put("Condition", bf.toString());
        this.bp_change_cmds.add(this.srv_breakpoints.change(m, new IBreakpoints.DoneCommand(){

            public void doneCommand(IToken token, Exception error) {
                TestRCBP1.this.bp_change_cmds.remove(token);
                TestRCBP1.this.bp_change_done = true;
                if (error != null) {
                    TestRCBP1.this.exit(error);
                }
            }
        }));
        this.srv_breakpoints.getIDs(new IBreakpoints.DoneGetIDs(){

            public void doneGetIDs(IToken token, Exception error, String[] ids) {
                if (error != null) {
                    TestRCBP1.this.exit(error);
                    return;
                }
                if (!TestRCBP1.this.bp_change_done) {
                    TestRCBP1.this.exit(new Exception("Invalid responce order"));
                    return;
                }
                HashSet<String> s = new HashSet<String>();
                String[] stringArray = ids;
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    s.add(id);
                    ++n2;
                }
                if (ids.length != s.size()) {
                    TestRCBP1.this.exit(new Exception("Invalis BP list: " + Arrays.toString(ids)));
                    return;
                }
                for (String id : TestRCBP1.this.bp_list.keySet()) {
                    if (s.contains(id)) continue;
                    TestRCBP1.this.exit(new Exception("BP is not listed by Breakpoints.getIDs: " + id));
                    return;
                }
            }
        });
        for (final String id : this.bp_list.keySet()) {
            this.srv_breakpoints.getProperties(id, new IBreakpoints.DoneGetProperties(){

                public void doneGetProperties(IToken token, Exception error, Map<String, Object> properties) {
                    if (error != null) {
                        TestRCBP1.this.exit(error);
                        return;
                    }
                    HashMap<String, Object> m0 = new HashMap<String, Object>(properties);
                    HashMap m1 = (HashMap)TestRCBP1.this.bp_list.get(id);
                    if (m0.get("Enabled") == null) {
                        m0.put("Enabled", false);
                    }
                    if (m1.get("Enabled") == null) {
                        m1.put("Enabled", false);
                    }
                    if (!m1.equals(m0)) {
                        TestRCBP1.this.exit(new Exception("Invalid data returned by Breakpoints.getProperties: " + m0 + " != " + m1));
                        return;
                    }
                }
            });
            this.srv_breakpoints.getStatus(id, new IBreakpoints.DoneGetStatus(){

                public void doneGetStatus(IToken token, Exception error, Map<String, Object> status) {
                    if (error != null) {
                        TestRCBP1.this.exit(error);
                        return;
                    }
                }
            });
        }
        Protocol.sync((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!TestRCBP1.this.test_suite.isActive(TestRCBP1.this)) {
                    return;
                }
                if (!TestRCBP1.this.bp_change_done) {
                    TestRCBP1.this.exit(new Exception("Protocol.sync() test failed"));
                    return;
                }
                m.put("Enabled", true);
                TestRCBP1.this.srv_breakpoints.enable(new String[]{bp_id}, new IBreakpoints.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null) {
                            TestRCBP1.this.exit(error);
                        }
                    }
                });
                TestRCBP1.this.bp_sync_done = true;
                TestRCBP1.this.runTest();
            }
        });
    }

    private void changeBreakpoint6() {
        Boolean b;
        assert (this.bp_change_done);
        if (this.threads.size() < 5) {
            return;
        }
        String bp_id = "TcfTestBP6" + this.channel_id;
        Map<String, Object> m = this.bp_list.get(bp_id);
        ArrayList<String> l = new ArrayList<String>();
        for (String id : this.threads.keySet()) {
            l.add(id);
        }
        m.remove("ContextIds");
        m.remove("StopGroup");
        m.remove("ContextQuery");
        m.remove("Condition");
        if (this.rnd.nextBoolean() && (b = (Boolean)this.bp_capabilities.get("ContextIds")) != null && b.booleanValue()) {
            m.put("ContextIds", l);
        }
        if (this.rnd.nextBoolean() && (b = (Boolean)this.bp_capabilities.get("StopGroup")) != null && b.booleanValue()) {
            m.put("StopGroup", l);
        }
        if (this.rnd.nextBoolean() && (b = (Boolean)this.bp_capabilities.get("ContextQuery")) != null && b.booleanValue()) {
            String q = "ID=\"" + this.test_context.getProcessID() + "\"/HasState=true";
            m.put("ContextQuery", q);
        }
        if (this.rnd.nextBoolean()) {
            StringBuffer bf = new StringBuffer();
            for (String id : this.threads.keySet()) {
                if (bf.length() > 0) {
                    bf.append(" || ");
                }
                bf.append("$thread==\"");
                bf.append(id);
                bf.append('\"');
            }
            m.put("Condition", bf.toString());
        }
        this.bp_change_cmds.add(this.srv_breakpoints.change(m, new IBreakpoints.DoneCommand(){

            public void doneCommand(IToken token, Exception error) {
                TestRCBP1.this.bp_change_cmds.remove(token);
                if (error != null) {
                    TestRCBP1.this.exit(error);
                }
            }
        }));
    }

    public void containerResumed(String[] context_ids) {
        String[] stringArray = context_ids;
        int n = context_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.contextResumed(id);
            ++n2;
        }
    }

    public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
        String[] stringArray = suspended_ids;
        int n = suspended_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!id.equals(context)) {
                this.contextSuspended(id, null, null, null);
            }
            ++n2;
        }
        this.contextSuspended(context, pc, reason, params);
    }

    public void contextAdded(IRunControl.RunControlContext[] contexts) {
        if (this.test_done) {
            return;
        }
        IRunControl.RunControlContext[] runControlContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IRunControl.RunControlContext ctx = runControlContextArray[n2];
            final String id = ctx.getID();
            if (this.threads.get(id) != null) {
                this.exit(new Exception("Invalid contextAdded event:\nContext: " + ctx));
                return;
            }
            if (this.isMyContext(ctx)) {
                for (ITCFTest t : this.test_suite.getActiveTests()) {
                    if (!(t instanceof TestRCBP1) || ((TestRCBP1)t).threads.get(id) == null) continue;
                    this.exit(new Exception("Invalid or missing 'CreatorID' context attribute.\nContext: " + ctx));
                    return;
                }
                if (this.threads.size() > 0 && !this.all_setup_done) {
                    assert (!this.canResume(id));
                    this.exit(new Exception("Unexpected contextAdded event\nContext: " + ctx));
                    return;
                }
                if (this.srv_context_query != null) {
                    this.srv_context_query.getAttrNames(new IContextQuery.DoneGetAttrNames(){

                        public void doneGetAttrNames(IToken token, Exception error, String[] names) {
                            if (!(error instanceof IErrorReport) || ((IErrorReport)error).getErrorCode() != 25) {
                                if (error != null) {
                                    TestRCBP1.this.exit(error);
                                } else {
                                    StringBuffer bf = new StringBuffer();
                                    bf.append('\"');
                                    int l = id.length();
                                    int i = 0;
                                    while (i < l) {
                                        char ch = id.charAt(i);
                                        if (ch == '\"' || ch == '\\') {
                                            bf.append('\\');
                                        }
                                        bf.append(ch);
                                        ++i;
                                    }
                                    bf.append('\"');
                                    String v = bf.toString();
                                    String[] stringArray = names;
                                    int n = names.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String nm = stringArray[n2];
                                        if (nm.equals("ID")) {
                                            String s = null;
                                            switch (TestRCBP1.this.rnd.nextInt(4)) {
                                                case 0: {
                                                    s = "ID=" + v;
                                                    break;
                                                }
                                                case 1: {
                                                    s = "**/ID=" + v;
                                                    break;
                                                }
                                                case 2: {
                                                    s = "/**/ID=" + v;
                                                    break;
                                                }
                                                case 3: {
                                                    s = "ID=" + v + ",id=" + v;
                                                }
                                            }
                                            TestRCBP1.this.srv_context_query.query(s, new IContextQuery.DoneQuery(){

                                                public void doneQuery(IToken token, Exception error, String[] contexts) {
                                                    if (error != null) {
                                                        TestRCBP1.this.exit(error);
                                                    } else if (contexts == null || contexts.length != 1) {
                                                        TestRCBP1.this.exit(new Exception("Invalid result length of ContextQuery.query command"));
                                                    } else if (!id.equals(contexts[0])) {
                                                        TestRCBP1.this.exit(new Exception("Invalid ID returned by ContextQuery.query command"));
                                                    }
                                                }
                                            });
                                            switch (TestRCBP1.this.rnd.nextInt(2)) {
                                                case 0: {
                                                    s = "ID=ID=";
                                                    break;
                                                }
                                                case 1: {
                                                    s = "ID=ID=ID";
                                                }
                                            }
                                            TestRCBP1.this.srv_context_query.query(s, new IContextQuery.DoneQuery(){

                                                public void doneQuery(IToken token, Exception error, String[] contexts) {
                                                    if (error == null) {
                                                        TestRCBP1.this.exit(new Exception("Invalid ContextQuery.query responce: error expected"));
                                                    }
                                                }
                                            });
                                            return;
                                        }
                                        ++n2;
                                    }
                                    TestRCBP1.this.exit(new Exception("ContextQuery.getAttrNames result must include 'ID'"));
                                }
                            }
                        }
                    });
                }
                if (ctx.hasState()) {
                    this.threads.put(id, ctx);
                    if (!this.done_get_state) {
                        this.getContextState(id);
                    } else {
                        this.running.add(id);
                    }
                }
            }
            ++n2;
        }
    }

    public void contextChanged(IRunControl.RunControlContext[] contexts) {
        if (this.test_done) {
            return;
        }
        IRunControl.RunControlContext[] runControlContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IRunControl.RunControlContext ctx = runControlContextArray[n2];
            String id = ctx.getID();
            if (id.equals(this.test_ctx_id)) {
                this.test_context = ctx;
            }
            if (this.threads.get(id) != null) {
                assert (this.isMyContext(ctx));
                this.threads.put(id, ctx);
            }
            ++n2;
        }
    }

    public void contextException(String id, String msg) {
        if (this.test_done) {
            return;
        }
        IRunControl.RunControlContext ctx = this.threads.get(id);
        if (ctx != null) {
            assert (this.isMyContext(ctx));
            this.exit(new Exception("Context exception: " + msg));
        }
    }

    public void contextRemoved(String[] contexts) {
        if (this.test_done) {
            return;
        }
        String[] stringArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (this.suspended.get(id) != null) {
                this.exit(new Exception("Invalid contextRemoved event"));
                return;
            }
            this.running.remove(id);
            this.testDone(id);
            ++n2;
        }
    }

    public void contextResumed(String id) {
        if (this.test_done) {
            return;
        }
        IRunControl.RunControlContext ctx = this.threads.get(id);
        if (ctx == null) {
            return;
        }
        assert (this.isMyContext(ctx));
        if (!ctx.hasState()) {
            this.exit(new Exception("Resumed event for context that HasState = false"));
            return;
        }
        SuspendedContext sc = this.suspended.remove(id);
        if (!this.done_get_state || sc == null || !sc.ok_to_resume || sc.get_state_pending && ctx.getRCGroup() == null) {
            assert (!this.canResume(id));
            this.exit(new Exception("Unexpected contextResumed event: " + id));
            return;
        }
        if (this.isMyBreakpoint(sc)) {
            this.suspended_prev.put(id, sc);
        }
        this.running.add(id);
    }

    @Override
    public void testDone(String id) {
        assert (!this.test_done);
        if (this.threads.remove(id) != null && this.threads.isEmpty()) {
            if (this.bp_cnt != 40) {
                this.exit(new Exception("Test main thread breakpoint count = " + this.bp_cnt + ", expected 40"));
                return;
            }
            if (this.data_bp_id != null && this.data_bp_cnt != 10) {
                this.exit(new Exception("Test main thread data breakpoint count = " + this.data_bp_cnt + ", expected 10"));
                return;
            }
            if (this.temp_bp_id != null && this.temp_bp_cnt != 1) {
                this.exit(new Exception("Temporary breakpoint count = " + this.temp_bp_cnt + ", expected 1"));
                return;
            }
        }
        if (id.equals(this.test_ctx_id)) {
            if (!this.all_setup_done) {
                this.exit(new Exception("Test process exited too soon"));
                return;
            }
            this.test_done = true;
            this.runTest();
        }
    }

    private long getSymAddr(String sym) {
        return this.sym_list.get(sym).getValue().longValue();
    }

    private String toSymName(long addr) {
        for (String name : this.sym_list.keySet()) {
            if (this.getSymAddr(name) != addr) continue;
            return name;
        }
        return "0x" + Long.toHexString(addr);
    }

    private void checkSuspendedContext(SuspendedContext sc, String sym) {
        Object ids;
        long ss;
        long pc = Long.parseLong(sc.pc);
        if (pc != (ss = this.getSymAddr(sym)) || !"Breakpoint".equals(sc.reason)) {
            this.exit(new Exception("Invalid contextSuspended event: " + sc.id + " '" + this.toSymName(pc) + "' " + sc.pc + " " + sc.reason + ", expected breakpoint at '" + sym + "' " + ss));
        }
        String bp_id = null;
        if (sc.params != null && (ids = sc.params.get("BPs")) != null) {
            Collection c = (Collection)ids;
            HashSet<String> set = new HashSet<String>();
            for (String id : c) {
                if (!set.add(id)) {
                    this.exit(new Exception("Invalid value of 'BPs' attribute: duplicate items"));
                    return;
                }
                if (this.bp_list.get(id) == null) continue;
                bp_id = id;
                break;
            }
            if (bp_id == null) {
                this.exit(new Exception("Invalid value of 'BPs' attribute in a context state: " + ids));
            }
        }
    }

    private void checkSuspendedContext(final SuspendedContext sc) {
        if (sc.params != null) {
            Object pc_err = sc.params.get("PCError");
            if (pc_err != null) {
                String msg = Command.toErrorString((Object)pc_err);
                this.exit(new Exception("PC error: " + msg));
                return;
            }
            Object step_err = sc.params.get("StepError");
            if (step_err != null) {
                String msg = Command.toErrorString((Object)step_err);
                this.exit(new Exception("Step error: " + msg));
                return;
            }
        }
        boolean my_breakpoint = this.isMyBreakpoint(sc);
        if (this.main_thread_id == null && my_breakpoint) {
            if (!this.done_get_state) {
                this.exit(new Exception("Unexpeceted breakpoint hit"));
                return;
            }
            this.main_thread_id = sc.id;
            if (this.temp_bp_id != null) {
                Map<String, Object> m = this.bp_list.get(this.temp_bp_id);
                Boolean ci = (Boolean)this.bp_capabilities.get("ContextIds");
                if (ci != null && ci.booleanValue()) {
                    ArrayList<String> l = new ArrayList<String>();
                    l.add(this.main_thread_id);
                    m.put("ContextIds", l);
                }
                m.put("Enabled", true);
                this.bp_change_cmds.add(this.srv_breakpoints.change(m, new IBreakpoints.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        TestRCBP1.this.bp_change_cmds.remove(token);
                        if (error != null) {
                            TestRCBP1.this.exit(error);
                        }
                    }
                }));
            }
        }
        if (this.main_thread_id == null) {
            if (this.all_setup_done) {
                this.resume(sc.id);
            }
            return;
        }
        if (my_breakpoint) {
            SuspendedContext sp;
            String sp_sym;
            if (sc.id.equals(this.main_thread_id)) {
                ++this.bp_cnt;
            }
            String string = sp_sym = (sp = this.suspended_prev.get(sc.id)) == null ? null : this.toSymName(Long.parseLong(sp.pc));
            if (sp == null) {
                this.checkSuspendedContext(sc, "tcf_test_func0");
            } else if ("tcf_test_func0".equals(sp_sym)) {
                this.checkSuspendedContext(sc, "tcf_test_func1");
            } else if ("tcf_test_func1".equals(sp_sym)) {
                if (sc.id.equals(this.main_thread_id)) {
                    this.checkSuspendedContext(sc, "tcf_test_func2");
                } else {
                    this.checkSuspendedContext(sc, "tcf_test_func3");
                }
            } else if ("tcf_test_func2".equals(sp_sym)) {
                this.checkSuspendedContext(sc, "tcf_test_func3");
            } else if ("tcf_test_func3".equals(sp_sym)) {
                this.checkSuspendedContext(sc, "tcf_test_func0");
            }
            if (this.isMyTempBreakpoint(sc)) {
                ++this.temp_bp_cnt;
            }
        } else if (this.isMyDataBreakpoint(sc) && sc.id.equals(this.main_thread_id)) {
            ++this.data_bp_cnt;
        }
        if (!this.all_setup_done) {
            return;
        }
        if (!this.test_suite.isActive(this)) {
            return;
        }
        Runnable done = new Runnable(){

            @Override
            public void run() {
                if (TestRCBP1.this.suspended.get(sc.id) == sc) {
                    TestRCBP1.this.resume(sc.id);
                }
            }
        };
        if (my_breakpoint) {
            switch (this.rnd.nextInt(6)) {
                case 0: {
                    this.runMemoryTest(sc, done);
                    break;
                }
                case 1: {
                    this.runRegistersTest(sc, done);
                    break;
                }
                case 2: {
                    this.runLineNumbersTest(sc, done);
                    break;
                }
                case 3: {
                    this.runSymbolsTest(sc, done);
                    break;
                }
                case 4: {
                    this.changeBreakpoint6();
                    done.run();
                    break;
                }
                default: {
                    done.run();
                    break;
                }
            }
        } else {
            done.run();
        }
    }

    private boolean isMyContext(IRunControl.RunControlContext ctx) {
        if (this.test_ctx_id == null) {
            return false;
        }
        return this.test_ctx_id.equals(ctx.getID()) || this.test_ctx_id.equals(ctx.getParentID()) || this.test_ctx_id.equals(ctx.getCreatorID());
    }

    private boolean isMyBreakpoint(SuspendedContext sc) {
        if (!"Breakpoint".equals(sc.reason)) {
            return false;
        }
        long pc = Long.parseLong(sc.pc);
        for (IDiagnostics.ISymbol sym : this.sym_list.values()) {
            if (pc != sym.getValue().longValue()) continue;
            return true;
        }
        return false;
    }

    private boolean isMyDataBreakpoint(SuspendedContext sc) {
        Collection c;
        if (this.data_bp_id == null) {
            return false;
        }
        if (!"Breakpoint".equals(sc.reason)) {
            return false;
        }
        if (sc.params == null) {
            return false;
        }
        Object ids = sc.params.get("BPs");
        return ids != null && (c = (Collection)ids).contains(this.data_bp_id);
    }

    private boolean isMyTempBreakpoint(SuspendedContext sc) {
        Collection c;
        if (this.temp_bp_id == null) {
            return false;
        }
        if (!"Breakpoint".equals(sc.reason)) {
            return false;
        }
        if (sc.params == null) {
            return false;
        }
        Object ids = sc.params.get("BPs");
        return ids != null && (c = (Collection)ids).contains(this.temp_bp_id);
    }

    public void contextSuspended(final String id, String pc, String reason, Map<String, Object> params) {
        if (this.test_done) {
            return;
        }
        IRunControl.RunControlContext ctx = this.threads.get(id);
        if (ctx == null) {
            return;
        }
        assert (this.isMyContext(ctx));
        if (!ctx.hasState()) {
            this.exit(new Exception("Suspended event for context that HasState = false"));
            return;
        }
        this.running.remove(id);
        SuspendedContext sc = this.suspended.get(id);
        if (sc != null) {
            if (this.done_get_state || pc != null && !sc.pc.equals(pc) || reason != null && !sc.reason.equals(reason)) {
                this.exit(new Exception("Invalid contextSuspended event"));
                return;
            }
        } else {
            sc = new SuspendedContext(id, pc, reason, params);
            assert (!this.done_get_state || this.done_disassembly || this.srv_disassembly == null);
            this.suspended.put(id, sc);
        }
        if (!this.all_setup_done) {
            return;
        }
        assert (this.get_state_cmds.size() == 0);
        assert (this.suspended.get(id) == sc);
        assert (!sc.get_state_pending);
        sc.get_state_pending = true;
        final SuspendedContext sc0 = sc;
        this.testSymbolsFlushEvents();
        ctx.getState(new IRunControl.DoneGetState(){

            public void doneGetState(IToken token, Exception error, boolean susp, String pc, String reason, Map<String, Object> params) {
                if (error != null) {
                    TestRCBP1.this.exit(new Exception("Cannot get context state", error));
                } else if (TestRCBP1.this.suspended.get(id) != sc0) {
                    TestRCBP1.this.exit(new Exception("Context resumed before RunControl.getState result"));
                } else if (!susp) {
                    TestRCBP1.this.exit(new Exception("Invalid RunControl.getState result"));
                } else if (pc == null || pc.length() == 0) {
                    TestRCBP1.this.exit(new Exception("Invalid PC returned by RunControl.getState"));
                } else if (TestRCBP1.this.test_suite.isActive(TestRCBP1.this)) {
                    SuspendedContext sc = (SuspendedContext)TestRCBP1.this.suspended.get(id);
                    if (!$assertionsDisabled && !sc.get_state_pending) {
                        throw new AssertionError();
                    }
                    sc.get_state_pending = false;
                    if (sc.pc == null || sc.reason == null) {
                        sc = new SuspendedContext(id, pc, reason, params);
                        if (!$assertionsDisabled && TestRCBP1.this.done_get_state && !TestRCBP1.this.done_disassembly && TestRCBP1.this.srv_disassembly != null) {
                            throw new AssertionError();
                        }
                        TestRCBP1.this.suspended.put(id, sc);
                    } else if (!sc.pc.equals(pc) || !sc.reason.equals(reason)) {
                        TestRCBP1.this.exit(new Exception("Invalid RunControl.getState result"));
                        return;
                    }
                    TestRCBP1.this.checkSuspendedContext(sc);
                }
            }
        });
    }

    @Override
    public boolean canResume(String id) {
        if (this.test_ctx_id != null && this.threads.size() == 0) {
            return false;
        }
        IRunControl.RunControlContext ctx = this.test_rc.getContext(id);
        if (ctx == null) {
            return false;
        }
        if (this.isMyContext(ctx) && (!this.all_setup_done || this.threads.get(id) == null)) {
            return false;
        }
        String grp = ctx.getRCGroup();
        for (IRunControl.RunControlContext x : this.threads.values()) {
            if (!x.getID().equals(id) && (grp == null || !grp.equals(x.getRCGroup()))) continue;
            SuspendedContext sc = this.suspended.get(x.getID());
            if (sc == null) {
                return false;
            }
            if (sc.ok_to_resume) continue;
            return false;
        }
        return true;
    }

    private void resume(String id) {
        assert (this.done_get_state || this.resume_cnt == 0);
        assert (this.bp_sync_done);
        assert (this.mem_map_test_done);
        ++this.resume_cnt;
        SuspendedContext sc = this.suspended.get(id);
        IRunControl.RunControlContext ctx = this.threads.get(id);
        if (ctx != null && sc != null) {
            assert (!sc.get_state_pending);
            assert (!sc.ok_to_resume);
            sc.ok_to_resume = true;
            int cnt = 1;
            int rm = 0;
            if (this.isMyBreakpoint(sc) && !ctx.canResume(rm = this.rnd.nextInt(6))) {
                rm = 0;
            }
            this.test_rc.resume(id, rm, cnt);
        }
    }

    private void runMemoryTest(final SuspendedContext sc, final Runnable done) {
        if (this.srv_memory == null || this.test_suite.target_lock) {
            Protocol.invokeLater((Runnable)done);
            return;
        }
        this.test_suite.target_lock = true;
        this.srv_memory.getContext(this.test_context.getProcessID(), new IMemory.DoneGetContext(){

            public void doneGetContext(IToken token, Exception error, final IMemory.MemoryContext mem_ctx) {
                if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                    ((TestRCBP1)TestRCBP1.this).test_suite.target_lock = false;
                    return;
                }
                if (error != null) {
                    TestRCBP1.this.exit(error);
                    return;
                }
                if (!TestRCBP1.this.test_context.getProcessID().equals(mem_ctx.getID())) {
                    TestRCBP1.this.exit(new Exception("Bad memory context data: invalid ID"));
                }
                final boolean big_endian = mem_ctx.isBigEndian();
                final int addr_size = mem_ctx.getAddressSize();
                final byte[] buf = new byte[4096];
                mem_ctx.get(((IDiagnostics.ISymbol)TestRCBP1.this.sym_list.get("tcf_test_array")).getValue(), 1, buf, 0, addr_size, 0, new IMemory.DoneMemory(){

                    public void doneMemory(IToken token, IMemory.MemoryError error) {
                        if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                            ((TestRCBP1)(this).TestRCBP1.this).test_suite.target_lock = false;
                            return;
                        }
                        if (error != null) {
                            TestRCBP1.this.exit((Throwable)error);
                            return;
                        }
                        byte[] tmp = new byte[addr_size + 1];
                        tmp[0] = 0;
                        if (big_endian) {
                            System.arraycopy(buf, 0, tmp, 1, addr_size);
                        } else {
                            int i = 0;
                            while (i < addr_size) {
                                tmp[i + 1] = buf[addr_size - i - 1];
                                ++i;
                            }
                        }
                        BigInteger mem_address = new BigInteger(tmp);
                        if (((Number)mem_address).longValue() == 0L) {
                            TestRCBP1.this.exit(new Exception("Bad value of 'tcf_test_array': " + mem_address));
                        }
                        TestRCBP1.this.testSetMemoryCommand(sc, mem_ctx, mem_address, buf, done);
                    }
                });
            }
        });
    }

    private void testSetMemoryCommand(final SuspendedContext sc, final IMemory.MemoryContext mem_ctx, final Number addr, final byte[] buf, final Runnable done) {
        final byte[] data = new byte[buf.length];
        this.rnd.nextBytes(data);
        mem_ctx.set(addr, 1, data, 0, data.length, 0, new IMemory.DoneMemory(){

            public void doneMemory(IToken token, IMemory.MemoryError error) {
                if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                    ((TestRCBP1)TestRCBP1.this).test_suite.target_lock = false;
                    return;
                }
                if (error != null) {
                    TestRCBP1.this.exit((Throwable)error);
                    return;
                }
                mem_ctx.get(addr, 1, buf, 0, buf.length, 0, new IMemory.DoneMemory(){

                    public void doneMemory(IToken token, IMemory.MemoryError error) {
                        if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                            ((TestRCBP1)(this).TestRCBP1.this).test_suite.target_lock = false;
                            return;
                        }
                        if (error != null) {
                            TestRCBP1.this.exit((Throwable)error);
                            return;
                        }
                        int i = 0;
                        while (i < data.length) {
                            if (data[i] != buf[i]) {
                                TestRCBP1.this.exit(new Exception("Invalid Memory.get responce: wrong data at offset " + i + ", expected " + data[i] + ", actual " + buf[i]));
                                return;
                            }
                            ++i;
                        }
                        TestRCBP1.this.testFillMemoryCommand(sc, mem_ctx, addr, buf, done);
                    }
                });
            }
        });
    }

    private void testFillMemoryCommand(final SuspendedContext sc, final IMemory.MemoryContext mem_ctx, final Number addr, final byte[] buf, final Runnable done) {
        final byte[] data = new byte[buf.length / 7];
        this.rnd.nextBytes(data);
        mem_ctx.fill(addr, 1, data, buf.length, 0, new IMemory.DoneMemory(){

            public void doneMemory(IToken token, IMemory.MemoryError error) {
                if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                    ((TestRCBP1)TestRCBP1.this).test_suite.target_lock = false;
                    return;
                }
                if (error != null) {
                    TestRCBP1.this.exit((Throwable)error);
                    return;
                }
                mem_ctx.get(addr, 1, buf, 0, buf.length, 0, new IMemory.DoneMemory(){

                    public void doneMemory(IToken token, IMemory.MemoryError error) {
                        if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                            ((TestRCBP1)(this).TestRCBP1.this).test_suite.target_lock = false;
                            return;
                        }
                        if (error != null) {
                            TestRCBP1.this.exit((Throwable)error);
                            return;
                        }
                        int i = 0;
                        while (i < data.length) {
                            if (data[i % data.length] != buf[i]) {
                                TestRCBP1.this.exit(new Exception("Invalid Memory.get responce: wrong data at offset " + i + ", expected " + data[i % data.length] + ", actual " + buf[i]));
                                return;
                            }
                            ++i;
                        }
                        ((TestRCBP1)(this).TestRCBP1.this).test_suite.target_lock = false;
                        done.run();
                    }
                });
            }
        });
    }

    private void runRegistersTest(final SuspendedContext sc, final Runnable done) {
        if (this.srv_registers == null) {
            Protocol.invokeLater((Runnable)done);
            return;
        }
        if (this.regs.get(sc.id) == null) {
            final HashMap reg_map = new HashMap();
            this.regs.put(sc.id, reg_map);
            final HashSet<IToken> cmds = new HashSet<IToken>();
            cmds.add(this.srv_registers.getChildren(sc.id, new IRegisters.DoneGetChildren(){

                public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
                    cmds.remove(token);
                    if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                        TestRCBP1.this.regs.remove(sc.id);
                        return;
                    }
                    if (error != null) {
                        TestRCBP1.this.exit(error);
                        return;
                    }
                    String[] stringArray = context_ids;
                    int n = context_ids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        final String id = stringArray[n2];
                        cmds.add(TestRCBP1.this.srv_registers.getChildren(id, (IRegisters.DoneGetChildren)this));
                        cmds.add(TestRCBP1.this.srv_registers.getContext(id, new IRegisters.DoneGetContext(){

                            public void doneGetContext(IToken token, Exception error, IRegisters.RegistersContext context) {
                                cmds.remove(token);
                                if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                                    TestRCBP1.this.regs.remove(sc.id);
                                    return;
                                }
                                if (error != null) {
                                    TestRCBP1.this.exit(error);
                                    return;
                                }
                                reg_map.put(id, context);
                                if (cmds.isEmpty()) {
                                    TestRCBP1.this.testGetSetRegisterCommands(sc, done);
                                }
                            }
                        }));
                        ++n2;
                    }
                }
            }));
        } else {
            this.testGetSetRegisterCommands(sc, done);
        }
    }

    private void testGetSetRegisterCommands(final SuspendedContext sc, final Runnable done) {
        final Map<String, IRegisters.RegistersContext> reg_map = this.regs.get(sc.id);
        final HashSet<IToken> cmds = new HashSet<IToken>();
        if (reg_map.size() > 0) {
            this.reg_changed.clear();
            String[] ids = reg_map.keySet().toArray(new String[reg_map.size()]);
            int n = 0;
            while (n < 10000 && cmds.size() < 100) {
                if (this.rnd.nextBoolean()) {
                    String id = ids[this.rnd.nextInt(ids.length)];
                    final IRegisters.RegistersContext ctx = reg_map.get(id);
                    if (ctx.isReadable() && !ctx.isReadOnce() && ctx.getSize() != 0) {
                        cmds.add(ctx.get(new IRegisters.DoneGet(){

                            public void doneGet(IToken token, Exception error, final byte[] value) {
                                cmds.remove(token);
                                if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                                    return;
                                }
                                if (error != null) {
                                    TestRCBP1.this.exit(error);
                                    return;
                                }
                                if (ctx.getSize() != value.length) {
                                    TestRCBP1.this.exit(new Exception("Invalid register value size"));
                                    return;
                                }
                                if (ctx.isWriteable() && !ctx.isWriteOnce() && ctx.getMemoryContext() == null) {
                                    cmds.add(ctx.set(value, new IRegisters.DoneSet(){

                                        public void doneSet(IToken token, Exception error) {
                                            cmds.remove(token);
                                            if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                                                return;
                                            }
                                            if (error != null) {
                                                TestRCBP1.this.exit(error);
                                                return;
                                            }
                                            if (!TestRCBP1.this.reg_changed.contains(ctx.getID())) {
                                                TestRCBP1.this.exit(new Exception("Missing register changed event for " + ctx.getName()));
                                                return;
                                            }
                                            cmds.add(ctx.get(new IRegisters.DoneGet(){

                                                public void doneGet(IToken token, Exception error, byte[] value1) {
                                                    cmds.remove(token);
                                                    if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                                                        return;
                                                    }
                                                    if (error != null) {
                                                        TestRCBP1.this.exit(error);
                                                        return;
                                                    }
                                                    int i = 0;
                                                    while (i < value.length) {
                                                        if (value[i] != value1[i]) {
                                                            TestRCBP1.this.exit(new Exception("Invalid register value in " + ctx.getName()));
                                                            return;
                                                        }
                                                        ++i;
                                                    }
                                                    if (cmds.isEmpty()) {
                                                        done.run();
                                                    }
                                                }
                                            }));
                                        }
                                    }));
                                }
                                if (cmds.isEmpty()) {
                                    TestRCBP1.this.reg_changed.clear();
                                    done.run();
                                }
                            }
                        }));
                    }
                } else {
                    int data_size = 0;
                    int l = this.rnd.nextInt(32);
                    ArrayList<IRegisters.Location> locs = new ArrayList<IRegisters.Location>();
                    final ArrayList<String> names = new ArrayList<String>();
                    int i = 0;
                    while (i < l) {
                        String id = ids[this.rnd.nextInt(ids.length)];
                        IRegisters.RegistersContext ctx = reg_map.get(id);
                        if (ctx.isReadable() && ctx.isWriteable() && !ctx.isReadOnce() && !ctx.isWriteOnce() && ctx.getSize() != 0 && ctx.getMemoryContext() == null) {
                            int offs = this.rnd.nextInt(ctx.getSize());
                            int size = this.rnd.nextInt(ctx.getSize() - offs) + 1;
                            locs.add(new IRegisters.Location(id, offs, size));
                            names.add(ctx.getName());
                            data_size += size;
                        }
                        ++i;
                    }
                    final int total_size = data_size;
                    final IRegisters.Location[] loc_arr = locs.toArray(new IRegisters.Location[locs.size()]);
                    cmds.add(this.srv_registers.getm(loc_arr, new IRegisters.DoneGet(){

                        public void doneGet(IToken token, Exception error, byte[] value) {
                            cmds.remove(token);
                            if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                                return;
                            }
                            if (error == null && value.length != total_size) {
                                error = new Exception("Invalid data size in Registers.getm reply");
                            }
                            if (error != null) {
                                error = new Exception("Cannot read regs " + names, error);
                                TestRCBP1.this.exit(error);
                                return;
                            }
                            cmds.add(TestRCBP1.this.srv_registers.setm(loc_arr, value, new IRegisters.DoneSet(){

                                public void doneSet(IToken token, Exception error) {
                                    cmds.remove(token);
                                    if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                                        return;
                                    }
                                    if (error != null) {
                                        TestRCBP1.this.exit(error);
                                        return;
                                    }
                                    IRegisters.Location[] locationArray = loc_arr;
                                    int n = loc_arr.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IRegisters.Location l = locationArray[n2];
                                        if (!TestRCBP1.this.reg_changed.contains(l.id)) {
                                            TestRCBP1.this.exit(new Exception("Missing register changed event for " + ((IRegisters.RegistersContext)reg_map.get(l.id)).getName()));
                                            return;
                                        }
                                        ++n2;
                                    }
                                    if (cmds.isEmpty()) {
                                        TestRCBP1.this.reg_changed.clear();
                                        done.run();
                                    }
                                }
                            }));
                        }
                    }));
                }
                ++n;
            }
        }
        if (cmds.isEmpty()) {
            done.run();
        }
    }

    private void runLineNumbersTest(SuspendedContext sc, final Runnable done) {
        if (this.srv_line_numbers != null && sc.pc != null) {
            BigInteger x = new BigInteger(sc.pc);
            BigInteger y = x.add(BigInteger.valueOf(1L));
            this.srv_line_numbers.mapToSource(sc.id, (Number)x, (Number)y, new ILineNumbers.DoneMapToSource(){

                public void doneMapToSource(IToken token, Exception error, ILineNumbers.CodeArea[] areas) {
                    if (error != null) {
                        TestRCBP1.this.exit(error);
                        return;
                    }
                    done.run();
                }
            });
        } else {
            done.run();
        }
    }

    private void runSymbolsTest(final SuspendedContext sc, final Runnable done) {
        if (this.srv_syms != null && sc.pc != null) {
            final BigInteger x = new BigInteger(sc.pc);
            this.srv_syms.findByAddr(sc.id, (Number)x, new ISymbols.DoneFind(){

                public void doneFind(IToken token, Exception error, String symbol_id) {
                    if (error != null) {
                        int code = 1;
                        if (error instanceof IErrorReport) {
                            code = ((IErrorReport)error).getErrorCode();
                        }
                        switch (code) {
                            case 22: 
                            case 25: {
                                done.run();
                                return;
                            }
                        }
                        TestRCBP1.this.exit(error);
                        return;
                    }
                    TestRCBP1.this.srv_syms.getContext(symbol_id, new ISymbols.DoneGetContext(){

                        public void doneGetContext(IToken token, Exception error, ISymbols.Symbol context) {
                            if (error != null) {
                                TestRCBP1.this.exit(error);
                                return;
                            }
                            Number addr = context.getAddress();
                            int size = context.getSize();
                            if (addr == null) {
                                TestRCBP1.this.exit(new Exception("Missing symbol address attribute"));
                                return;
                            }
                            if (size <= 0) {
                                TestRCBP1.this.exit(new Exception("Invalid symbol size attribute"));
                                return;
                            }
                            BigInteger y = JSON.toBigInteger((Number)addr);
                            BigInteger z = y.add(BigInteger.valueOf(size));
                            if (x.compareTo(y) < 0 || x.compareTo(z) >= 0) {
                                TestRCBP1.this.exit(new Exception("Invalid symbol address attribute"));
                                return;
                            }
                            String name = context.getName();
                            if (name == null) {
                                done.run();
                                return;
                            }
                            TestRCBP1.this.srv_syms.find(sc.id, (Number)0, name, new ISymbols.DoneFind(){

                                public void doneFind(IToken token, Exception error, String symbol_id) {
                                    if (error != null) {
                                        TestRCBP1.this.exit(error);
                                        return;
                                    }
                                    done.run();
                                }
                            });
                        }
                    });
                }
            });
        } else {
            done.run();
        }
    }

    private String getRandomString() {
        int l = this.rnd.nextInt(512) + 1;
        StringBuffer bf = new StringBuffer(l);
        int i = 0;
        while (i < l) {
            bf.append((char)(this.rnd.nextInt(65535) + 1));
            ++i;
        }
        return bf.toString();
    }

    private JSON.Binary getRandomBinary() {
        int l = this.rnd.nextInt(512) + 1;
        byte[] bf = new byte[l];
        int i = 0;
        while (i < l) {
            bf[i] = (byte)this.rnd.nextInt(256);
            ++i;
        }
        return new JSON.Binary(bf, 0, bf.length);
    }

    private Map<String, Object> getRandomObject(int level) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (level < 4) {
            if (this.rnd.nextBoolean()) {
                m.put("True", true);
            }
            if (this.rnd.nextBoolean()) {
                m.put("False", false);
            }
            if (this.rnd.nextBoolean()) {
                m.put("Null", null);
            }
            if (this.rnd.nextBoolean()) {
                m.put("Integer", this.rnd.nextInt());
            }
            if (this.rnd.nextBoolean()) {
                m.put("String", this.getRandomString());
            }
            if (this.rnd.nextBoolean()) {
                m.put("Object", this.getRandomObject(level + 1));
            }
            if (this.rnd.nextBoolean()) {
                m.put("Array", new ArrayList<Object>(this.getRandomObject(level + 1).values()));
            }
        }
        return m;
    }

    private void runMemoryMapTest() {
        assert (!this.mem_map_test_running);
        if (this.srv_memory_map == null || this.test_context == null || this.test_context.getProcessID() == null) {
            this.mem_map_test_done = true;
            this.runTest();
            return;
        }
        this.mem_map_test_running = true;
        final String prs_id = this.test_context.getProcessID();
        this.srv_memory_map.get(prs_id, new IMemoryMap.DoneGet(){

            public void doneGet(IToken token, Exception error, IMemoryMap.MemoryRegion[] map) {
                if (error != null) {
                    TestRCBP1.this.exit(error);
                    return;
                }
                final HashMap<String, Object> props = new HashMap<String, Object>();
                StringBuilder stringBuilder = new StringBuilder("TestRCBP1.");
                int n = mem_map_region_id;
                mem_map_region_id = n + 1;
                final String test_id = stringBuilder.append(n).append(".").append(prs_id).toString();
                props.put("ID", test_id);
                if (TestRCBP1.this.rnd.nextBoolean()) {
                    props.put("Addr", TestRCBP1.this.rnd.nextInt(0x10000000));
                }
                if (TestRCBP1.this.rnd.nextBoolean()) {
                    props.put("Size", TestRCBP1.this.rnd.nextInt(0x10000000));
                }
                if (TestRCBP1.this.rnd.nextBoolean()) {
                    props.put("Flags", TestRCBP1.this.rnd.nextInt(7));
                }
                if (TestRCBP1.this.rnd.nextBoolean()) {
                    props.put("FileName", TestRCBP1.this.getRandomString());
                    if (TestRCBP1.this.rnd.nextBoolean()) {
                        props.put("SectionName", TestRCBP1.this.getRandomString());
                    } else if (TestRCBP1.this.rnd.nextBoolean()) {
                        props.put("Offs", TestRCBP1.this.rnd.nextInt(0x10000000));
                    }
                    if (TestRCBP1.this.rnd.nextBoolean()) {
                        props.put("BSS", true);
                    }
                }
                if (TestRCBP1.this.rnd.nextBoolean()) {
                    props.put("TestRCBP-String", TestRCBP1.this.getRandomString());
                }
                if (TestRCBP1.this.rnd.nextBoolean()) {
                    props.put("TestRCBP-Binary", TestRCBP1.this.getRandomBinary());
                }
                if (TestRCBP1.this.rnd.nextBoolean()) {
                    props.put("TestRCBP-Object", TestRCBP1.this.getRandomObject(0));
                }
                ArrayList<Object> list = new ArrayList<Object>();
                IMemoryMap.MemoryRegion[] memoryRegionArray = map;
                int n2 = map.length;
                int n3 = 0;
                while (n3 < n2) {
                    IMemoryMap.MemoryRegion r = memoryRegionArray[n3];
                    String id = (String)r.getProperties().get("ID");
                    if (id != null) {
                        list.add(r);
                    }
                    ++n3;
                }
                final ArrayList org_list = new ArrayList(list);
                list.add(new TCFMemoryRegion(props));
                TestRCBP1.this.srv_memory_map.set(prs_id, list.toArray(new IMemoryMap.MemoryRegion[list.size()]), new IMemoryMap.DoneSet(){

                    public void doneSet(IToken token, Exception error) {
                        if (error != null) {
                            TestRCBP1.this.exit(error);
                            return;
                        }
                        TestRCBP1.this.srv_memory_map.get(prs_id, new IMemoryMap.DoneGet(){

                            public void doneGet(IToken token, Exception error, IMemoryMap.MemoryRegion[] map) {
                                if (error != null) {
                                    TestRCBP1.this.exit(error);
                                    return;
                                }
                                int cnt = 0;
                                IMemoryMap.MemoryRegion[] memoryRegionArray = map;
                                int n = map.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IMemoryMap.MemoryRegion r = memoryRegionArray[n2];
                                    String id = (String)r.getProperties().get("ID");
                                    if (test_id.equals(id)) {
                                        for (String p : props.keySet()) {
                                            Object o = props.get(p);
                                            if (o instanceof JSON.Binary) {
                                                byte[] x = ((JSON.Binary)o).bytes;
                                                byte[] y = JSON.toByteArray(r.getProperties().get(p));
                                                if (Arrays.equals(x, y)) continue;
                                                TestRCBP1.this.exit(new Error("Invalid value returned for Memory Map region property " + p));
                                                return;
                                            }
                                            if (o.equals(r.getProperties().get(p))) continue;
                                            TestRCBP1.this.exit(new Error("Invalid value returned for Memory Map region property " + p));
                                            return;
                                        }
                                        ++cnt;
                                    }
                                    ++n2;
                                }
                                if (cnt != 1) {
                                    TestRCBP1.this.exit(new Error("Error adding memory map entry with MemoryMap.set command"));
                                    return;
                                }
                                TestRCBP1.this.srv_memory_map.set(prs_id, org_list.toArray(new IMemoryMap.MemoryRegion[org_list.size()]), new IMemoryMap.DoneSet(){

                                    public void doneSet(IToken token, Exception error) {
                                        if (error != null) {
                                            TestRCBP1.this.exit(error);
                                            return;
                                        }
                                        TestRCBP1.this.mem_map_test_running = false;
                                        TestRCBP1.this.mem_map_test_done = true;
                                        TestRCBP1.this.runTest();
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    private void testSymbolsFlushEvents() {
        if (this.srv_memory_map == null) {
            return;
        }
        if (this.rnd.nextInt(101) != 0) {
            return;
        }
        ArrayList<Object> l = null;
        String process_id = this.test_context.getProcessID();
        if (this.mem_map != null) {
            l = this.mem_map.get(process_id);
        }
        l = l == null ? new ArrayList() : new ArrayList<IMemoryMap.MemoryRegion>(l);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("TestRCBP1", test_cnt++);
        l.add((IMemoryMap.MemoryRegion)new TCFMemoryRegion(props));
        this.srv_memory_map.set(process_id, l.toArray(new IMemoryMap.MemoryRegion[l.size()]), new IMemoryMap.DoneSet(){

            public void doneSet(IToken token, Exception error) {
                IErrorReport e;
                if (error instanceof IErrorReport && (e = (IErrorReport)error).getErrorCode() == 16) {
                    error = null;
                }
                if (error != null) {
                    TestRCBP1.this.exit(error);
                }
            }
        });
    }

    void cancel(final Runnable done) {
        if (this.srv_run_ctrl != null) {
            this.srv_run_ctrl.removeListener((IRunControl.RunControlListener)this);
        }
        if (this.test_ctx_id == null) {
            if (this.pending_cancel != null) {
                this.exit(null);
            } else {
                this.pending_cancel = done;
            }
        } else if (this.cancel_test_cmd == null) {
            this.cancel_test_cmd = this.srv_diag.cancelTest(this.test_ctx_id, new IDiagnostics.DoneCancelTest(){

                public void doneCancelTest(IToken token, Throwable error) {
                    TestRCBP1.this.cancel_test_cmd = null;
                    TestRCBP1.this.exit(error);
                    done.run();
                }
            });
        } else {
            this.exit(new Exception("Cannot terminate remote test process"));
            done.run();
        }
    }

    private void exit(Throwable x) {
        if (!this.test_suite.isActive(this)) {
            return;
        }
        if (this.pending_cancel != null) {
            Protocol.invokeLater((Runnable)this.pending_cancel);
            this.pending_cancel = null;
        } else if (this.srv_run_ctrl != null) {
            this.srv_run_ctrl.removeListener((IRunControl.RunControlListener)this);
        }
        if (this.srv_breakpoints != null) {
            this.srv_breakpoints.removeListener(this.bp_listener);
        }
        if (this.srv_registers != null) {
            this.srv_registers.removeListener(this.reg_listener);
        }
        this.test_suite.done(this, x);
    }

    private static class SuspendedContext {
        final String id;
        final String pc;
        final String reason;
        final Map<String, Object> params;
        boolean get_state_pending;
        boolean ok_to_resume;

        SuspendedContext(String id, String pc, String reason, Map<String, Object> params) {
            this.id = id;
            this.pc = pc;
            this.reason = reason;
            this.params = params;
        }
    }
}

