/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.concurrent.TCFOperationMonitor;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.AbstractOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpRename
extends AbstractOperation {
    FSTreeNode node;
    String newName;

    public OpRename(FSTreeNode node, String newName) {
        this.node = node;
        this.newName = newName;
    }

    @Override
    public IStatus doRun(IProgressMonitor monitor) {
        monitor.beginTask(this.getName(), -1);
        CacheManager.clearCache(this.node);
        final TCFOperationMonitor result = new TCFOperationMonitor();
        monitor.subTask(NLS.bind((String)Messages.OpMove_Moving, (Object)this.node.getLocation()));
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                OpRename.this.tcfRename(result);
            }
        });
        return result.waitDone(monitor);
    }

    protected void tcfRename(final TCFOperationMonitor<?> result) {
        if (result.checkCancelled()) {
            return;
        }
        IFileSystem fileSystem = this.node.getRuntimeModel().getFileSystem();
        if (fileSystem == null) {
            result.setCancelled();
            return;
        }
        CacheManager.clearCache(this.node);
        final String sourcePath = this.node.getLocation(true);
        String destPath = this.getPath(this.node.getParent(), this.newName);
        fileSystem.rename(sourcePath, destPath, new IFileSystem.DoneRename(){

            public void doneRename(IToken token, IFileSystem.FileSystemException error) {
                if (error != null) {
                    result.setError(MessageFormat.format(Messages.OpMove_CannotMove, sourcePath), (Throwable)error);
                } else {
                    FSTreeNode parent = OpRename.this.node.getParent();
                    parent.removeNode(OpRename.this.node, true);
                    OpRename.this.node.changeName(OpRename.this.newName);
                    parent.addNode(OpRename.this.node, true);
                    result.setDone(null);
                }
            }
        });
    }

    @Override
    public String getName() {
        return Messages.OpRename_TitleRename;
    }
}

