/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeLaunch;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;

class TCFModelSelectionPolicy
implements IModelSelectionPolicy {
    private final TCFModel model;

    TCFModelSelectionPolicy(TCFModel model) {
        this.model = model;
    }

    public boolean contains(ISelection selection, IPresentationContext context) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object e = ss.getFirstElement();
            if (e instanceof TCFNode) {
                TCFNode n = (TCFNode)e;
                return n.model == this.model;
            }
            if (e instanceof TCFLaunch) {
                return this.model.getLaunch() == e;
            }
        }
        return false;
    }

    public boolean isSticky(ISelection selection, IPresentationContext context) {
        IStructuredSelection ss;
        Object e;
        if (selection instanceof IStructuredSelection && (e = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof TCFNode) {
            return this.getSuspendReason((TCFNode)e) != null;
        }
        return false;
    }

    private String getSuspendReason(final TCFNode node) {
        return (String)new TCFTask<String>(){

            public void run() {
                TCFNode n = node;
                while (n != null && !n.isDisposed()) {
                    if (n instanceof TCFNodeExecContext) {
                        TCFDataCache<TCFContextState> cache = ((TCFNodeExecContext)n).getMinState();
                        if (!cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        TCFContextState state = (TCFContextState)cache.getData();
                        if (state != null && state.is_suspended) {
                            if (state.suspend_reason == null) {
                                this.done("Suspended");
                            } else {
                                this.done(state.suspend_reason);
                            }
                            return;
                        }
                    }
                    n = n.parent;
                }
                this.done(null);
            }
        }.getE();
    }

    public boolean overrides(ISelection existing, ISelection candidate, IPresentationContext context) {
        if ("org.eclipse.debug.ui.DebugView".equals(context.getId()) && existing instanceof IStructuredSelection && candidate instanceof IStructuredSelection) {
            Object el_existing = ((IStructuredSelection)existing).getFirstElement();
            Object el_candidate = ((IStructuredSelection)candidate).getFirstElement();
            if (el_existing == null) {
                return true;
            }
            if (el_existing == el_candidate) {
                return true;
            }
            if (el_existing instanceof TCFNode && el_candidate instanceof TCFNode) {
                String s1;
                TCFNode next;
                TCFNodeStackFrame curr;
                if (el_existing instanceof TCFNodeStackFrame && el_candidate instanceof TCFNodeStackFrame) {
                    curr = (TCFNodeStackFrame)el_existing;
                    next = (TCFNodeStackFrame)el_candidate;
                    if (curr.parent == next.parent) {
                        return true;
                    }
                }
                if (el_existing instanceof TCFNodeStackFrame && el_candidate instanceof TCFNodeExecContext) {
                    curr = (TCFNodeStackFrame)el_existing;
                    next = (TCFNodeExecContext)el_candidate;
                    if (curr.parent == next) {
                        return true;
                    }
                }
                if ((s1 = this.getSuspendReason((TCFNode)el_existing)) == null) {
                    return true;
                }
                String s2 = this.getSuspendReason((TCFNode)el_candidate);
                if (s2 == null) {
                    return false;
                }
                if (s2.equals("Suspended")) {
                    return false;
                }
                if (s2.equals("Container")) {
                    return false;
                }
                if (s1.equals("Suspended")) {
                    return true;
                }
                return s1.equals("Container");
            }
        }
        return true;
    }

    public ISelection replaceInvalidSelection(ISelection existing, ISelection candidate) {
        if (existing instanceof IStructuredSelection && candidate instanceof IStructuredSelection) {
            Object el_existing = ((IStructuredSelection)existing).getFirstElement();
            Object el_candidate = ((IStructuredSelection)candidate).getFirstElement();
            if (el_candidate == null) {
                if (el_existing == null) {
                    return new StructuredSelection((Object)this.model.getLaunch());
                }
                if (el_existing instanceof TCFNode) {
                    TCFNode node = (TCFNode)el_existing;
                    if (node.parent == null || node.parent instanceof TCFNodeLaunch) {
                        return new StructuredSelection((Object)this.model.getLaunch());
                    }
                    return new StructuredSelection((Object)node.parent);
                }
            }
        }
        return candidate;
    }
}

