/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.tcf.te.ui.views.internal.RestoreStatus;
import org.eclipse.tcf.te.ui.views.nls.Messages;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;

public class RestoreJob
extends Job {
    private IMemento memento;

    public RestoreJob(IMemento memento) {
        super(Messages.RestoreJob_JobName);
        this.memento = memento;
    }

    protected IStatus run(IProgressMonitor monitor) {
        int work = this.getTotalWork();
        if (work > 0) {
            monitor.beginTask(Messages.RestoreJob_MainTask, work);
            IMemento memExpand = this.memento.getChild("expanded-elements");
            if (memExpand != null) {
                monitor.subTask(Messages.RestoreJob_Task1Name);
                IMemento[] memElements = memExpand.getChildren("element");
                HashMap<UUID, Object> elements = new HashMap<UUID, Object>();
                IMemento[] iMementoArray = memElements;
                int n = memElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento memElement = iMementoArray[n2];
                    this.restoreElement(memElement, elements);
                    monitor.worked(1);
                    ++n2;
                }
                IMemento pathsElement = this.memento.getChild("expanded-paths");
                if (pathsElement != null) {
                    monitor.subTask(Messages.RestoreJob_Task2Name);
                    IMemento[] pathElements = pathsElement.getChildren("path");
                    ArrayList<TreePath> paths = new ArrayList<TreePath>();
                    IMemento[] iMementoArray2 = pathElements;
                    int n3 = pathElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMemento pathElement = iMementoArray2[n4];
                        TreePath path = this.restorePath(pathElement, elements);
                        if (path != null) {
                            paths.add(path);
                        }
                        monitor.worked(1);
                        ++n4;
                    }
                    monitor.done();
                    return new RestoreStatus(paths);
                }
            }
        }
        monitor.done();
        return Status.CANCEL_STATUS;
    }

    private int getTotalWork() {
        int work = 0;
        IMemento memExpand = this.memento.getChild("expanded-elements");
        if (memExpand != null) {
            IMemento[] memElements = memExpand.getChildren("element");
            work += memElements != null ? memElements.length : 0;
            IMemento pathsElement = this.memento.getChild("expanded-paths");
            if (pathsElement != null) {
                IMemento[] pathElements = pathsElement.getChildren("path");
                work += pathElements != null ? pathElements.length : 0;
            }
        }
        return work;
    }

    private TreePath restorePath(IMemento pathElement, Map<UUID, Object> elements) {
        IMemento[] children;
        ArrayList<Object> list = new ArrayList<Object>();
        IMemento[] iMementoArray = children = pathElement.getChildren("element");
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            String id = child.getID();
            try {
                UUID uuid = UUID.fromString(id);
                Object element = elements.get(uuid);
                if (element != null) {
                    list.add(element);
                }
            }
            catch (IllegalArgumentException e) {
                if (Platform.inDebugMode()) {
                    e.printStackTrace();
                }
                return null;
            }
            ++n2;
        }
        return new TreePath(list.toArray());
    }

    private void restoreElement(IMemento memElement, Map<UUID, Object> elements) {
        block3: {
            IAdaptable element;
            IElementFactory eFactory;
            String factoryId = memElement.getString("factoryId");
            if (factoryId != null && (eFactory = PlatformUI.getWorkbench().getElementFactory(factoryId)) != null && (element = eFactory.createElement(memElement)) != null) {
                String id = memElement.getID();
                try {
                    UUID uuid = UUID.fromString(id);
                    elements.put(uuid, element);
                }
                catch (IllegalArgumentException e) {
                    if (!Platform.inDebugMode()) break block3;
                    e.printStackTrace();
                }
            }
        }
    }
}

