/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tcf.te.runtime.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.events.NotifyEvent;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventFireDelegate;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.runtime.utils.Host;
import org.osgi.framework.Bundle;

public final class EventManager {
    private boolean extensionPointProcessed = false;
    private final List<ListenerListEntry> listeners = new ArrayList<ListenerListEntry>();

    EventManager() {
    }

    public static EventManager getInstance() {
        return LazyInstance.instance;
    }

    public void addEventListener(IEventListener listener, Class<?> eventType) {
        Class[] classArray;
        if (eventType != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = eventType;
        } else {
            classArray = null;
        }
        this.addEventListener(listener, classArray, null, null, null);
    }

    public void addEventListener(IEventListener listener, Class<?>[] eventTypes) {
        this.addEventListener(listener, eventTypes, null, null, null);
    }

    public void addEventListener(IEventListener listener, Class<?> eventType, Object eventSource) {
        Object[] objectArray;
        Class[] classArray;
        if (eventType != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = eventType;
        } else {
            classArray = null;
        }
        if (eventSource != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = eventSource;
        } else {
            objectArray = null;
        }
        this.addEventListener(listener, classArray, null, objectArray, null);
    }

    public void addEventListener(IEventListener listener, Class<?> eventType, Object[] eventSources) {
        Class[] classArray;
        if (eventType != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = eventType;
        } else {
            classArray = null;
        }
        this.addEventListener(listener, classArray, null, eventSources, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(IEventListener listener, Class<?>[] eventTypes, ClassNotLoadedItem[] eventTypesNotLoaded, Object[] eventSources, ClassNotLoadedItem[] eventSourcesNotLoaded) {
        ListenerListEntry listEntry = new ListenerListEntry(listener, eventTypes, eventTypesNotLoaded, eventSources, eventSourcesNotLoaded);
        List<ListenerListEntry> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(listEntry)) {
                this.listeners.remove(listEntry);
            }
            this.listeners.add(listEntry);
        }
    }

    public void removeEventListener(IEventListener listener) {
        ListenerListEntry listEntry = new ListenerListEntry(listener);
        this.listeners.remove(listEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.listeners.clear();
        EventManager eventManager = this;
        synchronized (eventManager) {
            this.extensionPointProcessed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(EventObject event) {
        ListenerListEntry[] registered;
        Assert.isNotNull((Object)event);
        if (event instanceof NotifyEvent && !Host.isInteractive()) {
            return;
        }
        EventManager eventManager = this;
        synchronized (eventManager) {
            if (!this.extensionPointProcessed) {
                this.addExtensionPointNotificationListeners();
                this.extensionPointProcessed = true;
            }
        }
        ArrayList<ListenerListEntry> affected = new ArrayList<ListenerListEntry>();
        ListenerListEntry[] listenerListEntryArray = registered = this.listeners.toArray(new ListenerListEntry[this.listeners.size()]);
        int n = registered.length;
        int n2 = 0;
        while (n2 < n) {
            ListenerListEntry listEntry = listenerListEntryArray[n2];
            if (listEntry.listensTo(event)) {
                affected.add(listEntry);
            }
            ++n2;
        }
        if (affected.size() == 0) {
            return;
        }
        for (ListenerListEntry listEntry : affected) {
            if (!(listEntry.getListener() instanceof IEventListener)) continue;
            FireRunnable runnable = new FireRunnable((IEventListener)listEntry.getListener(), event);
            if (listEntry.getListener() instanceof IEventFireDelegate) {
                ((IEventFireDelegate)((Object)listEntry.getListener())).fire(runnable);
                continue;
            }
            runnable.run();
        }
    }

    private void addExtensionPointNotificationListeners() {
        block25: {
            IExtension[] extensions;
            IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.tcf.te.runtime.eventListeners");
            if (ep == null || (extensions = ep.getExtensions()) == null || extensions.length <= 0) break block25;
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                block26: {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] configElements = extension.getConfigurationElements();
                    if (configElements == null || configElements.length <= 0) break block26;
                    IConfigurationElement[] iConfigurationElementArray = configElements;
                    int n3 = configElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        block27: {
                            IConfigurationElement[] children;
                            IConfigurationElement configElement = iConfigurationElementArray[n4];
                            String name = configElement.getName();
                            if (!"eventListener".equals(name)) break block27;
                            ArrayList<Class> eventTypes = new ArrayList<Class>();
                            ArrayList<Class> eventSourceTypes = new ArrayList<Class>();
                            ArrayList<ClassNotLoadedItem> eventTypesNotLoaded = new ArrayList<ClassNotLoadedItem>();
                            ArrayList<ClassNotLoadedItem> eventSourceTypesNotLoaded = new ArrayList<ClassNotLoadedItem>();
                            IConfigurationElement[] iConfigurationElementArray2 = children = configElement.getChildren();
                            int n5 = children.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                block24: {
                                    ClassNotLoadedItem item;
                                    Bundle bundle;
                                    String bundleId;
                                    String className;
                                    IConfigurationElement child;
                                    block23: {
                                        child = iConfigurationElementArray2[n6];
                                        if (!"eventType".equals(child.getName())) break block23;
                                        className = child.getAttribute("class");
                                        if (className == null || className.trim().length() == 0) break block24;
                                        bundleId = child.getAttribute("bundleId");
                                        Bundle bundle2 = bundle = bundleId != null ? Platform.getBundle((String)bundleId) : null;
                                        if (bundle == null) {
                                            bundle = Platform.getBundle((String)child.getDeclaringExtension().getNamespaceIdentifier());
                                        }
                                        if (bundle == null) {
                                            bundle = CoreBundleActivator.getContext().getBundle();
                                        }
                                        if (bundle != null && bundle.getState() == 32) {
                                            try {
                                                Class eventType = bundle.loadClass(className);
                                                if (eventType != null && !eventTypes.contains(eventType)) {
                                                    eventTypes.add(eventType);
                                                }
                                                break block23;
                                            }
                                            catch (Exception exception) {
                                                if (EventManager.isTracingEnabled()) {
                                                    CoreBundleActivator.getTraceHandler().trace("Error instantiating event listener event type object instance: " + child.getAttribute("class"), 0, "trace/events", 4, this);
                                                }
                                                break block23;
                                            }
                                        }
                                        item = new ClassNotLoadedItem(bundleId, className, child.getDeclaringExtension().getNamespaceIdentifier());
                                        if (!eventTypesNotLoaded.contains(item)) {
                                            eventTypesNotLoaded.add(item);
                                        }
                                    }
                                    if ("eventSourceType".equals(child.getName()) && (className = child.getAttribute("class")) != null && className.trim().length() != 0) {
                                        bundleId = child.getAttribute("bundleId");
                                        Bundle bundle3 = bundle = bundleId != null ? Platform.getBundle((String)bundleId) : null;
                                        if (bundle == null) {
                                            bundle = Platform.getBundle((String)child.getDeclaringExtension().getNamespaceIdentifier());
                                        }
                                        if (bundle == null) {
                                            bundle = CoreBundleActivator.getContext().getBundle();
                                        }
                                        if (bundle != null && bundle.getState() == 32) {
                                            try {
                                                Class eventSourceType = bundle.loadClass(className);
                                                if (eventSourceType != null && !eventSourceTypes.contains(eventSourceType)) {
                                                    eventSourceTypes.add(eventSourceType);
                                                }
                                                break block24;
                                            }
                                            catch (Exception exception) {
                                                if (EventManager.isTracingEnabled()) {
                                                    CoreBundleActivator.getTraceHandler().trace("Error instantiating event listener event source type object instance: " + child.getAttribute("class"), 0, "trace/events", 4, this);
                                                }
                                                break block24;
                                            }
                                        }
                                        item = new ClassNotLoadedItem(bundleId, className, child.getDeclaringExtension().getNamespaceIdentifier());
                                        if (!eventSourceTypesNotLoaded.contains(item)) {
                                            eventSourceTypesNotLoaded.add(item);
                                        }
                                    }
                                }
                                ++n6;
                            }
                            EventListenerProxy listener = new EventListenerProxy(configElement);
                            this.addEventListener(listener, !eventTypes.isEmpty() ? eventTypes.toArray(new Class[eventTypes.size()]) : null, !eventTypesNotLoaded.isEmpty() ? eventTypesNotLoaded.toArray(new ClassNotLoadedItem[eventTypesNotLoaded.size()]) : null, !eventSourceTypes.isEmpty() ? eventSourceTypes.toArray(new Class[eventSourceTypes.size()]) : null, !eventSourceTypesNotLoaded.isEmpty() ? eventSourceTypesNotLoaded.toArray(new ClassNotLoadedItem[eventSourceTypesNotLoaded.size()]) : null);
                            if (EventManager.isTracingEnabled()) {
                                CoreBundleActivator.getTraceHandler().trace("Add extension point change listener: " + configElement.getAttribute("class"), 0, "trace/events", 1, this);
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    public static boolean isTracingEnabled() {
        return CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/events");
    }

    private static class ClassNotLoadedItem {
        public final String bundleId;
        public final String className;
        public final String declaringBundleId;

        public ClassNotLoadedItem(String bundleId, String className, String declaringBundleId) {
            Assert.isNotNull((Object)bundleId);
            this.bundleId = bundleId;
            Assert.isNotNull((Object)className);
            this.className = className;
            Assert.isNotNull((Object)declaringBundleId);
            this.declaringBundleId = declaringBundleId;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ClassNotLoadedItem) {
                return this.bundleId.equals(((ClassNotLoadedItem)obj).bundleId) && this.className.equals(((ClassNotLoadedItem)obj).className) && this.declaringBundleId.equals(((ClassNotLoadedItem)obj).declaringBundleId);
            }
            return false;
        }

        public int hashCode() {
            return this.bundleId.hashCode() ^ this.className.hashCode() ^ this.declaringBundleId.hashCode();
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "{" + "bundleId=" + this.bundleId + ",className=" + this.className + ",declaringBundleId=" + this.declaringBundleId + "}";
        }
    }

    private class EventListenerProxy
    implements IEventListener,
    IEventFireDelegate {
        private final IConfigurationElement configElement;
        private IEventListener delegate;

        public EventListenerProxy(IConfigurationElement configElement) {
            Assert.isNotNull((Object)configElement);
            this.configElement = configElement;
            this.delegate = null;
        }

        private IEventListener getDelegate() {
            block6: {
                if (this.delegate == null) {
                    boolean forcePluginActivation = Boolean.parseBoolean(this.configElement.getAttribute("forcePluginActivation"));
                    if (!forcePluginActivation) {
                        Bundle bundle = Platform.getBundle((String)this.configElement.getContributor().getName());
                        boolean bl = bundle != null ? bundle.getState() == 32 : (forcePluginActivation = false);
                    }
                    if (forcePluginActivation) {
                        try {
                            Object executable = this.configElement.createExecutableExtension("class");
                            if (executable instanceof IEventListener) {
                                this.delegate = (IEventListener)executable;
                            }
                        }
                        catch (Exception ex) {
                            if (!EventManager.isTracingEnabled()) break block6;
                            CoreBundleActivator.getTraceHandler().trace("Error instantiating extension point event listener: " + this.configElement.getAttribute("class") + "(Possible Cause: " + ex.getLocalizedMessage() + ")", 0, "trace/events", 4, this);
                        }
                    }
                }
            }
            return this.delegate;
        }

        @Override
        public void eventFired(EventObject event) {
            Assert.isNotNull((Object)event);
            IEventListener delegate = this.getDelegate();
            if (delegate != null) {
                delegate.eventFired(event);
            }
        }

        @Override
        public void fire(Runnable runnable) {
            Assert.isNotNull((Object)runnable);
            if (this.getDelegate() instanceof IEventFireDelegate) {
                ((IEventFireDelegate)((Object)this.getDelegate())).fire(runnable);
            } else {
                runnable.run();
            }
        }
    }

    protected static class FireRunnable
    implements Runnable {
        private final IEventListener listener;
        private final EventObject event;

        public FireRunnable(IEventListener listener, EventObject event) {
            Assert.isNotNull((Object)listener);
            Assert.isNotNull((Object)event);
            this.listener = listener;
            this.event = event;
        }

        @Override
        public void run() {
            this.listener.eventFired(this.event);
        }
    }

    private static class LazyInstance {
        public static EventManager instance = new EventManager();

        private LazyInstance() {
        }
    }

    private static class ListenerListEntry {
        private final IEventListener listener;
        private Object[] eventSources;
        private ClassNotLoadedItem[] eventSourcesNotLoaded;
        private Class<?>[] eventTypes;
        private ClassNotLoadedItem[] eventTypesNotLoaded;

        protected ListenerListEntry(IEventListener listener) {
            this(listener, null, null, null, null);
        }

        protected ListenerListEntry(IEventListener listener, Class<?>[] eventTypes, ClassNotLoadedItem[] eventTypesNotLoaded, Object[] eventSources, ClassNotLoadedItem[] eventSourcesNotLoaded) {
            this.listener = listener;
            this.eventTypes = eventTypes == null || eventTypes.length == 0 ? null : eventTypes;
            this.eventTypesNotLoaded = eventTypesNotLoaded == null || eventTypesNotLoaded.length == 0 ? null : eventTypesNotLoaded;
            this.eventSources = eventSources == null || eventSources.length == 0 ? null : eventSources;
            this.eventSourcesNotLoaded = eventSourcesNotLoaded == null || eventSourcesNotLoaded.length == 0 ? null : eventSourcesNotLoaded;
        }

        protected EventListener getListener() {
            return this.listener;
        }

        private Class<?> loadClass(ClassNotLoadedItem item, String type) {
            Class clazz;
            block5: {
                Assert.isNotNull((Object)item);
                Assert.isNotNull((Object)type);
                clazz = null;
                Bundle bundle = Platform.getBundle((String)item.bundleId);
                if (bundle == null) {
                    bundle = Platform.getBundle((String)item.declaringBundleId);
                }
                if (bundle == null) {
                    bundle = CoreBundleActivator.getContext().getBundle();
                }
                if (bundle != null && bundle.getState() == 32) {
                    try {
                        clazz = bundle.loadClass(item.className);
                    }
                    catch (Exception exception) {
                        if (!EventManager.isTracingEnabled()) break block5;
                        CoreBundleActivator.getTraceHandler().trace("Error instantiating event listener " + type + " object instance: " + item.className, 0, "trace/events", 4, this);
                    }
                }
            }
            return clazz;
        }

        private void loadNotLoadedEventTypes() {
            if (this.eventTypesNotLoaded == null || this.eventTypesNotLoaded.length == 0) {
                return;
            }
            ArrayList types = new ArrayList();
            if (this.eventTypes != null && this.eventTypes.length > 0) {
                types.addAll(Arrays.asList(this.eventTypes));
            }
            ArrayList<ClassNotLoadedItem> notLoaded = new ArrayList<ClassNotLoadedItem>(Arrays.asList(this.eventTypesNotLoaded));
            boolean changed = false;
            Iterator it = notLoaded.iterator();
            while (it.hasNext()) {
                ClassNotLoadedItem item = (ClassNotLoadedItem)it.next();
                Class<?> clazz = this.loadClass(item, "event type");
                if (clazz == null) continue;
                it.remove();
                changed = true;
                if (types.contains(clazz)) continue;
                types.add(clazz);
            }
            if (changed) {
                this.eventTypes = types.toArray(new Class[types.size()]);
                this.eventTypesNotLoaded = notLoaded.toArray(new ClassNotLoadedItem[notLoaded.size()]);
            }
        }

        private void loadNotLoadedEventSources() {
            if (this.eventSourcesNotLoaded == null || this.eventSourcesNotLoaded.length == 0) {
                return;
            }
            ArrayList<Object> sources = new ArrayList<Object>();
            if (this.eventSources != null && this.eventSources.length > 0) {
                sources.addAll(Arrays.asList(this.eventSources));
            }
            ArrayList<ClassNotLoadedItem> notLoaded = new ArrayList<ClassNotLoadedItem>(Arrays.asList(this.eventSourcesNotLoaded));
            boolean changed = false;
            Iterator it = notLoaded.iterator();
            while (it.hasNext()) {
                ClassNotLoadedItem item = (ClassNotLoadedItem)it.next();
                Class<?> clazz = this.loadClass(item, "event source type");
                if (clazz == null) continue;
                it.remove();
                changed = true;
                if (sources.contains(clazz)) continue;
                sources.add(clazz);
            }
            if (changed) {
                this.eventSources = sources.toArray(new Object[sources.size()]);
                this.eventSourcesNotLoaded = notLoaded.toArray(new ClassNotLoadedItem[notLoaded.size()]);
            }
        }

        protected boolean listensTo(EventObject event) {
            boolean sources;
            boolean types = !(this.eventTypes != null && this.eventTypes.length != 0 || this.eventTypesNotLoaded != null && this.eventTypesNotLoaded.length != 0);
            boolean bl = sources = !(this.eventSources != null && this.eventSources.length != 0 || this.eventSourcesNotLoaded != null && this.eventSourcesNotLoaded.length != 0);
            if (!types) {
                this.loadNotLoadedEventTypes();
            }
            int t = 0;
            while (!types && this.eventTypes != null && t < this.eventTypes.length) {
                types = this.eventTypes[t].isInstance(event);
                ++t;
            }
            if (!sources) {
                this.loadNotLoadedEventSources();
            }
            int s = 0;
            while (!sources && this.eventSources != null && s < this.eventSources.length) {
                Object eventSource = this.eventSources[s];
                if (eventSource instanceof Class) {
                    Class eventSourceClass = (Class)eventSource;
                    sources = eventSourceClass.isInstance(event.getSource());
                } else {
                    sources = eventSource == event.getSource();
                }
                ++s;
            }
            return types && sources;
        }

        public int hashCode() {
            if (this.getListener() != null) {
                return this.getListener().hashCode();
            }
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ListenerListEntry) {
                ListenerListEntry other = (ListenerListEntry)obj;
                return this.getListener() == other.getListener();
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "{" + "listener=" + this.listener + ",eventTypes=" + Arrays.deepToString(this.eventTypes) + ",eventTypesNotLoaded=" + Arrays.deepToString(this.eventTypesNotLoaded) + ",eventSources=" + Arrays.deepToString(this.eventSources) + ",eventSourcesNotLoaded=" + Arrays.deepToString(this.eventSourcesNotLoaded) + "}";
        }
    }
}

