/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IMemoryBlockManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingManager;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.model.TCFDebugTask;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNumberFormat;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IExpressions;
import org.eclipse.tcf.services.IMemory;
import org.eclipse.tcf.services.ISymbols;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.helpers.DefaultHandler;

class TCFMemoryBlock
extends PlatformObject
implements IMemoryBlockExtension,
IModelProxyFactory {
    private final TCFModel model;
    private final IMemoryBlockRetrieval block_retrieval;
    private final String ctx_id;
    private final String expression;
    private final long length;
    private final Set<Object> connections = new HashSet<Object>();
    private final TCFDataCache<IExpressions.Expression> remote_expression;
    private final TCFDataCache<IExpressions.Value> expression_value;
    private final LinkedList<ModelProxy> model_proxies = new LinkedList();
    private MemData mem_data;
    private MemData mem_prev;
    private MemData mem_last;
    private boolean disposed;
    private static final String XML_NODE_MEMORY = "Memory";
    private static final String XML_NODE_BLOCK = "Block";
    private static final String XML_NODE_RENDERING = "Rendering";
    private static final String XML_ATTR_ID = "ID";
    private static final String XML_ATTR_VIEW = "View";
    private static final String XML_ATTR_PANE = "Pane";
    private static final String XML_ATTR_CTX = "Context";
    private static final String XML_ATTR_ADDR = "Addr";
    private static final String XML_ATTR_SIZE = "Size";
    private static final String XML_FILE_NAME = "memview.xml";
    private static final Display display = Display.getDefault();
    private static final Map<String, List<Element>> blocks_memento = new HashMap<String, List<Element>>();
    private static final Set<Runnable> pending_updates = new HashSet<Runnable>();
    private static boolean memento_loaded;

    TCFMemoryBlock(final TCFModel model, IMemoryBlockRetrieval block_retrieval, final String ctx_id, final String expression, long length) {
        assert (Protocol.isDispatchThread());
        this.model = model;
        this.block_retrieval = block_retrieval;
        this.ctx_id = ctx_id;
        this.expression = expression;
        this.length = length;
        final TCFLaunch launch = model.getLaunch();
        IChannel channel = launch.getChannel();
        this.remote_expression = new TCFDataCache<IExpressions.Expression>(channel){

            protected boolean startDataRetrieval() {
                IExpressions exps = (IExpressions)launch.getService(IExpressions.class);
                if (exps == null) {
                    this.set(null, new Exception("Expressions service not available"), null);
                    return true;
                }
                this.command = exps.create(ctx_id, null, expression, new IExpressions.DoneCreate(){

                    public void doneCreate(IToken token, Exception error, IExpressions.Expression context) {
                        TCFNode node = model.getNode(ctx_id);
                        if (node == null) {
                            if (context != null) {
                                IExpressions exps = (IExpressions)channel.getRemoteService(IExpressions.class);
                                exps.dispose(context.getID(), new IExpressions.DoneDispose(){

                                    public void doneDispose(IToken token, Exception error) {
                                        if (error == null) {
                                            return;
                                        }
                                        if (channel.getState() != 1) {
                                            return;
                                        }
                                        Activator.log("Error disposing remote expression evaluator", error);
                                    }
                                });
                            }
                            return;
                        }
                        this.set(token, error, context);
                    }
                });
                return false;
            }

            public void reset() {
                if (this.isValid() && this.getData() != null && this.channel.getState() == 1) {
                    IExpressions exps = (IExpressions)this.channel.getRemoteService(IExpressions.class);
                    exps.dispose(((IExpressions.Expression)TCFMemoryBlock.this.remote_expression.getData()).getID(), new IExpressions.DoneDispose(){

                        public void doneDispose(IToken token, Exception error) {
                            if (error == null) {
                                return;
                            }
                            if (channel.getState() != 1) {
                                return;
                            }
                            Activator.log("Error disposing remote expression evaluator", error);
                        }
                    });
                }
                super.reset();
            }
        };
        this.expression_value = new TCFDataCache<IExpressions.Value>(channel){

            protected boolean startDataRetrieval() {
                if (!TCFMemoryBlock.this.remote_expression.validate((Runnable)((Object)this))) {
                    return false;
                }
                IExpressions.Expression ctx = (IExpressions.Expression)TCFMemoryBlock.this.remote_expression.getData();
                if (ctx == null) {
                    this.set(null, TCFMemoryBlock.this.remote_expression.getError(), null);
                    return true;
                }
                IExpressions exps = (IExpressions)launch.getService(IExpressions.class);
                this.command = exps.evaluate(ctx.getID(), new IExpressions.DoneEvaluate(){

                    public void doneEvaluate(IToken token, Exception error, IExpressions.Value value) {
                        this.set(token, error, value);
                    }
                });
                return false;
            }
        };
    }

    public synchronized void connect(Object client) {
        this.connections.add(client);
    }

    public synchronized void disconnect(Object client) {
        this.connections.remove(client);
    }

    public synchronized Object[] getConnections() {
        return this.connections.toArray(new Object[this.connections.size()]);
    }

    public void dispose() throws DebugException {
        if (this.disposed) {
            return;
        }
        new TCFDebugTask<Boolean>(){

            public void run() {
                if (!TCFMemoryBlock.this.disposed) {
                    TCFMemoryBlock.this.onContextExited(TCFMemoryBlock.this.ctx_id);
                    TCFMemoryBlock.this.expression_value.dispose();
                    TCFMemoryBlock.this.remote_expression.dispose();
                    TCFMemoryBlock.this.disposed = true;
                }
                this.done(Boolean.TRUE);
            }
        }.getD();
    }

    public int getAddressSize() throws DebugException {
        return (Integer)new TCFDebugTask<Integer>(this.model.getChannel()){

            public void run() {
                TCFNode node = TCFMemoryBlock.this.model.getNode(TCFMemoryBlock.this.ctx_id);
                if (node == null) {
                    this.error("Context is disposed");
                } else if (node instanceof TCFNodeExecContext) {
                    TCFDataCache<IMemory.MemoryContext> cache = ((TCFNodeExecContext)node).getMemoryContext();
                    if (!cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    if (cache.getError() != null) {
                        this.error(cache.getError());
                    } else {
                        IMemory.MemoryContext mem = (IMemory.MemoryContext)cache.getData();
                        if (mem == null) {
                            this.error("Context does not provide memory access");
                        } else {
                            this.done(mem.getAddressSize());
                        }
                    }
                } else {
                    this.error("Context does not provide memory access");
                }
            }
        }.getD();
    }

    public int getAddressableSize() throws DebugException {
        return (Integer)new TCFDebugTask<Integer>(this.model.getChannel()){

            public void run() {
                TCFNode node = TCFMemoryBlock.this.model.getNode(TCFMemoryBlock.this.ctx_id);
                if (node == null) {
                    this.error("Context is disposed");
                } else if (node instanceof TCFNodeExecContext) {
                    TCFDataCache<IMemory.MemoryContext> cache = ((TCFNodeExecContext)node).getMemoryContext();
                    if (!cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    if (cache.getError() != null) {
                        this.error(cache.getError());
                    } else {
                        IMemory.MemoryContext mem = (IMemory.MemoryContext)cache.getData();
                        if (mem == null) {
                            this.error("Context does not provide memory access");
                        } else {
                            this.done(mem.getAddressableUnitSize());
                        }
                    }
                } else {
                    this.error("Context does not provide memory access");
                }
            }
        }.getD();
    }

    public BigInteger getBigBaseAddress() throws DebugException {
        return (BigInteger)new TCFDebugTask<BigInteger>(this.model.getChannel()){

            public void run() {
                if (!TCFMemoryBlock.this.expression_value.validate()) {
                    TCFMemoryBlock.this.expression_value.wait((Runnable)((Object)this));
                } else if (TCFMemoryBlock.this.expression_value.getError() != null) {
                    this.error(TCFMemoryBlock.this.expression_value.getError());
                } else if (TCFMemoryBlock.this.expression_value.getData() == null) {
                    this.error("Address expression evaluation failed");
                } else {
                    IExpressions.Value value = (IExpressions.Value)TCFMemoryBlock.this.expression_value.getData();
                    if (value.getTypeClass() == ISymbols.TypeClass.array) {
                        BigInteger addr = JSON.toBigInteger((Number)value.getAddress());
                        if (addr == null) {
                            this.error("Invalid expression: array without memory address");
                        } else {
                            this.done(addr);
                        }
                    } else {
                        byte[] data = value.getValue();
                        if (data == null || data.length == 0) {
                            this.error("Address expression value is empty (void)");
                        } else {
                            boolean signed = value.getTypeClass() == ISymbols.TypeClass.integer;
                            this.done(TCFNumberFormat.toBigInteger(data, value.isBigEndian(), signed));
                        }
                    }
                }
            }
        }.getD();
    }

    public MemoryByte[] getBytesFromAddress(final BigInteger address, final long units) throws DebugException {
        return (MemoryByte[])new TCFDebugTask<MemoryByte[]>(this.model.getChannel()){
            int offs;
            {
                super($anonymous0);
                this.offs = 0;
            }

            public void run() {
                if (TCFMemoryBlock.this.mem_data != null && address.compareTo(((TCFMemoryBlock)TCFMemoryBlock.this).mem_data.addr) >= 0 && address.add(BigInteger.valueOf(units)).compareTo(((TCFMemoryBlock)TCFMemoryBlock.this).mem_data.addr.add(BigInteger.valueOf(((TCFMemoryBlock)TCFMemoryBlock.this).mem_data.data.length))) <= 0) {
                    this.offs = address.subtract(((TCFMemoryBlock)TCFMemoryBlock.this).mem_data.addr).intValue();
                    MemoryByte[] res = ((TCFMemoryBlock)TCFMemoryBlock.this).mem_data.data;
                    if (units < (long)((TCFMemoryBlock)TCFMemoryBlock.this).mem_data.data.length) {
                        res = new MemoryByte[(int)units];
                        System.arraycopy(((TCFMemoryBlock)TCFMemoryBlock.this).mem_data.data, this.offs, res, 0, res.length);
                    }
                    TCFMemoryBlock.this.setHistoryFlags();
                    this.done(res);
                    return;
                }
                TCFNode node = TCFMemoryBlock.this.model.getNode(TCFMemoryBlock.this.ctx_id);
                if (node == null) {
                    this.error("Context is disposed");
                    return;
                }
                if (!(node instanceof TCFNodeExecContext)) {
                    this.error("Context does not provide memory access");
                    return;
                }
                TCFDataCache<IMemory.MemoryContext> cache = ((TCFNodeExecContext)node).getMemoryContext();
                if (!cache.validate((Runnable)((Object)this))) {
                    return;
                }
                if (cache.getError() != null) {
                    this.error(cache.getError());
                    return;
                }
                final IMemory.MemoryContext mem = (IMemory.MemoryContext)cache.getData();
                if (mem == null) {
                    this.error("Context does not provide memory access");
                    return;
                }
                final int size = (int)units;
                final byte[] buf = new byte[size];
                final MemoryByte[] res = new MemoryByte[size];
                mem.get((Number)address, 1, buf, 0, size, 3, new IMemory.DoneMemory(){

                    public void doneMemory(IToken token, IMemory.MemoryError error) {
                        int big_endian = 0;
                        if (mem.getProperties().get("BigEndian") != null) {
                            big_endian |= 0x20;
                            if (mem.isBigEndian()) {
                                big_endian |= 0x10;
                            }
                        }
                        int cnt = 0;
                        while (offs < size) {
                            int flags = big_endian;
                            if (error instanceof IMemory.ErrorOffset) {
                                IMemory.ErrorOffset ofs = (IMemory.ErrorOffset)error;
                                int status = ofs.getStatus(cnt);
                                if (status == 0) {
                                    flags |= 3;
                                } else if ((status & 1) != 0 && cnt > 0) {
                                    break;
                                }
                            } else if (error == null) {
                                flags |= 3;
                            }
                            res[offs] = new MemoryByte(buf[offs], (byte)flags);
                            ++offs;
                            ++cnt;
                        }
                        if (offs < size) {
                            mem.get((Number)address.add(BigInteger.valueOf(offs)), 1, buf, offs, size - offs, 3, (IMemory.DoneMemory)this);
                        } else {
                            TCFMemoryBlock tCFMemoryBlock = TCFMemoryBlock.this;
                            MemData memData = new MemData(address, res);
                            TCFMemoryBlock.this.mem_data = memData;
                            tCFMemoryBlock.mem_last = memData;
                            TCFMemoryBlock.this.setHistoryFlags();
                            this.done(res);
                        }
                    }
                });
            }
        }.getD();
    }

    private void setHistoryFlags() {
        if (this.mem_data == null) {
            return;
        }
        BigInteger addr = this.mem_data.addr;
        BigInteger his_start = null;
        BigInteger his_end = null;
        if (this.mem_prev != null) {
            his_start = this.mem_prev.addr;
            his_end = this.mem_prev.addr.add(BigInteger.valueOf(this.mem_prev.data.length));
        }
        MemoryByte[] memoryByteArray = this.mem_data.data;
        int n = this.mem_data.data.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryByte b = memoryByteArray[n2];
            int flags = b.getFlags();
            if (this.mem_prev != null && addr.compareTo(his_start) >= 0 && addr.compareTo(his_end) < 0) {
                flags |= 8;
                int offs = addr.subtract(his_start).intValue();
                if (b.getValue() != this.mem_prev.data[offs].getValue()) {
                    flags |= 4;
                }
            } else {
                flags &= 0xFFFFFFF3;
            }
            b.setFlags((byte)flags);
            addr = addr.add(BigInteger.valueOf(1L));
            ++n2;
        }
    }

    public MemoryByte[] getBytesFromOffset(BigInteger offset, long units) throws DebugException {
        return this.getBytesFromAddress(this.getBigBaseAddress().add(offset), units);
    }

    public String getExpression() {
        return this.expression;
    }

    public IMemoryBlockRetrieval getMemoryBlockRetrieval() {
        return this.block_retrieval;
    }

    public long getStartAddress() {
        return 0L;
    }

    public long getLength() {
        return this.length;
    }

    public BigInteger getMemoryBlockStartAddress() throws DebugException {
        return null;
    }

    public BigInteger getMemoryBlockEndAddress() throws DebugException {
        return null;
    }

    public BigInteger getBigLength() throws DebugException {
        return BigInteger.valueOf(this.length);
    }

    public void setBaseAddress(BigInteger address) throws DebugException {
    }

    public void setValue(BigInteger offset, final byte[] bytes) throws DebugException {
        final BigInteger address = this.getBigBaseAddress().add(offset);
        new TCFDebugTask<Object>(this.model.getChannel()){

            public void run() {
                TCFNode node = TCFMemoryBlock.this.model.getNode(TCFMemoryBlock.this.ctx_id);
                if (node == null) {
                    this.error("Context is disposed");
                    return;
                }
                if (!(node instanceof TCFNodeExecContext)) {
                    this.error("Context does not provide memory access");
                    return;
                }
                TCFDataCache<IMemory.MemoryContext> cache = ((TCFNodeExecContext)node).getMemoryContext();
                if (!cache.validate((Runnable)((Object)this))) {
                    return;
                }
                if (cache.getError() != null) {
                    this.error(cache.getError());
                    return;
                }
                IMemory.MemoryContext mem = (IMemory.MemoryContext)cache.getData();
                if (mem == null) {
                    this.error("Context does not provide memory access");
                    return;
                }
                mem.set((Number)address, 1, bytes, 0, bytes.length, 3, new IMemory.DoneMemory(){

                    public void doneMemory(IToken token, IMemory.MemoryError error) {
                        if (error != null) {
                            this.error((Throwable)error);
                        } else {
                            this.done(null);
                        }
                    }
                });
            }
        }.getD();
    }

    public boolean supportBaseAddressModification() throws DebugException {
        return false;
    }

    public boolean supportsChangeManagement() {
        return true;
    }

    public byte[] getBytes() throws DebugException {
        if (this.mem_data == null) {
            return null;
        }
        return this.mem_data.bytes;
    }

    public void setValue(long offset, byte[] bytes) throws DebugException {
        this.setValue(BigInteger.valueOf(offset), bytes);
    }

    public boolean supportsValueModification() {
        return true;
    }

    public IDebugTarget getDebugTarget() {
        return null;
    }

    public ILaunch getLaunch() {
        return this.model.getLaunch();
    }

    public String getModelIdentifier() {
        return "org.eclipse.tcf.debug";
    }

    public IModelProxy createModelProxy(Object element, IPresentationContext context) {
        assert (element == this);
        return new ModelProxy(this, context.getWindow().getShell().getDisplay());
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IMemoryBlockRetrieval.class) {
            return this.block_retrieval;
        }
        if (adapter == IMemoryBlockRetrievalExtension.class) {
            return this.block_retrieval;
        }
        return super.getAdapter(adapter);
    }

    String getMemoryID() {
        return this.ctx_id;
    }

    void flushAllCaches() {
        this.mem_data = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMemoryChanged(boolean suspended) {
        assert (Protocol.isDispatchThread());
        this.remote_expression.reset();
        this.expression_value.reset();
        if (suspended) {
            this.mem_prev = this.mem_last;
        }
        this.mem_data = null;
        LinkedList<ModelProxy> linkedList = this.model_proxies;
        synchronized (linkedList) {
            for (ModelProxy p : this.model_proxies) {
                p.onMemoryChanged(suspended);
            }
        }
    }

    void onContextExited(String id) {
        assert (Protocol.isDispatchThread());
        if (!id.equals(this.ctx_id)) {
            return;
        }
        this.remote_expression.reset();
        this.expression_value.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void asyncExec(TCFModel model, Runnable r) {
        Set<Runnable> set = pending_updates;
        synchronized (set) {
            Class<Device> clazz = Device.class;
            synchronized (Device.class) {
                if (display.isDisposed()) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                display.asyncExec(r);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                pending_updates.add(r);
            }
        }
    }

    private static Node cloneXML(Document document, Node node) {
        if (node instanceof Element) {
            Element x = (Element)node;
            Element y = document.createElement(x.getTagName());
            NamedNodeMap attrs = x.getAttributes();
            int l = attrs.getLength();
            int i = 0;
            while (i < l) {
                Attr a = (Attr)attrs.item(i);
                y.setAttribute(a.getName(), a.getValue());
                ++i;
            }
            Node c = x.getFirstChild();
            while (c != null) {
                Node d = TCFMemoryBlock.cloneXML(document, c);
                if (d != null) {
                    y.appendChild(d);
                }
                c = c.getNextSibling();
            }
            return y;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onModelCreated(TCFModel model) {
        assert (Protocol.isDispatchThread());
        if (memento_loaded) {
            return;
        }
        memento_loaded = true;
        try {
            Map<String, List<Element>> map = blocks_memento;
            synchronized (map) {
                blocks_memento.clear();
                IPath path = Activator.getDefault().getStateLocation();
                File f = path.append(XML_FILE_NAME).toFile();
                if (!f.exists()) {
                    return;
                }
                FileInputStream inp = new FileInputStream(f);
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                Element xml_memory = parser.parse(inp).getDocumentElement();
                if (xml_memory.getTagName().equals(XML_NODE_MEMORY)) {
                    Node node = xml_memory.getFirstChild();
                    while (node != null) {
                        Element xml_block;
                        String id;
                        if (node instanceof Element && ((Element)node).getTagName().equals(XML_NODE_BLOCK) && (id = (xml_block = (Element)node).getAttribute(XML_ATTR_CTX)) != null) {
                            List<Element> list = blocks_memento.get(id);
                            if (list == null) {
                                list = new ArrayList<Element>();
                                blocks_memento.put(id, list);
                            }
                            list.add(xml_block);
                        }
                        node = node.getNextSibling();
                    }
                }
                ((InputStream)inp).close();
            }
        }
        catch (Exception x) {
            Activator.log("Cannot read memory monitors memento", x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onMemoryNodeCreated(TCFNodeExecContext exe_ctx) {
        assert (Protocol.isDispatchThread());
        Map<String, List<Element>> map = blocks_memento;
        synchronized (map) {
            final List<Element> memento = blocks_memento.remove(exe_ctx.id);
            if (memento == null || memento.size() == 0) {
                return;
            }
            ArrayList<TCFMemoryBlock> list = new ArrayList<TCFMemoryBlock>();
            for (Element xml_block : memento) {
                String expr = xml_block.getAttribute(XML_ATTR_ADDR);
                long length = Long.parseLong(xml_block.getAttribute(XML_ATTR_SIZE));
                list.add(exe_ctx.model.getMemoryBlock(exe_ctx.id, expr, length));
            }
            final IMemoryBlock[] blks = list.toArray(new IMemoryBlock[list.size()]);
            TCFMemoryBlock.asyncExec(exe_ctx.model, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Set set = pending_updates;
                    synchronized (set) {
                        pending_updates.remove(this);
                    }
                    try {
                        int i = 0;
                        DebugPlugin.getDefault().getMemoryBlockManager().addMemoryBlocks(blks);
                        IMemoryRenderingManager rmngr = DebugUITools.getMemoryRenderingManager();
                        for (Element xml_block : memento) {
                            IMemoryBlock mb = blks[i++];
                            Node node = xml_block.getFirstChild();
                            while (node != null) {
                                if (node instanceof Element && ((Element)node).getTagName().equals(TCFMemoryBlock.XML_NODE_RENDERING)) {
                                    Element xml_rendering = (Element)node;
                                    String view_id = xml_rendering.getAttribute(TCFMemoryBlock.XML_ATTR_VIEW);
                                    if (view_id != null && view_id.length() == 0) {
                                        view_id = null;
                                    }
                                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                    IMemoryRenderingSite part = (IMemoryRenderingSite)page.showView("org.eclipse.debug.ui.MemoryView", view_id, 3);
                                    IMemoryRenderingType rendering_type = rmngr.getRenderingType(xml_rendering.getAttribute(TCFMemoryBlock.XML_ATTR_ID));
                                    IMemoryRendering rendering = rendering_type.createRendering();
                                    IMemoryRenderingContainer container = part.getContainer(xml_rendering.getAttribute(TCFMemoryBlock.XML_ATTR_PANE));
                                    rendering.init(container, mb);
                                    container.addMemoryRendering(rendering);
                                }
                                node = node.getNextSibling();
                            }
                        }
                    }
                    catch (Exception x) {
                        Activator.log("Cannot restore memory monitors", x);
                    }
                }
            });
        }
    }

    static void onModelDisconnected(final TCFModel model) {
        assert (Protocol.isDispatchThread());
        TCFMemoryBlock.asyncExec(model, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = pending_updates;
                synchronized (set) {
                    pending_updates.remove(this);
                }
                ArrayList<TCFMemoryBlock> block_list = new ArrayList<TCFMemoryBlock>();
                IMemoryBlockManager manager = DebugPlugin.getDefault().getMemoryBlockManager();
                try {
                    Document document = DebugPlugin.newDocument();
                    HashMap<String, ArrayList<Element>> memento = new HashMap<String, ArrayList<Element>>();
                    HashMap<TCFMemoryBlock, Element> mb_to_xml = new HashMap<TCFMemoryBlock, Element>();
                    Element xml_memory = document.createElement(TCFMemoryBlock.XML_NODE_MEMORY);
                    IMemoryBlock[] iMemoryBlockArray = manager.getMemoryBlocks();
                    int n = iMemoryBlockArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TCFMemoryBlock m;
                        IMemoryBlock mb = iMemoryBlockArray[n2];
                        if (mb instanceof TCFMemoryBlock && (m = (TCFMemoryBlock)mb).model == model) {
                            Element xml_block = document.createElement(TCFMemoryBlock.XML_NODE_BLOCK);
                            xml_block.setAttribute(TCFMemoryBlock.XML_ATTR_CTX, m.ctx_id);
                            xml_block.setAttribute(TCFMemoryBlock.XML_ATTR_ADDR, m.expression);
                            xml_block.setAttribute(TCFMemoryBlock.XML_ATTR_SIZE, Long.toString(m.length));
                            xml_memory.appendChild(xml_block);
                            mb_to_xml.put(m, xml_block);
                            ArrayList<Element> l = (ArrayList<Element>)memento.get(m.ctx_id);
                            if (l == null) {
                                l = new ArrayList<Element>();
                                memento.put(m.ctx_id, l);
                            }
                            l.add(xml_block);
                            block_list.add(m);
                        }
                        ++n2;
                    }
                    iMemoryBlockArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                    n = iMemoryBlockArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        IMemoryBlock window = iMemoryBlockArray[n2];
                        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                        int n3 = iWorkbenchPageArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IWorkbenchPage page = iWorkbenchPageArray[n4];
                            String[] pane_ids = new String[]{"org.eclipse.debug.ui.MemoryView.RenderingViewPane.1", "org.eclipse.debug.ui.MemoryView.RenderingViewPane.2"};
                            IViewReference[] iViewReferenceArray = page.getViewReferences();
                            int n5 = iViewReferenceArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IViewReference ref = iViewReferenceArray[n6];
                                IViewPart part = ref.getView(false);
                                if (part instanceof IMemoryRenderingSite) {
                                    IMemoryRenderingSite memory_view = (IMemoryRenderingSite)part;
                                    String[] stringArray = pane_ids;
                                    int n7 = pane_ids.length;
                                    int n8 = 0;
                                    while (n8 < n7) {
                                        IMemoryRendering[] renderings;
                                        String pane_id = stringArray[n8];
                                        IMemoryRenderingContainer container = memory_view.getContainer(pane_id);
                                        IMemoryRendering[] iMemoryRenderingArray = renderings = container.getRenderings();
                                        int n9 = renderings.length;
                                        int n10 = 0;
                                        while (n10 < n9) {
                                            IMemoryRendering rendering = iMemoryRenderingArray[n10];
                                            Element xml_block = (Element)mb_to_xml.get(rendering.getMemoryBlock());
                                            if (xml_block != null) {
                                                Element xml_rendering = document.createElement(TCFMemoryBlock.XML_NODE_RENDERING);
                                                xml_rendering.setAttribute(TCFMemoryBlock.XML_ATTR_ID, rendering.getRenderingId());
                                                if (ref.getSecondaryId() != null) {
                                                    xml_rendering.setAttribute(TCFMemoryBlock.XML_ATTR_VIEW, ref.getSecondaryId());
                                                }
                                                xml_rendering.setAttribute(TCFMemoryBlock.XML_ATTR_PANE, pane_id);
                                                xml_block.appendChild(xml_rendering);
                                            }
                                            ++n10;
                                        }
                                        ++n8;
                                    }
                                }
                                ++n6;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    Map map = blocks_memento;
                    synchronized (map) {
                        for (String id : blocks_memento.keySet()) {
                            if (memento.containsKey(id)) continue;
                            for (Element xml_block : (List)blocks_memento.get(id)) {
                                xml_memory.appendChild(TCFMemoryBlock.cloneXML(document, xml_block));
                            }
                        }
                        blocks_memento.clear();
                        Node node = xml_memory.getFirstChild();
                        while (node != null) {
                            Element xml_block;
                            String id;
                            if (node instanceof Element && ((Element)node).getTagName().equals(TCFMemoryBlock.XML_NODE_BLOCK) && (id = (xml_block = (Element)node).getAttribute(TCFMemoryBlock.XML_ATTR_CTX)) != null) {
                                ArrayList<Element> l = (ArrayList<Element>)blocks_memento.get(id);
                                if (l == null) {
                                    l = new ArrayList<Element>();
                                    blocks_memento.put(id, l);
                                }
                                l.add(xml_block);
                            }
                            node = node.getNextSibling();
                        }
                        document.appendChild(xml_memory);
                        IPath path = Activator.getDefault().getStateLocation();
                        File f = path.append(TCFMemoryBlock.XML_FILE_NAME).toFile();
                        BufferedWriter wr = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
                        wr.write(DebugPlugin.serializeDocument((Document)document));
                        wr.close();
                    }
                }
                catch (Exception x) {
                    Activator.log("Cannot save memory monitors", x);
                }
                if (block_list.size() != 0) {
                    manager.removeMemoryBlocks(block_list.toArray(new IMemoryBlock[block_list.size()]));
                }
            }
        });
    }

    static void onWorkbenchShutdown() {
        display.syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    Set set = pending_updates;
                    synchronized (set) {
                        if (pending_updates.size() == 0) {
                            return;
                        }
                    }
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
    }

    private static class MemData {
        final BigInteger addr;
        final MemoryByte[] data;
        final byte[] bytes;

        MemData(BigInteger addr, MemoryByte[] data) {
            int i = 0;
            this.addr = addr;
            this.data = data;
            this.bytes = new byte[data.length];
            MemoryByte[] memoryByteArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                MemoryByte b = memoryByteArray[n2];
                this.bytes[i++] = b.getValue();
                ++n2;
            }
        }
    }

    private static class ModelProxy
    extends AbstractModelProxy
    implements Runnable {
        final TCFMemoryBlock mem_block;
        final Display display;
        ModelDelta delta;

        public ModelProxy(TCFMemoryBlock mem_block, Display display) {
            this.mem_block = mem_block;
            this.display = display;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void installed(Viewer viewer) {
            LinkedList linkedList = this.mem_block.model_proxies;
            synchronized (linkedList) {
                if (this.isDisposed()) {
                    return;
                }
                this.setInstalled(true);
                super.installed(viewer);
                this.mem_block.model_proxies.add(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            LinkedList linkedList = this.mem_block.model_proxies;
            synchronized (linkedList) {
                if (this.isDisposed()) {
                    return;
                }
                this.mem_block.model_proxies.remove(this);
                super.dispose();
            }
        }

        void onMemoryChanged(boolean suspended) {
            assert (Protocol.isDispatchThread());
            int flags = 1024;
            if (suspended) {
                flags |= 0x800;
            }
            if (this.delta != null) {
                this.delta.setFlags(this.delta.getFlags() | flags);
            } else {
                this.delta = new ModelDelta((Object)this.mem_block, flags);
                Protocol.invokeLater((Runnable)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            assert (Protocol.isDispatchThread());
            final ModelDelta d = this.delta;
            this.delta = null;
            Class<Device> clazz = Device.class;
            synchronized (Device.class) {
                if (!this.display.isDisposed()) {
                    this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ModelProxy.this.fireModelChanged((IModelDelta)d);
                        }
                    });
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

