/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.navigator;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.ISimulatorService;
import org.eclipse.tcf.te.runtime.services.interfaces.delegates.ILabelProviderDelegate;
import org.eclipse.tcf.te.runtime.utils.net.IPAddressUtil;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelLookupService;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.locator.utils.CommonUtils;
import org.eclipse.tcf.te.tcf.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.ui.navigator.images.PeerNodeImageDescriptor;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.tables.properties.NodePropertiesTableTableNode;
import org.eclipse.ui.navigator.IDescriptionProvider;

public class PeerLabelProviderDelegate
extends LabelProvider
implements ILabelDecorator,
ILabelProviderDelegate,
IDescriptionProvider {
    public String getText(final Object element) {
        if (element instanceof IPeerNode || element instanceof IPeer) {
            String label;
            StringBuilder builder = new StringBuilder();
            final HashMap attrs = new HashMap();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (element instanceof IPeerNode) {
                        attrs.putAll(((IPeerNode)element).getProperties());
                        attrs.putAll(((IPeerNode)element).getPeer().getAttributes());
                    } else if (element instanceof IPeer) {
                        attrs.putAll(((IPeer)element).getAttributes());
                    }
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            builder.append((String)attrs.get("Name"));
            if (this.isAppendAddressText(builder.toString())) {
                String dnsName = (String)attrs.get("dns.name.transient");
                String ip = (String)attrs.get("Host");
                String port = (String)attrs.get("Port");
                if (ip != null && !"".equals(ip.trim())) {
                    builder.append(" ");
                    if (!IPAddressUtil.getInstance().isLocalHost(ip)) {
                        builder.append(dnsName != null && !"".equals(dnsName.trim()) ? dnsName.trim() : ip.trim());
                    }
                    if (port != null && !"".equals(port.trim()) && !"1534".equals(port.trim())) {
                        builder.append(":");
                        builder.append(port.trim());
                    }
                }
            }
            if (!"".equals((label = builder.toString()).trim())) {
                return label;
            }
        } else {
            if (element instanceof ILocatorNode) {
                String name = ((ILocatorNode)element).getName();
                if (name == null) {
                    name = ((ILocatorNode)element).getPeer().getID();
                }
                return name;
            }
            if (element instanceof IModelNode) {
                return ((IModelNode)element).getName();
            }
            if (element instanceof NodePropertiesTableTableNode) {
                NodePropertiesTableTableNode node = (NodePropertiesTableTableNode)element;
                if ("SimulatorType".equals(node.name)) {
                    ISimulatorService service = (ISimulatorService)ServiceManager.getInstance().getService(node.value, ISimulatorService.class, false);
                    if (service != null) {
                        return service.getName();
                    }
                    return node.value;
                }
                String key = "PeerLabelProviderDelegate_NodePropertiesTable_" + node.name.trim() + "_" + node.value.replaceAll("\\.", "_");
                if (Messages.hasString(key)) {
                    return Messages.getString(key);
                }
            }
        }
        return null;
    }

    public String getDescription(Object element) {
        if (element instanceof IPeerNode) {
            IPeerNode peerNode = (IPeerNode)element;
            if (!peerNode.isValid()) {
                String error = CommonUtils.getPeerError((IPeerNode)peerNode);
                if (error != null) {
                    return error;
                }
                return Messages.PeerLabelProviderDelegate_description_invalid;
            }
            Map warnings = CommonUtils.getPeerWarnings((IPeerNode)peerNode);
            if (warnings != null && !warnings.isEmpty()) {
                String desc = "";
                for (String warning : warnings.values()) {
                    if (desc.trim().length() > 0) {
                        desc = String.valueOf(desc) + "; ";
                    }
                    desc = String.valueOf(desc) + warning.replaceAll("\n", "").replaceAll("\t", "");
                }
                return desc;
            }
        }
        return null;
    }

    protected boolean isAppendAddressText(final String label) {
        boolean append;
        Assert.isNotNull((Object)label);
        boolean bl = append = "TCF Agent".equals(label) || "TCF Proxy".equals(label);
        if (!append) {
            final AtomicInteger count = new AtomicInteger();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    count.set(((IPeerModelLookupService)ModelManager.getPeerModel().getService(IPeerModelLookupService.class)).lkupPeerModelByName(label).length);
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            append = count.get() > 1;
        }
        return append;
    }

    public Image getImage(Object element) {
        if (element instanceof IPeerNode) {
            return UIPlugin.getImage("ConnectionObject");
        }
        if (element instanceof ILocatorNode) {
            if (((ILocatorNode)element).isDiscovered()) {
                return UIPlugin.getImage("PeerObjectDiscovered");
            }
            return UIPlugin.getImage("PeerObjectStatic");
        }
        if (element instanceof IModelNode) {
            return UIPlugin.getImage(((IModelNode)element).getImageId());
        }
        return super.getImage(element);
    }

    public Image decorateImage(Image image, Object element) {
        Image decoratedImage = image;
        if (image != null && element instanceof IPeerNode) {
            PeerNodeImageDescriptor descriptor = new PeerNodeImageDescriptor(UIPlugin.getDefault().getImageRegistry(), image, (IPeerNode)element);
            decoratedImage = UIPlugin.getSharedImage(descriptor);
        }
        return decoratedImage;
    }

    public String decorateText(String text, Object element) {
        if (element instanceof ILocatorNode) {
            String ip = (String)((ILocatorNode)element).getPeer().getAttributes().get("Host");
            String port = (String)((ILocatorNode)element).getPeer().getAttributes().get("Port");
            port = port == null || port.trim().equals("1534") ? "" : ":" + port.trim();
            if (text != null && ip != null && !text.contains(ip)) {
                text = String.valueOf(text) + " (" + ip + port + ")";
                return text;
            }
        }
        return null;
    }
}

