/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.export.menu.vector;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisSet;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.export.core.AbstractSeriesExportHandler;
import org.eclipse.swtchart.export.core.AxisSettings;
import org.eclipse.swtchart.export.core.ExportSettingsDialog;
import org.eclipse.swtchart.export.core.ISeriesExportConverter;
import org.eclipse.swtchart.export.menu.vector.Messages;
import org.eclipse.swtchart.extensions.barcharts.BarChart;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ChartType;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.core.ISecondaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.linecharts.LineChart;
import org.eclipse.swtchart.extensions.scattercharts.ScatterChart;

public class SVGExportHandler
extends AbstractSeriesExportHandler
implements ISeriesExportConverter {
    private static final String FILE_EXTENSION = "*.svg";
    private static final String NAME = String.valueOf(Messages.getString("SVG")) + "*.svg" + ")";
    private static final String TITLE = Messages.getString("SAVE_AS_SVG");
    private static final String AXIS_X = "x";
    private static final String AXIS_Y = "y";

    public String getName() {
        return NAME;
    }

    public void execute(final Shell shell, final ScrollableChart scrollableChart) {
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setOverwrite(true);
        fileDialog.setText(NAME);
        fileDialog.setFilterExtensions(new String[]{FILE_EXTENSION});
        final String fileName = fileDialog.open();
        if (fileName != null) {
            try {
                final BaseChart baseChart = scrollableChart.getBaseChart();
                final ExportSettingsDialog exportSettingsDialog = new ExportSettingsDialog(fileDialog.getParent(), baseChart);
                exportSettingsDialog.create();
                if (exportSettingsDialog.open() == 0) {
                    final int indexAxisX = exportSettingsDialog.getIndexAxisSelectionX();
                    final int indexAxisY = exportSettingsDialog.getIndexAxisSelectionY();
                    if (indexAxisX >= 0 && indexAxisY >= 0) {
                        try {
                            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(fileDialog.getParent());
                            monitorDialog.run(false, false, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    try {
                                        try {
                                            monitor.beginTask(Messages.getString("EXPORT_TO_SVG"), -1);
                                            IAxisSettings axisSettingsX = baseChart.getXAxisSettings(indexAxisX);
                                            IAxisScaleConverter axisScaleConverterX = null;
                                            if (axisSettingsX instanceof ISecondaryAxisSettings) {
                                                ISecondaryAxisSettings secondaryAxisSettings = (ISecondaryAxisSettings)axisSettingsX;
                                                axisScaleConverterX = secondaryAxisSettings.getAxisScaleConverter();
                                            }
                                            IAxisSettings axisSettingsY = baseChart.getYAxisSettings(indexAxisY);
                                            IAxisScaleConverter axisScaleConverterY = null;
                                            if (axisSettingsY instanceof ISecondaryAxisSettings) {
                                                ISecondaryAxisSettings secondaryAxisSettings = (ISecondaryAxisSettings)axisSettingsY;
                                                axisScaleConverterY = secondaryAxisSettings.getAxisScaleConverter();
                                            }
                                            PrintWriter printWriter = null;
                                            try {
                                                try {
                                                    printWriter = new PrintWriter(new File(fileName));
                                                    AxisSettings axisSettings = new AxisSettings();
                                                    axisSettings.setIndexAxisX(indexAxisX);
                                                    axisSettings.setIndexAxisY(indexAxisY);
                                                    axisSettings.setAxisSettingsX(axisSettingsX);
                                                    axisSettings.setAxisScaleConverterX(axisScaleConverterX);
                                                    axisSettings.setAxisSettingsY(axisSettingsY);
                                                    axisSettings.setAxisScaleConverterY(axisScaleConverterY);
                                                    if (scrollableChart instanceof LineChart) {
                                                        SVGExportHandler.this.printLinePlot(fileName, printWriter, scrollableChart, axisSettings);
                                                    } else if (scrollableChart instanceof BarChart) {
                                                        SVGExportHandler.this.printBarPlot(fileName, printWriter, scrollableChart, axisSettings);
                                                    } else if (scrollableChart instanceof ScatterChart) {
                                                        SVGExportHandler.this.printScatterPlot(fileName, printWriter, scrollableChart, axisSettings);
                                                    } else {
                                                        ChartType chartType = scrollableChart.getChartType();
                                                        switch (chartType) {
                                                            case LINE: 
                                                            case STEP: {
                                                                SVGExportHandler.this.printLinePlot(fileName, printWriter, scrollableChart, axisSettings);
                                                                break;
                                                            }
                                                            case BAR: {
                                                                SVGExportHandler.this.printBarPlot(fileName, printWriter, scrollableChart, axisSettings);
                                                                break;
                                                            }
                                                            case SCATTER: {
                                                                SVGExportHandler.this.printScatterPlot(fileName, printWriter, scrollableChart, axisSettings);
                                                                break;
                                                            }
                                                            default: {
                                                                System.out.println("The chart type export is not supported: " + chartType);
                                                            }
                                                        }
                                                    }
                                                    MessageDialog.openInformation((Shell)shell, (String)TITLE, (String)MESSAGE_OK);
                                                }
                                                catch (FileNotFoundException e) {
                                                    MessageDialog.openError((Shell)shell, (String)TITLE, (String)MESSAGE_ERROR);
                                                    System.out.println(e);
                                                    if (printWriter != null) {
                                                        printWriter.flush();
                                                        printWriter.close();
                                                    }
                                                }
                                            }
                                            finally {
                                                if (printWriter != null) {
                                                    printWriter.flush();
                                                    printWriter.close();
                                                }
                                            }
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            monitor.done();
                                            exportSettingsDialog.reset(baseChart);
                                        }
                                    }
                                    finally {
                                        monitor.done();
                                        exportSettingsDialog.reset(baseChart);
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception e) {
                MessageDialog.openInformation((Shell)shell, (String)TITLE, (String)MESSAGE_ERROR);
                e.printStackTrace();
            }
        }
    }

    private String getColor(Color color) {
        double[] rgb;
        StringBuilder hex_color = new StringBuilder("#");
        double r = color.getRed();
        double g = color.getGreen();
        double b = color.getBlue();
        double[] dArray = rgb = new double[]{r, g, b};
        int n = rgb.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            double hex = 16.0;
            double div = x / hex;
            int count = (int)div;
            double rem = div - (double)count;
            rem = (int)(rem * hex);
            char first = count >= 10 ? (char)(97 + (count - 10)) : (char)(48 + count);
            char second = rem >= 10.0 ? (char)(97.0 + (rem - 10.0)) : (char)(48.0 + rem);
            hex_color.append(first);
            hex_color.append(second);
            ++n2;
        }
        return hex_color.toString();
    }

    private void printLinePlot(String fileName, PrintWriter printWriter, ScrollableChart scrollableChart, AxisSettings axisSettings) throws Exception {
        IAxisSettings axisSettingsX = axisSettings.getAxisSettingsX();
        IAxisSettings axisSettingsY = axisSettings.getAxisSettingsY();
        boolean isReversedX = axisSettingsX.isReversed();
        boolean isReversedY = axisSettingsY.isReversed();
        DecimalFormat formatX = axisSettingsX.getDecimalFormat();
        DecimalFormat formatY = axisSettingsY.getDecimalFormat();
        BaseChart baseChart = scrollableChart.getBaseChart();
        boolean isShowAxisZeroMarker = baseChart.getChartSettings().isShowAxisZeroMarker();
        ISeries[] series = baseChart.getSeriesSet().getSeries();
        String Template = "Template_LineChart.svg";
        try {
            Throwable throwable = null;
            Object var16_18 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(Template)));){
                String line;
                double[] xTicks = baseChart.getAxisSet().getXAxis(axisSettings.getIndexAxisX()).getTick().getTickLabelValues();
                double[] yTicks = baseChart.getAxisSet().getYAxis(axisSettings.getIndexAxisY()).getTick().getTickLabelValues();
                StringBuilder tickX = new StringBuilder("<path\n                       inkscape:connector-curvature=\"0\"\n                       id=\"path888\"\n                       d=\"m %x-coordinate%,279.77439 v 5.05309\"\n                       style=\"fill:none;stroke:#000000;stroke-width:0.26458332px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" />\n                    <text\n\t\t       id=\"text892\"\n                       y=\"289.01782\"\n                       x=\"%x-coordinate%\"\n                       style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:6.3499999px;line-height:1.25;font-family:arial;-inkscape-font-specification:arial;letter-spacing:0px;word-spacing:0px;fill:#000000;fill-opacity:1;stroke:none;stroke-width:0.26458332\"\n                       xml:space=\"preserve\"><tspan\n                         id=\"tspan890\"\n                         style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:3.52777767px;font-family:arial;-inkscape-font-specification:arial;text-align:center;text-anchor:middle;stroke-width:0.26458332\"\n                         y=\"289.01782\"\n                         x=\"%x-coordinate%\"\n                         sodipodi:role=\"line\">%X01%</tspan></text>");
                StringBuilder tickY = new StringBuilder("<path\n                       inkscape:connector-curvature=\"0\"\n                       id=\"path1299\"\n                       d=\"m 15.387913,%y-coordinate% h 5.05309\"\n                       style=\"fill:none;stroke:#000000;stroke-width:0.26458332px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" />\n                    <text\n                       xml:space=\"preserve\"\n                       style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:6.3499999px;line-height:1.25;font-family:arial;-inkscape-font-specification:arial;letter-spacing:0px;word-spacing:0px;fill:#000000;fill-opacity:1;stroke:none;stroke-width:0.26458332\"\n                       x=\"14.211229\"\n                       y=\"%y-coordinate%\"\n                       id=\"text1303\"><tspan\n                         sodipodi:role=\"line\"\n                         id=\"tspan1301\"\n                         x=\"14.211229\"\n                         y=\"%y-coordinate%\"\n                         style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:3.52777767px;font-family:arial;-inkscape-font-specification:arial;text-align:end;text-anchor:end;stroke-width:0.26458332\">%Y01%</tspan></text>");
                StringBuilder legend = new StringBuilder("<path\n                   style=\"fill:url(#linearGradient3662);fill-opacity:1;stroke:%COLOR%;stroke-width:0.5;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1\"\n                   d=\"m 209.71446,%y1-coordinate% h 20.93268\"\n                   id=\"path1744\"\n                   inkscape:connector-curvature=\"0\" />\n                <text\n                   xml:space=\"preserve\"\n                   style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:6.3499999px;line-height:1.25;font-family:'Bold Oblique';-inkscape-font-specification:'Bold Oblique, ';letter-spacing:0px;word-spacing:0px;fill:url(#linearGradient4353);fill-opacity:1;stroke:none;stroke-width:0.26458332\"\n                   x=\"230.91121\"\n                   y=\"%y2-coordinate%\"\n                   id=\"text1748\"><tspan\n                     sodipodi:role=\"line\"\n                     id=\"tspan1746\"\n                     x=\"230.91121\"\n                     y=\"%y2-coordinate%\"\n                     style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:4.23333311px;font-family:Arial;-inkscape-font-specification:Arial;fill:url(#linearGradient4353);fill-opacity:1;stroke-width:0.26458332\">%SERIES A%</tspan></text>");
                StringBuilder axisLabel = new StringBuilder("<path\n         style=\"fill:none;stroke:#000000;stroke-width:0.26499999;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1;stroke-miterlimit:4;stroke-dasharray:0.52999998,0.52999998;stroke-dashoffset:0;opacity:1\"\n         d=\"M %x1-coordinate%,%y1-coordinate% L %x2-coordinate%,%y2-coordinate%\"\n         id=\"path850\"\n         inkscape:connector-curvature=\"0\" />");
                String regexX = ".*%X-AXIS_TICKS%.*";
                String regexY = ".*%Y-AXIS_TICKS%.*";
                String titleX = ".*%PLACEHOLDER X-AXIS%.*";
                String titleY = ".*%PLACEHOLDER Y-AXIS%.*";
                String data_series = ".*%DATA SERIES%.*";
                String regex_legend = ".*%LEGEND%.*";
                String axis_label = ".*%AXIS LABELS%.*";
                while ((line = in.readLine()) != null) {
                    int n;
                    String[] stringArray;
                    String[] split;
                    if (Pattern.matches(regexX, line)) {
                        int ticklabel_size = xTicks.length;
                        double start = 20.306;
                        double height = 286.91;
                        StringBuilder out = new StringBuilder("");
                        double upper = baseChart.getAxisSet().getXAxis((int)axisSettings.getIndexAxisX()).getRange().upper;
                        double lower = baseChart.getAxisSet().getXAxis((int)axisSettings.getIndexAxisX()).getRange().lower;
                        int count = 0;
                        while (count < ticklabel_size) {
                            split = tickX.toString().split("\\n");
                            String match1 = ".*%x-coordinate%.*";
                            String match2 = ".*%X01%.*";
                            double x = !isReversedX ? start + (xTicks[count] - lower) / (upper - lower) * height : start + height - (xTicks[count] - lower) / (upper - lower) * height;
                            stringArray = split;
                            int n2 = split.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                String string = stringArray[n3];
                                if (Pattern.matches(match1, string)) {
                                    string = string.replace("%x-coordinate%", String.valueOf(x));
                                } else if (Pattern.matches(match2, string)) {
                                    string = string.replace("%X01%", String.valueOf(formatX.format(xTicks[count])));
                                }
                                out.append(string);
                                out.append("\n");
                                ++n3;
                            }
                            out.append("\n");
                            ++count;
                        }
                        line = line.replaceAll(regexX, out.toString());
                    } else if (Pattern.matches(regexY, line)) {
                        int ticklabel_size = yTicks.length;
                        double start = 279.90709;
                        double height = 200.0;
                        StringBuilder out = new StringBuilder("");
                        double upper = baseChart.getAxisSet().getYAxis((int)axisSettings.getIndexAxisY()).getRange().upper;
                        double lower = baseChart.getAxisSet().getYAxis((int)axisSettings.getIndexAxisY()).getRange().lower;
                        int count = 0;
                        while (count < ticklabel_size) {
                            split = tickY.toString().split("\\n");
                            String match1 = ".*%y-coordinate%.*";
                            String match2 = ".*%Y01%.*";
                            double y = !isReversedY ? start - (height - (upper - yTicks[count]) / (upper - lower) * height) : start - height + (height - (upper - yTicks[count]) / (upper - lower) * height);
                            stringArray = split;
                            int n4 = split.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                String string = stringArray[n5];
                                if (Pattern.matches(match1, string)) {
                                    string = string.replace("%y-coordinate%", String.valueOf(y));
                                } else if (Pattern.matches(match2, string)) {
                                    string = string.replace("%Y01%", String.valueOf(formatY.format(yTicks[count])));
                                }
                                out.append(string);
                                out.append("\n");
                                ++n5;
                            }
                            out.append("\n");
                            ++count;
                        }
                        line = line.replaceAll(regexY, out.toString());
                    } else if (Pattern.matches(titleX, line)) {
                        line = line.replace("%PLACEHOLDER X-AXIS%", axisSettingsX.getTitle());
                    } else if (Pattern.matches(titleY, line)) {
                        line = line.replace("%PLACEHOLDER Y-AXIS%", axisSettingsY.getTitle());
                    } else if (Pattern.matches(regex_legend, line)) {
                        double start1 = 100.5815;
                        double start2 = 102.06668;
                        StringBuilder out = new StringBuilder("");
                        int count = 0;
                        ISeries[] iSeriesArray = series;
                        int lower = series.length;
                        n = 0;
                        while (n < lower) {
                            ISeries serie = iSeriesArray[n];
                            if (serie.isVisible()) {
                                ILineSeries lineSerie = (ILineSeries)serie;
                                Color color = lineSerie.getLineColor();
                                String col = this.getColor(color);
                                double y1 = start1 + (double)(6 * count);
                                double y2 = start2 + (double)(6 * count);
                                String des = serie.getDescription();
                                String[] split2 = legend.toString().split("\\n");
                                String match1 = ".*%y1-coordinate%.*";
                                String match2 = ".*%y2-coordinate%.*";
                                String match3 = ".*%COLOR%.*";
                                String match42 = ".*%SERIES A%.*";
                                String[] stringArray2 = split2;
                                int n6 = split2.length;
                                int n7 = 0;
                                while (n7 < n6) {
                                    String string = stringArray2[n7];
                                    if (Pattern.matches(match1, string)) {
                                        string = string.replace("%y1-coordinate%", String.valueOf(y1));
                                    } else if (Pattern.matches(match2, string)) {
                                        string = string.replace("%y2-coordinate%", String.valueOf(y2));
                                    } else if (Pattern.matches(match3, string)) {
                                        string = string.replace("%COLOR%", col);
                                    } else if (Pattern.matches(match42, string)) {
                                        string = string.replace("%SERIES A%", des);
                                    }
                                    out.append(string);
                                    out.append("\n");
                                    ++n7;
                                }
                                out.append("\n");
                                ++count;
                            }
                            ++n;
                        }
                        line = line.replaceAll(regex_legend, out.toString());
                    } else if (Pattern.matches(axis_label, line)) {
                        if (isShowAxisZeroMarker) {
                            StringBuilder out = new StringBuilder("");
                            String[] split3 = axisLabel.toString().split("\\n");
                            String match1 = ".*%x1-coordinate%.*";
                            String match2 = ".*%x2-coordinate%.*";
                            String match3 = ".*%y1-coordinate%.*";
                            String match4 = ".*%y2-coordinate%.*";
                            double start1 = 20.306;
                            double height1 = 286.91;
                            double start2 = 279.90709;
                            double height2 = 200.0;
                            double upper = baseChart.getAxisSet().getXAxis((int)axisSettings.getIndexAxisX()).getRange().upper;
                            double lower = baseChart.getAxisSet().getXAxis((int)axisSettings.getIndexAxisX()).getRange().lower;
                            double x1 = !isReversedX ? start1 + (0.0 - lower) / (upper - lower) * height1 : start1 + height1 - (0.0 - lower) / (upper - lower) * height1;
                            if (x1 >= start1 && x1 <= start1 + height1) {
                                String[] stringArray3 = split3;
                                int match42 = split3.length;
                                int n8 = 0;
                                while (n8 < match42) {
                                    String string = stringArray3[n8];
                                    if (Pattern.matches(match1, string)) {
                                        string = string.replace("%x1-coordinate%", String.valueOf(x1));
                                    }
                                    if (Pattern.matches(match3, string)) {
                                        string = string.replace("%y1-coordinate%", String.valueOf(start2));
                                    }
                                    if (Pattern.matches(match2, string)) {
                                        string = string.replace("%x2-coordinate%", String.valueOf(x1));
                                    }
                                    if (Pattern.matches(match4, string)) {
                                        string = string.replace("%y2-coordinate%", String.valueOf(start2 - height2));
                                    }
                                    out.append(string);
                                    out.append("\n");
                                    ++n8;
                                }
                            }
                            out.append("\n");
                            double upper2 = baseChart.getAxisSet().getYAxis((int)axisSettings.getIndexAxisY()).getRange().upper;
                            double lower2 = baseChart.getAxisSet().getYAxis((int)axisSettings.getIndexAxisY()).getRange().lower;
                            double y1 = !isReversedY ? start2 - (height2 - (upper2 - 0.0) / (upper2 - lower2) * height2) : start2 - height2 + (height2 - (upper2 - 0.0) / (upper2 - lower2) * height2);
                            if (y1 <= start2 && y1 >= start2 - height2) {
                                String[] stringArray4 = split3;
                                int n9 = split3.length;
                                int n10 = 0;
                                while (n10 < n9) {
                                    String string = stringArray4[n10];
                                    if (Pattern.matches(match1, string)) {
                                        string = string.replace("%x1-coordinate%", String.valueOf(start1));
                                    }
                                    if (Pattern.matches(match3, string)) {
                                        string = string.replace("%y1-coordinate%", String.valueOf(y1));
                                    }
                                    if (Pattern.matches(match2, string)) {
                                        string = string.replace("%x2-coordinate%", String.valueOf(start1 + height1));
                                    }
                                    if (Pattern.matches(match4, string)) {
                                        string = string.replace("%y2-coordinate%", String.valueOf(y1));
                                    }
                                    out.append(string);
                                    out.append("\n");
                                    ++n10;
                                }
                            }
                            line = line.replaceAll(axis_label, out.toString());
                        }
                    } else if (Pattern.matches(data_series, line)) {
                        StringBuilder out = new StringBuilder("");
                        int widthPlotArea = baseChart.getPlotArea().getSize().x;
                        int heightPlotArea = baseChart.getPlotArea().getSize().y;
                        IAxisSet axisSet = baseChart.getAxisSet();
                        int index = 0;
                        ISeries[] iSeriesArray = series;
                        n = series.length;
                        int n11 = 0;
                        while (n11 < n) {
                            ISeries dataSeries = iSeriesArray[n11];
                            if (dataSeries != null && dataSeries.isVisible()) {
                                ILineSeries lineSeries = (ILineSeries)dataSeries;
                                LineStyle lineStyle = lineSeries.getLineStyle();
                                StringBuilder string = null;
                                string = lineStyle != LineStyle.NONE ? this.printLineData(dataSeries, widthPlotArea, heightPlotArea, axisSettings, index++, printWriter, axisSet, isReversedX, isReversedY) : this.printScatterData(dataSeries, widthPlotArea, heightPlotArea, axisSettings, index++, printWriter, axisSet, isReversedX, isReversedY);
                                out.append((CharSequence)string);
                            }
                            ++n11;
                        }
                        line = line.replaceAll(data_series, out.toString());
                    }
                    printWriter.println(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private StringBuilder printLineData(ISeries<?> dataSeries, int widthPlotArea, int heightPlotArea, AxisSettings axisSettings, int index, PrintWriter printWriter, IAxisSet axisSet, boolean isReversedX, boolean isReversedY) {
        StringBuilder out = new StringBuilder("");
        StringBuilder data = new StringBuilder("<path\n               style=\"fill:none;stroke:%COLOR%;stroke-width:0.45888707;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1\"\n               d=\"M %DATA POINTS%\"\n               id=\"path1740\"\n               inkscape:connector-curvature=\"0\" />");
        ILineSeries lineSeries = (ILineSeries)dataSeries;
        Color lineColor = lineSeries.getLineColor();
        String color = this.getColor(lineColor);
        int indexAxisX = axisSettings.getIndexAxisX();
        int indexAxisY = axisSettings.getIndexAxisY();
        IAxisScaleConverter axisScaleConverterX = axisSettings.getAxisScaleConverterX();
        IAxisScaleConverter axisScaleConverterY = axisSettings.getAxisScaleConverterY();
        double[] xSeries = dataSeries.getXSeries();
        double[] ySeries = dataSeries.getYSeries();
        String[] split = data.toString().split("\\n");
        int size = dataSeries.getXSeries().length;
        String match1 = ".*%COLOR%.*";
        String match2 = ".*%DATA POINTS%.*";
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (Pattern.matches(match1, string)) {
                string = string.replace("%COLOR%", color);
            } else if (Pattern.matches(match2, string)) {
                StringBuilder rep = new StringBuilder("");
                int i = 0;
                while (i < size) {
                    Point point = dataSeries.getPixelCoordinates(i);
                    if (point.x >= 0 && point.x <= widthPlotArea && point.y >= 0 && point.y <= heightPlotArea) {
                        rep.append(this.printValueLinePlot(AXIS_X, index, printWriter, xSeries[i], indexAxisX, axisSet, 0, axisScaleConverterX, isReversedX, isReversedY));
                        rep.append(",");
                        rep.append(this.printValueLinePlot(AXIS_Y, index, printWriter, ySeries[i], indexAxisY, axisSet, 0, axisScaleConverterY, isReversedX, isReversedY));
                        rep.append(" ");
                    }
                    ++i;
                }
                string = string.replace("%DATA POINTS%", rep);
            }
            out.append(string);
            out.append("\n");
            ++n2;
        }
        return out;
    }

    private String printValueLinePlot(String axis, int index, PrintWriter printWriter, double value, int indexAxis, IAxisSet axisSet, int indexPrimaryAxis, IAxisScaleConverter axisScaleConverter, boolean isReversedX, boolean isReversedY) {
        String ret = "";
        double x = 232.0;
        double y = 183.0;
        if (indexAxis == indexPrimaryAxis || axisScaleConverter == null) {
            if (axis.equals(AXIS_X)) {
                IAxis xAxis = axisSet.getXAxis(indexAxis);
                double xUpper = xAxis.getRange().upper;
                double xLower = xAxis.getRange().lower;
                double x1 = !isReversedX ? 23.5 + (value - xLower) / (xUpper - xLower) * x : 23.5 + x - (value - xLower) / (xUpper - xLower) * x;
                ret = String.valueOf(x1);
            } else if (axis.equals(AXIS_Y)) {
                IAxis yAxis = axisSet.getYAxis(indexAxis);
                double yUpper = yAxis.getRange().upper;
                double yLower = yAxis.getRange().lower;
                double y1 = !isReversedY ? 263.5 - (y - (yUpper - value) / (yUpper - yLower) * y) : 263.5 - y + (y - (yUpper - value) / (yUpper - yLower) * y);
                ret = String.valueOf(y1);
            }
        } else if (axisScaleConverter != null) {
            if (axis.equals(AXIS_X)) {
                IAxis xAxis = axisSet.getXAxis(indexAxis);
                double xUpper = xAxis.getRange().upper;
                double xLower = xAxis.getRange().lower;
                double x1 = !isReversedX ? 23.5 + (axisScaleConverter.convertToSecondaryUnit(value) - xLower) / (xUpper - xLower) * x : 23.5 + x - (axisScaleConverter.convertToSecondaryUnit(value) - xLower) / (xUpper - xLower) * x;
                ret = String.valueOf(x1);
            } else if (axis.equals(AXIS_Y)) {
                IAxis yAxis = axisSet.getYAxis(indexAxis);
                double yUpper = yAxis.getRange().upper;
                double yLower = yAxis.getRange().lower;
                double y1 = !isReversedY ? 80.5 + (yUpper - axisScaleConverter.convertToSecondaryUnit(value)) / (yUpper - yLower) * y : 263.5 - y + (yUpper - axisScaleConverter.convertToSecondaryUnit(value)) / (yUpper - yLower) * y;
                ret = String.valueOf(y1);
            }
        }
        return ret;
    }

    private void printBarPlot(String fileName, PrintWriter printWriter, ScrollableChart scrollableChart, AxisSettings axisSettings) {
        IAxisSettings axisSettingsX = axisSettings.getAxisSettingsX();
        IAxisSettings axisSettingsY = axisSettings.getAxisSettingsY();
        boolean isReversedX = axisSettingsX.isReversed();
        boolean isReversedY = axisSettingsY.isReversed();
        DecimalFormat formatX = axisSettingsX.getDecimalFormat();
        DecimalFormat formatY = axisSettingsY.getDecimalFormat();
        BaseChart baseChart = scrollableChart.getBaseChart();
        boolean isShowAxisZeroMarker = baseChart.getChartSettings().isShowAxisZeroMarker();
        ISeries[] series = baseChart.getSeriesSet().getSeries();
        String Template = "Template_BarChart.svg";
        try {
            Throwable throwable = null;
            Object var16_18 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(Template)));){
                String line;
                double[] xTicks = baseChart.getAxisSet().getXAxis(axisSettings.getIndexAxisX()).getTick().getTickLabelValues();
                double[] yTicks = baseChart.getAxisSet().getYAxis(axisSettings.getIndexAxisY()).getTick().getTickLabelValues();
                StringBuilder tickX = new StringBuilder("<path\n                       inkscape:connector-curvature=\"0\"\n                       id=\"path888\"\n                       d=\"m %x-coordinate%,279.77439 v 5.05309\"\n                       style=\"fill:none;stroke:#000000;stroke-width:0.26458332px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" />\n                    <text\n\t\t       id=\"text892\"\n                       y=\"289.01782\"\n                       x=\"%x-coordinate%\"\n                       style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:6.3499999px;line-height:1.25;font-family:arial;-inkscape-font-specification:arial;letter-spacing:0px;word-spacing:0px;fill:#000000;fill-opacity:1;stroke:none;stroke-width:0.26458332\"\n                       xml:space=\"preserve\"><tspan\n                         id=\"tspan890\"\n                         style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:3.52777767px;font-family:arial;-inkscape-font-specification:arial;text-align:center;text-anchor:middle;stroke-width:0.26458332\"\n                         y=\"289.01782\"\n                         x=\"%x-coordinate%\"\n                         sodipodi:role=\"line\">%X01%</tspan></text>");
                StringBuilder tickY = new StringBuilder("<path\n                       inkscape:connector-curvature=\"0\"\n                       id=\"path1299\"\n                       d=\"m 15.387913,%y-coordinate% h 5.05309\"\n                       style=\"fill:none;stroke:#000000;stroke-width:0.26458332px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" />\n                    <text\n                       xml:space=\"preserve\"\n                       style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:6.3499999px;line-height:1.25;font-family:arial;-inkscape-font-specification:arial;letter-spacing:0px;word-spacing:0px;fill:#000000;fill-opacity:1;stroke:none;stroke-width:0.26458332\"\n                       x=\"14.211229\"\n                       y=\"%y-coordinate%\"\n                       id=\"text1303\"><tspan\n                         sodipodi:role=\"line\"\n                         id=\"tspan1301\"\n                         x=\"14.211229\"\n                         y=\"%y-coordinate%\"\n                         style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:3.52777767px;font-family:arial;-inkscape-font-specification:arial;text-align:end;text-anchor:end;stroke-width:0.26458332\">%Y01%</tspan></text>");
                StringBuilder legend = new StringBuilder("<path\n                   style=\"fill:url(#linearGradient3662);fill-opacity:1;stroke:%COLOR%;stroke-width:0.5;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1\"\n                   d=\"m 209.71446,%y1-coordinate% h 20.93268\"\n                   id=\"path1744\"\n                   inkscape:connector-curvature=\"0\" />\n                <text\n                   xml:space=\"preserve\"\n                   style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:6.3499999px;line-height:1.25;font-family:'Bold Oblique';-inkscape-font-specification:'Bold Oblique, ';letter-spacing:0px;word-spacing:0px;fill:url(#linearGradient4353);fill-opacity:1;stroke:none;stroke-width:0.26458332\"\n                   x=\"230.91121\"\n                   y=\"%y2-coordinate%\"\n                   id=\"text1748\"><tspan\n                     sodipodi:role=\"line\"\n                     id=\"tspan1746\"\n                     x=\"230.91121\"\n                     y=\"%y2-coordinate%\"\n                     style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:4.23333311px;font-family:Arial;-inkscape-font-specification:Arial;fill:url(#linearGradient4353);fill-opacity:1;stroke-width:0.26458332\">%SERIES A%</tspan></text>");
                StringBuilder axisLabel = new StringBuilder("<path\n         style=\"fill:none;stroke:#000000;stroke-width:0.26499999;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1;stroke-miterlimit:4;stroke-dasharray:0.52999998,0.52999998;stroke-dashoffset:0;opacity:1\"\n         d=\"M %x1-coordinate%,%y1-coordinate% L %x2-coordinate%,%y2-coordinate%\"\n         id=\"path850\"\n         inkscape:connector-curvature=\"0\" />");
                String regexX = ".*%X-AXIS_TICKS%.*";
                String regexY = ".*%Y-AXIS_TICKS%.*";
                String titleX = ".*%PLACEHOLDER X-AXIS%.*";
                String titleY = ".*%PLACEHOLDER Y-AXIS%.*";
                String data_series = ".*%DATA SERIES%.*";
                String regex_legend = ".*%LEGEND%.*";
                String axis_label = ".*%AXIS LABELS%.*";
                while ((line = in.readLine()) != null) {
                    int n;
                    String[] stringArray;
                    String[] split;
                    if (Pattern.matches(regexX, line)) {
                        int ticklabel_size = xTicks.length;
                        double start = 20.306;
                        double height = 286.91;
                        StringBuilder out = new StringBuilder("");
                        double upper = baseChart.getAxisSet().getXAxis((int)axisSettings.getIndexAxisX()).getRange().upper;
                        double lower = baseChart.getAxisSet().getXAxis((int)axisSettings.getIndexAxisX()).getRange().lower;
                        int count = 0;
                        while (count < ticklabel_size) {
                            split = tickX.toString().split("\\n");
                            String match1 = ".*%x-coordinate%.*";
                            String match2 = ".*%X01%.*";
                            double x = !isReversedX ? start + (xTicks[count] - lower) / (upper - lower) * height : start + height - (xTicks[count] - lower) / (upper - lower) * height;
                            stringArray = split;
                            int n2 = split.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                String string = stringArray[n3];
                                if (Pattern.matches(match1, string)) {
                                    string = string.replace("%x-coordinate%", String.valueOf(x));
                                } else if (Pattern.matches(match2, string)) {
                                    string = string.replace("%X01%", String.valueOf(formatX.format(xTicks[count])));
                                }
                                out.append(string);
                                out.append("\n");
                                ++n3;
                            }
                            out.append("\n");
                            ++count;
                        }
                        line = line.replaceAll(regexX, out.toString());
                    } else if (Pattern.matches(regexY, line)) {
                        int ticklabel_size = yTicks.length;
                        double start = 279.90709;
                        double height = 200.0;
                        StringBuilder out = new StringBuilder("");
                        double upper = baseChart.getAxisSet().getYAxis((int)axisSettings.getIndexAxisY()).getRange().upper;
                        double lower = baseChart.getAxisSet().getYAxis((int)axisSettings.getIndexAxisY()).getRange().lower;
                        int count = 0;
                        while (count < ticklabel_size) {
                            split = tickY.toString().split("\\n");
                            String match1 = ".*%y-coordinate%.*";
                            String match2 = ".*%Y01%.*";
                            double y = !isReversedY ? start - (height - (upper - yTicks[count]) / (upper - lower) * height) : start - height + (height - (upper - yTicks[count]) / (upper - lower) * height);
                            stringArray = split;
                            int n4 = split.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                String string = stringArray[n5];
                                if (Pattern.matches(match1, string)) {
                                    string = string.replace("%y-coordinate%", String.valueOf(y));
                                } else if (Pattern.matches(match2, string)) {
                                    string = string.replace("%Y01%", String.valueOf(formatY.format(yTicks[count])));
                                }
                                out.append(string);
                                out.append("\n");
                                ++n5;
                            }
                            out.append("\n");
                            ++count;
                        }
                        line = line.replaceAll(regexY, out.toString());
                    } else if (Pattern.matches(titleX, line)) {
                        line = line.replace("%PLACEHOLDER X-AXIS%", axisSettingsX.getTitle());
                    } else if (Pattern.matches(titleY, line)) {
                        line = line.replace("%PLACEHOLDER Y-AXIS%", axisSettingsY.getTitle());
                    } else if (Pattern.matches(regex_legend, line)) {
                        double start1 = 100.5815;
                        double start2 = 102.06668;
                        StringBuilder out = new StringBuilder("");
                        int count = 0;
                        ISeries[] iSeriesArray = series;
                        int lower = series.length;
                        n = 0;
                        while (n < lower) {
                            ISeries serie = iSeriesArray[n];
                            if (serie.isVisible()) {
                                IBarSeries barSerie = (IBarSeries)serie;
                                Color color = barSerie.getBarColor();
                                String col = this.getColor(color);
                                double y1 = start1 + (double)(6 * count);
                                double y2 = start2 + (double)(6 * count);
                                String des = serie.getDescription();
                                String[] split2 = legend.toString().split("\\n");
                                String match1 = ".*%y1-coordinate%.*";
                                String match2 = ".*%y2-coordinate%.*";
                                String match3 = ".*%COLOR%.*";
                                String match42 = ".*%SERIES A%.*";
                                String[] stringArray2 = split2;
                                int n6 = split2.length;
                                int n7 = 0;
                                while (n7 < n6) {
                                    String string = stringArray2[n7];
                                    if (Pattern.matches(match1, string)) {
                                        string = string.replace("%y1-coordinate%", String.valueOf(y1));
                                    } else if (Pattern.matches(match2, string)) {
                                        string = string.replace("%y2-coordinate%", String.valueOf(y2));
                                    } else if (Pattern.matches(match3, string)) {
                                        string = string.replace("%COLOR%", col);
                                    } else if (Pattern.matches(match42, string)) {
                                        string = string.replace("%SERIES A%", des);
                                    }
                                    out.append(string);
                                    out.append("\n");
                                    ++n7;
                                }
                                out.append("\n");
                                ++count;
                            }
                            ++n;
                        }
                        line = line.replaceAll(regex_legend, out.toString());
                    } else if (Pattern.matches(axis_label, line)) {
                        if (isShowAxisZeroMarker) {
                            StringBuilder out = new StringBuilder("");
                            String[] split3 = axisLabel.toString().split("\\n");
                            String match1 = ".*%x1-coordinate%.*";
                            String match2 = ".*%x2-coordinate%.*";
                            String match3 = ".*%y1-coordinate%.*";
                            String match4 = ".*%y2-coordinate%.*";
                            double start1 = 20.306;
                            double height1 = 286.91;
                            double start2 = 279.90709;
                            double height2 = 200.0;
                            double upper = baseChart.getAxisSet().getXAxis((int)axisSettings.getIndexAxisX()).getRange().upper;
                            double lower = baseChart.getAxisSet().getXAxis((int)axisSettings.getIndexAxisX()).getRange().lower;
                            double x1 = !isReversedX ? start1 + (0.0 - lower) / (upper - lower) * height1 : start1 + height1 - (0.0 - lower) / (upper - lower) * height1;
                            if (x1 >= start1 && x1 <= start1 + height1) {
                                String[] stringArray3 = split3;
                                int match42 = split3.length;
                                int n8 = 0;
                                while (n8 < match42) {
                                    String string = stringArray3[n8];
                                    if (Pattern.matches(match1, string)) {
                                        string = string.replace("%x1-coordinate%", String.valueOf(x1));
                                    }
                                    if (Pattern.matches(match3, string)) {
                                        string = string.replace("%y1-coordinate%", String.valueOf(start2));
                                    }
                                    if (Pattern.matches(match2, string)) {
                                        string = string.replace("%x2-coordinate%", String.valueOf(x1));
                                    }
                                    if (Pattern.matches(match4, string)) {
                                        string = string.replace("%y2-coordinate%", String.valueOf(start2 - height2));
                                    }
                                    out.append(string);
                                    out.append("\n");
                                    ++n8;
                                }
                            }
                            out.append("\n");
                            double upper2 = baseChart.getAxisSet().getYAxis((int)axisSettings.getIndexAxisY()).getRange().upper;
                            double lower2 = baseChart.getAxisSet().getYAxis((int)axisSettings.getIndexAxisY()).getRange().lower;
                            double y1 = !isReversedY ? start2 - (height2 - (upper2 - 0.0) / (upper2 - lower2) * height2) : start2 - height2 + (height2 - (upper2 - 0.0) / (upper2 - lower2) * height2);
                            if (y1 <= start2 && y1 >= start2 - height2) {
                                String[] stringArray4 = split3;
                                int n9 = split3.length;
                                int n10 = 0;
                                while (n10 < n9) {
                                    String string = stringArray4[n10];
                                    if (Pattern.matches(match1, string)) {
                                        string = string.replace("%x1-coordinate%", String.valueOf(start1));
                                    }
                                    if (Pattern.matches(match3, string)) {
                                        string = string.replace("%y1-coordinate%", String.valueOf(y1));
                                    }
                                    if (Pattern.matches(match2, string)) {
                                        string = string.replace("%x2-coordinate%", String.valueOf(start1 + height1));
                                    }
                                    if (Pattern.matches(match4, string)) {
                                        string = string.replace("%y2-coordinate%", String.valueOf(y1));
                                    }
                                    out.append(string);
                                    out.append("\n");
                                    ++n10;
                                }
                            }
                            line = line.replaceAll(axis_label, out.toString());
                        }
                    } else if (Pattern.matches(data_series, line)) {
                        StringBuilder out = new StringBuilder("");
                        int widthPlotArea = baseChart.getPlotArea().getSize().x;
                        int heightPlotArea = baseChart.getPlotArea().getSize().y;
                        IAxisSet axisSet = baseChart.getAxisSet();
                        int index = 0;
                        ISeries[] iSeriesArray = series;
                        n = series.length;
                        int n11 = 0;
                        while (n11 < n) {
                            ISeries dataSeries = iSeriesArray[n11];
                            if (dataSeries != null && dataSeries.isVisible()) {
                                StringBuilder string = this.printBarData(dataSeries, widthPlotArea, heightPlotArea, axisSettings, index++, printWriter, axisSet, isReversedX, isReversedY);
                                out.append((CharSequence)string);
                            }
                            ++n11;
                        }
                        line = line.replaceAll(data_series, out.toString());
                    }
                    printWriter.println(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private StringBuilder printBarData(ISeries<?> dataSeries, int widthPlotArea, int heightPlotArea, AxisSettings axisSettings, int index, PrintWriter printWriter, IAxisSet axisSet, boolean isReversedX, boolean isReversedY) {
        StringBuilder out = new StringBuilder("");
        StringBuilder data = new StringBuilder("<rect\n         style=\"opacity:1;fill:%COLOR%;fill-opacity:1;stroke:none;stroke-width:0.96499991;stroke-linecap:square;stroke-linejoin:round;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\"\n         id=\"rect901\"\n         width=\"1\"\n         height=\"%height%\"\n         x=\"%x-coordinate%\"\n         y=\"%y-coordinate%\"\n         ry=\"0\" />");
        IBarSeries barSeries = (IBarSeries)dataSeries;
        Color barColor = barSeries.getBarColor();
        String color = this.getColor(barColor);
        int indexAxisX = axisSettings.getIndexAxisX();
        int indexAxisY = axisSettings.getIndexAxisY();
        IAxisScaleConverter axisScaleConverterX = axisSettings.getAxisScaleConverterX();
        IAxisScaleConverter axisScaleConverterY = axisSettings.getAxisScaleConverterY();
        double[] xSeries = dataSeries.getXSeries();
        double[] ySeries = dataSeries.getYSeries();
        String[] split = data.toString().split("\\n");
        int size = dataSeries.getXSeries().length;
        String match1 = ".*%COLOR%.*";
        String match2 = ".*%x-coordinate%.*";
        String match3 = ".*%y-coordinate%.*";
        String match4 = ".*%height%.*";
        int i = 0;
        while (i < size) {
            Point point = dataSeries.getPixelCoordinates(i);
            if (point.x >= 0 && point.x <= widthPlotArea) {
                double plotWidthArea;
                double offset = 0.25;
                double x = Double.parseDouble(this.printValueBarPlot(AXIS_X, index, printWriter, xSeries[i], indexAxisX, axisSet, 0, axisScaleConverterX, isReversedX, isReversedY));
                double y = Double.parseDouble(this.printValueBarPlot(AXIS_Y, index, printWriter, ySeries[i], indexAxisY, axisSet, 0, axisScaleConverterY, isReversedX, isReversedY));
                double base = Double.parseDouble(this.printValueBarPlot(AXIS_Y, index, printWriter, 0.0, indexAxisY, axisSet, 0, axisScaleConverterY, isReversedX, isReversedY));
                double height = Math.abs(y - base);
                double width = 1.0;
                double newX = x;
                double newY = y;
                double newWidth = width;
                double newHeight = height;
                if (x < 23.5) {
                    newX = -offset;
                    newWidth += x + offset;
                }
                if (y < 80.5) {
                    newY = -offset;
                    newHeight += y + offset;
                }
                if (x + width > (plotWidthArea = 232.0) && (newWidth -= x + width - plotWidthArea + offset) < 0.0) {
                    newWidth = 0.0;
                }
                if (y > base) {
                    if (base + height > y && (newHeight -= base + height - y + offset) < 0.0) {
                        newHeight = 0.0;
                    }
                } else if (y + height > base && (newHeight -= y + height - base + offset) < 0.0) {
                    newHeight = 0.0;
                }
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (Pattern.matches(match1, string)) {
                        string = string.replace("%COLOR%", color);
                    } else if (Pattern.matches(match2, string)) {
                        string = string.replace("%x-coordinate%", String.valueOf(newX));
                    } else if (Pattern.matches(match3, string)) {
                        string = ySeries[i] >= 0.0 ? string.replace("%y-coordinate%", String.valueOf(newY)) : string.replace("%y-coordinate%", String.valueOf(base));
                    } else if (Pattern.matches(match4, string)) {
                        string = string.replace("%height%", String.valueOf(newHeight));
                    }
                    out.append(string);
                    out.append("\n");
                    ++n2;
                }
            }
            ++i;
        }
        return out;
    }

    private String printValueBarPlot(String axis, int index, PrintWriter printWriter, double value, int indexAxis, IAxisSet axisSet, int indexPrimaryAxis, IAxisScaleConverter axisScaleConverter, boolean isReversedX, boolean isReversedY) {
        String ret = null;
        double x = 232.0;
        double y = 183.0;
        if (indexAxis == indexPrimaryAxis || axisScaleConverter == null) {
            if (axis.equals(AXIS_X)) {
                IAxis xAxis = axisSet.getXAxis(indexAxis);
                double xUpper = xAxis.getRange().upper;
                double xLower = xAxis.getRange().lower;
                value = value > xUpper ? xUpper : value;
                value = value < xLower ? xLower : value;
                double x1 = !isReversedX ? 23.5 + (value - xLower) / (xUpper - xLower) * x : 23.5 + x - (value - xLower) / (xUpper - xLower) * x;
                ret = String.valueOf(x1);
            } else if (axis.equals(AXIS_Y)) {
                IAxis yAxis = axisSet.getYAxis(indexAxis);
                double yUpper = yAxis.getRange().upper;
                double yLower = yAxis.getRange().lower;
                value = value > yUpper ? yUpper : value;
                value = value < yLower ? yLower : value;
                double y1 = !isReversedY ? 263.5 - (y - (yUpper - value) / (yUpper - yLower) * y) : 263.5 - y + (y - (yUpper - value) / (yUpper - yLower) * y);
                ret = String.valueOf(y1);
            }
        } else if (axisScaleConverter != null) {
            if (axis.equals(AXIS_X)) {
                IAxis xAxis = axisSet.getXAxis(indexAxis);
                double xUpper = xAxis.getRange().upper;
                double xLower = xAxis.getRange().lower;
                value = (value = axisScaleConverter.convertToSecondaryUnit(value)) > xUpper ? xUpper : value;
                value = value < xLower ? xLower : value;
                double x1 = !isReversedX ? 23.5 + (value - xLower) / (xUpper - xLower) * x : 23.5 + x + (value - xLower) / (xUpper - xLower) * x;
                ret = String.valueOf(x1);
            } else if (axis.equals(AXIS_Y)) {
                IAxis yAxis = axisSet.getYAxis(indexAxis);
                double yUpper = yAxis.getRange().upper;
                double yLower = yAxis.getRange().lower;
                value = (value = axisScaleConverter.convertToSecondaryUnit(value)) > yUpper ? yUpper : value;
                value = value < yLower ? yLower : value;
                double y1 = !isReversedY ? 263.5 - (y - (yUpper - value) / (yUpper - yLower) * y) : 263.5 - y - (yUpper - value) / (yUpper - yLower) * y;
                ret = String.valueOf(y1);
            }
        }
        return ret;
    }

    private void printScatterPlot(String fileName, PrintWriter printWriter, ScrollableChart scrollableChart, AxisSettings axisSettings) {
        IAxisSettings axisSettingsX = axisSettings.getAxisSettingsX();
        IAxisSettings axisSettingsY = axisSettings.getAxisSettingsY();
        boolean isReversedX = axisSettingsX.isReversed();
        boolean isReversedY = axisSettingsY.isReversed();
        DecimalFormat formatX = axisSettingsX.getDecimalFormat();
        DecimalFormat formatY = axisSettingsY.getDecimalFormat();
        BaseChart baseChart = scrollableChart.getBaseChart();
        boolean isShowAxisZeroMarker = baseChart.getChartSettings().isShowAxisZeroMarker();
        ISeries[] series = baseChart.getSeriesSet().getSeries();
        String Template = "Template_ScatterChart.svg";
        try {
            Throwable throwable = null;
            Object var16_18 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(Template)));){
                String line;
                double[] xTicks = baseChart.getAxisSet().getXAxis(axisSettings.getIndexAxisX()).getTick().getTickLabelValues();
                double[] yTicks = baseChart.getAxisSet().getYAxis(axisSettings.getIndexAxisY()).getTick().getTickLabelValues();
                StringBuilder tickX = new StringBuilder("<path\n                       inkscape:connector-curvature=\"0\"\n                       id=\"path888\"\n                       d=\"m %x-coordinate%,279.77439 v 5.05309\"\n                       style=\"fill:none;stroke:#000000;stroke-width:0.26458332px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" />\n                    <text\n\t\t       id=\"text892\"\n                       y=\"289.01782\"\n                       x=\"%x-coordinate%\"\n                       style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:6.3499999px;line-height:1.25;font-family:arial;-inkscape-font-specification:arial;letter-spacing:0px;word-spacing:0px;fill:#000000;fill-opacity:1;stroke:none;stroke-width:0.26458332\"\n                       xml:space=\"preserve\"><tspan\n                         id=\"tspan890\"\n                         style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:3.52777767px;font-family:arial;-inkscape-font-specification:arial;text-align:center;text-anchor:middle;stroke-width:0.26458332\"\n                         y=\"289.01782\"\n                         x=\"%x-coordinate%\"\n                         sodipodi:role=\"line\">%X01%</tspan></text>");
                StringBuilder tickY = new StringBuilder("<path\n                       inkscape:connector-curvature=\"0\"\n                       id=\"path1299\"\n                       d=\"m 15.387913,%y-coordinate% h 5.05309\"\n                       style=\"fill:none;stroke:#000000;stroke-width:0.26458332px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" />\n                    <text\n                       xml:space=\"preserve\"\n                       style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:6.3499999px;line-height:1.25;font-family:arial;-inkscape-font-specification:arial;letter-spacing:0px;word-spacing:0px;fill:#000000;fill-opacity:1;stroke:none;stroke-width:0.26458332\"\n                       x=\"14.211229\"\n                       y=\"%y-coordinate%\"\n                       id=\"text1303\"><tspan\n                         sodipodi:role=\"line\"\n                         id=\"tspan1301\"\n                         x=\"14.211229\"\n                         y=\"%y-coordinate%\"\n                         style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:3.52777767px;font-family:arial;-inkscape-font-specification:arial;text-align:end;text-anchor:end;stroke-width:0.26458332\">%Y01%</tspan></text>");
                StringBuilder legend = new StringBuilder("<path\n                   style=\"fill:url(#linearGradient3662);fill-opacity:1;stroke:%COLOR%;stroke-width:0.5;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1\"\n                   d=\"m 209.71446,%y1-coordinate% h 20.93268\"\n                   id=\"path1744\"\n                   inkscape:connector-curvature=\"0\" />\n                <text\n                   xml:space=\"preserve\"\n                   style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:6.3499999px;line-height:1.25;font-family:'Bold Oblique';-inkscape-font-specification:'Bold Oblique, ';letter-spacing:0px;word-spacing:0px;fill:url(#linearGradient4353);fill-opacity:1;stroke:none;stroke-width:0.26458332\"\n                   x=\"230.91121\"\n                   y=\"%y2-coordinate%\"\n                   id=\"text1748\"><tspan\n                     sodipodi:role=\"line\"\n                     id=\"tspan1746\"\n                     x=\"230.91121\"\n                     y=\"%y2-coordinate%\"\n                     style=\"font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;font-size:4.23333311px;font-family:Arial;-inkscape-font-specification:Arial;fill:url(#linearGradient4353);fill-opacity:1;stroke-width:0.26458332\">%SERIES A%</tspan></text>");
                StringBuilder axisLabel = new StringBuilder("<path\n         style=\"fill:none;stroke:#000000;stroke-width:0.26499999;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1;stroke-miterlimit:4;stroke-dasharray:0.52999998,0.52999998;stroke-dashoffset:0;opacity:1\"\n         d=\"M %x1-coordinate%,%y1-coordinate% L %x2-coordinate%,%y2-coordinate%\"\n         id=\"path850\"\n         inkscape:connector-curvature=\"0\" />");
                String regexX = ".*%X-AXIS_TICKS%.*";
                String regexY = ".*%Y-AXIS_TICKS%.*";
                String titleX = ".*%PLACEHOLDER X-AXIS%.*";
                String titleY = ".*%PLACEHOLDER Y-AXIS%.*";
                String data_series = ".*%DATA SERIES%.*";
                String regex_legend = ".*%LEGEND%.*";
                String axis_label = ".*%AXIS LABELS%.*";
                while ((line = in.readLine()) != null) {
                    int n;
                    String[] stringArray;
                    String[] split;
                    if (Pattern.matches(regexX, line)) {
                        int ticklabel_size = xTicks.length;
                        double start = 20.306;
                        double height = 286.91;
                        StringBuilder out = new StringBuilder("");
                        double upper = baseChart.getAxisSet().getXAxis((int)axisSettings.getIndexAxisX()).getRange().upper;
                        double lower = baseChart.getAxisSet().getXAxis((int)axisSettings.getIndexAxisX()).getRange().lower;
                        int count = 0;
                        while (count < ticklabel_size) {
                            split = tickX.toString().split("\\n");
                            String match1 = ".*%x-coordinate%.*";
                            String match2 = ".*%X01%.*";
                            double x = !isReversedX ? start + (xTicks[count] - lower) / (upper - lower) * height : start + height - (xTicks[count] - lower) / (upper - lower) * height;
                            stringArray = split;
                            int n2 = split.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                String string = stringArray[n3];
                                if (Pattern.matches(match1, string)) {
                                    string = string.replace("%x-coordinate%", String.valueOf(x));
                                } else if (Pattern.matches(match2, string)) {
                                    string = string.replace("%X01%", String.valueOf(formatX.format(xTicks[count])));
                                }
                                out.append(string);
                                out.append("\n");
                                ++n3;
                            }
                            out.append("\n");
                            ++count;
                        }
                        line = line.replaceAll(regexX, out.toString());
                    } else if (Pattern.matches(regexY, line)) {
                        int ticklabel_size = yTicks.length;
                        double start = 279.90709;
                        double height = 200.0;
                        StringBuilder out = new StringBuilder("");
                        double upper = baseChart.getAxisSet().getYAxis((int)axisSettings.getIndexAxisY()).getRange().upper;
                        double lower = baseChart.getAxisSet().getYAxis((int)axisSettings.getIndexAxisY()).getRange().lower;
                        int count = 0;
                        while (count < ticklabel_size) {
                            split = tickY.toString().split("\\n");
                            String match1 = ".*%y-coordinate%.*";
                            String match2 = ".*%Y01%.*";
                            double y = !isReversedY ? start - (height - (upper - yTicks[count]) / (upper - lower) * height) : start - height + (height - (upper - yTicks[count]) / (upper - lower) * height);
                            stringArray = split;
                            int n4 = split.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                String string = stringArray[n5];
                                if (Pattern.matches(match1, string)) {
                                    string = string.replace("%y-coordinate%", String.valueOf(y));
                                } else if (Pattern.matches(match2, string)) {
                                    string = string.replace("%Y01%", String.valueOf(formatY.format(yTicks[count])));
                                }
                                out.append(string);
                                out.append("\n");
                                ++n5;
                            }
                            out.append("\n");
                            ++count;
                        }
                        line = line.replaceAll(regexY, out.toString());
                    } else if (Pattern.matches(titleX, line)) {
                        line = line.replace("%PLACEHOLDER X-AXIS%", axisSettingsX.getTitle());
                    } else if (Pattern.matches(titleY, line)) {
                        line = line.replace("%PLACEHOLDER Y-AXIS%", axisSettingsY.getTitle());
                    } else if (Pattern.matches(regex_legend, line)) {
                        double start1 = 100.5815;
                        double start2 = 102.06668;
                        StringBuilder out = new StringBuilder("");
                        int count = 0;
                        ISeries[] iSeriesArray = series;
                        int lower = series.length;
                        n = 0;
                        while (n < lower) {
                            ISeries serie = iSeriesArray[n];
                            if (serie.isVisible()) {
                                ILineSeries lineSerie = (ILineSeries)serie;
                                Color color = lineSerie.getSymbolColor();
                                String col = this.getColor(color);
                                double y1 = start1 + (double)(6 * count);
                                double y2 = start2 + (double)(6 * count);
                                String des = serie.getDescription();
                                String[] split2 = legend.toString().split("\\n");
                                String match1 = ".*%y1-coordinate%.*";
                                String match2 = ".*%y2-coordinate%.*";
                                String match3 = ".*%COLOR%.*";
                                String match42 = ".*%SERIES A%.*";
                                String[] stringArray2 = split2;
                                int n6 = split2.length;
                                int n7 = 0;
                                while (n7 < n6) {
                                    String string = stringArray2[n7];
                                    if (Pattern.matches(match1, string)) {
                                        string = string.replace("%y1-coordinate%", String.valueOf(y1));
                                    } else if (Pattern.matches(match2, string)) {
                                        string = string.replace("%y2-coordinate%", String.valueOf(y2));
                                    } else if (Pattern.matches(match3, string)) {
                                        string = string.replace("%COLOR%", col);
                                    } else if (Pattern.matches(match42, string)) {
                                        string = string.replace("%SERIES A%", des);
                                    }
                                    out.append(string);
                                    out.append("\n");
                                    ++n7;
                                }
                                out.append("\n");
                                ++count;
                            }
                            ++n;
                        }
                        line = line.replaceAll(regex_legend, out.toString());
                    } else if (Pattern.matches(axis_label, line)) {
                        if (isShowAxisZeroMarker) {
                            StringBuilder out = new StringBuilder("");
                            String[] split3 = axisLabel.toString().split("\\n");
                            String match1 = ".*%x1-coordinate%.*";
                            String match2 = ".*%x2-coordinate%.*";
                            String match3 = ".*%y1-coordinate%.*";
                            String match4 = ".*%y2-coordinate%.*";
                            double start1 = 20.306;
                            double height1 = 286.91;
                            double start2 = 279.90709;
                            double height2 = 200.0;
                            double upper = baseChart.getAxisSet().getXAxis((int)axisSettings.getIndexAxisX()).getRange().upper;
                            double lower = baseChart.getAxisSet().getXAxis((int)axisSettings.getIndexAxisX()).getRange().lower;
                            double x1 = !isReversedX ? start1 + (0.0 - lower) / (upper - lower) * height1 : start1 + height1 - (0.0 - lower) / (upper - lower) * height1;
                            if (x1 >= start1 && x1 <= start1 + height1) {
                                String[] stringArray3 = split3;
                                int match42 = split3.length;
                                int n8 = 0;
                                while (n8 < match42) {
                                    String string = stringArray3[n8];
                                    if (Pattern.matches(match1, string)) {
                                        string = string.replace("%x1-coordinate%", String.valueOf(x1));
                                    }
                                    if (Pattern.matches(match3, string)) {
                                        string = string.replace("%y1-coordinate%", String.valueOf(start2));
                                    }
                                    if (Pattern.matches(match2, string)) {
                                        string = string.replace("%x2-coordinate%", String.valueOf(x1));
                                    }
                                    if (Pattern.matches(match4, string)) {
                                        string = string.replace("%y2-coordinate%", String.valueOf(start2 - height2));
                                    }
                                    out.append(string);
                                    out.append("\n");
                                    ++n8;
                                }
                            }
                            out.append("\n");
                            double upper2 = baseChart.getAxisSet().getYAxis((int)axisSettings.getIndexAxisY()).getRange().upper;
                            double lower2 = baseChart.getAxisSet().getYAxis((int)axisSettings.getIndexAxisY()).getRange().lower;
                            double y1 = !isReversedY ? start2 - (height2 - (upper2 - 0.0) / (upper2 - lower2) * height2) : start2 - height2 + (height2 - (upper2 - 0.0) / (upper2 - lower2) * height2);
                            if (y1 <= start2 && y1 >= start2 - height2) {
                                String[] stringArray4 = split3;
                                int n9 = split3.length;
                                int n10 = 0;
                                while (n10 < n9) {
                                    String string = stringArray4[n10];
                                    if (Pattern.matches(match1, string)) {
                                        string = string.replace("%x1-coordinate%", String.valueOf(start1));
                                    }
                                    if (Pattern.matches(match3, string)) {
                                        string = string.replace("%y1-coordinate%", String.valueOf(y1));
                                    }
                                    if (Pattern.matches(match2, string)) {
                                        string = string.replace("%x2-coordinate%", String.valueOf(start1 + height1));
                                    }
                                    if (Pattern.matches(match4, string)) {
                                        string = string.replace("%y2-coordinate%", String.valueOf(y1));
                                    }
                                    out.append(string);
                                    out.append("\n");
                                    ++n10;
                                }
                            }
                            line = line.replaceAll(axis_label, out.toString());
                        }
                    } else if (Pattern.matches(data_series, line)) {
                        StringBuilder out = new StringBuilder("");
                        int widthPlotArea = baseChart.getPlotArea().getSize().x;
                        int heightPlotArea = baseChart.getPlotArea().getSize().y;
                        IAxisSet axisSet = baseChart.getAxisSet();
                        int index = 0;
                        ISeries[] iSeriesArray = series;
                        n = series.length;
                        int n11 = 0;
                        while (n11 < n) {
                            ISeries dataSeries = iSeriesArray[n11];
                            if (dataSeries != null && dataSeries.isVisible()) {
                                StringBuilder string = this.printScatterData(dataSeries, widthPlotArea, heightPlotArea, axisSettings, index++, printWriter, axisSet, isReversedX, isReversedY);
                                out.append((CharSequence)string);
                            }
                            ++n11;
                        }
                        line = line.replaceAll(data_series, out.toString());
                    }
                    printWriter.println(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private StringBuilder printScatterData(ISeries<?> dataSeries, int widthPlotArea, int heightPlotArea, AxisSettings axisSettings, int index, PrintWriter printWriter, IAxisSet axisSet, boolean isReversedX, boolean isReversedY) {
        StringBuilder out = new StringBuilder("");
        StringBuilder data = new StringBuilder("<circle\n         style=\"opacity:1;fill:%COLOR%;fill-opacity:1;stroke:none;stroke-width:0.96499991;stroke-linecap:square;stroke-linejoin:round;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\"\n         id=\"rect901\"\n\t cx=\"%x-coordinate%\"\n\t cy=\"%y-coordinate%\"\n\t r=\"1\" />");
        ILineSeries lineSerie = (ILineSeries)dataSeries;
        Color lineColor = lineSerie.getSymbolColor();
        String color = this.getColor(lineColor);
        int indexAxisX = axisSettings.getIndexAxisX();
        int indexAxisY = axisSettings.getIndexAxisY();
        IAxisScaleConverter axisScaleConverterX = axisSettings.getAxisScaleConverterX();
        IAxisScaleConverter axisScaleConverterY = axisSettings.getAxisScaleConverterY();
        double[] xSeries = dataSeries.getXSeries();
        double[] ySeries = dataSeries.getYSeries();
        String[] split = data.toString().split("\\n");
        int size = dataSeries.getXSeries().length;
        String match1 = ".*%COLOR%.*";
        String match2 = ".*%x-coordinate%.*";
        String match3 = ".*%y-coordinate%.*";
        int i = 0;
        while (i < size) {
            Point point = dataSeries.getPixelCoordinates(i);
            if (point.x >= 0 && point.x <= widthPlotArea && point.y >= 0 && point.y <= heightPlotArea) {
                double x = Double.parseDouble(this.printValueScatterPlot(AXIS_X, index, printWriter, xSeries[i], indexAxisX, axisSet, 0, axisScaleConverterX, isReversedX, isReversedY));
                double y = Double.parseDouble(this.printValueScatterPlot(AXIS_Y, index, printWriter, ySeries[i], indexAxisY, axisSet, 0, axisScaleConverterY, isReversedX, isReversedY));
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (Pattern.matches(match1, string)) {
                        string = string.replace("%COLOR%", color);
                    } else if (Pattern.matches(match2, string)) {
                        string = string.replace("%x-coordinate%", String.valueOf(x));
                    } else if (Pattern.matches(match3, string)) {
                        string = string.replace("%y-coordinate%", String.valueOf(y));
                    }
                    out.append(string);
                    out.append("\n");
                    ++n2;
                }
            }
            ++i;
        }
        return out;
    }

    private String printValueScatterPlot(String axis, int index, PrintWriter printWriter, double value, int indexAxis, IAxisSet axisSet, int indexPrimaryAxis, IAxisScaleConverter axisScaleConverter, boolean isReversedX, boolean isReversedY) {
        String ret = null;
        double x = 232.0;
        double y = 183.0;
        if (indexAxis == indexPrimaryAxis || axisScaleConverter == null) {
            if (axis.equals(AXIS_X)) {
                IAxis xAxis = axisSet.getXAxis(indexAxis);
                double xUpper = xAxis.getRange().upper;
                double xLower = xAxis.getRange().lower;
                double x1 = !isReversedX ? 23.5 + (value - xLower) / (xUpper - xLower) * x : 23.5 + x - (value - xLower) / (xUpper - xLower) * x;
                ret = String.valueOf(x1);
            } else if (axis.equals(AXIS_Y)) {
                IAxis yAxis = axisSet.getYAxis(indexAxis);
                double yUpper = yAxis.getRange().upper;
                double yLower = yAxis.getRange().lower;
                double y1 = 263.5 - (y - (yUpper - value) / (yUpper - yLower) * y);
                ret = String.valueOf(y1);
            }
        } else if (axisScaleConverter != null) {
            if (axis.equals(AXIS_X)) {
                IAxis xAxis = axisSet.getXAxis(indexAxis);
                double xUpper = xAxis.getRange().upper;
                double xLower = xAxis.getRange().lower;
                value = axisScaleConverter.convertToSecondaryUnit(value);
                double x1 = !isReversedX ? 23.5 + (axisScaleConverter.convertToSecondaryUnit(value) - xLower) / (xUpper - xLower) * x : 23.5 + x - (axisScaleConverter.convertToSecondaryUnit(value) - xLower) / (xUpper - xLower) * x;
                ret = String.valueOf(x1);
            } else if (axis.equals(AXIS_Y)) {
                IAxis yAxis = axisSet.getYAxis(indexAxis);
                double yUpper = yAxis.getRange().upper;
                double yLower = yAxis.getRange().lower;
                value = axisScaleConverter.convertToSecondaryUnit(value);
                double y1 = !isReversedY ? 80.5 + (yUpper - axisScaleConverter.convertToSecondaryUnit(value)) / (yUpper - yLower) * y : 263.5 - y + (yUpper - axisScaleConverter.convertToSecondaryUnit(value)) / (yUpper - yLower) * y;
                ret = String.valueOf(y1);
            }
        }
        return ret;
    }
}

