/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.statet.ecommons.text.core.FragmentDocument;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionUtils;
import org.eclipse.statet.internal.r.ui.editors.RArgumentListContextInformation;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIntList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.text.core.input.OffsetStringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistCompletionInformationProposalWrapper;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.model.RFunctionSpec;
import org.eclipse.statet.r.core.source.ast.Assignment;
import org.eclipse.statet.r.core.source.ast.FCall;
import org.eclipse.statet.r.core.source.ast.Pipe;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAsts;
import org.eclipse.statet.r.core.source.ast.RParser;
import org.eclipse.statet.r.core.source.doc.RPartitionNodeScanner;
import org.eclipse.swt.custom.StyleRange;

@NonNullByDefault
public class RContextInformationValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    private final SourceEditor sourceEditor;
    private @Nullable RArgumentListContextInformation info;
    private long scannedArgsStamp;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable FCall.Args scannedArgs;
    private int lastPresentation = -2;

    public RContextInformationValidator(SourceEditor sourceEditor) {
        this.sourceEditor = sourceEditor;
    }

    protected RCoreAccess getRCoreAccess() {
        return RCore.getContextAccess((IAdaptable)this.sourceEditor);
    }

    public void install(IContextInformation info, ITextViewer viewer, int offset) {
        if (info instanceof AssistCompletionInformationProposalWrapper) {
            info = ((AssistCompletionInformationProposalWrapper)info).getContextInformation();
        }
        this.scannedArgs = null;
        this.lastPresentation = -2;
        if (!(info instanceof RArgumentListContextInformation) || viewer != this.sourceEditor.getViewer()) {
            this.info = null;
            return;
        }
        this.info = (RArgumentListContextInformation)info;
    }

    public boolean isContextInformationValid(int offset) {
        RArgumentListContextInformation info = this.info;
        if (info == null || offset < info.getContextInformationPosition() || offset > this.sourceEditor.getViewer().getDocument().getLength()) {
            return false;
        }
        FCall.Args args = this.getScannedArgs();
        if (args != null) {
            return offset <= args.getEndOffset();
        }
        return offset == info.getContextInformationPosition();
    }

    public boolean updatePresentation(int offset, TextPresentation presentation) {
        RArgumentListContextInformation info = this.info;
        if (info == null) {
            return false;
        }
        RFunctionSpec fSpec = info.getFunctionSpec();
        if (fSpec != null && fSpec.getParamCount() > 0) {
            int argParamIdx = this.getCurrentArgParamIdx(offset);
            ImIntList indexes = info.getInformationDisplayStringParamIndexes();
            if (argParamIdx >= 0 && argParamIdx < indexes.size()) {
                if (argParamIdx == this.lastPresentation) {
                    return false;
                }
                int start = indexes.getAt(argParamIdx);
                int stop = argParamIdx + 1 < indexes.size() ? indexes.getAt(argParamIdx + 1) : info.getInformationDisplayString().length();
                presentation.clear();
                presentation.addStyleRange(new StyleRange(start, stop - start, null, null, 1));
                this.lastPresentation = argParamIdx;
                return true;
            }
        }
        if (this.lastPresentation >= 0) {
            presentation.clear();
            this.lastPresentation = -1;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable FCall.Args getScannedArgs() {
        RArgumentListContextInformation info = (RArgumentListContextInformation)ObjectUtils.nonNullAssert((Object)this.info);
        int startOffset = info.getFCallArgsOffset();
        AbstractDocument document = (AbstractDocument)this.sourceEditor.getViewer().getDocument();
        int docStartOffset = startOffset;
        AbstractDocument abstractDocument = document;
        if (abstractDocument instanceof FragmentDocument) {
            void fragmentDoc;
            FragmentDocument fragmentDocument = (FragmentDocument)abstractDocument;
            FragmentDocument cfr_ignored_0 = (FragmentDocument)abstractDocument;
            document = fragmentDoc.getMasterDocument();
            docStartOffset += fragmentDoc.getOffsetInMasterDocument();
        }
        if (docStartOffset < 0) {
            docStartOffset = 0;
        }
        long stamp = document.getModificationStamp();
        if (this.scannedArgs == null || this.scannedArgsStamp != stamp) {
            try {
                FCall.Args args = null;
                TextRegion rRootNode = this.getRContentRegion(document, docStartOffset);
                if (rRootNode != null) {
                    int docEndOffset = Math.min(2048, rRootNode.getEndOffset() - docStartOffset);
                    OffsetStringParserInput input = new OffsetStringParserInput(document.get(docStartOffset, docEndOffset), startOffset);
                    RParser rParser = new RParser(this.getRCoreAccess().getRSourceConfig(), 4, null);
                    args = rParser.parseFCallArgs((TextParserInput)input.initAtOffset(), true);
                }
                this.scannedArgs = args;
                this.scannedArgsStamp = stamp;
            }
            catch (Exception e) {
                this.scannedArgs = null;
            }
        }
        return this.scannedArgs;
    }

    protected @Nullable TextRegion getRContentRegion(AbstractDocument document, int offset) throws BadLocationException, BadPartitioningException {
        return RPartitionNodeScanner.findRRootNode((TreePartitionNode)TreePartitionUtils.getNode((IDocument)document, (String)this.sourceEditor.getDocumentContentInfo().getPartitioning(), (int)offset, (boolean)true));
    }

    private int getCurrentArgParamIdx(int offset) {
        RAsts.FCallArgMatch match;
        RFunctionSpec.Parameter parameter;
        int callArgIdx;
        FCall.Args args = this.getScannedArgs();
        if (args != null && (callArgIdx = RContextInformationValidator.getCurrentArgInFCall(args, offset)) >= 0 && (parameter = (match = this.matchArgs(args)).getParamForFCall(callArgIdx)) != null) {
            return parameter.index;
        }
        return -1;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private RAsts.FCallArgMatch matchArgs(FCall.Args argsNode) {
        RAstNode parentNode;
        RArgumentListContextInformation info = (RArgumentListContextInformation)ObjectUtils.nonNullAssert((Object)this.info);
        @Nullable RAstNode replValueArg = null;
        @Nullable ImList inject0Args = ImCollections.emptyList();
        FCall fCallNode = info.getFCallNode();
        if (fCallNode != null && (parentNode = fCallNode.getRParent()) != null) {
            switch (parentNode.getNodeType()) {
                case PIPE_FORWARD: {
                    Pipe pipeNode = (Pipe)parentNode;
                    if (pipeNode.getTargetChild() != fCallNode) break;
                    inject0Args = ImCollections.newList((Object)pipeNode.getSourceChild());
                    break;
                }
                case A_RIGHT: 
                case A_EQUALS: 
                case A_LEFT: {
                    Assignment assignNode = (Assignment)parentNode;
                    if (assignNode.getTargetChild() != fCallNode) break;
                    replValueArg = assignNode.getSourceChild();
                    break;
                }
            }
        }
        RFunctionSpec fSpec = (RFunctionSpec)ObjectUtils.nonNullAssert((Object)info.getFunctionSpec());
        return RAsts.matchArgs((FCall.Args)argsNode, (RFunctionSpec)fSpec, replValueArg, (ImList)inject0Args);
    }

    private static int getCurrentArgInFCall(FCall.Args args, int offset) {
        int last = args.getChildCount() - 1;
        if (last == -1) {
            return 0;
        }
        int i = 0;
        while (i < last) {
            if (offset <= args.getSeparatorOffsets().getAt(i)) {
                return i;
            }
            ++i;
        }
        return last;
    }
}

