/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapterExtension;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.r.debug.ui.actions.AbstractDebugHandler;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.debug.core.RElementVariable;
import org.eclipse.statet.r.debug.core.RVariable;
import org.eclipse.statet.r.ui.editors.RSourceEditor;
import org.eclipse.ui.IWorkbenchPart;

public class WatchHandler
extends AbstractDebugHandler
implements IWatchExpressionFactoryAdapter,
IWatchExpressionFactoryAdapterExtension {
    /*
     * WARNING - void declaration
     */
    public void setEnabled(Object evaluationContext) {
        IWorkbenchPart part = WorkbenchUIUtils.getActivePart((Object)evaluationContext);
        ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)evaluationContext);
        if (part != null && selection != null) {
            ISelection iSelection = selection;
            if (iSelection instanceof IStructuredSelection) {
                void structSelection;
                IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                IStructuredSelection cfr_ignored_0 = (IStructuredSelection)iSelection;
                if (structSelection.isEmpty()) {
                    this.setBaseEnabled(false);
                    return;
                }
                for (Object obj : structSelection.toList()) {
                    if (obj instanceof RVariable && this.canCreateWatchExpression((RVariable)obj)) continue;
                    this.setBaseEnabled(false);
                    return;
                }
                this.setBaseEnabled(true);
                return;
            }
            if (selection instanceof ITextSelection && part instanceof RSourceEditor) {
                this.setBaseEnabled(true);
                return;
            }
        }
        this.setBaseEnabled(false);
    }

    /*
     * WARNING - void declaration
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = WorkbenchUIUtils.getActivePart((Object)event.getApplicationContext());
        ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)event.getApplicationContext());
        if (part != null && selection != null) {
            SourceEditor sourceEditor;
            ITextSelection textSelection;
            String expression;
            int count = 0;
            IDebugElement contextElement = this.getContextElement(this.getViewInput(part), part);
            ISelection iSelection = selection;
            if (iSelection instanceof IStructuredSelection) {
                void structSelection;
                IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                IStructuredSelection cfr_ignored_0 = (IStructuredSelection)iSelection;
                for (Object obj : structSelection.toList()) {
                    String expression2;
                    if (!(obj instanceof RVariable) || (expression2 = this.createWatchExpression((RVariable)obj)) == null) continue;
                    this.installWatchExpression(expression2, contextElement);
                    ++count;
                }
            } else if (selection instanceof ITextSelection && part instanceof RSourceEditor && (expression = this.getExpressionText(textSelection = (ITextSelection)selection, sourceEditor = (SourceEditor)part)) != null) {
                this.installWatchExpression(expression, contextElement);
                ++count;
            }
            if (count > 0) {
                WatchHandler.showView(part, "org.eclipse.debug.ui.ExpressionView");
            }
        }
        return null;
    }

    private boolean canCreateWatchExpression(RVariable rVariable) {
        RElementVariable elementVariable = this.getElementVariable(rVariable);
        return elementVariable != null && elementVariable.getFQElementName() != null;
    }

    private String createWatchExpression(RVariable rVariable) {
        RElementName elementName;
        RElementVariable elementVariable = this.getElementVariable(rVariable);
        if (elementVariable != null && (elementName = elementVariable.getFQElementName()) != null) {
            return this.addIndex(elementName.getDisplayName(2), this.getVariableItemIndex(rVariable));
        }
        return null;
    }

    public boolean canCreateWatchExpression(IVariable variable) {
        if (variable instanceof RVariable) {
            return this.canCreateWatchExpression((RVariable)variable);
        }
        return false;
    }

    public String createWatchExpression(IVariable variable) throws CoreException {
        if (variable instanceof RVariable) {
            return this.createWatchExpression((RVariable)variable);
        }
        return null;
    }

    private void installWatchExpression(String snippet, IDebugElement contextElement) {
        IExpressionManager expressionManager = DebugPlugin.getDefault().getExpressionManager();
        IWatchExpression expression = expressionManager.newWatchExpression(snippet);
        expressionManager.addExpression((IExpression)expression);
        if (contextElement != null) {
            expression.setExpressionContext(contextElement);
        }
    }
}

