/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.actions;

import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.r.debug.ui.RDebugUIUtils;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolStatus;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.rlang.RTokens;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.doc.RDocumentConstants;
import org.eclipse.statet.r.debug.core.RStackFrame;
import org.eclipse.statet.r.nico.AbstractRDbgController;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.statushandlers.StatusManager;

public class StepIntoSelectionHandler
extends AbstractHandler {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RElementAccess searchAccess(SourceEditor editor, IRegion region) {
        try {
            void access;
            void node;
            RSourceUnitModelInfo info;
            IDocument document = editor.getViewer().getDocument();
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)editor.getDocumentContentInfo().getPartitioning(), (int)region.getOffset(), (boolean)false);
            SourceUnit su = editor.getSourceUnit();
            if (!(su instanceof RSourceUnit)) return null;
            if (region.getOffset() >= document.getLength()) return null;
            if ((!RDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(partition.getType()) || RTokens.isRobustSeparator((int)document.getChar(region.getOffset()), (boolean)false)) && partition.getType() != "R.QuotedSymbol") {
                if (partition.getType() != "R.String") return null;
            }
            if ((info = (RSourceUnitModelInfo)su.getModelInfo("R", 2, (IProgressMonitor)new NullProgressMonitor())) == null) return null;
            AstInfo astInfo = info.getAst();
            AstSelection selection = AstSelection.search((AstNode)astInfo.getRoot(), (int)region.getOffset(), (int)(region.getOffset() + region.getLength()), (int)3);
            AstNode covering = selection.getCovering();
            AstNode astNode = covering;
            if (!(astNode instanceof RAstNode)) return null;
            RAstNode rAstNode = (RAstNode)astNode;
            RAstNode cfr_ignored_0 = (RAstNode)astNode;
            RAstNode current = node;
            block2: while (true) {
                ImList attachments = current.getAttachments();
                Iterator iterator = attachments.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        if ((current = current.getRParent()) != null) continue block2;
                        return null;
                    }
                    Object attachment = iterator.next();
                    Object e = attachment;
                    if (!(e instanceof RElementAccess)) continue;
                    RElementAccess cfr_ignored_1 = (RElementAccess)e;
                    RElementAccess cfr_ignored_2 = (RElementAccess)e;
                    if (access.isFunctionAccess() && access.isCallAccess()) break block2;
                }
                break;
            }
            if (!StepIntoSelectionHandler.isChild((RAstNode)node, access.getNode())) return null;
            return access;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    private static boolean isChild(RAstNode child, RAstNode parent) {
        do {
            if (child != parent) continue;
            return true;
        } while ((child = child.getRParent()) != null);
        return false;
    }

    public static void exec(AbstractRDbgController controller, AbstractDocument document, RElementAccess access, IWorkbenchPart part) {
        try {
            String code;
            RAstNode nameNode = access.getNameNode();
            switch (nameNode.getNodeType()) {
                case SYMBOL: 
                case STRING_CONST: {
                    code = access.getSegmentName();
                    if (access.getNode().getNodeType() == NodeType.F_CALL) {
                        code = "`" + code + "`";
                        break;
                    }
                    code = "get('" + code + "')";
                    break;
                }
                default: {
                    code = document.get(nameNode.getStartOffset(), nameNode.getLength());
                }
            }
            if (code != null && code.length() > 0) {
                RStackFrame frame = RDebugUIUtils.getFrame(part, (ToolProcess)controller.getTool());
                controller.debugStepInto(frame != null ? frame.getPosition() : -1, code);
            }
        }
        catch (BadLocationException nameNode) {
        }
        catch (StatusException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.debug.ui", 5012, "An error occurred when executing debug request in the R engine.", (Throwable)e), 1);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart activePart = WorkbenchUIUtils.getActivePart((Object)event.getApplicationContext());
        SourceEditor editor = (SourceEditor)activePart.getAdapter(SourceEditor.class);
        if (editor == null) {
            return null;
        }
        AbstractRDbgController controller = RDebugUIUtils.getRDbgController(editor);
        if (controller == null || controller.getStatus() != ToolStatus.STARTED_SUSPENDED) {
            return null;
        }
        ITextSelection selection = (ITextSelection)editor.getViewer().getSelection();
        RElementAccess access = StepIntoSelectionHandler.searchAccess(editor, (IRegion)new Region(selection.getOffset(), selection.getLength()));
        if (access != null) {
            StepIntoSelectionHandler.exec(controller, (AbstractDocument)editor.getViewer().getDocument(), access, activePart);
            return null;
        }
        Display.getCurrent().beep();
        return null;
    }
}

