/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.internal.ltk.ui.AdvancedExtensionsInternal;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHoverDescriptor;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class InfoHoverRegistry
implements SettingsChangeNotifier.ManageListener,
Disposable {
    public static final String TYPE_SETTINGS = "hover.type_settings.ids:setting";
    private final String contentTypeId;
    private final String settingsGroupId;
    private final Preference.StringArrayPref prefTypeSettings;
    private @Nullable List<InfoHoverDescriptor> descriptors;
    private @Nullable EffectiveHovers effectiveHovers;

    public InfoHoverRegistry(String contentTypeId, String prefQualifier, String settingsGroupId) {
        this.contentTypeId = contentTypeId;
        this.settingsGroupId = settingsGroupId;
        this.prefTypeSettings = new Preference.StringArrayPref(prefQualifier, TYPE_SETTINGS);
        PreferencesUtil.getSettingsChangeNotifier().addManageListener((SettingsChangeNotifier.ManageListener)this);
    }

    public void dispose() {
        SettingsChangeNotifier notifier = PreferencesUtil.getSettingsChangeNotifier();
        if (notifier != null) {
            notifier.removeManageListener((SettingsChangeNotifier.ManageListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeSettingsChangeNotification(Set<String> groupIds) {
        if (this.settingsGroupId != null && groupIds.contains(this.settingsGroupId)) {
            InfoHoverRegistry infoHoverRegistry = this;
            synchronized (infoHoverRegistry) {
                List<InfoHoverDescriptor> descriptors = this.descriptors;
                if (descriptors != null) {
                    this.descriptors = descriptors = this.applyPreferences(EPreferences.getInstancePrefs(), new ArrayList<InfoHoverDescriptor>(descriptors));
                }
                this.effectiveHovers = null;
            }
        }
    }

    public void afterSettingsChangeNotification(Set<String> groupIds) {
    }

    String getSettingsGroupId() {
        return this.settingsGroupId;
    }

    Preference.StringArrayPref getPrefSeparateSettings() {
        return this.prefTypeSettings;
    }

    List<InfoHoverDescriptor> loadCurrent() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = extensionRegistry.getConfigurationElementsFor("org.eclipse.statet.ltk.AdvancedInfoHover");
        ArrayList<InfoHoverDescriptor> descriptors = new ArrayList<InfoHoverDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String id = null;
            try {
                String contentTypeId = AdvancedExtensionsInternal.getCheckedString(element, "contentTypeId");
                if (this.contentTypeId.equals(contentTypeId)) {
                    id = AdvancedExtensionsInternal.getCheckedString(element, "id").intern();
                    String name = AdvancedExtensionsInternal.getCheckedString(element, "name");
                    InfoHoverDescriptor descriptor = new InfoHoverDescriptor(id, name, element);
                    descriptors.add(descriptor);
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", 0, NLS.bind((String)"Loading Text Hover failed (id= ''{0}'', contributed by= ''{1}'')", (Object)(id != null ? id : ""), (Object)element.getDeclaringExtension().getContributor().getName()), (Throwable)e));
            }
            ++n2;
        }
        return this.applyPreferences(EPreferences.getInstancePrefs(), descriptors);
    }

    List<InfoHoverDescriptor> applyPreferences(PreferenceAccess prefAccess, List<InfoHoverDescriptor> descriptors) {
        String[] settings = (String[])prefAccess.getPreferenceValue((Preference)this.getPrefSeparateSettings());
        ArrayList<InfoHoverDescriptor> sortedDescriptors = new ArrayList<InfoHoverDescriptor>(descriptors.size());
        String[] stringArray = settings;
        int n = settings.length;
        int n2 = 0;
        while (n2 < n) {
            int idx2;
            String setting = stringArray[n2];
            int idx1 = setting.indexOf(58);
            if (idx1 >= 0 && (idx2 = setting.indexOf(59, idx1 + 1)) >= 0) {
                String id = setting.substring(0, idx1);
                for (InfoHoverDescriptor descriptor : descriptors) {
                    if (!descriptor.getId().equals(id)) continue;
                    descriptors.remove(descriptor);
                    descriptor.isEnabled = Boolean.parseBoolean(setting.substring(idx1 + 1, idx2));
                    descriptor.stateMask = AdvancedExtensionsInternal.computeStateMask(setting.substring(idx2 + 1, setting.length()));
                    sortedDescriptors.add(descriptor);
                    break;
                }
            }
            ++n2;
        }
        for (InfoHoverDescriptor descriptor : descriptors) {
            descriptor.isEnabled = false;
            descriptor.stateMask = 0;
            sortedDescriptors.add(descriptor);
        }
        return sortedDescriptors;
    }

    Map<Preference<?>, Object> toPreferencesMap(List<InfoHoverDescriptor> descriptors) {
        HashMap map = new HashMap();
        String[] settings = new String[descriptors.size()];
        int i = 0;
        while (i < settings.length) {
            InfoHoverDescriptor descriptor = descriptors.get(i);
            settings[i] = String.valueOf(descriptor.getId()) + ':' + descriptor.isEnabled() + ';' + AdvancedExtensionsInternal.createUnifiedStateMaskString(descriptor.getStateMask());
            ++i;
        }
        map.put((Preference<?>)this.prefTypeSettings, settings);
        return map;
    }

    public String getContentTypeId() {
        return this.contentTypeId;
    }

    public synchronized @Nullable InfoHoverDescriptor getHoverDescriptor(int stateMask) {
        List<InfoHoverDescriptor> descriptors = this.descriptors;
        if (descriptors == null) {
            this.descriptors = descriptors = this.loadCurrent();
        }
        for (InfoHoverDescriptor descriptor : descriptors) {
            if (!descriptor.isEnabled() || descriptor.getStateMask() != stateMask) continue;
            return descriptor;
        }
        return null;
    }

    public synchronized EffectiveHovers getEffectiveHoverDescriptors() {
        EffectiveHovers effectiveHovers = this.effectiveHovers;
        if (effectiveHovers == null) {
            this.effectiveHovers = effectiveHovers = this.gatherEffectiveHovers();
        }
        return effectiveHovers;
    }

    private EffectiveHovers gatherEffectiveHovers() {
        List<InfoHoverDescriptor> descriptors = this.descriptors;
        if (descriptors == null) {
            this.descriptors = descriptors = this.loadCurrent();
        }
        int[] stateMasks = new int[descriptors.size()];
        ArrayList<InfoHoverDescriptor> effectiveDescriptors = new ArrayList<InfoHoverDescriptor>(descriptors.size());
        ArrayList<InfoHoverDescriptor> combinedDescriptors = new ArrayList<InfoHoverDescriptor>(descriptors.size());
        for (InfoHoverDescriptor descriptor : descriptors) {
            int stateMask;
            if (!descriptor.getId().endsWith("CombinedHover")) {
                combinedDescriptors.add(descriptor);
            }
            if (!descriptor.isEnabled() || (stateMask = descriptor.getStateMask()) == -1) continue;
            int i = 0;
            while (i < effectiveDescriptors.size()) {
                if (stateMasks[i] == stateMask) {
                    // empty if block
                }
                ++i;
            }
            stateMasks[effectiveDescriptors.size()] = stateMask;
            effectiveDescriptors.add(descriptor);
        }
        if (stateMasks.length != effectiveDescriptors.size()) {
            int[] fittedMasks = new int[effectiveDescriptors.size()];
            System.arraycopy(stateMasks, 0, fittedMasks, 0, effectiveDescriptors.size());
            stateMasks = fittedMasks;
        }
        return new EffectiveHovers(stateMasks, effectiveDescriptors, combinedDescriptors);
    }

    public static final class EffectiveHovers {
        private final int[] stateMasks;
        private final List<InfoHoverDescriptor> stateMaskDescriptors;
        private final List<InfoHoverDescriptor> combinedDescriptors;

        public EffectiveHovers(int[] stateMasks, List<InfoHoverDescriptor> effectiveDescriptors, List<InfoHoverDescriptor> combinedDescriptors) {
            this.stateMasks = stateMasks;
            this.stateMaskDescriptors = effectiveDescriptors;
            this.combinedDescriptors = combinedDescriptors;
        }

        public int[] getStateMasks() {
            return this.stateMasks;
        }

        public @Nullable InfoHoverDescriptor getDescriptor(int stateMask) {
            for (InfoHoverDescriptor descriptor : this.stateMaskDescriptors) {
                if (descriptor.getStateMask() != stateMask) continue;
                return descriptor;
            }
            return null;
        }

        public List<InfoHoverDescriptor> getDescriptorsForCombined() {
            return this.combinedDescriptors;
        }
    }
}

