/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.commands.core.BasicHandlerCollection;
import org.eclipse.statet.ecommons.commands.core.HandlerCollection;
import org.eclipse.statet.ecommons.preferences.ui.SettingsUpdater;
import org.eclipse.statet.ecommons.text.ui.TextViewerAction;
import org.eclipse.statet.ecommons.ui.ISettingsChangedHandler;
import org.eclipse.statet.ecommons.ui.actions.ControlServicesUtil;
import org.eclipse.statet.ecommons.ui.components.WidgetToolsButton;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.ContextHandlers;
import org.eclipse.statet.ecommons.ui.workbench.texteditor.ActionHandler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.sourceediting.ViewerSourceEditorAdapter;
import org.eclipse.statet.ltk.ui.sourceediting.swt.EnhStyledText;
import org.eclipse.statet.ltk.ui.sourceediting.util.SourceViewerEditorPreferenceUpdater;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

@NonNullByDefault
public class SnippetEditor {
    public static final int DEFAULT_SINGLE_LINE_STYLE = 33556484;
    public static final int DEFAULT_MULTI_LINE_STYLE = 0x2000B02;
    private Composite composite;
    private final Document document;
    private SourceViewer sourceViewer;
    private final boolean withToolButton;
    private WidgetToolsButton toolButton;
    private final SourceEditorViewerConfigurator configurator;
    private Map<String, Action> globalActions;
    private Updater updater;
    private final @Nullable IServiceLocator serviceLocator;
    private final HandlerCollection handlers;

    public SnippetEditor(SourceEditorViewerConfigurator configurator, @Nullable String initialContent, @Nullable IServiceLocator serviceParent, boolean withToolButton) {
        this.configurator = configurator;
        this.document = initialContent != null ? new Document(initialContent) : new Document();
        this.configurator.getDocumentSetupParticipant().setup((IDocument)this.document);
        this.serviceLocator = serviceParent;
        this.handlers = serviceParent != null ? new ContextHandlers(serviceParent) : new BasicHandlerCollection();
        this.withToolButton = withToolButton;
    }

    public SnippetEditor(SourceEditorViewerConfigurator configurator, String initialContent, IServiceLocator serviceParent) {
        this(configurator, initialContent, serviceParent, false);
    }

    public SnippetEditor(SourceEditorViewerConfigurator configurator) {
        this(configurator, null, null, false);
    }

    protected final @Nullable IServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public void create(Composite parent, int style) {
        if (this.withToolButton) {
            this.composite = new Composite(parent, 0){

                public boolean setFocus() {
                    return SnippetEditor.this.sourceViewer.getTextWidget().setFocus();
                }
            };
            this.composite.setLayout((Layout)LayoutUtils.newSashGrid((int)2));
            this.createSourceViewer(this.composite, style);
            this.sourceViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            WidgetToolsButton button = new WidgetToolsButton((Control)this.sourceViewer.getTextWidget()){

                protected void fillMenu(Menu menu) {
                    SnippetEditor.this.fillToolMenu(menu);
                }
            };
            button.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.toolButton = button;
        } else {
            this.createSourceViewer(parent, style);
            this.composite = this.sourceViewer.getTextWidget();
        }
        this.initActions();
        this.sourceViewer.activatePlugins();
        this.updater = new Updater();
        this.sourceViewer.addSelectionChangedListener((ISelectionChangedListener)this.updater);
        this.sourceViewer.getDocument().addDocumentListener((IDocumentListener)this.updater);
        this.composite.addDisposeListener(this::dispose);
    }

    private void createSourceViewer(Composite composite, int style) {
        this.sourceViewer = new SourceViewer(composite, null, style){

            protected StyledText createTextWidget(Composite parent, int styles) {
                return EnhStyledText.forSourceEditor(parent, styles);
            }
        };
        this.sourceViewer.setEditable(true);
        this.sourceViewer.setDocument((IDocument)this.document);
        ViewerSourceEditorAdapter adapter = new ViewerSourceEditorAdapter(this.sourceViewer, this.configurator);
        this.configurator.setTarget(adapter);
        new SourceViewerEditorPreferenceUpdater(this.sourceViewer, this.configurator.getSourceViewerConfiguration().getPreferences());
        new SettingsUpdater((ISettingsChangedHandler)this.configurator, this.sourceViewer.getControl());
    }

    protected void dispose(DisposeEvent e) {
        this.handlers.dispose();
    }

    public void registerCommandHandler(String commandId, IHandler2 handler) {
        if (this.handlers instanceof ContextHandlers) {
            ((ContextHandlers)this.handlers).addActivate(commandId, handler);
        } else {
            this.handlers.add(commandId, handler);
        }
    }

    public HandlerCollection getCommandHandlers() {
        return this.handlers;
    }

    public void addAction(Action action) {
        this.globalActions.put(action.getId(), action);
        String commandId = action.getActionDefinitionId();
        if (this.handlers instanceof ContextHandlers && commandId != null) {
            ((ContextHandlers)this.handlers).addActivate(commandId, (IHandler2)new ActionHandler((IAction)action));
        }
    }

    public @Nullable Action getAction(String id) {
        return this.globalActions.get(id);
    }

    /*
     * WARNING - void declaration
     */
    protected void initActions() {
        this.globalActions = new HashMap<String, Action>(10);
        HandlerCollection handlerCollection = this.handlers;
        if (handlerCollection instanceof ContextHandlers) {
            void contextHandlers;
            ContextHandlers contextHandlers2 = (ContextHandlers)handlerCollection;
            ContextHandlers cfr_ignored_0 = (ContextHandlers)handlerCollection;
            ControlServicesUtil serviceUtil = new ControlServicesUtil(this.serviceLocator, String.valueOf(this.getClass().getName()) + '#' + this.hashCode(), this.getSourceViewer().getControl());
            serviceUtil.addControl(this.getSourceViewer().getControl());
            if (this.toolButton != null) {
                serviceUtil.addControl(this.toolButton.getButton());
            }
            contextHandlers.setDefaultActivationExpression(serviceUtil.getExpression());
            contextHandlers.setDeactivateOnDisposal(serviceUtil.getRequireDeactivation());
        }
        this.addAction(TextViewerAction.createUndoAction((ITextViewer)this.sourceViewer));
        this.addAction(TextViewerAction.createRedoAction((ITextViewer)this.sourceViewer));
        this.addAction(TextViewerAction.createCutAction((ITextViewer)this.sourceViewer));
        this.addAction(TextViewerAction.createCopyAction((ITextViewer)this.sourceViewer));
        this.addAction(TextViewerAction.createPasteAction((ITextViewer)this.sourceViewer));
        this.addAction(TextViewerAction.createSelectAllAction((ITextViewer)this.sourceViewer));
        MenuManager manager = new MenuManager(null, null);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SnippetEditor.this.fillContextMenu(mgr);
            }
        });
        StyledText text = this.sourceViewer.getTextWidget();
        Menu menu = manager.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("group.undo"));
        menu.appendToGroup("group.undo", (IAction)this.getAction(ITextEditorActionConstants.UNDO));
        menu.appendToGroup("group.undo", (IAction)this.getAction(ITextEditorActionConstants.REDO));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.appendToGroup("group.edit", (IAction)this.getAction(ITextEditorActionConstants.CUT));
        menu.appendToGroup("group.edit", (IAction)this.getAction(ITextEditorActionConstants.COPY));
        menu.appendToGroup("group.edit", (IAction)this.getAction(ITextEditorActionConstants.PASTE));
        menu.appendToGroup("group.edit", (IAction)this.getAction(ITextEditorActionConstants.SELECT_ALL));
        menu.add((IContributionItem)new Separator("group.assist"));
        Action action = this.globalActions.get("ContentAssistProposal");
        if (action != null && action.getText() != null) {
            menu.appendToGroup("group.assist", (IAction)action);
        }
        menu.add((IContributionItem)new Separator("view"));
    }

    protected void fillToolMenu(Menu menu) {
    }

    public Document getDocument() {
        return this.document;
    }

    public SourceViewer getSourceViewer() {
        return this.sourceViewer;
    }

    public Composite getControl() {
        return this.composite;
    }

    public StyledText getTextControl() {
        return this.sourceViewer.getTextWidget();
    }

    public void reset() {
        this.sourceViewer.resetPlugins();
        this.updater.run();
    }

    private class Updater
    implements ISelectionChangedListener,
    IDocumentListener,
    Runnable {
        private boolean actionUpdateScheduled = false;

        private Updater() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.schedule();
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            this.schedule();
        }

        public void schedule() {
            if (this.actionUpdateScheduled) {
                return;
            }
            Display.getCurrent().asyncExec((Runnable)this);
            this.actionUpdateScheduled = true;
        }

        @Override
        public void run() {
            this.actionUpdateScheduled = false;
            if (UIAccess.isOkToUse((Viewer)SnippetEditor.this.sourceViewer)) {
                SnippetEditor.this.handlers.update(null);
                for (Action action : SnippetEditor.this.globalActions.values()) {
                    if (!(action instanceof IUpdate)) continue;
                    ((IUpdate)action).update();
                }
            }
        }
    }
}

