/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.dialogs.QuickTreeInformationControl;
import org.eclipse.statet.internal.ltk.ui.LtkUIPlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceElement;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.sourceediting.actions.OpenDeclaration;
import org.eclipse.statet.ltk.ui.util.ExtModelContentProvider;
import org.eclipse.statet.ltk.ui.util.ExtModelLabelProvider;
import org.eclipse.swt.widgets.Shell;

@NonNullByDefault
public abstract class QuickOutlineInformationControl
extends QuickTreeInformationControl {
    protected static final String INHERITED_COLOR_NAME = "org.eclipse.jdt.ui.ColoredLabels.inherited";
    private final OpenDeclaration opener;
    private ITreeContentProvider contentProvider = (ITreeContentProvider)ObjectUtils.nonNullLateInit();
    private boolean requireFullName;

    public QuickOutlineInformationControl(Shell parent, String commandId, int pageCount, OpenDeclaration opener) {
        super(parent, 16, true, commandId, pageCount);
        this.opener = opener;
    }

    public abstract String getModelTypeId(int var1);

    protected IDialogSettings getDialogSettings() {
        return DialogUtils.getDialogSettings((Plugin)LtkUIPlugin.getInstance(), (String)"EditorStructurePopup");
    }

    protected String getDescription(int page) {
        if (this.getCommandId() == "org.eclipse.statet.ltk.commands.ShowQuickSourceOutline") {
            return "Document Outline";
        }
        if (this.getCommandId() == "org.eclipse.statet.ltk.commands.ShowQuickElementOutline") {
            return "Object Outline";
        }
        return "";
    }

    protected void setMatcherString(String pattern, boolean update) {
        this.requireFullName = pattern.indexOf(42) >= 0;
        super.setMatcherString(pattern, update);
    }

    protected String getElementName(IAdaptable element) {
        if (element instanceof LtkModelElement && !this.requireFullName) {
            return ((LtkModelElement)element).getElementName().getSegmentName();
        }
        return super.getElementName(element);
    }

    protected void configureViewer(TreeViewer viewer) {
        this.contentProvider = this.createContentProvider();
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
    }

    protected ITreeContentProvider createContentProvider() {
        return new ExtModelContentProvider(new QuickOutlineContent());
    }

    protected ILabelProvider createLabelProvider() {
        return new ExtModelLabelProvider(this.getModelTypeId(0));
    }

    protected @Nullable SourceUnitModelInfo getModelInfo(Object input) {
        if (input instanceof SourceUnit) {
            String modelTypeId = this.getModelTypeId(this.getIterationPosition());
            return ((SourceUnit)input).getModelInfo(modelTypeId, 0, null);
        }
        return null;
    }

    protected @Nullable LtkModelElementFilter<? super SourceStructElement<?, ?>> getContentFilter() {
        return null;
    }

    protected int getInitialIterationPage(SourceElement<?> element) {
        return 0;
    }

    public void setInput(Object information) {
        SourceElement element;
        SourceUnit su;
        if (information instanceof SourceElement && (su = (element = (SourceElement)information).getSourceUnit()) != null) {
            this.inputChanged(this.getInitialIterationPage(element), su, element);
            return;
        }
        this.inputChanged(0, null, null);
    }

    protected void openElement(Object element) throws CoreException {
        if (element instanceof SourceElement) {
            this.opener.open((SourceElement)element, true);
        }
    }

    protected class QuickOutlineContent
    implements ExtModelContentProvider.ModelContent {
        @Override
        public @Nullable SourceUnitModelInfo getModelInfo(Object input) {
            return QuickOutlineInformationControl.this.getModelInfo(input);
        }

        @Override
        public @Nullable LtkModelElementFilter<? super SourceStructElement<?, ?>> getContentFilter() {
            return QuickOutlineInformationControl.this.getContentFilter();
        }
    }
}

