/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.ui.config.actions;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigManager;
import org.eclipse.statet.ecommons.debug.ui.config.actions.ActionUtil;
import org.eclipse.statet.ecommons.ui.actions.ListContributionItem;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.ecommons.ui.actions.SubMenuContributionItem;
import org.eclipse.statet.ecommons.ui.util.MessageUtils;
import org.eclipse.statet.internal.ecommons.debug.ui.Messages;
import org.eclipse.statet.jcommons.collections.IdentityCollection;
import org.eclipse.statet.jcommons.collections.IdentitySet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class RunConfigsMenuContribution<TElement>
extends ListContributionItem
implements IWorkbenchContribution,
IExecutableExtension {
    private final ActionUtil<TElement> util;
    private IServiceLocator serviceLocator;
    private final StringBuilder sBuilder = new StringBuilder(32);

    public RunConfigsMenuContribution(ActionUtil<TElement> util) {
        this.util = util;
    }

    protected ActionUtil<TElement> getUtil() {
        return this.util;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, @Nullable Object data) throws CoreException {
        block10: {
            if (!(data instanceof String)) break block10;
            switch ((String)data) {
                case "activeEditor": {
                    this.setMode((byte)1);
                    break;
                }
                case "activeMenuSelection": {
                    this.setMode((byte)2);
                    break;
                }
            }
        }
    }

    protected void setMode(byte mode) {
        this.util.setMode(mode);
    }

    protected byte getMode() {
        return this.util.getMode();
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    protected StringBuilder getStringBuilder() {
        this.sBuilder.setLength(0);
        return this.sBuilder;
    }

    protected void createContributionItems(List<IContributionItem> items) {
        List<ImIdentitySet<String>> shortcuts;
        IWorkbenchWindow window = ActionUtil.getWindow(this.serviceLocator);
        @Nullable TElement element = this.util.getLaunchElement(window);
        if (element == null) {
            return;
        }
        LaunchConfigManager<TElement> manager = this.util.getManager(window, element);
        if (manager == null) {
            return;
        }
        ImList<ILaunchConfiguration> configs = manager.getAvailableConfigs();
        Data data = new Data(window, (IServiceLocator)(this.serviceLocator != null ? this.serviceLocator : window), element, manager);
        if (this.getMode() != 1 && data.activeConfig != null && !(shortcuts = this.getContextShortcutLaunchFlags()).isEmpty()) {
            for (ImIdentitySet<String> launchFlags : shortcuts) {
                items.add((IContributionItem)this.createContextShortcut(data, (IdentitySet<String>)launchFlags));
            }
            items.add((IContributionItem)new Separator());
        }
        int i = 0;
        int num = 1;
        while (i < configs.size()) {
            ILaunchConfiguration configuration = (ILaunchConfiguration)configs.get(i);
            StringBuilder label = this.getStringBuilder();
            String mnemonic = null;
            if (num > 0 && num <= 10) {
                mnemonic = Integer.toString(num % 10);
                label.append('&');
                label.append(mnemonic);
                label.append(' ');
            }
            label.append(MessageUtils.escapeForMenu((String)configuration.getName()));
            Image image = manager.getImage(configuration);
            ConfigContribution item = this.createConfigContribution(label, image, configuration);
            item.data = data;
            items.add((IContributionItem)item);
            ++i;
            ++num;
        }
        if (this.getMode() == 1 || configs.isEmpty()) {
            items.add((IContributionItem)new ConfigureContribution(data));
        }
    }

    protected List<ImIdentitySet<String>> getContextShortcutLaunchFlags() {
        return ImCollections.emptyList();
    }

    private ShortcutContribution createContextShortcut(Data data, IdentitySet<String> launchFlags) {
        Image icon = data.manager.getActionImage((IdentityCollection<String>)launchFlags);
        String label = data.manager.getLabel(data.activeConfig, (IdentityCollection<String>)launchFlags, false);
        return new ShortcutContribution(label, icon != null ? ImageDescriptor.createFromImage((Image)icon) : null, launchFlags);
    }

    protected ConfigContribution createConfigContribution(StringBuilder label, Image icon, ILaunchConfiguration configuration) {
        return new ConfigContribution(label.toString(), icon, configuration);
    }

    protected class ConfigContribution
    extends SubMenuContributionItem
    implements SelectionListener {
        private static final String ACTIVATE = "activate";
        private static final String EDIT = "edit";
        private final String label;
        private final Image icon;
        private final ILaunchConfiguration config;
        private Data data;

        public ConfigContribution(String label, Image icon, ILaunchConfiguration configuration) {
            this.label = label;
            this.icon = icon;
            this.config = configuration;
        }

        protected IWorkbenchWindow getWindow() {
            return this.data.window;
        }

        protected TElement getElement() {
            return this.data.element;
        }

        protected LaunchConfigManager<TElement> getManager() {
            return this.data.manager;
        }

        protected String getLabel() {
            return this.label;
        }

        protected Image getImage() {
            return this.icon;
        }

        public ILaunchConfiguration getConfiguration() {
            return this.config;
        }

        protected boolean isActive() {
            return this.config == this.data.activeConfig;
        }

        protected void fillMenu(Menu menu) {
            this.addLaunchItem(menu, (ImIdentitySet<String>)ImCollections.newIdentitySet(), null, true, null, null);
            this.addActivateItem(menu, null);
            this.addEditItem(menu, null);
        }

        protected void addActivateItem(Menu menu, String helpContextId) {
            MenuItem item = new MenuItem(menu, 16);
            item.setText(Messages.RunAction_ActivateConfig_label);
            item.setData((Object)ACTIVATE);
            item.addSelectionListener((SelectionListener)this);
            item.setSelection(this.isActive());
            if (this.data.helpSystem != null && helpContextId != null) {
                this.data.helpSystem.setHelp(item, helpContextId);
            }
        }

        protected void addEditItem(Menu menu, String helpContextId) {
            MenuItem item = new MenuItem(menu, 8);
            item.setText(Messages.RunAction_EditConfig_label);
            item.setData((Object)EDIT);
            item.addSelectionListener((SelectionListener)this);
            if (this.data.helpSystem != null && helpContextId != null) {
                this.data.helpSystem.setHelp(item, helpContextId);
            }
        }

        protected void addLaunchItem(Menu menu, ImIdentitySet<String> launchFlags, @Nullable String actionDetailInfo, boolean enabled, @Nullable String commandId, @Nullable String helpContextId) {
            TriggerSequence binding;
            if (RunConfigsMenuContribution.this.getMode() != 1) {
                commandId = null;
            }
            StringBuilder label = RunConfigsMenuContribution.this.getStringBuilder();
            label.append(this.data.manager.getActionLabel((IdentityCollection<String>)launchFlags));
            if (actionDetailInfo != null) {
                label.append(actionDetailInfo);
            }
            if (this.isActive() && commandId != null && this.data.bindingService != null && (binding = this.data.bindingService.getBestActiveBindingFor(commandId)) != null) {
                label.append('\t');
                label.append(binding.format());
            }
            MenuItem item = new MenuItem(menu, 8);
            item.setText(label.toString());
            item.setImage(this.data.manager.getActionImage((IdentityCollection<String>)launchFlags));
            item.setData(launchFlags);
            item.addSelectionListener((SelectionListener)this);
            item.setEnabled(enabled);
            if (this.data.helpSystem != null && helpContextId != null) {
                this.data.helpSystem.setHelp(item, helpContextId);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            LaunchConfigManager manager = this.getManager();
            Object data = e.widget.getData();
            if (data instanceof ImIdentitySet) {
                manager.launch(this.config, this.getElement(), (IdentitySet<String>)((ImIdentitySet)data));
                return;
            }
            if (data == ACTIVATE) {
                manager.setActiveConfig(this.config);
                return;
            }
            if (data == EDIT) {
                IWorkbenchWindow window = this.getWindow();
                if (RunConfigsMenuContribution.this.getMode() == 1) {
                    ActionUtil.activateActiveEditor(window);
                }
                manager.openConfigurationDialog(window.getShell(), (IStructuredSelection)new StructuredSelection((Object)this.config));
                return;
            }
        }
    }

    private class ConfigureContribution
    extends SimpleContributionItem {
        private final Data data;

        public ConfigureContribution(Data data) {
            super(Messages.RunAction_CreateEditConfigs_label, null);
            this.data = data;
        }

        protected IWorkbenchWindow getWindow() {
            return this.data.window;
        }

        protected LaunchConfigManager<TElement> getManager() {
            return this.data.manager;
        }

        protected void execute(Event event) throws ExecutionException {
            IWorkbenchWindow window = this.getWindow();
            if (RunConfigsMenuContribution.this.getMode() == 1) {
                ActionUtil.activateActiveEditor(window);
            }
            this.getManager().openConfigurationDialog(window.getShell(), null);
        }
    }

    private class Data {
        public final IWorkbenchWindow window;
        public final TElement element;
        public final LaunchConfigManager<TElement> manager;
        public final @Nullable ILaunchConfiguration activeConfig;
        public final @Nullable IBindingService bindingService;
        public final @Nullable IWorkbenchHelpSystem helpSystem;

        public Data(IWorkbenchWindow window, IServiceLocator serviceLocator, TElement file, LaunchConfigManager<TElement> manager) {
            this.window = window;
            this.element = file;
            this.manager = manager;
            this.activeConfig = manager.getActiveConfig();
            this.bindingService = serviceLocator != null ? (IBindingService)serviceLocator.getService(IBindingService.class) : null;
            this.helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        }
    }

    private class ShortcutContribution
    extends SimpleContributionItem {
        private Data data;
        private final IdentitySet<String> launchFlags;

        public ShortcutContribution(@Nullable String label, ImageDescriptor icon, IdentitySet<String> launchFlags) {
            super(label, null, icon, null);
            this.launchFlags = launchFlags;
        }

        protected LaunchConfigManager<TElement> getManager() {
            return this.data.manager;
        }

        protected TElement getElement() {
            return this.data.element;
        }

        protected IdentitySet<String> getLaunchFlags() {
            return this.launchFlags;
        }

        protected void execute(Event event) throws ExecutionException {
            this.getManager().launch(this.data.activeConfig, this.getElement(), this.getLaunchFlags());
        }
    }
}

