/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.search.ui.ISearchPageScoreComputer;
import org.eclipse.statet.internal.r.ui.RSearchPageScoreComputer;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.ltk.model.core.element.SourceElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;
import org.eclipse.statet.r.core.rmodel.RElement;
import org.eclipse.ui.IContributorResourceAdapter;

public class RElementAdapterFactory
implements IAdapterFactory,
IContributorResourceAdapter {
    private static Class<?>[] PROPERTIES = new Class[]{IResource.class, IContributorResourceAdapter.class};
    private Class<?> fSearchPageScoreComputerClass;
    private Object fSearchPageScoreComputer;

    public Class<?>[] getAdapterList() {
        this.updateLazyLoadedAdapters();
        return PROPERTIES;
    }

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        this.updateLazyLoadedAdapters();
        RElement element = this.getRElement(adaptableObject);
        if (adapterType == IResource.class) {
            return (T)this.getResource(element);
        }
        if (this.fSearchPageScoreComputerClass != null && adapterType == this.fSearchPageScoreComputerClass) {
            return (T)this.fSearchPageScoreComputer;
        }
        if (adapterType == IContributorResourceAdapter.class) {
            return (T)this;
        }
        return null;
    }

    private IResource getResource(RElement element) {
        switch (element.getElementType() & 0xF00) {
            case 512: {
                SourceUnit su;
                if (element instanceof SourceElement && (su = ((SourceElement)element).getSourceUnit()) instanceof WorkspaceSourceUnit) {
                    return ((WorkspaceSourceUnit)su).getResource();
                }
                return null;
            }
        }
        return null;
    }

    public IResource getAdaptedResource(IAdaptable adaptable) {
        RElement element = this.getRElement(adaptable);
        if (element != null) {
            return this.getResource(element);
        }
        return null;
    }

    private RElement getRElement(Object element) {
        if (element instanceof RElement) {
            return (RElement)element;
        }
        return null;
    }

    private synchronized void updateLazyLoadedAdapters() {
        if (this.fSearchPageScoreComputerClass == null && RUIPlugin.isSearchPlugInActivated()) {
            this.createSearchPageScoreComputer();
        }
    }

    private void createSearchPageScoreComputer() {
        this.fSearchPageScoreComputerClass = ISearchPageScoreComputer.class;
        this.fSearchPageScoreComputer = new RSearchPageScoreComputer();
        Class[] newProperties = new Class[PROPERTIES.length + 1];
        System.arraycopy(PROPERTIES, 0, newProperties, 0, PROPERTIES.length);
        newProperties[RElementAdapterFactory.PROPERTIES.length] = this.fSearchPageScoreComputerClass;
        PROPERTIES = newProperties;
    }
}

