/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.AbstractRawStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRStore;
import org.eclipse.statet.rj.data.impl.RDataResizeExtension;

@NonNullByDefault
public class RRaw32Store
extends AbstractRawStore
implements RDataResizeExtension<Byte>,
ExternalizableRStore,
Externalizable {
    private int length;
    protected byte[] byteValues;

    public RRaw32Store() {
        this.byteValues = EMPTY_BYTE_ARRAY;
        this.length = 0;
    }

    public RRaw32Store(int length) {
        this.byteValues = new byte[length];
        this.length = length;
    }

    public RRaw32Store(byte[] values) {
        this.byteValues = values;
        this.length = this.byteValues.length;
    }

    public RRaw32Store(RJIO io, int length) throws IOException {
        this.length = length;
        this.byteValues = io.readByteData(new byte[length], length);
    }

    @Override
    public void writeExternal(RJIO io) throws IOException {
        io.writeByteData(this.byteValues, this.length);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.length = in.readInt();
        this.byteValues = new byte[this.length];
        in.readFully(this.byteValues, 0, this.length);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.length);
        out.write(this.byteValues, 0, this.length);
    }

    @Override
    protected final boolean isStructOnly() {
        return false;
    }

    protected final int length() {
        return this.length;
    }

    @Override
    public final long getLength() {
        return this.length;
    }

    @Override
    public final boolean isNA(int idx) {
        if (idx < 0 || idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return false;
    }

    @Override
    public final boolean isNA(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return false;
    }

    @Override
    public final boolean isMissing(int idx) {
        if (idx < 0 || idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return false;
    }

    @Override
    public final boolean isMissing(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return false;
    }

    @Override
    public byte getRaw(int idx) {
        return this.byteValues[idx];
    }

    @Override
    public byte getRaw(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.byteValues[(int)idx];
    }

    @Override
    public byte[] toRawArray() {
        return Arrays.copyOf(this.byteValues, this.length);
    }

    @Override
    public void setRaw(int idx, byte value) {
        this.byteValues[idx] = value;
    }

    @Override
    public void setRaw(long idx, byte value) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.byteValues[(int)idx] = value;
    }

    private void prepareInsert(int[] idxs) {
        this.byteValues = RRaw32Store.prepareInsert(this.byteValues, this.length, idxs);
        this.length += idxs.length;
    }

    public void insert(int idx, byte value) {
        this.prepareInsert(new int[]{idx});
        this.byteValues[idx] = value;
    }

    @Override
    public void insertNA(int idx) {
        this.prepareInsert(new int[]{idx});
        this.byteValues[idx] = 0;
    }

    @Override
    public void insertNA(int[] idxs) {
        if (idxs.length == 0) {
            return;
        }
        this.prepareInsert(idxs);
        int idx = 0;
        while (idx < idxs.length) {
            this.byteValues[idx] = 0;
            ++idx;
        }
    }

    @Override
    public void remove(int idx) {
        this.byteValues = RRaw32Store.remove(this.byteValues, this.length, new int[]{idx});
        --this.length;
    }

    @Override
    public void remove(int[] idxs) {
        this.byteValues = RRaw32Store.remove(this.byteValues, this.length, idxs);
        this.length -= idxs.length;
    }

    @Override
    public Byte get(int idx) {
        if (idx < 0 || idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.byteValues[idx];
    }

    @Override
    public Byte get(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.byteValues[(int)idx];
    }

    @Override
    public @NonNull Byte[] toArray() {
        Byte[] array = new Byte[this.length];
        byte[] raws = this.byteValues;
        int i = 0;
        while (i < array.length) {
            array[i] = raws[i];
            ++i;
        }
        return array;
    }

    @Override
    public long indexOf(int integer, long fromIdx) {
        if (fromIdx >= Integer.MAX_VALUE || (integer & 0xFFFFFF00) != 0) {
            return -1L;
        }
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        byte raw = (byte)(integer & 0xFF);
        int l = this.length;
        byte[] raws = this.byteValues;
        int i = (int)fromIdx;
        while (i < l) {
            if (raws[i] == raw) {
                return i;
            }
            ++i;
        }
        return -1L;
    }

    @Override
    public boolean allEqual(RStore<?> other) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

