/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.util.VariableFilterUtils;
import org.eclipse.statet.internal.nico.ui.NicoUIPlugin;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolWorkspace;
import org.eclipse.statet.nico.core.util.TrackWriter;
import org.eclipse.statet.nico.core.util.TrackingConfiguration;
import org.eclipse.statet.nico.ui.console.NIConsolePage;
import org.eclipse.statet.nico.ui.util.OpenTrackingFilesContributionItem;
import org.eclipse.statet.nico.ui.util.ToolInfoGroup;
import org.eclipse.statet.nico.ui.util.TrackingConfigurationComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.statushandlers.StatusManager;

public class ExportConsoleOutputWizard
extends Wizard {
    private static final String FILE_HISTORY_SETTINGSKEY = "FileLocation_history";
    private TrackingConfiguration config;
    private final int selectionLength;
    private final NIConsolePage consolePage;
    private ConfigurationPage configPage;

    public ExportConsoleOutputWizard(NIConsolePage consolePage) {
        this.consolePage = consolePage;
        this.selectionLength = ((ITextSelection)consolePage.getOutputViewer().getSelection()).getLength();
        this.setWindowTitle("Export Console Output");
        this.setNeedsProgressMonitor(true);
        this.setDialogSettings(DialogUtils.getDialogSettings((Plugin)NicoUIPlugin.getInstance(), (String)"tools/ExportConsoleOutputWizard"));
    }

    protected TrackingConfiguration createTrackingConfiguration() {
        TrackingConfiguration config = new TrackingConfiguration("");
        config.getSubmitTypes().remove(SubmitType.OTHER);
        return config;
    }

    public void addPages() {
        this.config = this.createTrackingConfiguration();
        this.configPage = new ConfigurationPage(this.consolePage, this.config, this.selectionLength > 0);
        this.addPage((IWizardPage)this.configPage);
    }

    public boolean performFinish() {
        this.configPage.saveSettings();
        final boolean openInEditor = this.configPage.getOpenInEditor();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)"Export Output", (int)100);
                    final TextConsoleViewer outputViewer = ExportConsoleOutputWizard.this.consolePage.getOutputViewer();
                    AbstractDocument document = (AbstractDocument)outputViewer.getDocument();
                    IJobManager jobManager = Job.getJobManager();
                    ISchedulingRule schedulingRule = ExportConsoleOutputWizard.this.consolePage.getConsole().getSchedulingRule();
                    jobManager.beginRule(schedulingRule, (IProgressMonitor)m.newChild(1));
                    try {
                        if (ExportConsoleOutputWizard.this.selectionLength > 0) {
                            final AtomicReference currentSelection = new AtomicReference();
                            ExportConsoleOutputWizard.this.getShell().getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    boolean continueExport;
                                    ITextSelection selection = (ITextSelection)outputViewer.getSelection();
                                    if (selection.getLength() != (this).ExportConsoleOutputWizard.this.selectionLength && !(continueExport = MessageDialog.openQuestion((Shell)ExportConsoleOutputWizard.this.getShell(), (String)"Export Output", (String)"The selection is changed due to updates in the console. Do you want to continue nevertheless?"))) {
                                        return;
                                    }
                                    currentSelection.set(selection);
                                }
                            });
                            ITextSelection selection = (ITextSelection)currentSelection.get();
                            if (selection == null) {
                                return;
                            }
                            ExportConsoleOutputWizard.this.export(document, selection.getOffset(), selection.getLength(), openInEditor, m);
                        } else {
                            ExportConsoleOutputWizard.this.export(document, 0, document.getLength(), openInEditor, m);
                        }
                    }
                    finally {
                        jobManager.endRule(schedulingRule);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.nico.ui", -1, "An error occurred when exporting console output to file.", cause), 3);
            return !(cause instanceof CoreException) && !(cause instanceof IOException);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    private void export(AbstractDocument document, int offset, int length, boolean openInEditor, SubMonitor m) throws InvocationTargetException {
        m.setWorkRemaining(21);
        OutputStream outputStream = null;
        Writer outputWriter = null;
        try {
            try {
                IFileStore fileStore;
                block32: {
                    block31: {
                        String filePath = this.config.getFilePath();
                        filePath = TrackWriter.resolveVariables((String)filePath, (ToolWorkspace)this.consolePage.getTool().getWorkspaceData());
                        fileStore = FileUtil.getFileStore((String)filePath);
                        outputStream = fileStore.openOutputStream(this.config.getFileMode(), (IProgressMonitor)m.newChild(1));
                        if (fileStore.fetchInfo().getLength() <= 0L) {
                            FileUtil.prepareTextOutput((OutputStream)outputStream, (String)this.config.getFileEncoding());
                        }
                        outputWriter = new BufferedWriter(new OutputStreamWriter(outputStream, this.config.getFileEncoding()));
                        if (this.config.getPrependTimestamp()) {
                            ToolProcess process = this.consolePage.getConsole().getProcess();
                            outputWriter.append(process.createTimestampComment(process.getConnectionTimestamp()));
                        }
                        if (!this.config.getTrackStreamInfo() || !this.config.getTrackStreamInput() || !this.config.getTrackStreamOutput() || this.config.getTrackStreamOutputTruncate() || !this.config.getSubmitTypes().contains(SubmitType.OTHER)) break block31;
                        int pOffset = offset;
                        int pLength = length;
                        while (pLength > 0) {
                            int currentLength = Math.min(pLength, 32768);
                            outputWriter.append(document.get(pOffset, currentLength));
                            pOffset += currentLength;
                            pLength -= currentLength;
                        }
                        break block32;
                    }
                    ITypedRegion[] partitions = document.getDocumentPartitioner().computePartitioning(offset, length);
                    SubMonitor m1 = m.newChild(20);
                    int workRemaining = partitions.length;
                    ITypedRegion[] iTypedRegionArray = partitions;
                    int n = partitions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block33: {
                            boolean truncate;
                            String text2;
                            ITypedRegion partition;
                            block35: {
                                String type;
                                block40: {
                                    block39: {
                                        block38: {
                                            block37: {
                                                block36: {
                                                    block34: {
                                                        partition = iTypedRegionArray[n2];
                                                        m1.setWorkRemaining(workRemaining--);
                                                        type = partition.getType();
                                                        text2 = null;
                                                        if (type == null) break block33;
                                                        truncate = false;
                                                        if (type != "org.eclipse.statet.nico.ui.InfoStream") break block34;
                                                        if (this.config.getTrackStreamInfo()) break block35;
                                                        break block33;
                                                    }
                                                    if (type != "org.eclipse.statet.nico.ui.InfoStream-OtherTasks") break block36;
                                                    if (this.config.getTrackStreamInfo() && this.config.getSubmitTypes().contains(SubmitType.OTHER)) break block35;
                                                    break block33;
                                                }
                                                if (type != "org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM") break block37;
                                                if (this.config.getTrackStreamInput()) break block35;
                                                break block33;
                                            }
                                            if (type != "org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM-OtherTasks") break block38;
                                            if (this.config.getTrackStreamInput() && this.config.getSubmitTypes().contains(SubmitType.OTHER)) break block35;
                                            break block33;
                                        }
                                        if (type != "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM") break block39;
                                        if (!this.config.getTrackStreamOutput()) break block33;
                                        truncate = this.config.getTrackStreamOutputTruncate();
                                        break block35;
                                    }
                                    if (type != "org.eclipse.statet.nico.ui.InfoStream-OtherTasks") break block40;
                                    if (!this.config.getTrackStreamOutput() || !this.config.getSubmitTypes().contains(SubmitType.OTHER)) break block33;
                                    truncate = this.config.getTrackStreamOutputTruncate();
                                    break block35;
                                }
                                if (type == "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM" ? !this.config.getTrackStreamOutput() : type == "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM-OtherTasks" && (!this.config.getTrackStreamOutput() || !this.config.getSubmitTypes().contains(SubmitType.OTHER))) break block33;
                            }
                            int pOffset = Math.max(offset, partition.getOffset());
                            int pLength = Math.min(offset + length, partition.getOffset() + partition.getLength()) - pOffset;
                            if (truncate) {
                                int firstLine = document.getLineOfOffset(pOffset);
                                int lastLine = document.getLineOfOffset(pOffset + pLength);
                                if (lastLine - firstLine + 1 > this.config.getTrackStreamOutputTruncateLines()) {
                                    pLength = document.getLineOffset(firstLine + this.config.getTrackStreamOutputTruncateLines()) - pOffset;
                                    text2 = "[...] (truncated)\n\n";
                                }
                            }
                            while (pLength > 0) {
                                int currentLength = Math.min(pLength, 32768);
                                outputWriter.append(document.get(pOffset, currentLength));
                                pOffset += currentLength;
                                pLength -= currentLength;
                            }
                            if (text2 != null) {
                                outputWriter.append(text2);
                            }
                        }
                        ++n2;
                    }
                }
                outputWriter.close();
                outputWriter = null;
                if (openInEditor) {
                    UIAccess.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            OpenTrackingFilesContributionItem.open("export", fileStore);
                        }
                    });
                }
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            if (outputWriter != null) {
                try {
                    outputWriter.close();
                }
                catch (IOException iOException) {}
            } else if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected static class ConfigurationPage
    extends WizardPage {
        private final NIConsolePage consolePage;
        private final TrackingConfiguration config;
        private final IObservableValue<Boolean> openValue;
        private TrackingConfigurationComposite configControl;
        private Button openControl;
        private DataBindingSupport dataBinding;

        public ConfigurationPage(NIConsolePage page, TrackingConfiguration config, boolean selectionMode) {
            super("ConfigureConsoleExportPage");
            this.consolePage = page;
            this.setTitle(selectionMode ? "Export Selected Output" : "Export Current Output");
            this.setDescription("Select the content to export and the destination file.");
            this.config = config;
            Realm realm = Realm.getDefault();
            this.openValue = new WritableValue(realm, (Object)false, Boolean.class);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)LayoutUtils.newContentGrid((int)1));
            this.configControl = this.createTrackingControl(composite);
            this.configControl.setLayoutData(new GridData(4, 128, true, false));
            this.configControl.getPathInput().getValidator().setOnLateResolve(4);
            this.configControl.getPathInput().setShowInsertVariable(true, (List)VariableFilterUtils.DEFAULT_NON_ITERACTIVE_FILTERS, (List)this.consolePage.getTool().getWorkspaceData().getStringVariables());
            this.configControl.setInput(this.config);
            Composite additionalOptions = this.createAdditionalOptions(composite);
            additionalOptions.setLayoutData((Object)new GridData(4, 128, true, false));
            LayoutUtils.addSmallFiller((Composite)composite, (boolean)true);
            ToolInfoGroup info = new ToolInfoGroup(composite, this.consolePage.getTool());
            info.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
            Dialog.applyDialogFont((Control)composite);
            this.setControl((Control)composite);
            this.configControl.getPathInput().setHistory(this.getDialogSettings().getArray(ExportConsoleOutputWizard.FILE_HISTORY_SETTINGSKEY));
            this.dataBinding = new DataBindingSupport((Control)composite);
            this.addBindings(this.dataBinding);
            WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dataBinding.getContext());
        }

        protected TrackingConfigurationComposite createTrackingControl(Composite parent) {
            return new TrackingConfigurationComposite(parent){

                @Override
                protected boolean enableFullMode() {
                    return false;
                }

                @Override
                protected boolean enableFilePathAsCombo() {
                    return true;
                }

                @Override
                protected EnumSet<SubmitType> getEditableSubmitTypes() {
                    return EnumSet.of(SubmitType.OTHER);
                }
            };
        }

        protected Composite createAdditionalOptions(Composite parent) {
            Group composite = new Group(parent, 0);
            composite.setText("Actions:");
            composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
            this.openControl = new Button((Composite)composite, 32);
            this.openControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.openControl.setText("Open in &Editor");
            return composite;
        }

        protected void addBindings(DataBindingSupport db) {
            this.configControl.addBindings(db);
            db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.openControl), this.openValue);
        }

        public boolean getOpenInEditor() {
            return (Boolean)this.openValue.getValue();
        }

        protected void saveSettings() {
            IDialogSettings settings = this.getDialogSettings();
            DialogUtils.saveHistorySettings((IDialogSettings)settings, (String)ExportConsoleOutputWizard.FILE_HISTORY_SETTINGSKEY, (String)this.config.getFilePath());
        }
    }
}

