/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ltk.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.statet.internal.ltk.core.AdapterFactory;
import org.eclipse.statet.internal.ltk.core.ExtContentTypeServices;
import org.eclipse.statet.internal.ltk.core.SourceUnitManagerImpl;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.ltk.core.IExtContentTypeManager;
import org.eclipse.statet.ltk.model.core.SourceUnitManager;
import org.osgi.framework.BundleContext;

public final class LtkCorePlugin
extends Plugin {
    public static final String BUNDLE_ID = "org.eclipse.statet.ltk.core";
    private static LtkCorePlugin instance;
    private static LtkCorePlugin gSafe;
    private boolean started;
    private final List<Disposable> disposables = new ArrayList<Disposable>();
    private ExtContentTypeServices contentTypeServices;
    private SourceUnitManagerImpl sourceUnitManagerImpl;
    private AdapterFactory modelAdapterFactory;

    public static LtkCorePlugin getInstance() {
        return instance;
    }

    public static LtkCorePlugin getSafe() {
        return gSafe;
    }

    public static void log(IStatus status) {
        LtkCorePlugin plugin = LtkCorePlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public LtkCorePlugin() {
        instance = this;
        gSafe = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
        LtkCorePlugin ltkCorePlugin = this;
        synchronized (ltkCorePlugin) {
            this.started = true;
            this.contentTypeServices = new ExtContentTypeServices();
            this.addStoppingListener(this.contentTypeServices);
            this.sourceUnitManagerImpl = new SourceUnitManagerImpl();
            this.addStoppingListener(this.sourceUnitManagerImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            LtkCorePlugin ltkCorePlugin = this;
            synchronized (ltkCorePlugin) {
                this.started = false;
                this.contentTypeServices = null;
                this.sourceUnitManagerImpl = null;
            }
            try {
                for (Disposable listener : this.disposables) {
                    listener.dispose();
                }
            }
            finally {
                this.disposables.clear();
            }
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoppingListener(Disposable listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        LtkCorePlugin ltkCorePlugin = this;
        synchronized (ltkCorePlugin) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.disposables.add(listener);
        }
    }

    public IExtContentTypeManager getContentTypeServices() {
        return this.contentTypeServices;
    }

    public SourceUnitManager getSourceUnitManager() {
        return this.sourceUnitManagerImpl;
    }

    public synchronized AdapterFactory getModelAdapterFactory() {
        if (this.modelAdapterFactory == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.modelAdapterFactory = new AdapterFactory("org.eclipse.statet.ltk.ModelAdapters");
        }
        return this.modelAdapterFactory;
    }
}

