/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.services;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.rj.data.RLanguage;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.services.FQRObjectRef;

@NonNullByDefault
public class BasicFQRObjectRef<THandle>
implements FQRObjectRef<THandle> {
    private final THandle rHandle;
    private final RObject env;
    private final RObject name;

    private static boolean isValidEnvObject(RObject env) {
        switch (env.getRObjectType()) {
            case 14: {
                return ((RReference)env).getReferencedRObjectType() == 8;
            }
            case 12: {
                return ((RLanguage)env).getLanguageType() == 3;
            }
        }
        return false;
    }

    private static boolean isValidNameObject(RObject env) {
        switch (env.getRObjectType()) {
            case 12: {
                switch (((RLanguage)env).getLanguageType()) {
                    case 1: 
                    case 3: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public BasicFQRObjectRef(THandle rHandle, RObject env, RObject name) {
        if (env == null) {
            throw new NullPointerException("env");
        }
        if (!BasicFQRObjectRef.isValidEnvObject(env)) {
            throw new IllegalArgumentException("env");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (!BasicFQRObjectRef.isValidNameObject(name)) {
            throw new IllegalArgumentException("name");
        }
        this.rHandle = rHandle;
        this.env = env;
        this.name = name;
    }

    @Override
    public THandle getRHandle() {
        return this.rHandle;
    }

    @Override
    public RObject getEnv() {
        return this.env;
    }

    @Override
    public RObject getName() {
        return this.name;
    }

    public String toString() {
        return this.env + "\n" + this.name.toString();
    }
}

