/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.Arrays;
import java.util.Spliterators;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import org.eclipse.statet.internal.jcommons.collections.AbstractImLongList;
import org.eclipse.statet.jcommons.collections.LongList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ImLongArrayList
extends AbstractImLongList {
    private final long[] array;

    public ImLongArrayList(long[] array) {
        this.array = array;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    @Override
    public boolean contains(long element) {
        return this.indexOf(element) >= 0;
    }

    @Override
    public long getAt(int index) {
        if (index < 0 || index >= this.array.length) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return this.array[index];
    }

    @Override
    public int indexOf(long element) {
        int i = 0;
        while (i < this.array.length) {
            if (this.array[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(long element) {
        int i = this.array.length - 1;
        while (i >= 0) {
            if (this.array[i] == element) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public LongStream stream() {
        return StreamSupport.longStream(Spliterators.spliterator(this.array, 1040), false);
    }

    @Override
    public long[] toArray() {
        return Arrays.copyOf(this.array, this.array.length);
    }

    public int hashCode() {
        int hashCode = 7;
        int i = 0;
        while (i < this.array.length) {
            hashCode = 31 * hashCode + Long.hashCode(this.array[i]);
            ++i;
        }
        return hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LongList) {
            LongList other = (LongList)obj;
            if (this.array.length != other.size()) {
                return false;
            }
            int i = 0;
            while (i < this.array.length) {
                if (this.array[i] != other.getAt(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }
}

