/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.HeadingAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.LabelInfo;
import org.eclipse.statet.docmlet.wikitext.core.source.SourceHeadingAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.SourceTextBlockAttributes;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonRegex;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Lines;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.References;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockType;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.TextSegment;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.ParagraphBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlineParser;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.ReferenceDefinition;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class ParagraphAndTheLikeBlock
extends ParagraphBlock<ParagraphOrTheLikeBlockNode> {
    private static final Pattern SETEXT_UNDERLINE_PATTERN = Pattern.compile("(=+|-+)[ \t]*", 32);
    private static final int SETEXT_UNDERLINE_GROUP = 1;
    private static final Pattern REFDEF_LABEL_PATTERN = Pattern.compile("((?:\\\\.|[^\\[\\]]){0,1000})(?:(\\]\\:)(?:[ \t]*([^ \t].+)?)?)?");
    private static final int REFDEF_LABEL_CHARS_GROUP = 1;
    private static final int REFDEF_LABEL_DEFSEP_GROUP = 2;
    private static final int REFDEF_LABEL_LINK_GROUP = 3;
    private final Matcher refDefLabelMatcher = REFDEF_LABEL_PATTERN.matcher("");
    private final Matcher setextMatcher = SETEXT_UNDERLINE_PATTERN.matcher("");

    public ParagraphAndTheLikeBlock() {
    }

    public ParagraphAndTheLikeBlock(ImCollection<Class<? extends SourceBlockType<?>>> interruptExclusions) {
        super(interruptExclusions);
    }

    @Override
    public void createNodes(SourceBlocks.SourceBlockBuilder builder) {
        LineSequence lineSequence = builder.getLineSequence();
        ParagraphOrTheLikeBlockNode node = new ParagraphOrTheLikeBlockNode(this, builder);
        ReferenceDefParser referenceDefParser = null;
        Line line = (Line)ObjectUtils.nonNullAssert((Object)lineSequence.getCurrentLine());
        if (!line.isBlank() && line.getText().charAt(line.getIndentLength()) == '[' && (referenceDefParser = new ReferenceDefParser(node).process(builder)) != null) {
            if (referenceDefParser.isCompleteNoContinue()) {
                node.refDef = referenceDefParser;
                return;
            }
        } else {
            lineSequence.advance();
        }
        while ((line = lineSequence.getCurrentLine()) != null && !line.isBlank()) {
            Matcher setextMatcher;
            if (!line.isLazy() && line.getIndent() < 4 && (setextMatcher = line.setupIndent(this.setextMatcher)).matches()) {
                if (referenceDefParser != null && referenceDefParser.isComplete()) {
                    node.refDef = referenceDefParser;
                    return;
                }
                node.headingLevel = this.getHeadingLevel(setextMatcher, line);
                lineSequence.advance();
                return;
            }
            if (this.isAnotherBlockStart(lineSequence, builder.getSourceBlocks(), node)) break;
            if (referenceDefParser != null && (referenceDefParser = referenceDefParser.process(builder)) != null) {
                if (!referenceDefParser.isCompleteNoContinue()) continue;
                node.refDef = referenceDefParser;
                return;
            }
            lineSequence.advance();
        }
        if (referenceDefParser != null && referenceDefParser.isComplete()) {
            node.refDef = referenceDefParser;
        }
    }

    private byte getHeadingLevel(Matcher matcher, Line line) {
        switch (line.getText().charAt(matcher.start(1))) {
            case '=': {
                return 1;
            }
            case '-': {
                return 2;
            }
        }
        throw new IllegalStateException();
    }

    private ReferenceDefinition getReferenceDefinition(ProcessingContext context, ParagraphOrTheLikeBlockNode node) {
        ReferenceDefinition inline;
        Object obj = ObjectUtils.nonNullAssert((Object)node.refDef);
        if (obj instanceof ReferenceDefParser) {
            inline = ((ReferenceDefParser)obj).createInline(node, context);
            node.refDef = inline;
        } else {
            inline = (ReferenceDefinition)obj;
        }
        return inline;
    }

    @Override
    public void initializeContext(ProcessingContext context, ParagraphOrTheLikeBlockNode node) {
        if (node.refDef != null) {
            ReferenceDefinition inline = this.getReferenceDefinition(context, node);
            context.addReferenceDef(inline.getLabel(), inline.getHref(), inline.getTitle());
        }
    }

    @Override
    public void emit(ProcessingContext context, ParagraphOrTheLikeBlockNode node, CommonmarkLocator locator, DocumentBuilder builder) {
        if (node.refDef != null) {
            this.emitRefDef(context, node, locator, builder);
        } else if (node.headingLevel > 0) {
            this.emitHeading(context, node, locator, builder);
        } else {
            this.emitParagraph(context, node, true, locator, builder);
        }
    }

    private void emitHeading(ProcessingContext context, ParagraphOrTheLikeBlockNode node, CommonmarkLocator locator, DocumentBuilder builder) {
        ImList<Line> lines = node.getLines();
        ImList<Line> textLines = Lines.trimWhitespace(lines, 0, lines.size() - 1);
        if (!textLines.isEmpty()) {
            TextSegment textSegment = new TextSegment(textLines);
            SourceHeadingAttributes attributes = new SourceHeadingAttributes(0);
            InlineParser inlineParser = context.getInlineParser();
            String headingText = inlineParser.toStringContent(context, textSegment);
            attributes.setId(context.generateHeadingId(node.headingLevel, headingText));
            locator.setBlockBegin(node);
            builder.beginHeading((int)node.headingLevel, (Attributes)attributes);
            List<Inline> inlines = inlineParser.parse(context, textSegment, true);
            InlineParser.emit(context, inlines, locator, builder);
            locator.setBlockEnd(node);
            builder.endHeading();
        } else {
            locator.setBlockBegin(node);
            builder.beginHeading((int)node.headingLevel, (Attributes)new HeadingAttributes());
            locator.setBlockEnd(node);
            builder.endHeading();
        }
    }

    private void emitRefDef(ProcessingContext context, ParagraphOrTheLikeBlockNode node, CommonmarkLocator locator, DocumentBuilder builder) {
        if (context.getMode() == 3) {
            TextSegment textSegment = new TextSegment(node.getLines());
            ImList inlines = ImCollections.newList((Object)this.getReferenceDefinition(context, node));
            locator.setBlockBegin(node);
            SourceTextBlockAttributes attributes = new SourceTextBlockAttributes(textSegment.getLines(), 256);
            builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, (Attributes)attributes);
            InlineParser.emit(context, (List<Inline>)inlines, locator, builder);
            locator.setBlockEnd(node);
            builder.endBlock();
        }
    }

    static final class ParagraphOrTheLikeBlockNode
    extends ParagraphBlock.ParagraphBlockNode<ParagraphAndTheLikeBlock> {
        private byte headingLevel;
        private @Nullable Object refDef;

        public ParagraphOrTheLikeBlockNode(ParagraphAndTheLikeBlock type, SourceBlocks.SourceBlockBuilder builder) {
            super(type, builder);
        }

        @Override
        public boolean isParagraph() {
            return this.headingLevel == 0;
        }
    }

    private static class ReferenceDefParser {
        private static final byte START = 0;
        private static final byte IN_LABEL = 1;
        private static final byte DEFSEP = 2;
        private static final byte LINK = 3;
        private static final byte IN_TITLE = 4;
        private static final byte COMPLETE = 5;
        private final ParagraphOrTheLikeBlockNode node;
        private byte state;
        private int stateDetail;
        private String label = "";
        private int labelStartOffset = -1;
        private int labelEndOffset;
        private String escapedUri;
        private @Nullable String escapedTitle;
        private int endOffset;

        private ReferenceDefParser(ParagraphOrTheLikeBlockNode node) {
            this.node = node;
            this.state = 0;
        }

        public @Nullable ReferenceDefParser process(SourceBlocks.SourceBlockBuilder builder) {
            LineSequence lineSequence = builder.getLineSequence();
            byte orgState = this.state;
            Line line = (Line)ObjectUtils.nonNullAssert((Object)lineSequence.getCurrentLine());
            switch (this.state) {
                case 0: {
                    this.checkLabel(line, line.getIndentLength() + 1);
                    break;
                }
                case 1: {
                    this.checkLabel(line, line.getIndentLength());
                    break;
                }
                case 2: {
                    this.checkLink(line, line.getIndentLength());
                    break;
                }
                case 3: {
                    this.checkTitleStart(line, line.getIndentLength());
                    break;
                }
                case 4: {
                    this.checkTitleEnd(line, line.getIndentLength());
                    break;
                }
                default: {
                    this.state = (byte)-1;
                }
            }
            switch (this.state) {
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    lineSequence.advance();
                    return this;
                }
                case 4: {
                    this.state = this.completeInTitle(builder);
                    break;
                }
                default: {
                    this.state = (byte)-1;
                }
            }
            if (this.state == -1 && orgState == 3) {
                this.state = (byte)5;
            }
            return this.state == 5 ? this : null;
        }

        private byte completeInTitle(SourceBlocks.SourceBlockBuilder builder) {
            assert (this.state == 4);
            ArrayList<String> titleSegments = new ArrayList<String>();
            CollectionUtils.addNonNull(titleSegments, (Object)this.escapedTitle);
            LineSequence lineSequence = builder.getLineSequence();
            LineSequence lookAhead = lineSequence.lookAhead();
            do {
                lookAhead.advance();
                this.escapedTitle = null;
                this.checkTitleEnd(builder, lookAhead);
                CollectionUtils.addNonNull(titleSegments, (Object)this.escapedTitle);
            } while (this.state == 4);
            if (this.state == 5) {
                this.escapedTitle = builder.getParseHelper().joinLines(titleSegments);
                ParagraphAndTheLikeBlock.advanceLinesUpto(lineSequence, lookAhead.getCurrentLine().getLineNumber() + 1);
                return 5;
            }
            return -1;
        }

        public boolean isComplete() {
            return this.state == 3 || this.state == 5;
        }

        public boolean isCompleteNoContinue() {
            return this.state == 5;
        }

        private ReferenceDefinition createInline(ParagraphOrTheLikeBlockNode node, ProcessingContext context) {
            assert (this.isComplete());
            LabelInfo labelInfo = new LabelInfo(context.normalizeLabel(this.label), this.labelStartOffset, this.labelEndOffset);
            String uri = References.normalizeUri(context.getHelper().replaceEscaping(this.escapedUri));
            String escapedTitle = this.escapedTitle;
            String title = escapedTitle != null && !escapedTitle.isEmpty() ? context.getHelper().replaceEscaping(escapedTitle) : null;
            Line startLine = (Line)node.getLines().get(0);
            int startOffset = startLine.getStartOffset() + startLine.getIndentLength();
            return new ReferenceDefinition(startLine, startOffset, this.endOffset - startOffset, uri, title, labelInfo);
        }

        private void checkLabel(Line line, int offset) {
            int index;
            assert (this.state >= 0 && this.state <= 1);
            Matcher matcher = line.setup(((ParagraphAndTheLikeBlock)this.node.getType()).refDefLabelMatcher, offset, line.getText().length());
            if (!matcher.matches()) {
                this.state = (byte)-1;
                return;
            }
            String label0 = matcher.group(1);
            this.stateDetail += label0.length();
            if (this.stateDetail >= 1000) {
                this.state = (byte)-1;
                return;
            }
            String string = this.label = this.label.isEmpty() ? label0 : String.valueOf(this.label) + ' ' + label0;
            if (this.labelStartOffset == -1) {
                index = CommonRegex.indexOfNonWhitespace(line.getText(), matcher.start(1), matcher.end(1));
                if (index >= 0) {
                    this.labelStartOffset = line.getStartOffset() + index;
                    this.labelEndOffset = line.getStartOffset() + CommonRegex.indexOfNonWhitespaceEnd(line.getText(), matcher.start(1), matcher.end(1));
                }
            } else {
                index = CommonRegex.indexOfNonWhitespaceEnd(line.getText(), matcher.start(1), matcher.end(1));
                if (index >= 0) {
                    this.labelEndOffset = line.getStartOffset() + index;
                }
            }
            if (matcher.start(2) == -1) {
                this.state = 1;
                return;
            }
            if (this.labelStartOffset == -1) {
                this.state = (byte)-1;
                return;
            }
            this.state = (byte)2;
            int linkStart = matcher.start(3);
            if (linkStart != -1) {
                this.checkLink(line, linkStart);
            }
        }

        private void checkLink(Line line, int offset) {
            assert (this.state == 2);
            String text = line.getText();
            References.LinkDestination destination = References.readLinkDestination(line.getText(), offset);
            if (destination == null) {
                this.state = (byte)-1;
                return;
            }
            this.escapedUri = destination.getEscapedUri();
            this.endOffset = line.getStartOffset() + destination.getEndOffset();
            offset = destination.getEndOffset();
            while (offset < text.length() && text.charAt(offset) == ' ') {
                ++offset;
            }
            this.state = (byte)3;
            if (offset < text.length()) {
                this.checkTitleStart(line, offset);
            }
        }

        private void checkTitleStart(Line line, int offset) {
            assert (this.state == 3);
            String text = line.getText();
            switch (text.charAt(offset++)) {
                case '\"': {
                    this.stateDetail = 34;
                    break;
                }
                case '\'': {
                    this.stateDetail = 39;
                    break;
                }
                case '(': {
                    this.stateDetail = 40;
                    break;
                }
                default: {
                    this.state = (byte)-1;
                    return;
                }
            }
            this.state = (byte)4;
            this.checkTitleEnd(line, offset);
        }

        private void checkTitleEnd(SourceBlocks.SourceBlockBuilder builder, LineSequence lineSequence) {
            assert (this.state == 4);
            Line line = lineSequence.getCurrentLine();
            if (line == null || line.isBlank() || ((ParagraphAndTheLikeBlock)this.node.getType()).isAnotherBlockStart(lineSequence, builder.getSourceBlocks(), builder.getCurrentNode())) {
                this.state = (byte)-1;
                return;
            }
            this.checkTitleEnd(line, line.getIndentLength());
        }

        private void checkTitleEnd(Line line, int startOffset) {
            assert (this.state == 4);
            String text = line.getText();
            char sep = (char)this.stateDetail;
            int offset = startOffset;
            while (offset < text.length()) {
                char c;
                if ((c = text.charAt(offset++)) == '\\') {
                    ++offset;
                    continue;
                }
                if (c != sep) continue;
                if (CommonRegex.indexOfNonWhitespace(text, offset, text.length()) == -1) {
                    this.state = (byte)5;
                    this.endOffset = line.getStartOffset() + offset;
                    this.escapedTitle = text.substring(startOffset, offset - 1);
                    return;
                }
                this.state = (byte)-1;
                return;
            }
            this.escapedTitle = text.substring(startOffset, offset);
        }
    }
}

