/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolProcess;

public abstract class DocProcessingToolOperationContext {
    private static final byte S_CANCELED = 1;
    private static final byte S_START = 16;
    private static final byte S_PROCESSING = 32;
    private static final byte S_FINISHED = 112;
    private volatile byte state;
    private Runnable runnable;
    private Exception error;

    public synchronized void start(DocProcessingToolProcess toolProcess, Runnable runnable, SubMonitor m) throws Exception {
        if (toolProcess == null) {
            throw new NullPointerException("tool");
        }
        if (runnable == null) {
            throw new NullPointerException("runnable");
        }
        this.state = (byte)16;
        this.runnable = runnable;
        this.error = null;
        try {
            this.start(toolProcess, m);
            block9: while (this.state < 112) {
                try {
                    switch (this.state) {
                        case 17: {
                            this.canceling(false);
                            break block9;
                        }
                        case 33: {
                            this.canceling(true);
                        }
                        default: {
                            this.notifyAll();
                            this.wait(100L);
                            break;
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.error != null) {
                throw this.error;
            }
            if (this.isCanceled()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
        }
        finally {
            this.runnable = null;
            this.error = null;
        }
    }

    public final synchronized void cancel() {
        this.state = (byte)(this.state | 1);
        this.notifyAll();
    }

    public boolean isCanceled() {
        return (this.state & 1) != 0;
    }

    public abstract String getId();

    public abstract String getLabel();

    protected abstract void start(DocProcessingToolProcess var1, SubMonitor var2) throws CoreException;

    protected void canceling(boolean running) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInContext() {
        block18: {
            Runnable runnable;
            DocProcessingToolOperationContext docProcessingToolOperationContext = this;
            synchronized (docProcessingToolOperationContext) {
                if (this.state != 16) {
                    return;
                }
                this.state = (byte)32;
                runnable = this.runnable;
            }
            try {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    this.error = e;
                    DocProcessingToolOperationContext docProcessingToolOperationContext2 = this;
                    synchronized (docProcessingToolOperationContext2) {
                        this.state = (byte)112;
                        this.notifyAll();
                        break block18;
                    }
                }
            }
            catch (Throwable throwable) {
                DocProcessingToolOperationContext docProcessingToolOperationContext3 = this;
                synchronized (docProcessingToolOperationContext3) {
                    this.state = (byte)112;
                    this.notifyAll();
                }
                throw throwable;
            }
            DocProcessingToolOperationContext docProcessingToolOperationContext4 = this;
            synchronized (docProcessingToolOperationContext4) {
                this.state = (byte)112;
                this.notifyAll();
            }
        }
    }
}

