/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.debug.core.sourcelookup;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.DefaultSourceContainer;
import org.eclipse.statet.internal.r.debug.core.sourcelookup.RSourceLookupParticipant;
import org.eclipse.statet.r.debug.core.sourcelookup.AllRProjectsSourceContainer;
import org.eclipse.statet.r.debug.core.sourcelookup.RSourceLookupMatch;

public class RSourceLookupDirector
extends AbstractSourceLookupDirector {
    private static final Set<String> gFilteredSourceContainerTypes = new HashSet<String>();

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        this.dispose();
        this.setLaunchConfiguration(configuration);
        this.setSourceContainers(new ISourceContainer[]{new AllRProjectsSourceContainer(), new DefaultSourceContainer()});
        this.initializeParticipants();
    }

    public void initializeParticipants() {
        this.addParticipants(new ISourceLookupParticipant[]{new RSourceLookupParticipant()});
    }

    public boolean supportsSourceContainerType(ISourceContainerType type) {
        return !gFilteredSourceContainerTypes.contains(type.getId());
    }

    protected void cacheResolvedElement(List duplicates, Object sourceElement) {
        if (sourceElement instanceof RSourceLookupMatch) {
            ((RSourceLookupMatch)sourceElement).select();
        }
        super.cacheResolvedElement(duplicates, sourceElement);
    }
}

