/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.apps.ui.launching;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.databinding.core.observable.ObservableUtils;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigTabWithDbc;
import org.eclipse.statet.ecommons.templates.TemplateVariableProcessor;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.r.apps.ui.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ui.sourceediting.SnippetEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SnippetEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.r.apps.ui.RAppUIResources;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.ui.sourceediting.RTemplateSourceViewerConfigurator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class AppControlConfigViewTab
extends LaunchConfigTabWithDbc
implements IValueChangeListener<Object> {
    private ImList<ViewerItem> viewers;
    private IObservableValue<ViewerItem> viewerValue;
    private IObservableValue<String> variablesCodeValue;
    private IObservableValue<Boolean> variablesActionValue;
    private ComboViewer viewerSelectionViewer;
    private StackLayout viewerDetailLayout;
    private Composite viewerDetailControl;
    private SnippetEditor variablesCodeEditor;
    private Button variablesActionControl;

    static void initDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.statet.r.apps/Viewer.id", "workbench-view");
        config.setAttribute("org.eclipse.statet.r.apps/Variables.Viewer.action", "show");
    }

    public AppControlConfigViewTab() {
        Realm realm = this.getRealm();
        this.viewerValue = new WritableValue(realm, null, String.class);
        this.viewerValue.addValueChangeListener((IValueChangeListener)this);
        this.viewers = ImCollections.newList((Object[])new ViewerItem[]{new ViewerItem(null, Messages.Operation_Viewer_None_label), new ViewerItem("workbench-view", Messages.Operation_Viewer_WorkbenchView_label), new ViewerItem(this, "workbench-external", Messages.Operation_Viewer_WorkbenchExternal_label){

            @Override
            protected Composite createControl(Composite parent) {
                Composite composite = super.createControl(parent);
                composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
                LayoutUtils.addSmallFiller((Composite)composite, (boolean)true);
                Link link = new Link(composite, 0);
                link.setText("Global preferences: <a href=\"org.eclipse.ui.browser.preferencePage\">Web Browser</a>.");
                composite.setLayoutData((Object)new GridData(4, 1024, true, false));
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)e.text, null, null);
                        if (dialog != null) {
                            dialog.open();
                        }
                    }
                });
                return composite;
            }
        }});
        this.variablesCodeValue = new WritableValue(realm, (Object)"", String.class);
        this.variablesActionValue = new WritableValue(realm, (Object)true, Boolean.TYPE);
    }

    public Image getImage() {
        return (Image)ObjectUtils.nonNullAssert((Object)RAppUIResources.INSTANCE.getImage("org.eclipse.statet.r.apps/image/tool/View"));
    }

    public String getName() {
        return Messages.Operation_ViewTab_name;
    }

    public String getLabel() {
        return Messages.Operation_ViewTab_label;
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComposite.setLayout((Layout)new GridLayout());
        Label label = new Label(mainComposite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label.setText(String.valueOf(this.getLabel()) + ':');
        Composite composite = this.createViewerSettings(mainComposite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite = this.createVariablesSettings(mainComposite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Dialog.applyDialogFont((Control)parent);
        this.initBindings();
    }

    private ViewerItem getViewerItem(String id) {
        for (ViewerItem item : this.viewers) {
            if (item.getId() != id) continue;
            return item;
        }
        return (ViewerItem)this.viewers.get(0);
    }

    private Composite createViewerSettings(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText(String.valueOf(Messages.Operation_ViewTab_Operation_label) + ':');
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
        ComboViewer viewer = new ComboViewer((Composite)composite);
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput(this.viewers);
        viewer.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.viewerSelectionViewer = viewer;
        Composite detailControl = new Composite((Composite)composite, 0);
        this.viewerDetailLayout = new StackLayout();
        detailControl.setLayout((Layout)this.viewerDetailLayout);
        detailControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewerDetailControl = detailControl;
        return composite;
    }

    private Composite createVariablesSettings(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText(String.valueOf(Messages.Operation_Variables_label) + ':');
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)2));
        Label label = new Label((Composite)composite, 0);
        label.setText(String.valueOf(Messages.Operation_Variables_RCode_label) + ':');
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        TemplateVariableProcessor templateVariableProcessor = new TemplateVariableProcessor();
        RTemplateSourceViewerConfigurator configurator = new RTemplateSourceViewerConfigurator(RCore.getWorkbenchAccess(), templateVariableProcessor);
        SnippetEditor1 editor = new SnippetEditor1((SourceEditorViewerConfigurator)configurator, null, (IServiceLocator)PlatformUI.getWorkbench(), "org.eclipse.statet.r.ui/launchingconfig");
        editor.create((Composite)composite, 33556484);
        GridData gd = new GridData(4, 4, true, false);
        gd.heightHint = LayoutUtils.hintHeight((StyledText)editor.getSourceViewer().getTextWidget(), (int)1);
        editor.getControl().setLayoutData((Object)gd);
        this.variablesCodeEditor = editor;
        Button button = new Button((Composite)composite, 32);
        button.setText(Messages.Operation_Variables_ShowView_label);
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.variablesActionControl = button;
        return composite;
    }

    protected void addBindings(DataBindingContext dbc) {
        dbc.bindValue((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.viewerSelectionViewer), this.viewerValue);
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.variablesCodeEditor.getTextControl()), this.variablesCodeValue);
        dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.variablesActionControl), this.variablesActionValue);
    }

    public void handleValueChange(ValueChangeEvent<?> event) {
        if (event.getObservable() == this.viewerValue) {
            ViewerItem newItem;
            ViewerItem oldItem = (ViewerItem)ObservableUtils.typed(event, this.viewerValue).diff.getOldValue();
            if (oldItem != null) {
                oldItem.disable();
            }
            this.viewerDetailLayout.topControl = (newItem = (ViewerItem)ObservableUtils.typed(event, this.viewerValue).diff.getNewValue()) != null ? newItem.enable() : null;
            this.viewerDetailControl.layout();
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        AppControlConfigViewTab.initDefaults(configuration);
    }

    protected void doInitialize(ILaunchConfiguration configuration) {
        String id = this.readAttribute(configuration, "org.eclipse.statet.r.apps/Viewer.id", "").intern();
        ViewerItem item = this.getViewerItem(id);
        this.viewerValue.setValue((Object)item);
        String code = this.readAttribute(configuration, "org.eclipse.statet.r.apps/Variables.code", "");
        this.variablesCodeValue.setValue((Object)code);
        String action = this.readAttribute(configuration, "org.eclipse.statet.r.apps/Variables.Viewer.action", "");
        this.variablesActionValue.setValue((Object)action.equals("show"));
    }

    protected void doSave(ILaunchConfigurationWorkingCopy configuration) {
        ViewerItem item = (ViewerItem)this.viewerValue.getValue();
        configuration.setAttribute("org.eclipse.statet.r.apps/Viewer.id", item.getId());
        String code = (String)this.variablesCodeValue.getValue();
        configuration.setAttribute("org.eclipse.statet.r.apps/Variables.code", code);
        Boolean enabled = (Boolean)this.variablesActionValue.getValue();
        configuration.setAttribute("org.eclipse.statet.r.apps/Variables.Viewer.action", enabled != false ? "show" : null);
    }

    private class ViewerItem {
        private final @Nullable String id;
        private final String label;
        private @Nullable Composite detailControl;

        public ViewerItem(String id, String label) {
            this.id = id;
            this.label = label;
        }

        public @Nullable String getId() {
            return this.id;
        }

        public String toString() {
            return this.label;
        }

        public @Nullable Composite enable() {
            Composite control = this.detailControl;
            if (this.id != null && control == null) {
                this.detailControl = control = this.createControl(AppControlConfigViewTab.this.viewerDetailControl);
            }
            return control;
        }

        public void disable() {
        }

        protected Composite createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            return composite;
        }
    }
}

