/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.impl;

import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.core.SourceModelStamp;

@NonNullByDefault
public class BasicSourceModelStamp
implements SourceModelStamp {
    private final long sourceStamp;
    private final ImList<Object> sourceConfigs;

    public BasicSourceModelStamp(long sourceStamp, ImList<Object> sourceConfigs) {
        this.sourceStamp = sourceStamp;
        this.sourceConfigs = (ImList)ObjectUtils.nonNullAssert(sourceConfigs);
    }

    public BasicSourceModelStamp(long sourceStamp) {
        this.sourceStamp = sourceStamp;
        this.sourceConfigs = ImCollections.emptyList();
    }

    @Override
    public final long getContentStamp() {
        return this.sourceStamp;
    }

    public int hashCode() {
        int h = (int)(this.sourceStamp ^ this.sourceStamp >>> 32);
        h = 31 * h + this.sourceConfigs.hashCode();
        return h;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof BasicSourceModelStamp && this.getClass() == obj.getClass()) {
            BasicSourceModelStamp other = (BasicSourceModelStamp)obj;
            return this.sourceStamp == other.sourceStamp && this.sourceConfigs.equals(other.sourceConfigs);
        }
        return false;
    }

    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder(BasicSourceModelStamp.class);
        sb.append(' ', this.sourceStamp);
        sb.addProp("sourceConfigs", this.sourceConfigs);
        return sb.toString();
    }
}

