/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.ecommons.waltable.data.IDataProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.AbstractRDataProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataTableContentDescription;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.statet.r.ui.dataeditor.RDataTableInput;
import org.eclipse.statet.r.ui.dataeditor.RDataTableVariable;
import org.eclipse.statet.rj.data.RDataFrame;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.util.dataaccess.LazyRStore;
import org.eclipse.statet.rj.services.util.dataaccess.RDataFrameDataAdapter;
import org.eclipse.statet.rj.ts.core.RToolService;

public class RDataFrameDataProvider
extends AbstractRDataProvider<RDataFrame> {
    public RDataFrameDataProvider(RDataTableInput input, RDataFrame struct) throws CoreException {
        super(input, new RDataFrameDataAdapter(), struct);
        this.reset();
    }

    @Override
    protected RDataTableContentDescription loadDescription(RElementName name, RDataFrame struct, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        RDataTableContentDescription description = new RDataTableContentDescription(name, (RObject)struct, r.getTool());
        int columnCount = (int)this.getColumnCount();
        description.setRowHeaderColumns(this.createNamesColumn("attr(" + this.getInput().getFullName() + ", 'row.names', exact= TRUE)", struct.getRowCount(), r, m));
        RDataTableVariable[] dataColumns = new RDataTableColumn[columnCount];
        int i = 0;
        while (i < columnCount) {
            String columnName = struct.getColumnNames().getChar(i);
            RElementName elementName = RElementName.create((List)ImCollections.newList((Object[])new RElementName[]{BASE_NAME, RElementName.create((int)26, (String)columnName, (int)(i + 1))}));
            dataColumns[i] = this.createColumn(struct.getColumn(i), String.valueOf(this.getInput().getFullName()) + "[[" + (i + 1) + "]]", elementName, i, columnName, r, m);
            ++i;
        }
        description.setDataColumns((RDataTableColumn[])dataColumns);
        description.setVariables(dataColumns);
        return description;
    }

    @Override
    protected void appendOrderCmd(StringBuilder cmd, AbstractRDataProvider.SortColumn sortColumn) {
        cmd.append("order(");
        cmd.append(this.getInput().getFullName());
        cmd.append("[[");
        cmd.append(sortColumn.getIdx() + 1L);
        cmd.append("]], decreasing=");
        cmd.append(sortColumn.decreasing ? "TRUE" : "FALSE");
        cmd.append(')');
    }

    @Override
    protected Object getDataValue(LazyRStore.Fragment<RDataFrame> fragment, long rowIdx, long columnIdx) {
        return ((RDataFrame)fragment.getRObject()).getColumn(fragment.toLocalColumnIdx(columnIdx)).get(fragment.toLocalRowIdx(rowIdx));
    }

    @Override
    public IDataProvider createColumnDataProvider() {
        return new AbstractRDataProvider.ColumnDataProvider(this){

            @Override
            public Object getDataValue(long columnIndex, long rowIndex, int flags, IProgressMonitor monitor) {
                return ((RDataFrame)RDataFrameDataProvider.this.getRObject()).getName(columnIndex);
            }
        };
    }

    @Override
    protected Object getColumnName(LazyRStore.Fragment<RDataFrame> fragment, long columnIdx) {
        return ((RDataFrame)fragment.getRObject()).getName(fragment.toLocalColumnIdx(columnIdx));
    }
}

