/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class RSymbolComparator
implements Comparator<String> {
    public static final Collator R_NAMES_COLLATOR = Collator.getInstance((Locale)Locale.ENGLISH);

    static {
        ((RuleBasedCollator)R_NAMES_COLLATOR).setUpperCaseFirst(true);
    }

    @Override
    public int compare(String name1, String name2) {
        return R_NAMES_COLLATOR.compare(this.check(name1), this.check(name2));
    }

    private String check(String name) {
        if (name.length() > 0 && name.charAt(0) == '`') {
            return name.substring(1);
        }
        return name;
    }

    public static final class PrefixPattern {
        private final char[] prefix;

        public PrefixPattern(String namePrefix) {
            this.prefix = namePrefix.toLowerCase().toCharArray();
        }

        public boolean matches(@Nullable String candidate) {
            if (candidate == null || candidate.isEmpty()) {
                return false;
            }
            if (this.prefix.length == 0) {
                return candidate.charAt(0) != '.';
            }
            char pC = this.prefix[0];
            char cC = Character.toLowerCase(candidate.charAt(0));
            if (cC != pC) {
                return false;
            }
            int pIdx = 0;
            int cIdx = 0;
            while (true) {
                if (pC == cC) {
                    if (++pIdx >= this.prefix.length) {
                        return true;
                    }
                    if (++cIdx >= candidate.length()) {
                        return false;
                    }
                    pC = this.prefix[pIdx];
                    cC = Character.toLowerCase(candidate.charAt(cIdx));
                    continue;
                }
                if (pC == '.' || pC == '_') {
                    if (++pIdx >= this.prefix.length) {
                        return true;
                    }
                    pC = this.prefix[pIdx];
                    continue;
                }
                if (cC != '.' && cC != '_') break;
                if (++cIdx >= candidate.length()) {
                    return false;
                }
                cC = Character.toLowerCase(candidate.charAt(cIdx));
            }
            return false;
        }
    }
}

