/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.statet.ecommons.text.BasicHeuristicTokenScanner;
import org.eclipse.statet.ecommons.text.ICharPairMatcher;
import org.eclipse.statet.ecommons.text.ITokenScanner;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;

public class PairMatcher
implements ICharPairMatcher {
    private static final char IGNORE = '\n';
    private static final byte NOTHING_FOUND = 0;
    private static final byte OPENING_NOT_FOUND = 1;
    private static final byte CLOSING_NOT_FOUND = 2;
    private static final byte PAIR_FOUND = 3;
    protected final char[][] pairs;
    protected final String partitioning;
    protected final String[] applicablePartitions;
    protected final char escapeChar;
    protected final ITokenScanner scanner;
    protected int offset;
    protected int beginPos;
    protected int endPos;
    protected int anchor;
    protected String partition;

    public PairMatcher(char[][] pairs, String partitioning, String[] partitions, ITokenScanner scanner, char escapeChar) {
        this.pairs = pairs;
        this.scanner = scanner;
        this.partitioning = partitioning;
        this.applicablePartitions = partitions;
        this.escapeChar = escapeChar;
    }

    public PairMatcher(char[][] pairs, DocContentSections documentContentInfo, String[] partitions, char escapeChar) {
        this(pairs, documentContentInfo.getPartitioning(), partitions, new BasicHeuristicTokenScanner(documentContentInfo, partitionType -> {
            int i = 0;
            while (i < partitions.length) {
                if (partitions[i] == partitionType) {
                    return true;
                }
                ++i;
            }
            return false;
        }), escapeChar);
    }

    public char[][] getPairs(IDocument document, int offset) {
        return this.pairs;
    }

    @Override
    public IRegion match(IDocument document, int offset) {
        if (document == null || offset < 0) {
            return null;
        }
        this.offset = offset;
        if (this.matchPairsAt(document, true) == 3) {
            return new Region(this.beginPos, this.endPos - this.beginPos + 1);
        }
        return null;
    }

    @Override
    public IRegion match(IDocument document, int offset, boolean auto) {
        if (document == null || offset < 0) {
            return null;
        }
        this.offset = offset;
        switch (this.matchPairsAt(document, auto)) {
            case 1: {
                return new Region(this.endPos, -1);
            }
            case 2: {
                return new Region(this.beginPos, -1);
            }
            case 3: {
                return new Region(this.beginPos, this.endPos - this.beginPos + 1);
            }
        }
        return null;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void dispose() {
        this.clear();
    }

    public void clear() {
    }

    protected byte matchPairsAt(IDocument document, boolean auto) {
        this.beginPos = -1;
        this.endPos = -1;
        try {
            ITypedRegion thisPartition = TextUtilities.getPartition((IDocument)document, (String)this.partitioning, (int)this.offset, (boolean)false);
            ITypedRegion prevPartition = this.offset > 0 ? TextUtilities.getPartition((IDocument)document, (String)this.partitioning, (int)(this.offset - 1), (boolean)false) : null;
            int thisChar = 10;
            char prevChar = '\n';
            int thisPart = this.checkPartition(thisPartition.getType());
            if (thisPart >= 0 && this.offset < document.getLength()) {
                thisChar = document.getChar(this.offset);
            }
            int prevPart = -1;
            if (prevPartition != null) {
                prevPart = this.checkPartition(prevPartition.getType());
                if (auto && prevPart >= 0) {
                    prevChar = document.getChar(this.offset - 1);
                    int partitionOffset = prevPartition.getOffset();
                    int checkOffset = this.offset - 2;
                    char escapeChar = this.getEscapeChar(prevPartition.getType());
                    while (checkOffset >= partitionOffset) {
                        if (document.getChar(checkOffset) != escapeChar) break;
                        --checkOffset;
                    }
                    if ((this.offset - checkOffset) % 2 == 1) {
                        prevChar = '\n';
                    } else if (prevPart == thisPart && prevChar == escapeChar) {
                        thisChar = 10;
                    }
                }
            }
            int pairIdx = this.findChar(prevChar, prevPart, (char)thisChar, thisPart);
            if (this.beginPos > -1) {
                this.anchor = 1;
                this.scanner.configure(document, this.partition);
                this.endPos = this.scanner.findClosingPeer(this.beginPos + 1, this.pairs[pairIdx], this.getEscapeChar(this.partition));
                return (byte)(this.endPos > -1 && this.beginPos != this.endPos ? 3 : 2);
            }
            if (this.endPos > -1) {
                this.anchor = 0;
                this.scanner.configure(document, this.partition);
                this.beginPos = this.scanner.findOpeningPeer(this.endPos - 1, this.pairs[pairIdx], this.getEscapeChar(this.partition));
                return (byte)(this.beginPos > -1 && this.beginPos != this.endPos ? 3 : 1);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return 0;
    }

    private int checkPartition(String id) {
        int i = 0;
        while (i < this.applicablePartitions.length) {
            if (this.applicablePartitions[i].equals(id)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int findChar(char prevChar, int prevPart, char thisChar, int thisPart) {
        int i = 0;
        while (i < this.pairs.length) {
            if (thisChar == this.pairs[i][1]) {
                this.endPos = this.offset;
                this.partition = this.applicablePartitions[thisPart];
                return i;
            }
            ++i;
        }
        i = 0;
        while (i < this.pairs.length) {
            if (prevChar == this.pairs[i][0]) {
                this.beginPos = this.offset - 1;
                this.partition = this.applicablePartitions[prevPart];
                return i;
            }
            ++i;
        }
        i = 0;
        while (i < this.pairs.length) {
            if (thisChar == this.pairs[i][0]) {
                this.beginPos = this.offset;
                this.partition = this.applicablePartitions[thisPart];
                return i;
            }
            ++i;
        }
        i = 0;
        while (i < this.pairs.length) {
            if (prevChar == this.pairs[i][1]) {
                this.endPos = this.offset - 1;
                this.partition = this.applicablePartitions[prevPart];
                return i;
            }
            ++i;
        }
        this.partition = null;
        return -1;
    }

    protected char getEscapeChar(String contentType) {
        return this.escapeChar;
    }
}

