/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.eclient.graphics;

import java.util.List;
import org.eclipse.statet.rj.eclient.graphics.ERGraphic;
import org.eclipse.statet.rj.eclient.graphics.ERGraphicInstruction;
import org.eclipse.statet.rj.eclient.graphics.RGraphicCanvas;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class RGraphicComposite
extends Composite
implements ERGraphic.ListenerInstructionsExtension,
ERGraphic.ListenerLocatorExtension {
    private ERGraphic graphic;
    private RGraphicCanvas canvas;
    private int width = 0;
    private int height = 0;
    private boolean changedLayout;
    private boolean changedContent;
    private int panIncrement;
    private final PanListener panListener;
    private MouseListener locatorListener;

    private static int checkStyle(int style) {
        int mask = 0x6000B00;
        return style & 0x6000B00;
    }

    public RGraphicComposite(Composite parent, ERGraphic graphic) {
        super(parent, RGraphicComposite.checkStyle(768));
        super.setLayout((Layout)new ScrolledCompositeLayout());
        this.panIncrement = 10;
        ScrollBar hBar = this.getHorizontalBar();
        hBar.setVisible(false);
        hBar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RGraphicComposite.this.scrollH();
            }
        });
        hBar.setIncrement(this.panIncrement);
        ScrollBar vBar = this.getVerticalBar();
        vBar.setVisible(false);
        vBar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RGraphicComposite.this.scrollV();
            }
        });
        vBar.setIncrement(this.panIncrement);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        this.createCanvas();
        Listener updateListener = new Listener(){

            public void handleEvent(Event event) {
                if (RGraphicComposite.this.changedContent) {
                    RGraphicComposite.this.updateGraphic();
                }
            }
        };
        this.addListener(22, updateListener);
        this.addListener(26, updateListener);
        this.panListener = new PanListener();
        this.addListener(3, this.panListener);
        this.addListener(5, this.panListener);
        this.addListener(7, this.panListener);
        this.addListener(4, this.panListener);
        this.addListener(1, this.panListener);
        this.canvas.addListener(3, this.panListener);
        this.canvas.addListener(5, this.panListener);
        this.canvas.addListener(7, this.panListener);
        this.canvas.addListener(4, this.panListener);
        this.canvas.addListener(1, this.panListener);
        this.setGraphic(graphic);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RGraphicComposite.this.disconnect();
            }
        });
    }

    private void createCanvas() {
        this.canvas = new RGraphicCanvas(this);
    }

    boolean needHBar(Rectangle contentRect, boolean vVisible) {
        Rectangle hostRect = this.getBounds();
        hostRect.width -= 2 * this.getBorderWidth();
        if (vVisible) {
            hostRect.width -= this.getVerticalBar().getSize().x;
        }
        return this.width > hostRect.width;
    }

    boolean needVBar(Rectangle contentRect, boolean hVisible) {
        Rectangle hostRect = this.getBounds();
        hostRect.height -= 2 * this.getBorderWidth();
        if (hVisible) {
            hostRect.height -= this.getHorizontalBar().getSize().y;
        }
        return this.height > hostRect.height;
    }

    private void scrollH() {
        Point location = this.canvas.getLocation();
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar != null && hBar.isVisible()) {
            int hSelection = hBar.getSelection();
            this.canvas.setLocation(-hSelection, location.y);
        }
    }

    private void scrollV() {
        Point location = this.canvas.getLocation();
        ScrollBar vBar = this.getVerticalBar();
        if (vBar != null && vBar.isVisible()) {
            int vSelection = vBar.getSelection();
            this.canvas.setLocation(location.x, -vSelection);
        }
    }

    protected void disconnect() {
        if (this.graphic != null) {
            this.graphic.removeListener(this);
        }
        this.locatorStopped();
    }

    public void setGraphic(ERGraphic graphic) {
        this.disconnect();
        this.graphic = graphic;
        if (this.graphic != null) {
            this.graphic.addListener(this);
        }
        this.instructionsChanged(true, null);
        if (this.graphic != null && this.graphic.isLocatorStarted()) {
            this.locatorStarted();
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void activated() {
    }

    public void deactivated() {
    }

    public void drawingStarted() {
    }

    @Override
    public void instructionsChanged(boolean reset, List<ERGraphicInstruction> added) {
        this.changedContent = true;
        if (this.isVisible()) {
            this.updateGraphic();
        }
    }

    public void drawingStopped() {
    }

    @Override
    public void locatorStarted() {
        if (this.locatorListener == null) {
            this.locatorListener = new MouseListener(){

                public void mouseDown(MouseEvent e) {
                    switch (e.button) {
                        case 1: {
                            RGraphicComposite.this.graphic.returnLocator(RGraphicComposite.this.canvas.widget2graphicsX(e.x), RGraphicComposite.this.canvas.widget2graphicY(e.y));
                            break;
                        }
                        case 3: {
                            RGraphicComposite.this.graphic.stopLocator("done");
                            break;
                        }
                    }
                }

                public void mouseUp(MouseEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            };
            this.canvas.addMouseListener(this.locatorListener);
            this.updateCursor();
        }
    }

    @Override
    public void locatorStopped() {
        if (this.locatorListener != null) {
            this.canvas.removeMouseListener(this.locatorListener);
            this.locatorListener = null;
            this.updateCursor();
        }
    }

    private void updateCursor() {
        if (this.panListener.started) {
            this.canvas.setCursor(Display.getCurrent().getSystemCursor(21));
        } else if (this.locatorListener != null) {
            this.canvas.setCursor(Display.getCurrent().getSystemCursor(2));
        } else {
            this.canvas.setCursor(null);
        }
    }

    private void checkContentSize() {
        Point size = this.canvas.computeSize(-1, -1);
        if (this.width == size.x && this.height == size.y) {
            return;
        }
        this.changedLayout = true;
        this.width = size.x;
        this.height = size.y;
        this.canvas.setSize(this.width, this.height);
        ScrollBar hBar = this.getHorizontalBar();
        hBar.setMaximum(this.width);
        ScrollBar vBar = this.getVerticalBar();
        vBar.setMaximum(this.height);
        this.layout(false);
    }

    public void redrawGraphic() {
        this.canvas.redraw();
    }

    private void updateGraphic() {
        this.changedContent = false;
        List<ERGraphicInstruction> instructions = this.graphic != null ? this.graphic.getInstructions() : RGraphicCanvas.NO_GRAPHIC;
        this.canvas.setInstructions(instructions);
        this.checkContentSize();
        this.canvas.redraw();
    }

    public double[] getGraphicFitSize() {
        Rectangle bounds = this.getBounds();
        return new double[]{bounds.width, bounds.height};
    }

    public Control getControl() {
        return this;
    }

    public Control getGraphicWidget() {
        return this.canvas;
    }

    public double convertWidget2GraphicX(int x) {
        return this.canvas.widget2graphicsX(x);
    }

    public double convertWidget2GraphicY(int y) {
        return this.canvas.widget2graphicY(y);
    }

    private class PanListener
    implements Listener {
        private boolean started;
        private Point startMouse;

        private PanListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 3: {
                    if (event.button == 2) {
                        this.started = true;
                        RGraphicComposite.this.updateCursor();
                        this.startMouse = this.checkedPoint(event);
                        return;
                    }
                    this.started = false;
                    return;
                }
                case 5: 
                case 7: {
                    if (this.started) {
                        this.pan(this.checkedPoint(event));
                        return;
                    }
                    return;
                }
                case 4: {
                    if (this.started && event.button == 2) {
                        this.started = false;
                        RGraphicComposite.this.updateCursor();
                        return;
                    }
                    return;
                }
                case 1: {
                    switch (event.keyCode) {
                        case 0x1000002: {
                            if (this.update(RGraphicComposite.this.getVerticalBar(), RGraphicComposite.this.panIncrement)) {
                                RGraphicComposite.this.scrollV();
                            }
                            return;
                        }
                        case 0x1000001: {
                            if (this.update(RGraphicComposite.this.getVerticalBar(), -RGraphicComposite.this.panIncrement)) {
                                RGraphicComposite.this.scrollV();
                            }
                            return;
                        }
                        case 0x1000004: {
                            if (this.update(RGraphicComposite.this.getHorizontalBar(), RGraphicComposite.this.panIncrement)) {
                                RGraphicComposite.this.scrollH();
                            }
                            return;
                        }
                        case 0x1000003: {
                            if (this.update(RGraphicComposite.this.getHorizontalBar(), -RGraphicComposite.this.panIncrement)) {
                                RGraphicComposite.this.scrollH();
                            }
                            return;
                        }
                    }
                    return;
                }
            }
        }

        private Point checkedPoint(Event event) {
            if (event.item == RGraphicComposite.this) {
                return new Point(event.x, event.y);
            }
            Point point = ((Control)event.widget).toDisplay(event.x, event.y);
            return RGraphicComposite.this.toControl(point);
        }

        private void pan(Point point) {
            if (this.update(RGraphicComposite.this.getHorizontalBar(), this.startMouse.x - point.x)) {
                RGraphicComposite.this.scrollH();
            }
            if (this.update(RGraphicComposite.this.getVerticalBar(), this.startMouse.y - point.y)) {
                RGraphicComposite.this.scrollV();
            }
            this.startMouse = point;
        }

        private boolean update(ScrollBar bar, int step) {
            if (bar != null && bar.isVisible()) {
                int selection = bar.getSelection() + step;
                if (selection < 0) {
                    selection = 0;
                } else if (selection > bar.getMaximum()) {
                    selection = bar.getMaximum() - bar.getThumb();
                }
                bar.setSelection(selection);
                return true;
            }
            return false;
        }
    }

    private static class ScrolledCompositeLayout
    extends Layout {
        static final int DEFAULT_WIDTH = 64;
        static final int DEFAULT_HEIGHT = 64;
        private boolean inLayout = false;

        protected boolean flushCache(Control control) {
            return true;
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            RGraphicComposite sc = (RGraphicComposite)composite;
            Point size = new Point(wHint, hHint);
            if (wHint == -1) {
                size.x = Math.max(64, sc.width);
            }
            if (hHint == -1) {
                size.y = Math.max(64, sc.height);
            }
            return size;
        }

        protected void layout(Composite composite, boolean flushCache) {
            int y;
            int x;
            if (this.inLayout || composite == null) {
                return;
            }
            RGraphicComposite sc = (RGraphicComposite)composite;
            ScrollBar hBar = sc.getHorizontalBar();
            ScrollBar vBar = sc.getVerticalBar();
            if (hBar.getSize().y >= sc.getSize().y) {
                return;
            }
            if (vBar.getSize().x >= sc.getSize().x) {
                return;
            }
            this.inLayout = true;
            Rectangle previousBounds = sc.canvas.getBounds();
            boolean hVisible = sc.needHBar(previousBounds, false);
            boolean vVisible = sc.needVBar(previousBounds, hVisible);
            if (!hVisible && vVisible) {
                hVisible = sc.needHBar(previousBounds, vVisible);
            }
            hBar.setVisible(hVisible);
            vBar.setVisible(vVisible);
            Rectangle clientArea = sc.getClientArea();
            int width = sc.width;
            int height = sc.height;
            hBar.setThumb(clientArea.width);
            hBar.setPageIncrement(clientArea.width);
            if (hVisible) {
                x = sc.changedLayout || previousBounds.x >= 0 ? 0 : Math.max(previousBounds.x, clientArea.width - width);
                hBar.setSelection(-x);
            } else {
                x = (clientArea.width - width) / 2;
                hBar.setSelection(0);
            }
            vBar.setThumb(clientArea.height);
            vBar.setPageIncrement(clientArea.height);
            if (vVisible) {
                y = sc.changedLayout || previousBounds.y >= 0 ? 0 : Math.max(previousBounds.y, clientArea.height - height);
                vBar.setSelection(-y);
            } else {
                y = (clientArea.height - height) / 2;
                vBar.setSelection(0);
            }
            sc.changedLayout = false;
            sc.canvas.setBounds(x, y, width, height);
            this.inLayout = false;
        }
    }
}

