/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.text.core.JFaceTextRegion;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.ltk.ui.EditingMessages;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.StatusManager;

public class OpenWorkspaceFileHyperlink
implements IHyperlink {
    private final IRegion region;
    private final IFile file;

    public OpenWorkspaceFileHyperlink(TextRegion region, IFile file) {
        this.region = JFaceTextRegion.toJFaceRegion((TextRegion)region);
        this.file = file;
    }

    public String getTypeLabel() {
        return null;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return NLS.bind((String)EditingMessages.Hyperlink_OpenFile2_label, (Object)this.file.getName(), (Object)this.file.getParent().getFullPath());
    }

    public void open() {
        try {
            IDE.openEditor((IWorkbenchPage)UIAccess.getActiveWorkbenchPage((boolean)true), (IFile)this.file);
        }
        catch (PartInitException e) {
            Display.getCurrent().beep();
            StatusManager.getManager().handle((IStatus)new Status(1, "org.eclipse.statet.ecommons.uimisc", -1, NLS.bind((String)EditingMessages.Hyperlink_OpenFile_error_message, (Object)this.file.toString()), (Throwable)e));
        }
    }
}

