/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.rmi;

import java.io.File;
import java.net.BindException;
import java.net.InetAddress;
import java.net.URI;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.eclipse.statet.internal.jcommons.rmi.Messages;
import org.eclipse.statet.internal.jcommons.rmi.eplatform.EPlatformContributor;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.net.Port;
import org.eclipse.statet.jcommons.net.PortRange;
import org.eclipse.statet.jcommons.rmi.RMIAddress;
import org.eclipse.statet.jcommons.rmi.RMIRegistry;
import org.eclipse.statet.jcommons.rmi.RMIUtils;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.Statuses;

@NonNullByDefault
public class RMIRegistryManager {
    private static final String EMBEDDED_PORT_RANGE_KEY = "org.eclipse.statet.jcommons.rmi.registry.TcpPort";
    private static final PortRange EMBEDDED_PORT_RANGE_DEFAULT = new PortRange(51100, 51199);
    public static final RMIRegistryManager INSTANCE = new RMIRegistryManager(true);
    private final Map<Port, ManagedRegistry> registries = new HashMap<Port, ManagedRegistry>();
    private final Object embeddedLock = new Object();
    private PortRange embeddedPortRange;
    private boolean embeddedStartSeparate = true;
    private boolean embeddedSsl = false;
    private @Nullable ManagedRegistry embeddedRegistry;
    private final List<ManagedRegistry> embeddedRegistries = new ArrayList<ManagedRegistry>(4);
    private @Nullable List<URI> embeddedCodebaseEntries;
    private boolean embeddedCodebaseLoadContrib;

    private RMIRegistryManager(boolean instance) {
        this.initDispose();
        this.embeddedPortRange = EMBEDDED_PORT_RANGE_DEFAULT;
        if (instance) {
            this.embeddedCodebaseLoadContrib = true;
            String s = System.getProperty(EMBEDDED_PORT_RANGE_KEY);
            if (s != null && s.length() > 0) {
                try {
                    this.embeddedPortRange = PortRange.valueOf(s);
                }
                catch (IllegalArgumentException e) {
                    this.embeddedPortRange = EMBEDDED_PORT_RANGE_DEFAULT;
                    CommonsRuntime.log(new ErrorStatus("org.eclipse.statet.jcommons.util", "The value of the Java property 'org.eclipse.statet.jcommons.rmi.registry.TcpPort' is invalid.", e));
                }
            }
        }
    }

    protected void initDispose() {
        CommonsRuntime.getEnvironment().addStoppingListener(() -> this.dispose());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable RMIRegistry getRegistry(int port) {
        ManagedRegistry r;
        if (port <= 0) {
            port = 1099;
        }
        Port key = new Port(port);
        RMIRegistryManager rMIRegistryManager = this;
        synchronized (rMIRegistryManager) {
            r = this.registries.get(key);
        }
        return r != null ? r.registry : null;
    }

    public void setEmbeddedPrivatePort(int port) {
        this.setEmbeddedPrivatePortDynamic(port, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEmbeddedPrivatePortDynamic(int min, int max) {
        if (min > 0 && min > max) {
            throw new IllegalArgumentException("min > max");
        }
        Object object = this.embeddedLock;
        synchronized (object) {
            this.embeddedRegistry = null;
            this.embeddedPortRange = min > 0 ? new PortRange(min, max) : EMBEDDED_PORT_RANGE_DEFAULT;
        }
    }

    public void setEmbeddedPrivateMode(boolean separate) {
        this.setEmbeddedPrivateMode(separate, this.embeddedSsl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEmbeddedPrivateMode(boolean separate, boolean ssl) {
        if (separate && ssl) {
            throw new IllegalArgumentException("ssl is only supported if separate is not enabled");
        }
        Object object = this.embeddedLock;
        synchronized (object) {
            this.embeddedRegistry = null;
            this.embeddedStartSeparate = separate;
            this.embeddedSsl = ssl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEmbeddedCodebaseEntry(URI entry) {
        if (entry.getScheme() == null) {
            throw new IllegalArgumentException("entry: missing scheme");
        }
        Object object = this.embeddedLock;
        synchronized (object) {
            if (this.embeddedCodebaseEntries == null) {
                this.embeddedCodebaseEntries = new ArrayList<URI>();
            }
            if (!this.embeddedCodebaseEntries.contains(entry)) {
                this.embeddedRegistry = null;
                this.embeddedCodebaseEntries.add(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMIRegistry getEmbeddedPrivateRegistry(ProgressMonitor m) throws StatusException {
        ManagedRegistry r2 = null;
        Status status = null;
        Object object = this.embeddedLock;
        synchronized (object) {
            block20: {
                if (this.embeddedRegistry != null) {
                    return this.embeddedRegistry.registry;
                }
                for (ManagedRegistry r2 : this.embeddedRegistries) {
                    RMIAddress address = r2.registry.getAddress();
                    if (!this.embeddedPortRange.contains(address.getPort()) || address.isSsl() != this.embeddedSsl || this.embeddedStartSeparate != (r2.process != null)) continue;
                    this.embeddedRegistry = r2;
                    return this.embeddedRegistry.registry;
                }
                r2 = null;
                m.beginTask("Starting embedded service registry", -1);
                m.beginSubTask(this.embeddedStartSeparate ? "Starting service registry (RMI) process." : "Starting service registry (RMI).");
                if (this.embeddedCodebaseLoadContrib && this.embeddedStartSeparate) {
                    this.loadCodebaseContrib();
                }
                int loop = 1;
                BindException bindException = null;
                int portNum = this.embeddedPortRange.getMin();
                while (true) {
                    block19: {
                        m.checkCanceled();
                        try {
                            RMIAddress rmiAddress = new RMIAddress(InetAddress.getLoopbackAddress(), new Port(portNum), this.embeddedSsl, "");
                            if (this.embeddedStartSeparate) {
                                status = this.startSeparateRegistry(rmiAddress, false, this.embeddedPortRange.getLength() == 1, 2, StopRule.ALWAYS, this.embeddedCodebaseEntries);
                                if (status.getSeverity() < 4) {
                                    r2 = this.registries.get(rmiAddress.getPort());
                                }
                            } else {
                                Registry javaRegistry = rmiAddress.isSsl() ? LocateRegistry.createRegistry(portNum, new SslRMIClientSocketFactory(), new SslRMIServerSocketFactory(null, null, true)) : LocateRegistry.createRegistry(portNum);
                                r2 = new ManagedRegistry(new RMIRegistry(rmiAddress, javaRegistry, false), 2, StopRule.ALWAYS);
                            }
                            if (r2 == null) break block19;
                            this.embeddedRegistry = r2;
                            this.embeddedRegistries.add(r2);
                            break block20;
                        }
                        catch (Exception e) {
                            if (e.getCause() instanceof BindException) {
                                bindException = (BindException)e;
                            }
                            status = new ErrorStatus("org.eclipse.statet.jcommons.util", "An exception was thrown when starting the embedded registry.", e);
                        }
                    }
                    if (++portNum % 10 == 0) {
                        portNum += 10;
                    }
                    if (portNum <= this.embeddedPortRange.getMax()) continue;
                    if (loop != true) break;
                    loop = 2;
                    portNum = this.embeddedPortRange.getMin() + 10;
                    if (portNum > this.embeddedPortRange.getMax()) break;
                }
                if (status == null) {
                    status = new ErrorStatus("org.eclipse.statet.jcommons.util", String.format("Failed to bind the embedded RMI registry to a TCP port in the specified range (%1$s).", this.embeddedPortRange), bindException);
                }
            }
        }
        if (r2 != null) {
            object = this;
            synchronized (object) {
                this.registries.put(r2.registry.getAddress().getPort(), r2);
            }
            return r2.registry;
        }
        throw new StatusException(status);
    }

    private void loadCodebaseContrib() {
        try {
            if (this.embeddedCodebaseEntries == null) {
                this.embeddedCodebaseEntries = new ArrayList<URI>();
            }
            new EPlatformContributor().addCodebaseEntries(this.embeddedCodebaseEntries);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.embeddedCodebaseLoadContrib = false;
    }

    public Status startSeparateRegistry(RMIAddress address, boolean allowExisting, @Nullable StopRule stopRule, @Nullable List<URI> codebaseEntries) {
        return this.startSeparateRegistry(address, allowExisting, false, 0, stopRule, codebaseEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status startSeparateRegistry(RMIAddress address, boolean allowExisting, boolean noCheck, int addType, @Nullable StopRule stopRule, @Nullable List<URI> codebaseEntries) {
        Process process;
        if (allowExisting && codebaseEntries != null) {
            throw new IllegalArgumentException("allow existing not valid in combination with codebase entries");
        }
        InetAddress hostAddress = address.getHostAddress();
        if (!hostAddress.isLinkLocalAddress() && !hostAddress.isLoopbackAddress()) {
            throw new IllegalArgumentException("address: not local");
        }
        if (address.getName() != null) {
            address = new RMIAddress(address, "");
        }
        if (!noCheck) {
            try {
                RMIUtils.checkRegistryAccess(address);
                if (allowExisting) {
                    try {
                        Registry registry = LocateRegistry.getRegistry(address.getHost(), address.getPort().get());
                        registry.list();
                        RMIRegistryManager rMIRegistryManager = this;
                        synchronized (rMIRegistryManager) {
                            if (!this.registries.containsKey(address.getPort())) {
                                ManagedRegistry r = new ManagedRegistry(new RMIRegistry(address, registry, false), 4, StopRule.NEVER);
                                this.registries.put(address.getPort(), r);
                            }
                        }
                        return new InfoStatus("org.eclipse.statet.jcommons.util", MessageFormat.format(Messages.RMI_status_RegistryAlreadyStarted_message, address.getPort()));
                    }
                    catch (RemoteException registry) {
                        // empty catch block
                    }
                }
                return new ErrorStatus("org.eclipse.statet.jcommons.util", MessageFormat.format(Messages.RMI_status_RegistryStartFailedPortAlreadyUsed_message, address.getPort()));
            }
            catch (RemoteException registry) {
                // empty catch block
            }
        }
        try {
            ArrayList<String> command = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            sb.setLength(0);
            sb.append(System.getProperty("java.home"));
            sb.append(File.separator).append("bin");
            sb.append(File.separator).append("rmiregistry");
            command.add(sb.toString());
            command.add(address.getPort().toString());
            if (codebaseEntries != null && !codebaseEntries.isEmpty()) {
                sb.setLength(0);
                sb.append("-J-Djava.rmi.server.codebase=");
                sb.append(codebaseEntries.get(0));
                int i = 1;
                while (i < codebaseEntries.size()) {
                    sb.append(' ');
                    sb.append(codebaseEntries.get(i));
                    ++i;
                }
                command.add(sb.toString());
            }
            if (address.getHost() != null) {
                sb.setLength(0);
                sb.append("-J-Djava.rmi.server.hostname=");
                sb.append(address.getHost());
                command.add(sb.toString());
            }
            process = Runtime.getRuntime().exec(command.toArray(new String[command.size()]));
        }
        catch (Exception e) {
            return new ErrorStatus("org.eclipse.statet.jcommons.util", MessageFormat.format(Messages.RMI_status_RegistryStartFailed_message, address.getPort()), e);
        }
        RemoteException lastException = null;
        int i = 1;
        while (true) {
            try {
                int exit = process.exitValue();
                return new ErrorStatus("org.eclipse.statet.jcommons.util", MessageFormat.format(Messages.RMI_status_RegistryStartFailedWithExitValue_message, address.getPort(), exit));
            }
            catch (IllegalThreadStateException exit) {
                if (i > 1) {
                    try {
                        RMIUtils.checkRegistryAccess(address);
                        Registry registry = LocateRegistry.getRegistry(address.getHost(), address.getPort().get());
                        registry.list();
                        ManagedRegistry r = new ManagedRegistry(new RMIRegistry(address, registry, true), 1 | addType, stopRule != null ? stopRule : StopRule.IF_EMPTY);
                        r.process = process;
                        RMIRegistryManager rMIRegistryManager = this;
                        synchronized (rMIRegistryManager) {
                            this.registries.put(address.getPort(), r);
                        }
                        return Statuses.OK_STATUS;
                    }
                    catch (RemoteException e) {
                        lastException = e;
                    }
                }
                if (Thread.interrupted()) {
                    process.destroy();
                    return Statuses.CANCEL_STATUS;
                }
                if (i >= 25) {
                    process.destroy();
                    return new ErrorStatus("org.eclipse.statet.jcommons.util", MessageFormat.format(Messages.RMI_status_RegistryStartFailed_message, address.getPort()), lastException);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                ++i;
                continue;
            }
            break;
        }
    }

    public Status stopSeparateRegistry(RMIAddress address) {
        return this.stopSeparateRegistry(address.getPort().get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status stopSeparateRegistry(int port) {
        ManagedRegistry r;
        if (port <= 0) {
            port = 1099;
        }
        Port key = new Port(port);
        RMIRegistryManager rMIRegistryManager = this;
        synchronized (rMIRegistryManager) {
            r = this.registries.get(key);
            if (r == null || r.process == null) {
                return new ErrorStatus("org.eclipse.statet.jcommons.util", MessageFormat.format(Messages.RMI_status_RegistryStopFailedNotFound_message, port));
            }
            this.registries.remove(key);
        }
        r.process.destroy();
        return Statuses.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dispose() {
        RMIRegistryManager rMIRegistryManager = this;
        synchronized (rMIRegistryManager) {
            block10: for (ManagedRegistry r : this.registries.values()) {
                if (r.process == null) continue;
                switch (r.stopRule) {
                    case ALWAYS: {
                        break;
                    }
                    case NEVER: {
                        continue block10;
                    }
                    case IF_EMPTY: {
                        try {
                            Registry registry = r.registry.getRegistry();
                            if (registry.list().length <= 0) break;
                            continue block10;
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }
                r.process.destroy();
                r.process = null;
            }
            this.registries.clear();
            return;
        }
    }

    private static final class ManagedRegistry {
        public static final int SEPERATE = 1;
        public static final int EMBEDDED = 2;
        public static final int FOREIGN = 4;
        private final RMIRegistry registry;
        private final int type;
        private @Nullable Process process;
        private final StopRule stopRule;

        public ManagedRegistry(RMIRegistry registry, int type, StopRule stopRule) {
            this.registry = registry;
            this.type = type;
            this.stopRule = stopRule;
        }
    }

    public static enum StopRule {
        ALWAYS,
        NEVER,
        IF_EMPTY;

    }
}

