/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolRegistryListener;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolSessionData;
import org.eclipse.statet.internal.nico.ui.NicoUIPlugin;
import org.eclipse.statet.internal.nico.ui.ToolRegistry;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ToolSourceProvider
extends AbstractSourceProvider
implements IWindowListener {
    private final ToolRegistry registry;
    private final List<RegistryListerner> createdListeners = new ArrayList<RegistryListerner>();
    private IWorkbenchWindow activeWindow;
    private Tool currentTool;

    public ToolSourceProvider() {
        this.registry = NicoUIPlugin.getInstance().getToolRegistry();
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            this.windowOpened(window);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List<RegistryListerner> list = this.createdListeners;
        synchronized (list) {
            Iterator<RegistryListerner> iter = this.createdListeners.iterator();
            while (iter.hasNext()) {
                this.registry.removeListener(iter.next());
                iter.remove();
            }
            this.createdListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowOpened(IWorkbenchWindow window) {
        RegistryListerner listener = new RegistryListerner(window);
        List<RegistryListerner> list = this.createdListeners;
        synchronized (list) {
            this.createdListeners.add(listener);
        }
        this.registry.addListener(listener, window.getActivePage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowClosed(IWorkbenchWindow window) {
        List<RegistryListerner> list = this.createdListeners;
        synchronized (list) {
            Iterator<RegistryListerner> iter = this.createdListeners.iterator();
            while (iter.hasNext()) {
                if (iter.next().window != window) continue;
                iter.remove();
            }
        }
        this.activeWindow = null;
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.activeWindow = window;
        this.handleActivated(this.registry.getActiveToolSession(window.getActivePage()).getTool());
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleActivated(Tool tool) {
        ToolSourceProvider toolSourceProvider = this;
        synchronized (toolSourceProvider) {
            if (this.currentTool == tool || this.currentTool == null && tool == null) {
                return;
            }
            this.currentTool = tool;
        }
        if (DEBUG) {
            System.out.println("[tool source] changed:" + (tool != null ? tool.getLabel(1) : "-"));
        }
        Object value = tool != null ? tool : IEvaluationContext.UNDEFINED_VARIABLE;
        this.fireSourceChanged(0, "org.eclipse.statet.activeTool", value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTerminated(Tool tool) {
        ToolSourceProvider toolSourceProvider = this;
        synchronized (toolSourceProvider) {
            if (this.currentTool == tool) {
                if (DEBUG) {
                    System.out.println("[tool source] terminated:" + (tool != null ? tool.getLabel(1) : "-"));
                }
                this.fireSourceChanged(0, "org.eclipse.statet.activeTool", tool);
            }
        }
    }

    public String[] getProvidedSourceNames() {
        return new String[]{"org.eclipse.statet.activeTool"};
    }

    public Map getCurrentState() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object tool = null;
        if (this.activeWindow != null) {
            tool = this.registry.getActiveToolSession(this.activeWindow.getActivePage()).getTool();
        }
        if (tool == null) {
            tool = IEvaluationContext.UNDEFINED_VARIABLE;
        }
        map.put("org.eclipse.statet.activeTool", tool);
        return map;
    }

    private class RegistryListerner
    implements WorkbenchToolRegistryListener {
        private final IWorkbenchWindow window;

        public RegistryListerner(IWorkbenchWindow window) {
            this.window = window;
        }

        public void toolSessionActivated(WorkbenchToolSessionData info) {
            if (ToolSourceProvider.this.activeWindow == this.window) {
                ToolSourceProvider.this.handleActivated(info.getTool());
            }
        }

        public void toolTerminated(WorkbenchToolSessionData sessionData) {
            if (ToolSourceProvider.this.activeWindow == this.window) {
                ToolSourceProvider.this.handleTerminated(sessionData.getTool());
            }
        }
    }
}

