/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.services.util.dataaccess;

import org.eclipse.statet.rj.data.RDataFrame;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.util.dataaccess.AbstractRDataAdapter;
import org.eclipse.statet.rj.services.util.dataaccess.LazyRStore;

public class RDataFrameDataAdapter
extends AbstractRDataAdapter<RDataFrame, RDataFrame> {
    @Override
    public RDataFrame validate(RObject rObject) throws UnexpectedRDataException {
        return RDataUtils.checkRDataFrame((RObject)rObject);
    }

    @Override
    public RDataFrame validate(RObject rObject, RDataFrame referenceObject, int flags) throws UnexpectedRDataException {
        RDataFrame dataframe = RDataUtils.checkRDataFrame((RObject)rObject, (long)referenceObject.getColumnCount());
        if ((flags & 1) != 0) {
            RDataUtils.checkRowCountEqual((RDataFrame)dataframe, (long)referenceObject.getRowCount());
        }
        if ((flags & 4) != 0) {
            int i = 0;
            while ((long)i < dataframe.getColumnCount()) {
                RDataUtils.checkData((RStore)dataframe.getColumn(i), (byte)referenceObject.getColumn(i).getStoreType());
                ++i;
            }
        }
        return dataframe;
    }

    @Override
    public long getRowCount(RDataFrame rObject) {
        return rObject.getRowCount();
    }

    @Override
    public long getColumnCount(RDataFrame rObject) {
        return rObject.getColumnCount();
    }

    @Override
    protected String getLoadDataFName() {
        return "rj:::sda002.getDataFrameValues";
    }

    @Override
    protected String getSetDataFName() {
        return "rj:::.setDataFrameValues";
    }

    @Override
    protected RDataFrame validateData(RObject rObject, RDataFrame referenceObject, LazyRStore.Fragment<RDataFrame> fragment) throws UnexpectedRDataException {
        RDataFrame dataframe = RDataUtils.checkRDataFrame((RObject)rObject, (long)fragment.getColumnCount());
        RDataUtils.checkRowCountEqual((RDataFrame)dataframe, (long)fragment.getRowCount());
        int i = 0;
        while ((long)i < fragment.getColumnCount()) {
            RDataUtils.checkData((RStore)dataframe.getColumn(i), (byte)referenceObject.getColumn(fragment.getColumnBeginIdx() + (long)i).getStoreType());
            ++i;
        }
        return dataframe;
    }

    @Override
    protected String getLoadRowNamesFName() {
        return "rj:::sda002.getDataFrameRowNames";
    }
}

