/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.statet.ecommons.io.TextContentDescriber;

public class RdTextContentDescriber
extends TextContentDescriber {
    private static final QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
    private static String ENCODING_COMMAND_NAME = "encoding";
    private static Pattern BRACKET_CONTENT_PATTERN = Pattern.compile("\\s*\\{\\s*(\\S*)\\s*\\}.*");

    public QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    public int describe(Reader contents, IContentDescription description) throws IOException {
        if (description != null && description.isRequested(IContentDescription.CHARSET)) {
            BufferedReader reader = new BufferedReader(contents);
            String encoding = this.searchEncoding(reader);
            if (encoding == null) {
                return 1;
            }
            description.setProperty(IContentDescription.CHARSET, (Object)encoding);
        }
        return 2;
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        byte[] bom = this.getByteOrderMark(contents);
        String baseEncoding = "UTF-8";
        if (bom != null) {
            if (bom == IContentDescription.BOM_UTF_16BE) {
                baseEncoding = "UTF-16BE";
            } else if (bom == IContentDescription.BOM_UTF_16LE) {
                baseEncoding = "UTF-16LE";
            } else if (bom == IContentDescription.BOM_UTF_8) {
                baseEncoding = "UTF-8";
            }
            if (description != null && description.isRequested(IContentDescription.BYTE_ORDER_MARK)) {
                description.setProperty(IContentDescription.BYTE_ORDER_MARK, (Object)bom);
            }
        }
        if (description != null && description.isRequested(IContentDescription.CHARSET)) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(contents, baseEncoding));
            String encoding = this.searchEncoding(reader);
            if (encoding == null) {
                return 1;
            }
            IContentType contentType = description.getContentType();
            if (contentType == null || !encoding.equals(contentType.getDefaultCharset())) {
                description.setProperty(IContentDescription.CHARSET, (Object)encoding);
            }
        }
        return 2;
    }

    private String searchEncoding(BufferedReader reader) throws IOException {
        String line;
        block5: while ((line = reader.readLine()) != null) {
            int i = 0;
            while (i < line.length()) {
                switch (line.charAt(i)) {
                    case '\t': 
                    case ' ': {
                        break;
                    }
                    case '%': {
                        continue block5;
                    }
                    case '\\': {
                        Matcher matcher;
                        if (!line.regionMatches(i + 1, ENCODING_COMMAND_NAME, 0, ENCODING_COMMAND_NAME.length()) || !(matcher = BRACKET_CONTENT_PATTERN.matcher(line.substring(i + 1 + ENCODING_COMMAND_NAME.length()))).matches()) break block5;
                        return matcher.group(1);
                    }
                    default: {
                        break block5;
                    }
                }
                ++i;
            }
        }
        return null;
    }
}

