/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.freeze;

import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeEventHandler;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.layer.TransformLayer;
import org.eclipse.statet.ecommons.waltable.layer.TransformLayerDim;

public class FreezeLayer
extends TransformLayer {
    public static final String PERSISTENCE_TOP_LEFT_POSITION = ".freezeTopLeftPosition";
    public static final String PERSISTENCE_BOTTOM_RIGHT_POSITION = ".freezeBottomRightPosition";

    public FreezeLayer(ILayer underlyingLayer) {
        super(underlyingLayer);
        this.registerEventHandler(new FreezeEventHandler(this));
    }

    @Override
    protected void initDims() {
        ILayer underlying = this.getUnderlyingLayer();
        if (underlying == null) {
            return;
        }
        this.setDim(new Dim(this, underlying.getDim(Orientation.HORIZONTAL)));
        this.setDim(new Dim(this, underlying.getDim(Orientation.VERTICAL)));
    }

    final Dim get(Orientation orientation) {
        return (Dim)this.getDim(orientation);
    }

    public boolean isFrozen() {
        return this.getColumnCount() > 0L || this.getRowCount() > 0L;
    }

    public PositionCoordinate getTopLeftPosition() {
        return new PositionCoordinate(this, this.get(Orientation.HORIZONTAL).startPosition, this.get(Orientation.VERTICAL).startPosition);
    }

    public PositionCoordinate getBottomRightPosition() {
        return new PositionCoordinate(this, this.get(Orientation.HORIZONTAL).endPosition - 1L, this.get(Orientation.VERTICAL).endPosition - 1L);
    }

    public void setFreeze(long leftColumnPosition, long topRowPosition, long rightColumnPosition, long bottomRowPosition) {
        if (rightColumnPosition < leftColumnPosition || bottomRowPosition < topRowPosition) {
            throw new IllegalArgumentException();
        }
        if (leftColumnPosition < 0L) {
            this.get(Orientation.HORIZONTAL).setFreeze(0L, 0L);
        } else {
            this.get(Orientation.HORIZONTAL).setFreeze(leftColumnPosition, rightColumnPosition + 1L);
        }
        if (topRowPosition < 0L) {
            this.get(Orientation.VERTICAL).setFreeze(0L, 0L);
        } else {
            this.get(Orientation.VERTICAL).setFreeze(topRowPosition, bottomRowPosition + 1L);
        }
    }

    static class Dim
    extends TransformLayerDim<FreezeLayer> {
        private long startPosition;
        private long endPosition;

        public Dim(FreezeLayer layer, ILayerDim underlyingDim) {
            super(layer, underlyingDim);
        }

        public void setFreeze(long start, long end) {
            if (start < 0L || start > end) {
                throw new IllegalArgumentException();
            }
            this.startPosition = start;
            this.endPosition = end;
        }

        public long getStartPosition() {
            return this.startPosition;
        }

        public long getEndPosition() {
            return this.endPosition;
        }

        private long getStartPixel() {
            return this.underlyingDim.getPositionStart(this.startPosition);
        }

        @Override
        public long getPositionCount() {
            return this.endPosition - this.startPosition;
        }

        @Override
        public long localToUnderlyingPosition(long refPosition, long position) {
            if (refPosition < 0L || refPosition >= this.getPositionCount()) {
                throw PositionOutOfBoundsException.refPosition(refPosition, this.getOrientation());
            }
            return this.startPosition + position;
        }

        @Override
        protected long doUnderlyingToLocalPosition(long underlyingPosition) {
            return underlyingPosition - this.startPosition;
        }

        @Override
        public long getSize() {
            long size = 0L;
            long position = this.startPosition;
            while (position < this.endPosition) {
                size += (long)this.underlyingDim.getPositionSize(position, position);
                ++position;
            }
            return size;
        }

        @Override
        public long getPreferredSize() {
            return this.getSize();
        }

        @Override
        public long getPositionByPixel(long pixel) {
            long underlyingPosition = this.underlyingDim.getPositionByPixel(this.getStartPixel() + pixel);
            return this.underlyingToLocalPosition(this.underlyingDim, underlyingPosition);
        }

        @Override
        public long getPositionStart(long refPosition, long position) {
            return super.getPositionStart(refPosition, position) - this.getStartPixel();
        }

        @Override
        public long getPositionStart(long position) {
            return super.getPositionStart(position) - this.getStartPixel();
        }
    }
}

