/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.util.ColumnWidgetTokenOwner;
import org.eclipse.statet.internal.ecommons.ui.Messages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class InformationDispatchHandler
extends AbstractHandler {
    public static final String COMMAND_ID = "org.eclipse.ui.edit.text.showInformation";
    public static final int MODE_TOOLTIP = 1;
    public static final int MODE_PROPOSAL_INFO = 2;
    public static final int MODE_FOCUS = 16;
    private final ColumnWidgetTokenOwner tokenOwner;

    public static final String getTooltipAffordanceString() {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService == null) {
            return null;
        }
        String keySequence = bindingService.getBestActiveBindingFormattedFor(COMMAND_ID);
        if (keySequence == null) {
            return "";
        }
        return NLS.bind((String)Messages.Hover_TooltipFocusAffordance_message, (Object)keySequence);
    }

    public static final String getAdditionalInfoAffordanceString() {
        String keySequence = SWTKeySupport.getKeyFormatterForPlatform().format(9);
        return NLS.bind((String)Messages.Hover_ProposalInfoFocusAffordance_message, (Object)keySequence);
    }

    public static final String getAffordanceString(int mode) {
        switch (mode & 0xFF) {
            case 1: {
                return InformationDispatchHandler.getTooltipAffordanceString();
            }
            case 2: {
                return InformationDispatchHandler.getAdditionalInfoAffordanceString();
            }
        }
        return "";
    }

    public InformationDispatchHandler(ColumnWidgetTokenOwner owner) {
        this.tokenOwner = owner;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.tokenOwner != null && this.tokenOwner.moveFocusToWidgetToken()) {
            return null;
        }
        return this.showInformation();
    }

    protected Object showInformation() {
        return null;
    }
}

